/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace BusinessPlace}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.field.BusinessPlaceField
 * BusinessPlaceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.link.BusinessPlaceLink
 * BusinessPlaceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace#BRANCH BRANCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace#BUSINESS_PLACE_STATE_TAX_NUMBER
 * BUSINESS_PLACE_STATE_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace#BUS_PLACE_MUNICIPAL_TAX_NUMBER
 * BUS_PLACE_MUNICIPAL_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace#TO_EMAILS
 * TO_EMAILS}</li>
 * </ul>
 *
 */
public interface BusinessPlaceSelectable extends EntitySelectable<BusinessPlace>
{

}
