/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.SmtpNumbers;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.SmtpNumbers SmtpNumbers}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.field.SmtpNumbersField
 * SmtpNumbersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.link.SmtpNumbersLink SmtpNumbersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.SmtpNumbers#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.SmtpNumbers#BRANCH BRANCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.SmtpNumbers#COMPANY_CODE
 * COMPANY_CODE}</li>
 * </ul>
 *
 */
public interface SmtpNumbersSelectable extends EntitySelectable<SmtpNumbers>
{

}
