/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFAdditionImportDocSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
 * BR_NFAdditionImportDoc} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BR_NFAdditionImportDocByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFAdditionImportDocByKeyFluentHelper, BR_NFAdditionImportDoc, BR_NFAdditionImportDocSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     * BR_NFAdditionImportDoc} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFAdditionImportDoc}
     * @param bR_NFAddition
     *            Addition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param bR_NFImportDocument
     *            Import Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFAdditionImportDoc}
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFItemSequenceNumber
     *            Number of the Item /XML Tag <nSeqAdic>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public BR_NFAdditionImportDocByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportDocument,
        final String bR_NFAddition,
        final String bR_NFItemSequenceNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NotaFiscalItem", bR_NotaFiscalItem);
        this.key.put("BR_NFImportDocument", bR_NFImportDocument);
        this.key.put("BR_NFAddition", bR_NFAddition);
        this.key.put("BR_NFItemSequenceNumber", bR_NFItemSequenceNumber);
    }

    @Override
    @Nonnull
    protected Class<BR_NFAdditionImportDoc> getEntityClass()
    {
        return BR_NFAdditionImportDoc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
