/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFAdditionalInformationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFAdditionalInformationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFAdditionalInformationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Additional Info
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFAdditionalInformationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFAdditionalInformation extends VdmEntity<BR_NFAdditionalInformation>
{

    /**
     * Selector for all available fields of BR_NFAdditionalInformation.
     *
     */
    public final static BR_NFAdditionalInformationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFAdditionalInformationField<String> BR_NOTA_FISCAL =
        new BR_NFAdditionalInformationField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFInfoFieldUsage</b>
     * </p>
     *
     * @return Usage
     */
    @Key
    @SerializedName( "BR_NFInfoFieldUsage" )
    @JsonProperty( "BR_NFInfoFieldUsage" )
    @Nullable
    @ODataField( odataName = "BR_NFInfoFieldUsage" )
    private String bR_NFInfoFieldUsage;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFInfoFieldUsage</b> field to query operations.
     *
     */
    public final static BR_NFAdditionalInformationField<String> BRNF_INFO_FIELD_USAGE =
        new BR_NFAdditionalInformationField<String>("BR_NFInfoFieldUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalInformationID</b>
     * </p>
     *
     * @return Field ID
     */
    @Key
    @SerializedName( "BR_NFAdditionalInformationID" )
    @JsonProperty( "BR_NFAdditionalInformationID" )
    @Nullable
    @ODataField( odataName = "BR_NFAdditionalInformationID" )
    private String bR_NFAdditionalInformationID;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdditionalInformationID</b> field to query operations.
     *
     */
    public final static BR_NFAdditionalInformationField<String> BRNF_ADDITIONAL_INFORMATION_ID =
        new BR_NFAdditionalInformationField<String>("BR_NFAdditionalInformationID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalInfoDesc</b>
     * </p>
     *
     * @return Field Content
     */
    @SerializedName( "BR_NFAdditionalInfoDesc" )
    @JsonProperty( "BR_NFAdditionalInfoDesc" )
    @Nullable
    @ODataField( odataName = "BR_NFAdditionalInfoDesc" )
    private String bR_NFAdditionalInfoDesc;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdditionalInfoDesc</b> field to query operations.
     *
     */
    public final static BR_NFAdditionalInformationField<String> BRNF_ADDITIONAL_INFO_DESC =
        new BR_NFAdditionalInformationField<String>("BR_NFAdditionalInfoDesc");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFAdditionalInformation</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFAdditionalInformationOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFAdditionalInformationOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFAdditionalInformation> getType()
    {
        return BR_NFAdditionalInformation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFInfoFieldUsage</b>
     * </p>
     *
     * @param bR_NFInfoFieldUsage
     *            Usage
     */
    public void setBR_NFInfoFieldUsage( @Nullable final String bR_NFInfoFieldUsage )
    {
        rememberChangedField("BR_NFInfoFieldUsage", this.bR_NFInfoFieldUsage);
        this.bR_NFInfoFieldUsage = bR_NFInfoFieldUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalInformationID</b>
     * </p>
     *
     * @param bR_NFAdditionalInformationID
     *            Field ID
     */
    public void setBR_NFAdditionalInformationID( @Nullable final String bR_NFAdditionalInformationID )
    {
        rememberChangedField("BR_NFAdditionalInformationID", this.bR_NFAdditionalInformationID);
        this.bR_NFAdditionalInformationID = bR_NFAdditionalInformationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalInfoDesc</b>
     * </p>
     *
     * @param bR_NFAdditionalInfoDesc
     *            Field Content
     */
    public void setBR_NFAdditionalInfoDesc( @Nullable final String bR_NFAdditionalInfoDesc )
    {
        rememberChangedField("BR_NFAdditionalInfoDesc", this.bR_NFAdditionalInfoDesc);
        this.bR_NFAdditionalInfoDesc = bR_NFAdditionalInfoDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFAdditionalInformation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFInfoFieldUsage", getBR_NFInfoFieldUsage());
        result.put("BR_NFAdditionalInformationID", getBR_NFAdditionalInformationID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFInfoFieldUsage", getBR_NFInfoFieldUsage());
        values.put("BR_NFAdditionalInformationID", getBR_NFAdditionalInformationID());
        values.put("BR_NFAdditionalInfoDesc", getBR_NFAdditionalInfoDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFInfoFieldUsage") ) {
                final Object value = values.remove("BR_NFInfoFieldUsage");
                if( (value == null) || (!value.equals(getBR_NFInfoFieldUsage())) ) {
                    setBR_NFInfoFieldUsage(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdditionalInformationID") ) {
                final Object value = values.remove("BR_NFAdditionalInformationID");
                if( (value == null) || (!value.equals(getBR_NFAdditionalInformationID())) ) {
                    setBR_NFAdditionalInformationID(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdditionalInfoDesc") ) {
                final Object value = values.remove("BR_NFAdditionalInfoDesc");
                if( (value == null) || (!value.equals(getBR_NFAdditionalInfoDesc())) ) {
                    setBR_NFAdditionalInfoDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFAdditionalInformationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BR_NFAdditionalInformationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFAdditionalInformationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFAdditionalInformationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFAdditionalInformation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFAdditionalInformation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFAdditionalInformation instances.
     *
     */
    public final static class BR_NFAdditionalInformationBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFAdditionalInformation.BR_NFAdditionalInformationBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFAdditionalInformation</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFAdditionalInformation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFAdditionalInformation.BR_NFAdditionalInformationBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
