/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFAdditionalInformationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
 * BR_NFAdditionalInformation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BR_NFAdditionalInformationByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFAdditionalInformationByKeyFluentHelper, BR_NFAdditionalInformation, BR_NFAdditionalInformationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     * BR_NFAdditionalInformation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFAdditionalInformation}
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param bR_NFAdditionalInformationID
     *            Field ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFAdditionalInformation}
     * @param bR_NFInfoFieldUsage
     *            Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BR_NFAdditionalInformationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NFInfoFieldUsage,
        final String bR_NFAdditionalInformationID )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NFInfoFieldUsage", bR_NFInfoFieldUsage);
        this.key.put("BR_NFAdditionalInformationID", bR_NFAdditionalInformationID);
    }

    @Override
    @Nonnull
    protected Class<BR_NFAdditionalInformation> getEntityClass()
    {
        return BR_NFAdditionalInformation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
