/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFDocumentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFDocumentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFDocument extends VdmEntity<BR_NFDocument>
{

    /**
     * Selector for all available fields of BR_NFDocument.
     *
     */
    public final static BR_NFDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_NOTA_FISCAL = new BR_NFDocumentField<String>("BR_NotaFiscal");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerFunction</b>
     * </p>
     *
     * @return Nota Fiscal Partner Function
     */
    @SerializedName( "BR_NFPartnerFunction" )
    @JsonProperty( "BR_NFPartnerFunction" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerFunction" )
    private String bR_NFPartnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerFunction</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_FUNCTION =
        new BR_NFDocumentField<String>("BR_NFPartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartner</b>
     * </p>
     *
     * @return Partner ID (Customer, Vendor, Business Place)
     */
    @SerializedName( "BR_NFPartner" )
    @JsonProperty( "BR_NFPartner" )
    @Nullable
    @ODataField( odataName = "BR_NFPartner" )
    private String bR_NFPartner;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartner</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER = new BR_NFDocumentField<String>("BR_NFPartner");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BR_NFPartnerName1" )
    @JsonProperty( "BR_NFPartnerName1" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName1" )
    private String bR_NFPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName1</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_NAME1 =
        new BR_NFDocumentField<String>("BR_NFPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BR_NFPartnerName2" )
    @JsonProperty( "BR_NFPartnerName2" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName2" )
    private String bR_NFPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName2</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_NAME2 =
        new BR_NFDocumentField<String>("BR_NFPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "BR_NFPartnerName3" )
    @JsonProperty( "BR_NFPartnerName3" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName3" )
    private String bR_NFPartnerName3;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName3</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_NAME3 =
        new BR_NFDocumentField<String>("BR_NFPartnerName3");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "BR_NFPartnerName4" )
    @JsonProperty( "BR_NFPartnerName4" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName4" )
    private String bR_NFPartnerName4;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName4</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_NAME4 =
        new BR_NFDocumentField<String>("BR_NFPartnerName4");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerIsOneTimeAccount</b>
     * </p>
     *
     * @return Indicator: Is the Account a One-Time Account?
     */
    @SerializedName( "PartnerIsOneTimeAccount" )
    @JsonProperty( "PartnerIsOneTimeAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PartnerIsOneTimeAccount" )
    private Boolean partnerIsOneTimeAccount;
    /**
     * Use with available fluent helpers to apply the <b>PartnerIsOneTimeAccount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> PARTNER_IS_ONE_TIME_ACCOUNT =
        new BR_NFDocumentField<Boolean>("PartnerIsOneTimeAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerType</b>
     * </p>
     *
     * @return Type
     */
    @SerializedName( "BR_NFPartnerType" )
    @JsonProperty( "BR_NFPartnerType" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerType" )
    private String bR_NFPartnerType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_TYPE =
        new BR_NFDocumentField<String>("BR_NFPartnerType");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStreetName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "BR_NFPartnerStreetName" )
    @JsonProperty( "BR_NFPartnerStreetName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerStreetName" )
    private String bR_NFPartnerStreetName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerStreetName</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_STREET_NAME =
        new BR_NFDocumentField<String>("BR_NFPartnerStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "BusinessPartnerHouseNumber" )
    @JsonProperty( "BusinessPartnerHouseNumber" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerHouseNumber" )
    private String businessPartnerHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerHouseNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BUSINESS_PARTNER_HOUSE_NUMBER =
        new BR_NFDocumentField<String>("BusinessPartnerHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPHsNmbrSuplmntTxt</b>
     * </p>
     *
     * @return House number supplement
     */
    @SerializedName( "BPHsNmbrSuplmntTxt" )
    @JsonProperty( "BPHsNmbrSuplmntTxt" )
    @Nullable
    @ODataField( odataName = "BPHsNmbrSuplmntTxt" )
    private String bPHsNmbrSuplmntTxt;
    /**
     * Use with available fluent helpers to apply the <b>BPHsNmbrSuplmntTxt</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BP_HS_NMBR_SUPLMNT_TXT =
        new BR_NFDocumentField<String>("BPHsNmbrSuplmntTxt");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "BR_NFPartnerCityName" )
    @JsonProperty( "BR_NFPartnerCityName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCityName" )
    private String bR_NFPartnerCityName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCityName</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_CITY_NAME =
        new BR_NFDocumentField<String>("BR_NFPartnerCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerRegionCode</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "BR_NFPartnerRegionCode" )
    @JsonProperty( "BR_NFPartnerRegionCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerRegionCode" )
    private String bR_NFPartnerRegionCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerRegionCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_REGION_CODE =
        new BR_NFDocumentField<String>("BR_NFPartnerRegionCode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerDistrictName</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "BR_NFPartnerDistrictName" )
    @JsonProperty( "BR_NFPartnerDistrictName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerDistrictName" )
    private String bR_NFPartnerDistrictName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerDistrictName</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_DISTRICT_NAME =
        new BR_NFDocumentField<String>("BR_NFPartnerDistrictName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCountryCode</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "BR_NFPartnerCountryCode" )
    @JsonProperty( "BR_NFPartnerCountryCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCountryCode" )
    private String bR_NFPartnerCountryCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCountryCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_COUNTRY_CODE =
        new BR_NFDocumentField<String>("BR_NFPartnerCountryCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "BR_NFPartnerPostalCode" )
    @JsonProperty( "BR_NFPartnerPostalCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerPostalCode" )
    private String bR_NFPartnerPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerPostalCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_POSTAL_CODE =
        new BR_NFDocumentField<String>("BR_NFPartnerPostalCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerIsNaturalPerson</b>
     * </p>
     *
     * @return Natural Person
     */
    @SerializedName( "BR_NFPartnerIsNaturalPerson" )
    @JsonProperty( "BR_NFPartnerIsNaturalPerson" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFPartnerIsNaturalPerson" )
    private Boolean bR_NFPartnerIsNaturalPerson;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerIsNaturalPerson</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_PARTNER_IS_NATURAL_PERSON =
        new BR_NFDocumentField<Boolean>("BR_NFPartnerIsNaturalPerson");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNPJ</b>
     * </p>
     *
     * @return CNPJ Number
     */
    @SerializedName( "BR_NFPartnerCNPJ" )
    @JsonProperty( "BR_NFPartnerCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCNPJ" )
    private String bR_NFPartnerCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_CNPJ =
        new BR_NFDocumentField<String>("BR_NFPartnerCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCPF</b>
     * </p>
     *
     * @return CPF number
     */
    @SerializedName( "BR_NFPartnerCPF" )
    @JsonProperty( "BR_NFPartnerCPF" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCPF" )
    private String bR_NFPartnerCPF;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCPF</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_CPF = new BR_NFDocumentField<String>("BR_NFPartnerCPF");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Addresses: telephone no.
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> PHONE_NUMBER = new BR_NFDocumentField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumber</b>
     * </p>
     *
     * @return State Tax Number
     */
    @SerializedName( "BR_NFPartnerStateTaxNumber" )
    @JsonProperty( "BR_NFPartnerStateTaxNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerStateTaxNumber" )
    private String bR_NFPartnerStateTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerStateTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_STATE_TAX_NUMBER =
        new BR_NFDocumentField<String>("BR_NFPartnerStateTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerMunicipalTaxNumber</b>
     * </p>
     *
     * @return Municipal Tax Number
     */
    @SerializedName( "BR_NFPartnerMunicipalTaxNumber" )
    @JsonProperty( "BR_NFPartnerMunicipalTaxNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerMunicipalTaxNumber" )
    private String bR_NFPartnerMunicipalTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerMunicipalTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_MUNICIPAL_TAX_NUMBER =
        new BR_NFDocumentField<String>("BR_NFPartnerMunicipalTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumberST</b>
     * </p>
     *
     * @return State Tax Number of Partner (SubTrib)
     */
    @SerializedName( "BR_NFPartnerStateTaxNumberST" )
    @JsonProperty( "BR_NFPartnerStateTaxNumberST" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerStateTaxNumberST" )
    private String bR_NFPartnerStateTaxNumberST;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerStateTaxNumberST</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_STATE_TAX_NUMBER_ST =
        new BR_NFDocumentField<String>("BR_NFPartnerStateTaxNumberST");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNAE</b>
     * </p>
     *
     * @return CNAE Code of Partner
     */
    @SerializedName( "BR_NFPartnerCNAE" )
    @JsonProperty( "BR_NFPartnerCNAE" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCNAE" )
    private String bR_NFPartnerCNAE;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCNAE</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_CNAE =
        new BR_NFDocumentField<String>("BR_NFPartnerCNAE");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTaxRegimenCode</b>
     * </p>
     *
     * @return Tax Regimen Code (CRT) of Partner
     */
    @SerializedName( "BR_NFPartnerTaxRegimenCode" )
    @JsonProperty( "BR_NFPartnerTaxRegimenCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerTaxRegimenCode" )
    private String bR_NFPartnerTaxRegimenCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerTaxRegimenCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_TAX_REGIMEN_CODE =
        new BR_NFDocumentField<String>("BR_NFPartnerTaxRegimenCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCFOPCategory</b>
     * </p>
     *
     * @return Customer's CFOP category
     */
    @SerializedName( "BR_PartnerCFOPCategory" )
    @JsonProperty( "BR_PartnerCFOPCategory" )
    @Nullable
    @ODataField( odataName = "BR_PartnerCFOPCategory" )
    private String bR_PartnerCFOPCategory;
    /**
     * Use with available fluent helpers to apply the <b>BR_PartnerCFOPCategory</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_PARTNER_CFOP_CATEGORY =
        new BR_NFDocumentField<String>("BR_PartnerCFOPCategory");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_SUFRAMACode</b>
     * </p>
     *
     * @return SUFRAMA Subscription of Partner
     */
    @SerializedName( "BR_SUFRAMACode" )
    @JsonProperty( "BR_SUFRAMACode" )
    @Nullable
    @ODataField( odataName = "BR_SUFRAMACode" )
    private String bR_SUFRAMACode;
    /**
     * Use with available fluent helpers to apply the <b>BR_SUFRAMACode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRSUFRAMA_CODE = new BR_NFDocumentField<String>("BR_SUFRAMACode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_SPEDTaxCategory</b>
     * </p>
     *
     * @return Tax Category
     */
    @SerializedName( "BR_SPEDTaxCategory" )
    @JsonProperty( "BR_SPEDTaxCategory" )
    @Nullable
    @ODataField( odataName = "BR_SPEDTaxCategory" )
    private String bR_SPEDTaxCategory;
    /**
     * Use with available fluent helpers to apply the <b>BR_SPEDTaxCategory</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRSPED_TAX_CATEGORY =
        new BR_NFDocumentField<String>("BR_SPEDTaxCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReportingIncgOrOutgDate</b>
     * </p>
     *
     * @return TMF Reporting Date
     */
    @SerializedName( "ReportingIncgOrOutgDate" )
    @JsonProperty( "ReportingIncgOrOutgDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ReportingIncgOrOutgDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime reportingIncgOrOutgDate;
    /**
     * Use with available fluent helpers to apply the <b>ReportingIncgOrOutgDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> REPORTING_INCG_OR_OUTG_DATE =
        new BR_NFDocumentField<LocalDateTime>("ReportingIncgOrOutgDate");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "BR_NFPartnerTaxJurisdiction" )
    @JsonProperty( "BR_NFPartnerTaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerTaxJurisdiction" )
    private String bR_NFPartnerTaxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerTaxJurisdiction</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_TAX_JURISDICTION =
        new BR_NFDocumentField<String>("BR_NFPartnerTaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFObservationText</b>
     * </p>
     *
     * @return Legal Books Mod. 1 + 2: Header text for observations column
     */
    @SerializedName( "BR_NFObservationText" )
    @JsonProperty( "BR_NFObservationText" )
    @Nullable
    @ODataField( odataName = "BR_NFObservationText" )
    private String bR_NFObservationText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFObservationText</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_OBSERVATION_TEXT =
        new BR_NFDocumentField<String>("BR_NFObservationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportType</b>
     * </p>
     *
     * @return Means of Transport
     */
    @SerializedName( "MeansOfTransportType" )
    @JsonProperty( "MeansOfTransportType" )
    @Nullable
    @ODataField( odataName = "MeansOfTransportType" )
    private String meansOfTransportType;
    /**
     * Use with available fluent helpers to apply the <b>MeansOfTransportType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> MEANS_OF_TRANSPORT_TYPE =
        new BR_NFDocumentField<String>("MeansOfTransportType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransport</b>
     * </p>
     *
     * @return Transport ID
     */
    @SerializedName( "MeansOfTransport" )
    @JsonProperty( "MeansOfTransport" )
    @Nullable
    @ODataField( odataName = "MeansOfTransport" )
    private String meansOfTransport;
    /**
     * Use with available fluent helpers to apply the <b>MeansOfTransport</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> MEANS_OF_TRANSPORT =
        new BR_NFDocumentField<String>("MeansOfTransport");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> INCOTERMS_CLASSIFICATION =
        new BR_NFDocumentField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> INCOTERMS_TRANSFER_LOCATION =
        new BR_NFDocumentField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SHIPPING_POINT = new BR_NFDocumentField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnitBrand</b>
     * </p>
     *
     * @return Shipping Unit Mark
     */
    @SerializedName( "BR_NFShippingUnitBrand" )
    @JsonProperty( "BR_NFShippingUnitBrand" )
    @Nullable
    @ODataField( odataName = "BR_NFShippingUnitBrand" )
    private String bR_NFShippingUnitBrand;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFShippingUnitBrand</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SHIPPING_UNIT_BRAND =
        new BR_NFDocumentField<String>("BR_NFShippingUnitBrand");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnitNumber</b>
     * </p>
     *
     * @return Shipping Unit Number
     */
    @SerializedName( "BR_NFShippingUnitNumber" )
    @JsonProperty( "BR_NFShippingUnitNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFShippingUnitNumber" )
    private String bR_NFShippingUnitNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFShippingUnitNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SHIPPING_UNIT_NUMBER =
        new BR_NFDocumentField<String>("BR_NFShippingUnitNumber");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNumberOfPackages</b>
     * </p>
     *
     * @return Number of Packages
     */
    @SerializedName( "BR_NFNumberOfPackages" )
    @JsonProperty( "BR_NFNumberOfPackages" )
    @Nullable
    @ODataField( odataName = "BR_NFNumberOfPackages" )
    private String bR_NFNumberOfPackages;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNumberOfPackages</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_NUMBER_OF_PACKAGES =
        new BR_NFDocumentField<String>("BR_NFNumberOfPackages");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnit</b>
     * </p>
     *
     * @return Shipping Unit
     */
    @SerializedName( "BR_NFShippingUnit" )
    @JsonProperty( "BR_NFShippingUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFShippingUnit" )
    private String bR_NFShippingUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFShippingUnit</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SHIPPING_UNIT =
        new BR_NFDocumentField<String>("BR_NFShippingUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFArrivalOrDepartureDate</b>
     * </p>
     *
     * @return Goods Departure or Arrival Date
     */
    @SerializedName( "BR_NFArrivalOrDepartureDate" )
    @JsonProperty( "BR_NFArrivalOrDepartureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFArrivalOrDepartureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFArrivalOrDepartureDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFArrivalOrDepartureDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRNF_ARRIVAL_OR_DEPARTURE_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_NFArrivalOrDepartureDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "HeaderWeightUnit" )
    @JsonProperty( "HeaderWeightUnit" )
    @Nullable
    @ODataField( odataName = "HeaderWeightUnit" )
    private String headerWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HeaderWeightUnit</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> HEADER_WEIGHT_UNIT =
        new BR_NFDocumentField<String>("HeaderWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "HeaderNetWeight" )
    @JsonProperty( "HeaderNetWeight" )
    @Nullable
    @ODataField( odataName = "HeaderNetWeight" )
    private BigDecimal headerNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>HeaderNetWeight</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> HEADER_NET_WEIGHT =
        new BR_NFDocumentField<BigDecimal>("HeaderNetWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "HeaderGrossWeight" )
    @JsonProperty( "HeaderGrossWeight" )
    @Nullable
    @ODataField( odataName = "HeaderGrossWeight" )
    private BigDecimal headerGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>HeaderGrossWeight</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> HEADER_GROSS_WEIGHT =
        new BR_NFDocumentField<BigDecimal>("HeaderGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFArrivalOrDepartureTime</b>
     * </p>
     *
     * @return Departure/Arrival Time
     */
    @SerializedName( "BR_NFArrivalOrDepartureTime" )
    @JsonProperty( "BR_NFArrivalOrDepartureTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFArrivalOrDepartureTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime bR_NFArrivalOrDepartureTime;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFArrivalOrDepartureTime</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalTime> BRNF_ARRIVAL_OR_DEPARTURE_TIME =
        new BR_NFDocumentField<LocalTime>("BR_NFArrivalOrDepartureTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_WhldgICMSForTranspCFOP</b>
     * </p>
     *
     * @return CFOP of ICMS Withholding for Transportation
     */
    @SerializedName( "BR_WhldgICMSForTranspCFOP" )
    @JsonProperty( "BR_WhldgICMSForTranspCFOP" )
    @Nullable
    @ODataField( odataName = "BR_WhldgICMSForTranspCFOP" )
    private String bR_WhldgICMSForTranspCFOP;
    /**
     * Use with available fluent helpers to apply the <b>BR_WhldgICMSForTranspCFOP</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_WHLDG_ICMS_FOR_TRANSP_CFOP =
        new BR_NFDocumentField<String>("BR_WhldgICMSForTranspCFOP");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_WhldgICMSForTranspCity</b>
     * </p>
     *
     * @return City Code
     */
    @SerializedName( "BR_WhldgICMSForTranspCity" )
    @JsonProperty( "BR_WhldgICMSForTranspCity" )
    @Nullable
    @ODataField( odataName = "BR_WhldgICMSForTranspCity" )
    private String bR_WhldgICMSForTranspCity;
    /**
     * Use with available fluent helpers to apply the <b>BR_WhldgICMSForTranspCity</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_WHLDG_ICMS_FOR_TRANSP_CITY =
        new BR_NFDocumentField<String>("BR_WhldgICMSForTranspCity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User who created the document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> CREATED_BY_USER = new BR_NFDocumentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Document Creation Date
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> CREATION_DATE =
        new BR_NFDocumentField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Document Creation Time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalTime> CREATION_TIME = new BR_NFDocumentField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> LOGICAL_SYSTEM = new BR_NFDocumentField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return User who last changed the document
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> LAST_CHANGED_BY_USER =
        new BR_NFDocumentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date when document was changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> LAST_CHANGE_DATE =
        new BR_NFDocumentField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time when the document was last changed
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalTime> LAST_CHANGE_TIME =
        new BR_NFDocumentField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> PAYMENT_TERMS = new BR_NFDocumentField<String>("PaymentTerms");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPrinted</b>
     * </p>
     *
     * @return Nota Fiscal Was Printed
     */
    @SerializedName( "BR_NFIsPrinted" )
    @JsonProperty( "BR_NFIsPrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsPrinted" )
    private Boolean bR_NFIsPrinted;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsPrinted</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_PRINTED = new BR_NFDocumentField<Boolean>("BR_NFIsPrinted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCreatedManually</b>
     * </p>
     *
     * @return Manually Created
     */
    @SerializedName( "BR_NFIsCreatedManually" )
    @JsonProperty( "BR_NFIsCreatedManually" )
    @Nullable
    @ODataField( odataName = "BR_NFIsCreatedManually" )
    private String bR_NFIsCreatedManually;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsCreatedManually</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_IS_CREATED_MANUALLY =
        new BR_NFDocumentField<String>("BR_NFIsCreatedManually");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsIncomingIssdByCust</b>
     * </p>
     *
     * @return Nota Fiscal Entrada
     */
    @SerializedName( "BR_NFIsIncomingIssdByCust" )
    @JsonProperty( "BR_NFIsIncomingIssdByCust" )
    @Nullable
    @ODataField( odataName = "BR_NFIsIncomingIssdByCust" )
    private String bR_NFIsIncomingIssdByCust;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsIncomingIssdByCust</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_IS_INCOMING_ISSD_BY_CUST =
        new BR_NFDocumentField<String>("BR_NFIsIncomingIssdByCust");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCanceled</b>
     * </p>
     *
     * @return Nota Fiscal Cancelled
     */
    @SerializedName( "BR_NFIsCanceled" )
    @JsonProperty( "BR_NFIsCanceled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsCanceled" )
    private Boolean bR_NFIsCanceled;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsCanceled</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_CANCELED =
        new BR_NFDocumentField<Boolean>("BR_NFIsCanceled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsChargingInvoice</b>
     * </p>
     *
     * @return NF is a fatura
     */
    @SerializedName( "BR_NFIsChargingInvoice" )
    @JsonProperty( "BR_NFIsChargingInvoice" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsChargingInvoice" )
    private Boolean bR_NFIsChargingInvoice;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsChargingInvoice</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_CHARGING_INVOICE =
        new BR_NFDocumentField<Boolean>("BR_NFIsChargingInvoice");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDirection</b>
     * </p>
     *
     * @return Movement Direction
     */
    @SerializedName( "BR_NFDirection" )
    @JsonProperty( "BR_NFDirection" )
    @Nullable
    @ODataField( odataName = "BR_NFDirection" )
    private String bR_NFDirection;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDirection</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_DIRECTION = new BR_NFDocumentField<String>("BR_NFDirection");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFType</b>
     * </p>
     *
     * @return Nota Fiscal Type
     */
    @SerializedName( "BR_NFType" )
    @JsonProperty( "BR_NFType" )
    @Nullable
    @ODataField( odataName = "BR_NFType" )
    private String bR_NFType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_TYPE = new BR_NFDocumentField<String>("BR_NFType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "BR_NFDocumentType" )
    @JsonProperty( "BR_NFDocumentType" )
    @Nullable
    @ODataField( odataName = "BR_NFDocumentType" )
    private String bR_NFDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDocumentType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_DOCUMENT_TYPE =
        new BR_NFDocumentField<String>("BR_NFDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFModel</b>
     * </p>
     *
     * @return Nota Fiscal Model
     */
    @SerializedName( "BR_NFModel" )
    @JsonProperty( "BR_NFModel" )
    @Nullable
    @ODataField( odataName = "BR_NFModel" )
    private String bR_NFModel;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFModel</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_MODEL = new BR_NFDocumentField<String>("BR_NFModel");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNumber</b>
     * </p>
     *
     * @return Nota Fiscal Number
     */
    @SerializedName( "BR_NFNumber" )
    @JsonProperty( "BR_NFNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFNumber" )
    private String bR_NFNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_NUMBER = new BR_NFDocumentField<String>("BR_NFNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSeries</b>
     * </p>
     *
     * @return Nota Fiscal Series
     */
    @SerializedName( "BR_NFSeries" )
    @JsonProperty( "BR_NFSeries" )
    @Nullable
    @ODataField( odataName = "BR_NFSeries" )
    private String bR_NFSeries;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSeries</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SERIES = new BR_NFDocumentField<String>("BR_NFSeries");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSubSeries</b>
     * </p>
     *
     * @return Sub series
     */
    @SerializedName( "BR_NFSubSeries" )
    @JsonProperty( "BR_NFSubSeries" )
    @Nullable
    @ODataField( odataName = "BR_NFSubSeries" )
    private String bR_NFSubSeries;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSubSeries</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SUB_SERIES = new BR_NFDocumentField<String>("BR_NFSubSeries");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSituationCode</b>
     * </p>
     *
     * @return Status Code of Fiscal Document
     */
    @SerializedName( "BR_NFSituationCode" )
    @JsonProperty( "BR_NFSituationCode" )
    @Nullable
    @ODataField( odataName = "BR_NFSituationCode" )
    private String bR_NFSituationCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSituationCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_SITUATION_CODE =
        new BR_NFDocumentField<String>("BR_NFSituationCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIssuedBy</b>
     * </p>
     *
     * @return Nota Fiscal Issued By
     */
    @SerializedName( "BR_NFIssuedBy" )
    @JsonProperty( "BR_NFIssuedBy" )
    @Nullable
    @ODataField( odataName = "BR_NFIssuedBy" )
    private String bR_NFIssuedBy;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIssuedBy</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_ISSUED_BY = new BR_NFDocumentField<String>("BR_NFIssuedBy");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsContingency</b>
     * </p>
     *
     * @return Contingency Indicator for Nota Fiscal
     */
    @SerializedName( "BR_NFIsContingency" )
    @JsonProperty( "BR_NFIsContingency" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsContingency" )
    private Boolean bR_NFIsContingency;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsContingency</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_CONTINGENCY =
        new BR_NFDocumentField<Boolean>("BR_NFIsContingency");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthznProtocolNumber</b>
     * </p>
     *
     * @return Protocol Number
     */
    @SerializedName( "BR_NFAuthznProtocolNumber" )
    @JsonProperty( "BR_NFAuthznProtocolNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFAuthznProtocolNumber" )
    private String bR_NFAuthznProtocolNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAuthznProtocolNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_AUTHZN_PROTOCOL_NUMBER =
        new BR_NFDocumentField<String>("BR_NFAuthznProtocolNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthenticationDate</b>
     * </p>
     *
     * @return Processing Date
     */
    @SerializedName( "BR_NFAuthenticationDate" )
    @JsonProperty( "BR_NFAuthenticationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFAuthenticationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFAuthenticationDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAuthenticationDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRNF_AUTHENTICATION_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_NFAuthenticationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthenticationTime</b>
     * </p>
     *
     * @return Processing Time
     */
    @SerializedName( "BR_NFAuthenticationTime" )
    @JsonProperty( "BR_NFAuthenticationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFAuthenticationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime bR_NFAuthenticationTime;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAuthenticationTime</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalTime> BRNF_AUTHENTICATION_TIME =
        new BR_NFDocumentField<LocalTime>("BR_NFAuthenticationTime");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeXMLVersion</b>
     * </p>
     *
     * @return XML Version
     */
    @SerializedName( "BR_NFeXMLVersion" )
    @JsonProperty( "BR_NFeXMLVersion" )
    @Nullable
    @ODataField( odataName = "BR_NFeXMLVersion" )
    private BigDecimal bR_NFeXMLVersion;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeXMLVersion</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRN_FE_XML_VERSION =
        new BR_NFDocumentField<BigDecimal>("BR_NFeXMLVersion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Invoice Number
     */
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUPPLIER_INVOICE = new BR_NFDocumentField<String>("SupplierInvoice");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOriginalAmount</b>
     * </p>
     *
     * @return Invoice Original Amount
     */
    @SerializedName( "BR_NFOriginalAmount" )
    @JsonProperty( "BR_NFOriginalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFOriginalAmount" )
    private BigDecimal bR_NFOriginalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFOriginalAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRNF_ORIGINAL_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_NFOriginalAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDiscountAmount</b>
     * </p>
     *
     * @return Invoice Discount Amount
     */
    @SerializedName( "BR_NFDiscountAmount" )
    @JsonProperty( "BR_NFDiscountAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFDiscountAmount" )
    private BigDecimal bR_NFDiscountAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDiscountAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRNF_DISCOUNT_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_NFDiscountAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetAmount</b>
     * </p>
     *
     * @return Invoice Net Amount
     */
    @SerializedName( "BR_NFNetAmount" )
    @JsonProperty( "BR_NFNetAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFNetAmount" )
    private BigDecimal bR_NFNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNetAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRNF_NET_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_NFNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCommitmentNote</b>
     * </p>
     *
     * @return Commitment Note
     */
    @SerializedName( "BR_NFCommitmentNote" )
    @JsonProperty( "BR_NFCommitmentNote" )
    @Nullable
    @ODataField( odataName = "BR_NFCommitmentNote" )
    private String bR_NFCommitmentNote;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFCommitmentNote</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_COMMITMENT_NOTE =
        new BR_NFDocumentField<String>("BR_NFCommitmentNote");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneHarvest</b>
     * </p>
     *
     * @return Harvest ID
     */
    @SerializedName( "SugarcaneHarvest" )
    @JsonProperty( "SugarcaneHarvest" )
    @Nullable
    @ODataField( odataName = "SugarcaneHarvest" )
    private String sugarcaneHarvest;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneHarvest</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUGARCANE_HARVEST =
        new BR_NFDocumentField<String>("SugarcaneHarvest");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneRefMonthYear</b>
     * </p>
     *
     * @return Reference Month/Year
     */
    @SerializedName( "SugarcaneRefMonthYear" )
    @JsonProperty( "SugarcaneRefMonthYear" )
    @Nullable
    @ODataField( odataName = "SugarcaneRefMonthYear" )
    private String sugarcaneRefMonthYear;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneRefMonthYear</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUGARCANE_REF_MONTH_YEAR =
        new BR_NFDocumentField<String>("SugarcaneRefMonthYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneCurMnthQtyUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "SugarcaneCurMnthQtyUnit" )
    @JsonProperty( "SugarcaneCurMnthQtyUnit" )
    @Nullable
    @ODataField( odataName = "SugarcaneCurMnthQtyUnit" )
    private String sugarcaneCurMnthQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneCurMnthQtyUnit</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUGARCANE_CUR_MNTH_QTY_UNIT =
        new BR_NFDocumentField<String>("SugarcaneCurMnthQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneCurrentMonthQty</b>
     * </p>
     *
     * @return Current Month Amount
     */
    @SerializedName( "SugarcaneCurrentMonthQty" )
    @JsonProperty( "SugarcaneCurrentMonthQty" )
    @Nullable
    @ODataField( odataName = "SugarcaneCurrentMonthQty" )
    private BigDecimal sugarcaneCurrentMonthQty;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneCurrentMonthQty</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_CURRENT_MONTH_QTY =
        new BR_NFDocumentField<BigDecimal>("SugarcaneCurrentMonthQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneLastMnthQtyUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "SugarcaneLastMnthQtyUnit" )
    @JsonProperty( "SugarcaneLastMnthQtyUnit" )
    @Nullable
    @ODataField( odataName = "SugarcaneLastMnthQtyUnit" )
    private String sugarcaneLastMnthQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneLastMnthQtyUnit</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUGARCANE_LAST_MNTH_QTY_UNIT =
        new BR_NFDocumentField<String>("SugarcaneLastMnthQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneLastMnthQuantity</b>
     * </p>
     *
     * @return Last Month Amount
     */
    @SerializedName( "SugarcaneLastMnthQuantity" )
    @JsonProperty( "SugarcaneLastMnthQuantity" )
    @Nullable
    @ODataField( odataName = "SugarcaneLastMnthQuantity" )
    private BigDecimal sugarcaneLastMnthQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneLastMnthQuantity</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_LAST_MNTH_QUANTITY =
        new BR_NFDocumentField<BigDecimal>("SugarcaneLastMnthQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSumBothMnthsQtyUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "SugarcaneSumBothMnthsQtyUnit" )
    @JsonProperty( "SugarcaneSumBothMnthsQtyUnit" )
    @Nullable
    @ODataField( odataName = "SugarcaneSumBothMnthsQtyUnit" )
    private String sugarcaneSumBothMnthsQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneSumBothMnthsQtyUnit</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SUGARCANE_SUM_BOTH_MNTHS_QTY_UNIT =
        new BR_NFDocumentField<String>("SugarcaneSumBothMnthsQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSumBothMonthsQty</b>
     * </p>
     *
     * @return Sum of Both Months
     */
    @SerializedName( "SugarcaneSumBothMonthsQty" )
    @JsonProperty( "SugarcaneSumBothMonthsQty" )
    @Nullable
    @ODataField( odataName = "SugarcaneSumBothMonthsQty" )
    private BigDecimal sugarcaneSumBothMonthsQty;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneSumBothMonthsQty</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_SUM_BOTH_MONTHS_QTY =
        new BR_NFDocumentField<BigDecimal>("SugarcaneSumBothMonthsQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSuppliesAmount</b>
     * </p>
     *
     * @return Supplies Amount
     */
    @SerializedName( "SugarcaneSuppliesAmount" )
    @JsonProperty( "SugarcaneSuppliesAmount" )
    @Nullable
    @ODataField( odataName = "SugarcaneSuppliesAmount" )
    private BigDecimal sugarcaneSuppliesAmount;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneSuppliesAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_SUPPLIES_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("SugarcaneSuppliesAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneTotalDeductionAmount</b>
     * </p>
     *
     * @return Total Deduction
     */
    @SerializedName( "SugarcaneTotalDeductionAmount" )
    @JsonProperty( "SugarcaneTotalDeductionAmount" )
    @Nullable
    @ODataField( odataName = "SugarcaneTotalDeductionAmount" )
    private BigDecimal sugarcaneTotalDeductionAmount;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneTotalDeductionAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_TOTAL_DEDUCTION_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("SugarcaneTotalDeductionAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSuppliesNetAmt</b>
     * </p>
     *
     * @return Supplies Net Amount
     */
    @SerializedName( "SugarcaneSuppliesNetAmt" )
    @JsonProperty( "SugarcaneSuppliesNetAmt" )
    @Nullable
    @ODataField( odataName = "SugarcaneSuppliesNetAmt" )
    private BigDecimal sugarcaneSuppliesNetAmt;
    /**
     * Use with available fluent helpers to apply the <b>SugarcaneSuppliesNetAmt</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> SUGARCANE_SUPPLIES_NET_AMT =
        new BR_NFDocumentField<BigDecimal>("SugarcaneSuppliesNetAmt");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @SerializedName( "BR_NFeDocumentStatus" )
    @JsonProperty( "BR_NFeDocumentStatus" )
    @Nullable
    @ODataField( odataName = "BR_NFeDocumentStatus" )
    private String bR_NFeDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeDocumentStatus</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_DOCUMENT_STATUS =
        new BR_NFDocumentField<String>("BR_NFeDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsFinalConsumer</b>
     * </p>
     *
     * @return NF-e Final Consumer Identification
     */
    @SerializedName( "BR_NFIsFinalConsumer" )
    @JsonProperty( "BR_NFIsFinalConsumer" )
    @Nullable
    @ODataField( odataName = "BR_NFIsFinalConsumer" )
    private String bR_NFIsFinalConsumer;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsFinalConsumer</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_IS_FINAL_CONSUMER =
        new BR_NFDocumentField<String>("BR_NFIsFinalConsumer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeCustomerPresence</b>
     * </p>
     *
     * @return Customer Presence
     */
    @SerializedName( "BR_NFeCustomerPresence" )
    @JsonProperty( "BR_NFeCustomerPresence" )
    @Nullable
    @ODataField( odataName = "BR_NFeCustomerPresence" )
    private String bR_NFeCustomerPresence;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeCustomerPresence</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_CUSTOMER_PRESENCE =
        new BR_NFDocumentField<String>("BR_NFeCustomerPresence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeDestination</b>
     * </p>
     *
     * @return Destination
     */
    @SerializedName( "BR_NFeDestination" )
    @JsonProperty( "BR_NFeDestination" )
    @Nullable
    @ODataField( odataName = "BR_NFeDestination" )
    private String bR_NFeDestination;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeDestination</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_DESTINATION =
        new BR_NFDocumentField<String>("BR_NFeDestination");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> COMPANY_CODE = new BR_NFDocumentField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "BR_NFPostingDate" )
    @JsonProperty( "BR_NFPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPostingDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRNF_POSTING_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_NFPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @return Business Place
     */
    @SerializedName( "BusinessPlace" )
    @JsonProperty( "BusinessPlace" )
    @Nullable
    @ODataField( odataName = "BusinessPlace" )
    private String businessPlace;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlace</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BUSINESS_PLACE = new BR_NFDocumentField<String>("BusinessPlace");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNPJ</b>
     * </p>
     *
     * @return Business Place CNPJ
     */
    @SerializedName( "BR_BusinessPlaceCNPJ" )
    @JsonProperty( "BR_BusinessPlaceCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_BusinessPlaceCNPJ" )
    private String bR_BusinessPlaceCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_BusinessPlaceCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_BUSINESS_PLACE_CNPJ =
        new BR_NFDocumentField<String>("BR_BusinessPlaceCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceStateTaxNumber</b>
     * </p>
     *
     * @return State Tax Number
     */
    @SerializedName( "BusinessPlaceStateTaxNumber" )
    @JsonProperty( "BusinessPlaceStateTaxNumber" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceStateTaxNumber" )
    private String businessPlaceStateTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceStateTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BUSINESS_PLACE_STATE_TAX_NUMBER =
        new BR_NFDocumentField<String>("BusinessPlaceStateTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusPlaceStateTaxNumberST</b>
     * </p>
     *
     * @return State Tax Number (ST)
     */
    @SerializedName( "BR_BusPlaceStateTaxNumberST" )
    @JsonProperty( "BR_BusPlaceStateTaxNumberST" )
    @Nullable
    @ODataField( odataName = "BR_BusPlaceStateTaxNumberST" )
    private String bR_BusPlaceStateTaxNumberST;
    /**
     * Use with available fluent helpers to apply the <b>BR_BusPlaceStateTaxNumberST</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_BUS_PLACE_STATE_TAX_NUMBER_ST =
        new BR_NFDocumentField<String>("BR_BusPlaceStateTaxNumberST");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusPlaceMunicipalTaxNumber</b>
     * </p>
     *
     * @return Municipal Tax Number
     */
    @SerializedName( "BusPlaceMunicipalTaxNumber" )
    @JsonProperty( "BusPlaceMunicipalTaxNumber" )
    @Nullable
    @ODataField( odataName = "BusPlaceMunicipalTaxNumber" )
    private String busPlaceMunicipalTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusPlaceMunicipalTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BUS_PLACE_MUNICIPAL_TAX_NUMBER =
        new BR_NFDocumentField<String>("BusPlaceMunicipalTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNAE</b>
     * </p>
     *
     * @return Business Place CNAE
     */
    @SerializedName( "BR_BusinessPlaceCNAE" )
    @JsonProperty( "BR_BusinessPlaceCNAE" )
    @Nullable
    @ODataField( odataName = "BR_BusinessPlaceCNAE" )
    private String bR_BusinessPlaceCNAE;
    /**
     * Use with available fluent helpers to apply the <b>BR_BusinessPlaceCNAE</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_BUSINESS_PLACE_CNAE =
        new BR_NFDocumentField<String>("BR_BusinessPlaceCNAE");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceTaxRegimenCode</b>
     * </p>
     *
     * @return Business Place CRT
     */
    @SerializedName( "BusinessPlaceTaxRegimenCode" )
    @JsonProperty( "BusinessPlaceTaxRegimenCode" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceTaxRegimenCode" )
    private String businessPlaceTaxRegimenCode;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceTaxRegimenCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BUSINESS_PLACE_TAX_REGIMEN_CODE =
        new BR_NFDocumentField<String>("BusinessPlaceTaxRegimenCode");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmount</b>
     * </p>
     *
     * @return Total value including all taxes
     */
    @SerializedName( "BR_NFTotalAmount" )
    @JsonProperty( "BR_NFTotalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFTotalAmount" )
    private BigDecimal bR_NFTotalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTotalAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRNF_TOTAL_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_NFTotalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFDocumentField<String>("SalesDocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Accounting Document
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> ACCOUNTING_DOCUMENT =
        new BR_NFDocumentField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "BR_NFFiscalYear" )
    @JsonProperty( "BR_NFFiscalYear" )
    @Nullable
    @ODataField( odataName = "BR_NFFiscalYear" )
    private String bR_NFFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFiscalYear</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_FISCAL_YEAR = new BR_NFDocumentField<String>("BR_NFFiscalYear");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFWithholdingAmount</b>
     * </p>
     *
     * @return Withholding Amount
     */
    @SerializedName( "BR_NFWithholdingAmount" )
    @JsonProperty( "BR_NFWithholdingAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFWithholdingAmount" )
    private BigDecimal bR_NFWithholdingAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFWithholdingAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRNF_WITHHOLDING_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_NFWithholdingAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_PaymentForm</b>
     * </p>
     *
     * @return Payment Form Indicator
     */
    @SerializedName( "BR_PaymentForm" )
    @JsonProperty( "BR_PaymentForm" )
    @Nullable
    @ODataField( odataName = "BR_PaymentForm" )
    private String bR_PaymentForm;
    /**
     * Use with available fluent helpers to apply the <b>BR_PaymentForm</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_PAYMENT_FORM = new BR_NFDocumentField<String>("BR_PaymentForm");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FreightPayer</b>
     * </p>
     *
     * @return Freight Mode
     */
    @SerializedName( "FreightPayer" )
    @JsonProperty( "FreightPayer" )
    @Nullable
    @ODataField( odataName = "FreightPayer" )
    private String freightPayer;
    /**
     * Use with available fluent helpers to apply the <b>FreightPayer</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> FREIGHT_PAYER = new BR_NFDocumentField<String>("FreightPayer");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_ANTTCarrierRegistration</b>
     * </p>
     *
     * @return Cargo Carrier ID
     */
    @SerializedName( "BR_ANTTCarrierRegistration" )
    @JsonProperty( "BR_ANTTCarrierRegistration" )
    @Nullable
    @ODataField( odataName = "BR_ANTTCarrierRegistration" )
    private String bR_ANTTCarrierRegistration;
    /**
     * Use with available fluent helpers to apply the <b>BR_ANTTCarrierRegistration</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRANTT_CARRIER_REGISTRATION =
        new BR_NFDocumentField<String>("BR_ANTTCarrierRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeNumber</b>
     * </p>
     *
     * @return Nine-Digit Number
     */
    @SerializedName( "BR_NFeNumber" )
    @JsonProperty( "BR_NFeNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFeNumber" )
    private String bR_NFeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_NUMBER = new BR_NFDocumentField<String>("BR_NFeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>WagonID</b>
     * </p>
     *
     * @return Wagon ID
     */
    @SerializedName( "WagonID" )
    @JsonProperty( "WagonID" )
    @Nullable
    @ODataField( odataName = "WagonID" )
    private String wagonID;
    /**
     * Use with available fluent helpers to apply the <b>WagonID</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> WAGON_ID = new BR_NFDocumentField<String>("WagonID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FerryBoatID</b>
     * </p>
     *
     * @return Ferryboat ID
     */
    @SerializedName( "FerryBoatID" )
    @JsonProperty( "FerryBoatID" )
    @Nullable
    @ODataField( odataName = "FerryBoatID" )
    private String ferryBoatID;
    /**
     * Use with available fluent helpers to apply the <b>FerryBoatID</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> FERRY_BOAT_ID = new BR_NFDocumentField<String>("FerryBoatID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportShipmentPlace</b>
     * </p>
     *
     * @return Shipment Place (Export)
     */
    @SerializedName( "BR_NFExportShipmentPlace" )
    @JsonProperty( "BR_NFExportShipmentPlace" )
    @Nullable
    @ODataField( odataName = "BR_NFExportShipmentPlace" )
    private String bR_NFExportShipmentPlace;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExportShipmentPlace</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_EXPORT_SHIPMENT_PLACE =
        new BR_NFDocumentField<String>("BR_NFExportShipmentPlace");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportShipmentRegion</b>
     * </p>
     *
     * @return Shipment Region
     */
    @SerializedName( "BR_NFExportShipmentRegion" )
    @JsonProperty( "BR_NFExportShipmentRegion" )
    @Nullable
    @ODataField( odataName = "BR_NFExportShipmentRegion" )
    private String bR_NFExportShipmentRegion;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExportShipmentRegion</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_EXPORT_SHIPMENT_REGION =
        new BR_NFDocumentField<String>("BR_NFExportShipmentRegion");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportDispatchLocation</b>
     * </p>
     *
     * @return Dispatch Location
     */
    @SerializedName( "BR_NFExportDispatchLocation" )
    @JsonProperty( "BR_NFExportDispatchLocation" )
    @Nullable
    @ODataField( odataName = "BR_NFExportDispatchLocation" )
    private String bR_NFExportDispatchLocation;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExportDispatchLocation</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_EXPORT_DISPATCH_LOCATION =
        new BR_NFDocumentField<String>("BR_NFExportDispatchLocation");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIssueDate</b>
     * </p>
     *
     * @return Document Date
     */
    @SerializedName( "BR_NFIssueDate" )
    @JsonProperty( "BR_NFIssueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFIssueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFIssueDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIssueDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRNF_ISSUE_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_NFIssueDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsMunicipal</b>
     * </p>
     *
     * @return Municipal Fiscal Document
     */
    @SerializedName( "BR_NFIsMunicipal" )
    @JsonProperty( "BR_NFIsMunicipal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsMunicipal" )
    private Boolean bR_NFIsMunicipal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsMunicipal</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_MUNICIPAL =
        new BR_NFDocumentField<Boolean>("BR_NFIsMunicipal");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOperationTypeDesc</b>
     * </p>
     *
     * @return Operation Type
     */
    @SerializedName( "BR_NFOperationTypeDesc" )
    @JsonProperty( "BR_NFOperationTypeDesc" )
    @Nullable
    @ODataField( odataName = "BR_NFOperationTypeDesc" )
    private String bR_NFOperationTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFOperationTypeDesc</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_OPERATION_TYPE_DESC =
        new BR_NFDocumentField<String>("BR_NFOperationTypeDesc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_IsNFe</b>
     * </p>
     *
     * @return Electronic Fiscal Document
     */
    @SerializedName( "BR_IsNFe" )
    @JsonProperty( "BR_IsNFe" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_IsNFe" )
    private Boolean bR_IsNFe;
    /**
     * Use with available fluent helpers to apply the <b>BR_IsNFe</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BR_IS_N_FE = new BR_NFDocumentField<Boolean>("BR_IsNFe");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCancellationDate</b>
     * </p>
     *
     * @return Cancellation Date
     */
    @SerializedName( "BR_NFCancellationDate" )
    @JsonProperty( "BR_NFCancellationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFCancellationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFCancellationDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFCancellationDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRNF_CANCELLATION_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_NFCancellationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFHasFollowOnDocument</b>
     * </p>
     *
     * @return Follow-On Document
     */
    @SerializedName( "BR_NFHasFollowOnDocument" )
    @JsonProperty( "BR_NFHasFollowOnDocument" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFHasFollowOnDocument" )
    private Boolean bR_NFHasFollowOnDocument;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFHasFollowOnDocument</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_HAS_FOLLOW_ON_DOCUMENT =
        new BR_NFDocumentField<Boolean>("BR_NFHasFollowOnDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFReferenceDocument</b>
     * </p>
     *
     * @return The bR_NFReferenceDocument contained in this entity.
     */
    @SerializedName( "BR_NFReferenceDocument" )
    @JsonProperty( "BR_NFReferenceDocument" )
    @Nullable
    @ODataField( odataName = "BR_NFReferenceDocument" )
    private String bR_NFReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFReferenceDocument</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_REFERENCE_DOCUMENT =
        new BR_NFDocumentField<String>("BR_NFReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>LicensePlate</b>
     * </p>
     *
     * @return Vehicle License Plate
     */
    @SerializedName( "LicensePlate" )
    @JsonProperty( "LicensePlate" )
    @Nullable
    @ODataField( odataName = "LicensePlate" )
    private String licensePlate;
    /**
     * Use with available fluent helpers to apply the <b>LicensePlate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> LICENSE_PLATE = new BR_NFDocumentField<String>("LicensePlate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleRegion</b>
     * </p>
     *
     * @return Region of Vehicle
     */
    @SerializedName( "VehicleRegion" )
    @JsonProperty( "VehicleRegion" )
    @Nullable
    @ODataField( odataName = "VehicleRegion" )
    private String vehicleRegion;
    /**
     * Use with available fluent helpers to apply the <b>VehicleRegion</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> VEHICLE_REGION = new BR_NFDocumentField<String>("VehicleRegion");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_UtilsNFNumber</b>
     * </p>
     *
     * @return Number for Non-Electronic Documents
     */
    @SerializedName( "BR_UtilsNFNumber" )
    @JsonProperty( "BR_UtilsNFNumber" )
    @Nullable
    @ODataField( odataName = "BR_UtilsNFNumber" )
    private String bR_UtilsNFNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_UtilsNFNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BR_UTILS_NF_NUMBER =
        new BR_NFDocumentField<String>("BR_UtilsNFNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPlaceType</b>
     * </p>
     *
     * @return Nota Fiscal Partner Place Type
     */
    @SerializedName( "BR_NFPartnerPlaceType" )
    @JsonProperty( "BR_NFPartnerPlaceType" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerPlaceType" )
    private String bR_NFPartnerPlaceType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerPlaceType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_PLACE_TYPE =
        new BR_NFDocumentField<String>("BR_NFPartnerPlaceType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCalculatedByTaxService</b>
     * </p>
     *
     * @return Tax Calculated by External Tax Calculation Engines
     */
    @SerializedName( "BR_NFIsCalculatedByTaxService" )
    @JsonProperty( "BR_NFIsCalculatedByTaxService" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsCalculatedByTaxService" )
    private Boolean bR_NFIsCalculatedByTaxService;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsCalculatedByTaxService</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_IS_CALCULATED_BY_TAX_SERVICE =
        new BR_NFDocumentField<Boolean>("BR_NFIsCalculatedByTaxService");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeAmount</b>
     * </p>
     *
     * @return Change Amount
     */
    @SerializedName( "ChangeAmount" )
    @JsonProperty( "ChangeAmount" )
    @Nullable
    @ODataField( odataName = "ChangeAmount" )
    private BigDecimal changeAmount;
    /**
     * Use with available fluent helpers to apply the <b>ChangeAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> CHANGE_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("ChangeAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFiscalCouponDocModel</b>
     * </p>
     *
     * @return Fiscal Coupon Document Model
     */
    @SerializedName( "BR_NFFiscalCouponDocModel" )
    @JsonProperty( "BR_NFFiscalCouponDocModel" )
    @Nullable
    @ODataField( odataName = "BR_NFFiscalCouponDocModel" )
    private String bR_NFFiscalCouponDocModel;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFiscalCouponDocModel</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_FISCAL_COUPON_DOC_MODEL =
        new BR_NFDocumentField<String>("BR_NFFiscalCouponDocModel");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOperationOrderNumber</b>
     * </p>
     *
     * @return Operation Order Counter Number
     */
    @SerializedName( "BR_NFOperationOrderNumber" )
    @JsonProperty( "BR_NFOperationOrderNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFOperationOrderNumber" )
    private String bR_NFOperationOrderNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFOperationOrderNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_OPERATION_ORDER_NUMBER =
        new BR_NFDocumentField<String>("BR_NFOperationOrderNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerForeignIdn</b>
     * </p>
     *
     * @return Foreign Identification
     */
    @SerializedName( "BR_NFPartnerForeignIdn" )
    @JsonProperty( "BR_NFPartnerForeignIdn" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerForeignIdn" )
    private String bR_NFPartnerForeignIdn;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerForeignIdn</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_PARTNER_FOREIGN_IDN =
        new BR_NFDocumentField<String>("BR_NFPartnerForeignIdn");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeDocumentType</b>
     * </p>
     *
     * @return CT-e Type
     */
    @SerializedName( "BR_CTeDocumentType" )
    @JsonProperty( "BR_CTeDocumentType" )
    @Nullable
    @ODataField( odataName = "BR_CTeDocumentType" )
    private String bR_CTeDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeDocumentType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_DOCUMENT_TYPE =
        new BR_NFDocumentField<String>("BR_CTeDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeMainProductTransported</b>
     * </p>
     *
     * @return Main Product
     */
    @SerializedName( "BR_CTeMainProductTransported" )
    @JsonProperty( "BR_CTeMainProductTransported" )
    @Nullable
    @ODataField( odataName = "BR_CTeMainProductTransported" )
    private String bR_CTeMainProductTransported;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeMainProductTransported</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_MAIN_PRODUCT_TRANSPORTED =
        new BR_NFDocumentField<String>("BR_CTeMainProductTransported");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeTotalGoodsAmount</b>
     * </p>
     *
     * @return Total Amount of Goods
     */
    @SerializedName( "BR_CTeTotalGoodsAmount" )
    @JsonProperty( "BR_CTeTotalGoodsAmount" )
    @Nullable
    @ODataField( odataName = "BR_CTeTotalGoodsAmount" )
    private BigDecimal bR_CTeTotalGoodsAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeTotalGoodsAmount</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<BigDecimal> BRC_TE_TOTAL_GOODS_AMOUNT =
        new BR_NFDocumentField<BigDecimal>("BR_CTeTotalGoodsAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTePartnerServiceTaker</b>
     * </p>
     *
     * @return CT-e Partner as Service Taker
     */
    @SerializedName( "BR_CTePartnerServiceTaker" )
    @JsonProperty( "BR_CTePartnerServiceTaker" )
    @Nullable
    @ODataField( odataName = "BR_CTePartnerServiceTaker" )
    private String bR_CTePartnerServiceTaker;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTePartnerServiceTaker</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_PARTNER_SERVICE_TAKER =
        new BR_NFDocumentField<String>("BR_CTePartnerServiceTaker");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeFiscalDocumentPartner</b>
     * </p>
     *
     * @return CT-e Partner in Fiscal Document
     */
    @SerializedName( "BR_CTeFiscalDocumentPartner" )
    @JsonProperty( "BR_CTeFiscalDocumentPartner" )
    @Nullable
    @ODataField( odataName = "BR_CTeFiscalDocumentPartner" )
    private String bR_CTeFiscalDocumentPartner;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeFiscalDocumentPartner</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_FISCAL_DOCUMENT_PARTNER =
        new BR_NFDocumentField<String>("BR_CTeFiscalDocumentPartner");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeServiceType</b>
     * </p>
     *
     * @return Service Type Indicator
     */
    @SerializedName( "BR_CTeServiceType" )
    @JsonProperty( "BR_CTeServiceType" )
    @Nullable
    @ODataField( odataName = "BR_CTeServiceType" )
    private String bR_CTeServiceType;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeServiceType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_SERVICE_TYPE =
        new BR_NFDocumentField<String>("BR_CTeServiceType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeTransportationMode</b>
     * </p>
     *
     * @return Transportation Mode
     */
    @SerializedName( "BR_CTeTransportationMode" )
    @JsonProperty( "BR_CTeTransportationMode" )
    @Nullable
    @ODataField( odataName = "BR_CTeTransportationMode" )
    private String bR_CTeTransportationMode;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeTransportationMode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_TRANSPORTATION_MODE =
        new BR_NFDocumentField<String>("BR_CTeTransportationMode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeEstimatedDeliveryDate</b>
     * </p>
     *
     * @return Estimated Delivery Date
     */
    @SerializedName( "BR_CTeEstimatedDeliveryDate" )
    @JsonProperty( "BR_CTeEstimatedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_CTeEstimatedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_CTeEstimatedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeEstimatedDeliveryDate</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<LocalDateTime> BRC_TE_ESTIMATED_DELIVERY_DATE =
        new BR_NFDocumentField<LocalDateTime>("BR_CTeEstimatedDeliveryDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeIsTruckFullyLoaded</b>
     * </p>
     *
     * @return Full Truck Load Indicator
     */
    @SerializedName( "BR_CTeIsTruckFullyLoaded" )
    @JsonProperty( "BR_CTeIsTruckFullyLoaded" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_CTeIsTruckFullyLoaded" )
    private Boolean bR_CTeIsTruckFullyLoaded;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeIsTruckFullyLoaded</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRC_TE_IS_TRUCK_FULLY_LOADED =
        new BR_NFDocumentField<Boolean>("BR_CTeIsTruckFullyLoaded");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeJurisdictionCodeOrigin</b>
     * </p>
     *
     * @return Jurisdiction Code of the Point of Origin
     */
    @SerializedName( "BR_CTeJurisdictionCodeOrigin" )
    @JsonProperty( "BR_CTeJurisdictionCodeOrigin" )
    @Nullable
    @ODataField( odataName = "BR_CTeJurisdictionCodeOrigin" )
    private String bR_CTeJurisdictionCodeOrigin;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeJurisdictionCodeOrigin</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_JURISDICTION_CODE_ORIGIN =
        new BR_NFDocumentField<String>("BR_CTeJurisdictionCodeOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeJurisdictionCodeDest</b>
     * </p>
     *
     * @return Jurisdiction Code of the Final Destination
     */
    @SerializedName( "BR_CTeJurisdictionCodeDest" )
    @JsonProperty( "BR_CTeJurisdictionCodeDest" )
    @Nullable
    @ODataField( odataName = "BR_CTeJurisdictionCodeDest" )
    private String bR_CTeJurisdictionCodeDest;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeJurisdictionCodeDest</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRC_TE_JURISDICTION_CODE_DEST =
        new BR_NFDocumentField<String>("BR_CTeJurisdictionCodeDest");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSVerificationCode</b>
     * </p>
     *
     * @return Verification Code
     */
    @SerializedName( "BR_NFSVerificationCode" )
    @JsonProperty( "BR_NFSVerificationCode" )
    @Nullable
    @ODataField( odataName = "BR_NFSVerificationCode" )
    private String bR_NFSVerificationCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSVerificationCode</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNFS_VERIFICATION_CODE =
        new BR_NFDocumentField<String>("BR_NFSVerificationCode");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSNumber</b>
     * </p>
     *
     * @return Service NF-e Number
     */
    @SerializedName( "BR_NFSNumber" )
    @JsonProperty( "BR_NFSNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFSNumber" )
    private String bR_NFSNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNFS_NUMBER = new BR_NFDocumentField<String>("BR_NFSNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFHasServiceItem</b>
     * </p>
     *
     * @return Service NF/NF-e
     */
    @SerializedName( "BR_NFHasServiceItem" )
    @JsonProperty( "BR_NFHasServiceItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFHasServiceItem" )
    private Boolean bR_NFHasServiceItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFHasServiceItem</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<Boolean> BRNF_HAS_SERVICE_ITEM =
        new BR_NFDocumentField<Boolean>("BR_NFHasServiceItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @return The isBusinessPurposeCompleted contained in this entity.
     */
    @SerializedName( "IsBusinessPurposeCompleted" )
    @JsonProperty( "IsBusinessPurposeCompleted" )
    @Nullable
    @ODataField( odataName = "IsBusinessPurposeCompleted" )
    private String isBusinessPurposeCompleted;
    /**
     * Use with available fluent helpers to apply the <b>IsBusinessPurposeCompleted</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> IS_BUSINESS_PURPOSE_COMPLETED =
        new BR_NFDocumentField<String>("IsBusinessPurposeCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Name of Company Code or Company
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> COMPANY_CODE_NAME =
        new BR_NFDocumentField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorTransaction</b>
     * </p>
     *
     * @return Intermediator Indicator
     */
    @SerializedName( "BR_NFeIntermediatorTransaction" )
    @JsonProperty( "BR_NFeIntermediatorTransaction" )
    @Nullable
    @ODataField( odataName = "BR_NFeIntermediatorTransaction" )
    private String bR_NFeIntermediatorTransaction;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeIntermediatorTransaction</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_INTERMEDIATOR_TRANSACTION =
        new BR_NFDocumentField<String>("BR_NFeIntermediatorTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorRegistry</b>
     * </p>
     *
     * @return Intermediator Identification Registry
     */
    @SerializedName( "BR_NFeIntermediatorRegistry" )
    @JsonProperty( "BR_NFeIntermediatorRegistry" )
    @Nullable
    @ODataField( odataName = "BR_NFeIntermediatorRegistry" )
    private String bR_NFeIntermediatorRegistry;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeIntermediatorRegistry</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_INTERMEDIATOR_REGISTRY =
        new BR_NFDocumentField<String>("BR_NFeIntermediatorRegistry");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorCNPJ</b>
     * </p>
     *
     * @return CNPJ of the Intermediator
     */
    @SerializedName( "BR_NFeIntermediatorCNPJ" )
    @JsonProperty( "BR_NFeIntermediatorCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_NFeIntermediatorCNPJ" )
    private String bR_NFeIntermediatorCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeIntermediatorCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRN_FE_INTERMEDIATOR_CNPJ =
        new BR_NFDocumentField<String>("BR_NFeIntermediatorCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 999
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMessageText</b>
     * </p>
     *
     * @return The bR_NFMessageText contained in this entity.
     */
    @SerializedName( "BR_NFMessageText" )
    @JsonProperty( "BR_NFMessageText" )
    @Nullable
    @ODataField( odataName = "BR_NFMessageText" )
    private String bR_NFMessageText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMessageText</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_MESSAGE_TEXT =
        new BR_NFDocumentField<String>("BR_NFMessageText");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalFiscalInfoText</b>
     * </p>
     *
     * @return The bR_NFAdditionalFiscalInfoText contained in this entity.
     */
    @SerializedName( "BR_NFAdditionalFiscalInfoText" )
    @JsonProperty( "BR_NFAdditionalFiscalInfoText" )
    @Nullable
    @ODataField( odataName = "BR_NFAdditionalFiscalInfoText" )
    private String bR_NFAdditionalFiscalInfoText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdditionalFiscalInfoText</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_ADDITIONAL_FISCAL_INFO_TEXT =
        new BR_NFDocumentField<String>("BR_NFAdditionalFiscalInfoText");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalCompanyInfoText</b>
     * </p>
     *
     * @return The bR_NFAdditionalCompanyInfoText contained in this entity.
     */
    @SerializedName( "BR_NFAdditionalCompanyInfoText" )
    @JsonProperty( "BR_NFAdditionalCompanyInfoText" )
    @Nullable
    @ODataField( odataName = "BR_NFAdditionalCompanyInfoText" )
    private String bR_NFAdditionalCompanyInfoText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdditionalCompanyInfoText</b> field to query operations.
     *
     */
    public final static BR_NFDocumentField<String> BRNF_ADDITIONAL_COMPANY_INFO_TEXT =
        new BR_NFDocumentField<String>("BR_NFAdditionalCompanyInfoText");
    /**
     * Navigation property <b>to_BR_NFAdditionalInformation</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFAdditionalInformation</b>.
     *
     */
    @SerializedName( "to_BR_NFAdditionalInformation" )
    @JsonProperty( "to_BR_NFAdditionalInformation" )
    @ODataField( odataName = "to_BR_NFAdditionalInformation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFAdditionalInformation> toBR_NFAdditionalInformation;
    /**
     * Navigation property <b>to_BR_NFDocumentReference</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFDocumentReference</b>.
     *
     */
    @SerializedName( "to_BR_NFDocumentReference" )
    @JsonProperty( "to_BR_NFDocumentReference" )
    @ODataField( odataName = "to_BR_NFDocumentReference" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFDocumentReference> toBR_NFDocumentReference;
    /**
     * Navigation property <b>to_BR_NFePayment</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFePayment</b>.
     *
     */
    @SerializedName( "to_BR_NFePayment" )
    @JsonProperty( "to_BR_NFePayment" )
    @ODataField( odataName = "to_BR_NFePayment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFePayment> toBR_NFePayment;
    /**
     * Navigation property <b>to_BR_NFExportDeclaration</b> for <b>BR_NFDocument</b> to single
     * <b>BR_NFExportDeclaration</b>.
     *
     */
    @SerializedName( "to_BR_NFExportDeclaration" )
    @JsonProperty( "to_BR_NFExportDeclaration" )
    @ODataField( odataName = "to_BR_NFExportDeclaration" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFExportDeclaration toBR_NFExportDeclaration;
    /**
     * Navigation property <b>to_BR_NFHeaderText</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFHeaderText</b>.
     *
     */
    @SerializedName( "to_BR_NFHeaderText" )
    @JsonProperty( "to_BR_NFHeaderText" )
    @ODataField( odataName = "to_BR_NFHeaderText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFHeaderText> toBR_NFHeaderText;
    /**
     * Navigation property <b>to_BR_NFImportDocument</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFImportDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFImportDocument" )
    @JsonProperty( "to_BR_NFImportDocument" )
    @ODataField( odataName = "to_BR_NFImportDocument" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFImportDocument> toBR_NFImportDocument;
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFItem> toBR_NFItem;
    /**
     * Navigation property <b>to_BR_NFPartner</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFPartner</b>.
     *
     */
    @SerializedName( "to_BR_NFPartner" )
    @JsonProperty( "to_BR_NFPartner" )
    @ODataField( odataName = "to_BR_NFPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFPartner> toBR_NFPartner;
    /**
     * Navigation property <b>to_BR_NFReferencedProcess</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFReferencedProcess</b>.
     *
     */
    @SerializedName( "to_BR_NFReferencedProcess" )
    @JsonProperty( "to_BR_NFReferencedProcess" )
    @ODataField( odataName = "to_BR_NFReferencedProcess" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFReferencedProcess> toBR_NFReferencedProcess;
    /**
     * Navigation property <b>to_BR_NFSugarCaneDeductible</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFSugarCaneDeductible</b>.
     *
     */
    @SerializedName( "to_BR_NFSugarCaneDeductible" )
    @JsonProperty( "to_BR_NFSugarCaneDeductible" )
    @ODataField( odataName = "to_BR_NFSugarCaneDeductible" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFSugarCaneDeductible> toBR_NFSugarCaneDeductible;
    /**
     * Navigation property <b>to_BR_NFSugarCaneSupply</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFSugarCaneSupply</b>.
     *
     */
    @SerializedName( "to_BR_NFSugarCaneSupply" )
    @JsonProperty( "to_BR_NFSugarCaneSupply" )
    @ODataField( odataName = "to_BR_NFSugarCaneSupply" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFSugarCaneSupply> toBR_NFSugarCaneSupply;
    /**
     * Navigation property <b>to_BR_NFTradeNote</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFTradeNote</b>.
     *
     */
    @SerializedName( "to_BR_NFTradeNote" )
    @JsonProperty( "to_BR_NFTradeNote" )
    @ODataField( odataName = "to_BR_NFTradeNote" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFTradeNote> toBR_NFTradeNote;
    /**
     * Navigation property <b>to_BR_NFTrailer</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFTrailer</b>.
     *
     */
    @SerializedName( "to_BR_NFTrailer" )
    @JsonProperty( "to_BR_NFTrailer" )
    @ODataField( odataName = "to_BR_NFTrailer" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFTrailer> toBR_NFTrailer;
    /**
     * Navigation property <b>to_BR_NFTransportedVolume</b> for <b>BR_NFDocument</b> to multiple
     * <b>BR_NFTransportedVolume</b>.
     *
     */
    @SerializedName( "to_BR_NFTransportedVolume" )
    @JsonProperty( "to_BR_NFTransportedVolume" )
    @ODataField( odataName = "to_BR_NFTransportedVolume" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFTransportedVolume> toBR_NFTransportedVolume;
    /**
     * Navigation property <b>to_BR_OneTimePartner</b> for <b>BR_NFDocument</b> to multiple <b>BR_OneTimePartner</b>.
     *
     */
    @SerializedName( "to_BR_OneTimePartner" )
    @JsonProperty( "to_BR_OneTimePartner" )
    @ODataField( odataName = "to_BR_OneTimePartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_OneTimePartner> toBR_OneTimePartner;
    /**
     * Navigation property <b>to_BR_TechnicalResponsible</b> for <b>BR_NFDocument</b> to single
     * <b>BR_TechnicalResponsible</b>.
     *
     */
    @SerializedName( "to_BR_TechnicalResponsible" )
    @JsonProperty( "to_BR_TechnicalResponsible" )
    @ODataField( odataName = "to_BR_TechnicalResponsible" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_TechnicalResponsible toBR_TechnicalResponsible;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFAdditionalInformation</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFAdditionalInformation> TO_BRNF_ADDITIONAL_INFORMATION =
        new BR_NFDocumentLink<BR_NFAdditionalInformation>("to_BR_NFAdditionalInformation");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDocumentReference</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFDocumentReference> TO_BRNF_DOCUMENT_REFERENCE =
        new BR_NFDocumentLink<BR_NFDocumentReference>("to_BR_NFDocumentReference");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFePayment</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFePayment> TO_BRN_FE_PAYMENT =
        new BR_NFDocumentLink<BR_NFePayment>("to_BR_NFePayment");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFExportDeclaration</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentOneToOneLink<BR_NFExportDeclaration> TO_BRNF_EXPORT_DECLARATION =
        new BR_NFDocumentOneToOneLink<BR_NFExportDeclaration>("to_BR_NFExportDeclaration");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFHeaderText</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFHeaderText> TO_BRNF_HEADER_TEXT =
        new BR_NFDocumentLink<BR_NFHeaderText>("to_BR_NFHeaderText");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFImportDocument</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFImportDocument> TO_BRNF_IMPORT_DOCUMENT =
        new BR_NFDocumentLink<BR_NFImportDocument>("to_BR_NFImportDocument");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFItem> TO_BRNF_ITEM = new BR_NFDocumentLink<BR_NFItem>("to_BR_NFItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFPartner</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFPartner> TO_BRNF_PARTNER =
        new BR_NFDocumentLink<BR_NFPartner>("to_BR_NFPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFReferencedProcess</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFReferencedProcess> TO_BRNF_REFERENCED_PROCESS =
        new BR_NFDocumentLink<BR_NFReferencedProcess>("to_BR_NFReferencedProcess");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFSugarCaneDeductible</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFSugarCaneDeductible> TO_BRNF_SUGAR_CANE_DEDUCTIBLE =
        new BR_NFDocumentLink<BR_NFSugarCaneDeductible>("to_BR_NFSugarCaneDeductible");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFSugarCaneSupply</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFSugarCaneSupply> TO_BRNF_SUGAR_CANE_SUPPLY =
        new BR_NFDocumentLink<BR_NFSugarCaneSupply>("to_BR_NFSugarCaneSupply");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFTradeNote</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFTradeNote> TO_BRNF_TRADE_NOTE =
        new BR_NFDocumentLink<BR_NFTradeNote>("to_BR_NFTradeNote");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFTrailer</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFTrailer> TO_BRNF_TRAILER =
        new BR_NFDocumentLink<BR_NFTrailer>("to_BR_NFTrailer");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFTransportedVolume</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_NFTransportedVolume> TO_BRNF_TRANSPORTED_VOLUME =
        new BR_NFDocumentLink<BR_NFTransportedVolume>("to_BR_NFTransportedVolume");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_OneTimePartner</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentLink<BR_OneTimePartner> TO_BR_ONE_TIME_PARTNER =
        new BR_NFDocumentLink<BR_OneTimePartner>("to_BR_OneTimePartner");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_TechnicalResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFDocumentOneToOneLink<BR_TechnicalResponsible> TO_BR_TECHNICAL_RESPONSIBLE =
        new BR_NFDocumentOneToOneLink<BR_TechnicalResponsible>("to_BR_TechnicalResponsible");

    @Nonnull
    @Override
    public Class<BR_NFDocument> getType()
    {
        return BR_NFDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerFunction</b>
     * </p>
     *
     * @param bR_NFPartnerFunction
     *            Nota Fiscal Partner Function
     */
    public void setBR_NFPartnerFunction( @Nullable final String bR_NFPartnerFunction )
    {
        rememberChangedField("BR_NFPartnerFunction", this.bR_NFPartnerFunction);
        this.bR_NFPartnerFunction = bR_NFPartnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartner</b>
     * </p>
     *
     * @param bR_NFPartner
     *            Partner ID (Customer, Vendor, Business Place)
     */
    public void setBR_NFPartner( @Nullable final String bR_NFPartner )
    {
        rememberChangedField("BR_NFPartner", this.bR_NFPartner);
        this.bR_NFPartner = bR_NFPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName1</b>
     * </p>
     *
     * @param bR_NFPartnerName1
     *            Name 1
     */
    public void setBR_NFPartnerName1( @Nullable final String bR_NFPartnerName1 )
    {
        rememberChangedField("BR_NFPartnerName1", this.bR_NFPartnerName1);
        this.bR_NFPartnerName1 = bR_NFPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName2</b>
     * </p>
     *
     * @param bR_NFPartnerName2
     *            Name 2
     */
    public void setBR_NFPartnerName2( @Nullable final String bR_NFPartnerName2 )
    {
        rememberChangedField("BR_NFPartnerName2", this.bR_NFPartnerName2);
        this.bR_NFPartnerName2 = bR_NFPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName3</b>
     * </p>
     *
     * @param bR_NFPartnerName3
     *            Name 3
     */
    public void setBR_NFPartnerName3( @Nullable final String bR_NFPartnerName3 )
    {
        rememberChangedField("BR_NFPartnerName3", this.bR_NFPartnerName3);
        this.bR_NFPartnerName3 = bR_NFPartnerName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName4</b>
     * </p>
     *
     * @param bR_NFPartnerName4
     *            Name 4
     */
    public void setBR_NFPartnerName4( @Nullable final String bR_NFPartnerName4 )
    {
        rememberChangedField("BR_NFPartnerName4", this.bR_NFPartnerName4);
        this.bR_NFPartnerName4 = bR_NFPartnerName4;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerIsOneTimeAccount</b>
     * </p>
     *
     * @param partnerIsOneTimeAccount
     *            Indicator: Is the Account a One-Time Account?
     */
    public void setPartnerIsOneTimeAccount( @Nullable final Boolean partnerIsOneTimeAccount )
    {
        rememberChangedField("PartnerIsOneTimeAccount", this.partnerIsOneTimeAccount);
        this.partnerIsOneTimeAccount = partnerIsOneTimeAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerType</b>
     * </p>
     *
     * @param bR_NFPartnerType
     *            Type
     */
    public void setBR_NFPartnerType( @Nullable final String bR_NFPartnerType )
    {
        rememberChangedField("BR_NFPartnerType", this.bR_NFPartnerType);
        this.bR_NFPartnerType = bR_NFPartnerType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStreetName</b>
     * </p>
     *
     * @param bR_NFPartnerStreetName
     *            Street and House Number
     */
    public void setBR_NFPartnerStreetName( @Nullable final String bR_NFPartnerStreetName )
    {
        rememberChangedField("BR_NFPartnerStreetName", this.bR_NFPartnerStreetName);
        this.bR_NFPartnerStreetName = bR_NFPartnerStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerHouseNumber</b>
     * </p>
     *
     * @param businessPartnerHouseNumber
     *            House Number
     */
    public void setBusinessPartnerHouseNumber( @Nullable final String businessPartnerHouseNumber )
    {
        rememberChangedField("BusinessPartnerHouseNumber", this.businessPartnerHouseNumber);
        this.businessPartnerHouseNumber = businessPartnerHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPHsNmbrSuplmntTxt</b>
     * </p>
     *
     * @param bPHsNmbrSuplmntTxt
     *            House number supplement
     */
    public void setBPHsNmbrSuplmntTxt( @Nullable final String bPHsNmbrSuplmntTxt )
    {
        rememberChangedField("BPHsNmbrSuplmntTxt", this.bPHsNmbrSuplmntTxt);
        this.bPHsNmbrSuplmntTxt = bPHsNmbrSuplmntTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCityName</b>
     * </p>
     *
     * @param bR_NFPartnerCityName
     *            City
     */
    public void setBR_NFPartnerCityName( @Nullable final String bR_NFPartnerCityName )
    {
        rememberChangedField("BR_NFPartnerCityName", this.bR_NFPartnerCityName);
        this.bR_NFPartnerCityName = bR_NFPartnerCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerRegionCode</b>
     * </p>
     *
     * @param bR_NFPartnerRegionCode
     *            Region (State, Province, County)
     */
    public void setBR_NFPartnerRegionCode( @Nullable final String bR_NFPartnerRegionCode )
    {
        rememberChangedField("BR_NFPartnerRegionCode", this.bR_NFPartnerRegionCode);
        this.bR_NFPartnerRegionCode = bR_NFPartnerRegionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerDistrictName</b>
     * </p>
     *
     * @param bR_NFPartnerDistrictName
     *            District
     */
    public void setBR_NFPartnerDistrictName( @Nullable final String bR_NFPartnerDistrictName )
    {
        rememberChangedField("BR_NFPartnerDistrictName", this.bR_NFPartnerDistrictName);
        this.bR_NFPartnerDistrictName = bR_NFPartnerDistrictName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCountryCode</b>
     * </p>
     *
     * @param bR_NFPartnerCountryCode
     *            Country/Region Key
     */
    public void setBR_NFPartnerCountryCode( @Nullable final String bR_NFPartnerCountryCode )
    {
        rememberChangedField("BR_NFPartnerCountryCode", this.bR_NFPartnerCountryCode);
        this.bR_NFPartnerCountryCode = bR_NFPartnerCountryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPostalCode</b>
     * </p>
     *
     * @param bR_NFPartnerPostalCode
     *            Postal Code
     */
    public void setBR_NFPartnerPostalCode( @Nullable final String bR_NFPartnerPostalCode )
    {
        rememberChangedField("BR_NFPartnerPostalCode", this.bR_NFPartnerPostalCode);
        this.bR_NFPartnerPostalCode = bR_NFPartnerPostalCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerIsNaturalPerson</b>
     * </p>
     *
     * @param bR_NFPartnerIsNaturalPerson
     *            Natural Person
     */
    public void setBR_NFPartnerIsNaturalPerson( @Nullable final Boolean bR_NFPartnerIsNaturalPerson )
    {
        rememberChangedField("BR_NFPartnerIsNaturalPerson", this.bR_NFPartnerIsNaturalPerson);
        this.bR_NFPartnerIsNaturalPerson = bR_NFPartnerIsNaturalPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNPJ</b>
     * </p>
     *
     * @param bR_NFPartnerCNPJ
     *            CNPJ Number
     */
    public void setBR_NFPartnerCNPJ( @Nullable final String bR_NFPartnerCNPJ )
    {
        rememberChangedField("BR_NFPartnerCNPJ", this.bR_NFPartnerCNPJ);
        this.bR_NFPartnerCNPJ = bR_NFPartnerCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCPF</b>
     * </p>
     *
     * @param bR_NFPartnerCPF
     *            CPF number
     */
    public void setBR_NFPartnerCPF( @Nullable final String bR_NFPartnerCPF )
    {
        rememberChangedField("BR_NFPartnerCPF", this.bR_NFPartnerCPF);
        this.bR_NFPartnerCPF = bR_NFPartnerCPF;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Addresses: telephone no.
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumber</b>
     * </p>
     *
     * @param bR_NFPartnerStateTaxNumber
     *            State Tax Number
     */
    public void setBR_NFPartnerStateTaxNumber( @Nullable final String bR_NFPartnerStateTaxNumber )
    {
        rememberChangedField("BR_NFPartnerStateTaxNumber", this.bR_NFPartnerStateTaxNumber);
        this.bR_NFPartnerStateTaxNumber = bR_NFPartnerStateTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerMunicipalTaxNumber</b>
     * </p>
     *
     * @param bR_NFPartnerMunicipalTaxNumber
     *            Municipal Tax Number
     */
    public void setBR_NFPartnerMunicipalTaxNumber( @Nullable final String bR_NFPartnerMunicipalTaxNumber )
    {
        rememberChangedField("BR_NFPartnerMunicipalTaxNumber", this.bR_NFPartnerMunicipalTaxNumber);
        this.bR_NFPartnerMunicipalTaxNumber = bR_NFPartnerMunicipalTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumberST</b>
     * </p>
     *
     * @param bR_NFPartnerStateTaxNumberST
     *            State Tax Number of Partner (SubTrib)
     */
    public void setBR_NFPartnerStateTaxNumberST( @Nullable final String bR_NFPartnerStateTaxNumberST )
    {
        rememberChangedField("BR_NFPartnerStateTaxNumberST", this.bR_NFPartnerStateTaxNumberST);
        this.bR_NFPartnerStateTaxNumberST = bR_NFPartnerStateTaxNumberST;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNAE</b>
     * </p>
     *
     * @param bR_NFPartnerCNAE
     *            CNAE Code of Partner
     */
    public void setBR_NFPartnerCNAE( @Nullable final String bR_NFPartnerCNAE )
    {
        rememberChangedField("BR_NFPartnerCNAE", this.bR_NFPartnerCNAE);
        this.bR_NFPartnerCNAE = bR_NFPartnerCNAE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTaxRegimenCode</b>
     * </p>
     *
     * @param bR_NFPartnerTaxRegimenCode
     *            Tax Regimen Code (CRT) of Partner
     */
    public void setBR_NFPartnerTaxRegimenCode( @Nullable final String bR_NFPartnerTaxRegimenCode )
    {
        rememberChangedField("BR_NFPartnerTaxRegimenCode", this.bR_NFPartnerTaxRegimenCode);
        this.bR_NFPartnerTaxRegimenCode = bR_NFPartnerTaxRegimenCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCFOPCategory</b>
     * </p>
     *
     * @param bR_PartnerCFOPCategory
     *            Customer's CFOP category
     */
    public void setBR_PartnerCFOPCategory( @Nullable final String bR_PartnerCFOPCategory )
    {
        rememberChangedField("BR_PartnerCFOPCategory", this.bR_PartnerCFOPCategory);
        this.bR_PartnerCFOPCategory = bR_PartnerCFOPCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_SUFRAMACode</b>
     * </p>
     *
     * @param bR_SUFRAMACode
     *            SUFRAMA Subscription of Partner
     */
    public void setBR_SUFRAMACode( @Nullable final String bR_SUFRAMACode )
    {
        rememberChangedField("BR_SUFRAMACode", this.bR_SUFRAMACode);
        this.bR_SUFRAMACode = bR_SUFRAMACode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_SPEDTaxCategory</b>
     * </p>
     *
     * @param bR_SPEDTaxCategory
     *            Tax Category
     */
    public void setBR_SPEDTaxCategory( @Nullable final String bR_SPEDTaxCategory )
    {
        rememberChangedField("BR_SPEDTaxCategory", this.bR_SPEDTaxCategory);
        this.bR_SPEDTaxCategory = bR_SPEDTaxCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReportingIncgOrOutgDate</b>
     * </p>
     *
     * @param reportingIncgOrOutgDate
     *            TMF Reporting Date
     */
    public void setReportingIncgOrOutgDate( @Nullable final LocalDateTime reportingIncgOrOutgDate )
    {
        rememberChangedField("ReportingIncgOrOutgDate", this.reportingIncgOrOutgDate);
        this.reportingIncgOrOutgDate = reportingIncgOrOutgDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTaxJurisdiction</b>
     * </p>
     *
     * @param bR_NFPartnerTaxJurisdiction
     *            Tax Jurisdiction
     */
    public void setBR_NFPartnerTaxJurisdiction( @Nullable final String bR_NFPartnerTaxJurisdiction )
    {
        rememberChangedField("BR_NFPartnerTaxJurisdiction", this.bR_NFPartnerTaxJurisdiction);
        this.bR_NFPartnerTaxJurisdiction = bR_NFPartnerTaxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFObservationText</b>
     * </p>
     *
     * @param bR_NFObservationText
     *            Legal Books Mod. 1 + 2: Header text for observations column
     */
    public void setBR_NFObservationText( @Nullable final String bR_NFObservationText )
    {
        rememberChangedField("BR_NFObservationText", this.bR_NFObservationText);
        this.bR_NFObservationText = bR_NFObservationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransportType</b>
     * </p>
     *
     * @param meansOfTransportType
     *            Means of Transport
     */
    public void setMeansOfTransportType( @Nullable final String meansOfTransportType )
    {
        rememberChangedField("MeansOfTransportType", this.meansOfTransportType);
        this.meansOfTransportType = meansOfTransportType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeansOfTransport</b>
     * </p>
     *
     * @param meansOfTransport
     *            Transport ID
     */
    public void setMeansOfTransport( @Nullable final String meansOfTransport )
    {
        rememberChangedField("MeansOfTransport", this.meansOfTransport);
        this.meansOfTransport = meansOfTransport;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnitBrand</b>
     * </p>
     *
     * @param bR_NFShippingUnitBrand
     *            Shipping Unit Mark
     */
    public void setBR_NFShippingUnitBrand( @Nullable final String bR_NFShippingUnitBrand )
    {
        rememberChangedField("BR_NFShippingUnitBrand", this.bR_NFShippingUnitBrand);
        this.bR_NFShippingUnitBrand = bR_NFShippingUnitBrand;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnitNumber</b>
     * </p>
     *
     * @param bR_NFShippingUnitNumber
     *            Shipping Unit Number
     */
    public void setBR_NFShippingUnitNumber( @Nullable final String bR_NFShippingUnitNumber )
    {
        rememberChangedField("BR_NFShippingUnitNumber", this.bR_NFShippingUnitNumber);
        this.bR_NFShippingUnitNumber = bR_NFShippingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNumberOfPackages</b>
     * </p>
     *
     * @param bR_NFNumberOfPackages
     *            Number of Packages
     */
    public void setBR_NFNumberOfPackages( @Nullable final String bR_NFNumberOfPackages )
    {
        rememberChangedField("BR_NFNumberOfPackages", this.bR_NFNumberOfPackages);
        this.bR_NFNumberOfPackages = bR_NFNumberOfPackages;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFShippingUnit</b>
     * </p>
     *
     * @param bR_NFShippingUnit
     *            Shipping Unit
     */
    public void setBR_NFShippingUnit( @Nullable final String bR_NFShippingUnit )
    {
        rememberChangedField("BR_NFShippingUnit", this.bR_NFShippingUnit);
        this.bR_NFShippingUnit = bR_NFShippingUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFArrivalOrDepartureDate</b>
     * </p>
     *
     * @param bR_NFArrivalOrDepartureDate
     *            Goods Departure or Arrival Date
     */
    public void setBR_NFArrivalOrDepartureDate( @Nullable final LocalDateTime bR_NFArrivalOrDepartureDate )
    {
        rememberChangedField("BR_NFArrivalOrDepartureDate", this.bR_NFArrivalOrDepartureDate);
        this.bR_NFArrivalOrDepartureDate = bR_NFArrivalOrDepartureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderWeightUnit</b>
     * </p>
     *
     * @param headerWeightUnit
     *            Unit of Weight
     */
    public void setHeaderWeightUnit( @Nullable final String headerWeightUnit )
    {
        rememberChangedField("HeaderWeightUnit", this.headerWeightUnit);
        this.headerWeightUnit = headerWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderNetWeight</b>
     * </p>
     *
     * @param headerNetWeight
     *            Net Weight
     */
    public void setHeaderNetWeight( @Nullable final BigDecimal headerNetWeight )
    {
        rememberChangedField("HeaderNetWeight", this.headerNetWeight);
        this.headerNetWeight = headerNetWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HeaderGrossWeight</b>
     * </p>
     *
     * @param headerGrossWeight
     *            Gross Weight
     */
    public void setHeaderGrossWeight( @Nullable final BigDecimal headerGrossWeight )
    {
        rememberChangedField("HeaderGrossWeight", this.headerGrossWeight);
        this.headerGrossWeight = headerGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFArrivalOrDepartureTime</b>
     * </p>
     *
     * @param bR_NFArrivalOrDepartureTime
     *            Departure/Arrival Time
     */
    public void setBR_NFArrivalOrDepartureTime( @Nullable final LocalTime bR_NFArrivalOrDepartureTime )
    {
        rememberChangedField("BR_NFArrivalOrDepartureTime", this.bR_NFArrivalOrDepartureTime);
        this.bR_NFArrivalOrDepartureTime = bR_NFArrivalOrDepartureTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_WhldgICMSForTranspCFOP</b>
     * </p>
     *
     * @param bR_WhldgICMSForTranspCFOP
     *            CFOP of ICMS Withholding for Transportation
     */
    public void setBR_WhldgICMSForTranspCFOP( @Nullable final String bR_WhldgICMSForTranspCFOP )
    {
        rememberChangedField("BR_WhldgICMSForTranspCFOP", this.bR_WhldgICMSForTranspCFOP);
        this.bR_WhldgICMSForTranspCFOP = bR_WhldgICMSForTranspCFOP;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_WhldgICMSForTranspCity</b>
     * </p>
     *
     * @param bR_WhldgICMSForTranspCity
     *            City Code
     */
    public void setBR_WhldgICMSForTranspCity( @Nullable final String bR_WhldgICMSForTranspCity )
    {
        rememberChangedField("BR_WhldgICMSForTranspCity", this.bR_WhldgICMSForTranspCity);
        this.bR_WhldgICMSForTranspCity = bR_WhldgICMSForTranspCity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User who created the document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Document Creation Date
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Document Creation Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            User who last changed the document
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date when document was changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time when the document was last changed
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPrinted</b>
     * </p>
     *
     * @param bR_NFIsPrinted
     *            Nota Fiscal Was Printed
     */
    public void setBR_NFIsPrinted( @Nullable final Boolean bR_NFIsPrinted )
    {
        rememberChangedField("BR_NFIsPrinted", this.bR_NFIsPrinted);
        this.bR_NFIsPrinted = bR_NFIsPrinted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCreatedManually</b>
     * </p>
     *
     * @param bR_NFIsCreatedManually
     *            Manually Created
     */
    public void setBR_NFIsCreatedManually( @Nullable final String bR_NFIsCreatedManually )
    {
        rememberChangedField("BR_NFIsCreatedManually", this.bR_NFIsCreatedManually);
        this.bR_NFIsCreatedManually = bR_NFIsCreatedManually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsIncomingIssdByCust</b>
     * </p>
     *
     * @param bR_NFIsIncomingIssdByCust
     *            Nota Fiscal Entrada
     */
    public void setBR_NFIsIncomingIssdByCust( @Nullable final String bR_NFIsIncomingIssdByCust )
    {
        rememberChangedField("BR_NFIsIncomingIssdByCust", this.bR_NFIsIncomingIssdByCust);
        this.bR_NFIsIncomingIssdByCust = bR_NFIsIncomingIssdByCust;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCanceled</b>
     * </p>
     *
     * @param bR_NFIsCanceled
     *            Nota Fiscal Cancelled
     */
    public void setBR_NFIsCanceled( @Nullable final Boolean bR_NFIsCanceled )
    {
        rememberChangedField("BR_NFIsCanceled", this.bR_NFIsCanceled);
        this.bR_NFIsCanceled = bR_NFIsCanceled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsChargingInvoice</b>
     * </p>
     *
     * @param bR_NFIsChargingInvoice
     *            NF is a fatura
     */
    public void setBR_NFIsChargingInvoice( @Nullable final Boolean bR_NFIsChargingInvoice )
    {
        rememberChangedField("BR_NFIsChargingInvoice", this.bR_NFIsChargingInvoice);
        this.bR_NFIsChargingInvoice = bR_NFIsChargingInvoice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDirection</b>
     * </p>
     *
     * @param bR_NFDirection
     *            Movement Direction
     */
    public void setBR_NFDirection( @Nullable final String bR_NFDirection )
    {
        rememberChangedField("BR_NFDirection", this.bR_NFDirection);
        this.bR_NFDirection = bR_NFDirection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFType</b>
     * </p>
     *
     * @param bR_NFType
     *            Nota Fiscal Type
     */
    public void setBR_NFType( @Nullable final String bR_NFType )
    {
        rememberChangedField("BR_NFType", this.bR_NFType);
        this.bR_NFType = bR_NFType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentType</b>
     * </p>
     *
     * @param bR_NFDocumentType
     *            Document Type
     */
    public void setBR_NFDocumentType( @Nullable final String bR_NFDocumentType )
    {
        rememberChangedField("BR_NFDocumentType", this.bR_NFDocumentType);
        this.bR_NFDocumentType = bR_NFDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFModel</b>
     * </p>
     *
     * @param bR_NFModel
     *            Nota Fiscal Model
     */
    public void setBR_NFModel( @Nullable final String bR_NFModel )
    {
        rememberChangedField("BR_NFModel", this.bR_NFModel);
        this.bR_NFModel = bR_NFModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNumber</b>
     * </p>
     *
     * @param bR_NFNumber
     *            Nota Fiscal Number
     */
    public void setBR_NFNumber( @Nullable final String bR_NFNumber )
    {
        rememberChangedField("BR_NFNumber", this.bR_NFNumber);
        this.bR_NFNumber = bR_NFNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSeries</b>
     * </p>
     *
     * @param bR_NFSeries
     *            Nota Fiscal Series
     */
    public void setBR_NFSeries( @Nullable final String bR_NFSeries )
    {
        rememberChangedField("BR_NFSeries", this.bR_NFSeries);
        this.bR_NFSeries = bR_NFSeries;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSubSeries</b>
     * </p>
     *
     * @param bR_NFSubSeries
     *            Sub series
     */
    public void setBR_NFSubSeries( @Nullable final String bR_NFSubSeries )
    {
        rememberChangedField("BR_NFSubSeries", this.bR_NFSubSeries);
        this.bR_NFSubSeries = bR_NFSubSeries;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSituationCode</b>
     * </p>
     *
     * @param bR_NFSituationCode
     *            Status Code of Fiscal Document
     */
    public void setBR_NFSituationCode( @Nullable final String bR_NFSituationCode )
    {
        rememberChangedField("BR_NFSituationCode", this.bR_NFSituationCode);
        this.bR_NFSituationCode = bR_NFSituationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIssuedBy</b>
     * </p>
     *
     * @param bR_NFIssuedBy
     *            Nota Fiscal Issued By
     */
    public void setBR_NFIssuedBy( @Nullable final String bR_NFIssuedBy )
    {
        rememberChangedField("BR_NFIssuedBy", this.bR_NFIssuedBy);
        this.bR_NFIssuedBy = bR_NFIssuedBy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsContingency</b>
     * </p>
     *
     * @param bR_NFIsContingency
     *            Contingency Indicator for Nota Fiscal
     */
    public void setBR_NFIsContingency( @Nullable final Boolean bR_NFIsContingency )
    {
        rememberChangedField("BR_NFIsContingency", this.bR_NFIsContingency);
        this.bR_NFIsContingency = bR_NFIsContingency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthznProtocolNumber</b>
     * </p>
     *
     * @param bR_NFAuthznProtocolNumber
     *            Protocol Number
     */
    public void setBR_NFAuthznProtocolNumber( @Nullable final String bR_NFAuthznProtocolNumber )
    {
        rememberChangedField("BR_NFAuthznProtocolNumber", this.bR_NFAuthznProtocolNumber);
        this.bR_NFAuthznProtocolNumber = bR_NFAuthznProtocolNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthenticationDate</b>
     * </p>
     *
     * @param bR_NFAuthenticationDate
     *            Processing Date
     */
    public void setBR_NFAuthenticationDate( @Nullable final LocalDateTime bR_NFAuthenticationDate )
    {
        rememberChangedField("BR_NFAuthenticationDate", this.bR_NFAuthenticationDate);
        this.bR_NFAuthenticationDate = bR_NFAuthenticationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAuthenticationTime</b>
     * </p>
     *
     * @param bR_NFAuthenticationTime
     *            Processing Time
     */
    public void setBR_NFAuthenticationTime( @Nullable final LocalTime bR_NFAuthenticationTime )
    {
        rememberChangedField("BR_NFAuthenticationTime", this.bR_NFAuthenticationTime);
        this.bR_NFAuthenticationTime = bR_NFAuthenticationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeXMLVersion</b>
     * </p>
     *
     * @param bR_NFeXMLVersion
     *            XML Version
     */
    public void setBR_NFeXMLVersion( @Nullable final BigDecimal bR_NFeXMLVersion )
    {
        rememberChangedField("BR_NFeXMLVersion", this.bR_NFeXMLVersion);
        this.bR_NFeXMLVersion = bR_NFeXMLVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Invoice Number
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOriginalAmount</b>
     * </p>
     *
     * @param bR_NFOriginalAmount
     *            Invoice Original Amount
     */
    public void setBR_NFOriginalAmount( @Nullable final BigDecimal bR_NFOriginalAmount )
    {
        rememberChangedField("BR_NFOriginalAmount", this.bR_NFOriginalAmount);
        this.bR_NFOriginalAmount = bR_NFOriginalAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDiscountAmount</b>
     * </p>
     *
     * @param bR_NFDiscountAmount
     *            Invoice Discount Amount
     */
    public void setBR_NFDiscountAmount( @Nullable final BigDecimal bR_NFDiscountAmount )
    {
        rememberChangedField("BR_NFDiscountAmount", this.bR_NFDiscountAmount);
        this.bR_NFDiscountAmount = bR_NFDiscountAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetAmount</b>
     * </p>
     *
     * @param bR_NFNetAmount
     *            Invoice Net Amount
     */
    public void setBR_NFNetAmount( @Nullable final BigDecimal bR_NFNetAmount )
    {
        rememberChangedField("BR_NFNetAmount", this.bR_NFNetAmount);
        this.bR_NFNetAmount = bR_NFNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCommitmentNote</b>
     * </p>
     *
     * @param bR_NFCommitmentNote
     *            Commitment Note
     */
    public void setBR_NFCommitmentNote( @Nullable final String bR_NFCommitmentNote )
    {
        rememberChangedField("BR_NFCommitmentNote", this.bR_NFCommitmentNote);
        this.bR_NFCommitmentNote = bR_NFCommitmentNote;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneHarvest</b>
     * </p>
     *
     * @param sugarcaneHarvest
     *            Harvest ID
     */
    public void setSugarcaneHarvest( @Nullable final String sugarcaneHarvest )
    {
        rememberChangedField("SugarcaneHarvest", this.sugarcaneHarvest);
        this.sugarcaneHarvest = sugarcaneHarvest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneRefMonthYear</b>
     * </p>
     *
     * @param sugarcaneRefMonthYear
     *            Reference Month/Year
     */
    public void setSugarcaneRefMonthYear( @Nullable final String sugarcaneRefMonthYear )
    {
        rememberChangedField("SugarcaneRefMonthYear", this.sugarcaneRefMonthYear);
        this.sugarcaneRefMonthYear = sugarcaneRefMonthYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneCurMnthQtyUnit</b>
     * </p>
     *
     * @param sugarcaneCurMnthQtyUnit
     *            Unit of Measurement
     */
    public void setSugarcaneCurMnthQtyUnit( @Nullable final String sugarcaneCurMnthQtyUnit )
    {
        rememberChangedField("SugarcaneCurMnthQtyUnit", this.sugarcaneCurMnthQtyUnit);
        this.sugarcaneCurMnthQtyUnit = sugarcaneCurMnthQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneCurrentMonthQty</b>
     * </p>
     *
     * @param sugarcaneCurrentMonthQty
     *            Current Month Amount
     */
    public void setSugarcaneCurrentMonthQty( @Nullable final BigDecimal sugarcaneCurrentMonthQty )
    {
        rememberChangedField("SugarcaneCurrentMonthQty", this.sugarcaneCurrentMonthQty);
        this.sugarcaneCurrentMonthQty = sugarcaneCurrentMonthQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneLastMnthQtyUnit</b>
     * </p>
     *
     * @param sugarcaneLastMnthQtyUnit
     *            Unit of Measurement
     */
    public void setSugarcaneLastMnthQtyUnit( @Nullable final String sugarcaneLastMnthQtyUnit )
    {
        rememberChangedField("SugarcaneLastMnthQtyUnit", this.sugarcaneLastMnthQtyUnit);
        this.sugarcaneLastMnthQtyUnit = sugarcaneLastMnthQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneLastMnthQuantity</b>
     * </p>
     *
     * @param sugarcaneLastMnthQuantity
     *            Last Month Amount
     */
    public void setSugarcaneLastMnthQuantity( @Nullable final BigDecimal sugarcaneLastMnthQuantity )
    {
        rememberChangedField("SugarcaneLastMnthQuantity", this.sugarcaneLastMnthQuantity);
        this.sugarcaneLastMnthQuantity = sugarcaneLastMnthQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSumBothMnthsQtyUnit</b>
     * </p>
     *
     * @param sugarcaneSumBothMnthsQtyUnit
     *            Unit of Measurement
     */
    public void setSugarcaneSumBothMnthsQtyUnit( @Nullable final String sugarcaneSumBothMnthsQtyUnit )
    {
        rememberChangedField("SugarcaneSumBothMnthsQtyUnit", this.sugarcaneSumBothMnthsQtyUnit);
        this.sugarcaneSumBothMnthsQtyUnit = sugarcaneSumBothMnthsQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSumBothMonthsQty</b>
     * </p>
     *
     * @param sugarcaneSumBothMonthsQty
     *            Sum of Both Months
     */
    public void setSugarcaneSumBothMonthsQty( @Nullable final BigDecimal sugarcaneSumBothMonthsQty )
    {
        rememberChangedField("SugarcaneSumBothMonthsQty", this.sugarcaneSumBothMonthsQty);
        this.sugarcaneSumBothMonthsQty = sugarcaneSumBothMonthsQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSuppliesAmount</b>
     * </p>
     *
     * @param sugarcaneSuppliesAmount
     *            Supplies Amount
     */
    public void setSugarcaneSuppliesAmount( @Nullable final BigDecimal sugarcaneSuppliesAmount )
    {
        rememberChangedField("SugarcaneSuppliesAmount", this.sugarcaneSuppliesAmount);
        this.sugarcaneSuppliesAmount = sugarcaneSuppliesAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneTotalDeductionAmount</b>
     * </p>
     *
     * @param sugarcaneTotalDeductionAmount
     *            Total Deduction
     */
    public void setSugarcaneTotalDeductionAmount( @Nullable final BigDecimal sugarcaneTotalDeductionAmount )
    {
        rememberChangedField("SugarcaneTotalDeductionAmount", this.sugarcaneTotalDeductionAmount);
        this.sugarcaneTotalDeductionAmount = sugarcaneTotalDeductionAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SugarcaneSuppliesNetAmt</b>
     * </p>
     *
     * @param sugarcaneSuppliesNetAmt
     *            Supplies Net Amount
     */
    public void setSugarcaneSuppliesNetAmt( @Nullable final BigDecimal sugarcaneSuppliesNetAmt )
    {
        rememberChangedField("SugarcaneSuppliesNetAmt", this.sugarcaneSuppliesNetAmt);
        this.sugarcaneSuppliesNetAmt = sugarcaneSuppliesNetAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeDocumentStatus</b>
     * </p>
     *
     * @param bR_NFeDocumentStatus
     *            Document Status
     */
    public void setBR_NFeDocumentStatus( @Nullable final String bR_NFeDocumentStatus )
    {
        rememberChangedField("BR_NFeDocumentStatus", this.bR_NFeDocumentStatus);
        this.bR_NFeDocumentStatus = bR_NFeDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsFinalConsumer</b>
     * </p>
     *
     * @param bR_NFIsFinalConsumer
     *            NF-e Final Consumer Identification
     */
    public void setBR_NFIsFinalConsumer( @Nullable final String bR_NFIsFinalConsumer )
    {
        rememberChangedField("BR_NFIsFinalConsumer", this.bR_NFIsFinalConsumer);
        this.bR_NFIsFinalConsumer = bR_NFIsFinalConsumer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeCustomerPresence</b>
     * </p>
     *
     * @param bR_NFeCustomerPresence
     *            Customer Presence
     */
    public void setBR_NFeCustomerPresence( @Nullable final String bR_NFeCustomerPresence )
    {
        rememberChangedField("BR_NFeCustomerPresence", this.bR_NFeCustomerPresence);
        this.bR_NFeCustomerPresence = bR_NFeCustomerPresence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeDestination</b>
     * </p>
     *
     * @param bR_NFeDestination
     *            Destination
     */
    public void setBR_NFeDestination( @Nullable final String bR_NFeDestination )
    {
        rememberChangedField("BR_NFeDestination", this.bR_NFeDestination);
        this.bR_NFeDestination = bR_NFeDestination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPostingDate</b>
     * </p>
     *
     * @param bR_NFPostingDate
     *            Posting Date
     */
    public void setBR_NFPostingDate( @Nullable final LocalDateTime bR_NFPostingDate )
    {
        rememberChangedField("BR_NFPostingDate", this.bR_NFPostingDate);
        this.bR_NFPostingDate = bR_NFPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @param businessPlace
     *            Business Place
     */
    public void setBusinessPlace( @Nullable final String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNPJ</b>
     * </p>
     *
     * @param bR_BusinessPlaceCNPJ
     *            Business Place CNPJ
     */
    public void setBR_BusinessPlaceCNPJ( @Nullable final String bR_BusinessPlaceCNPJ )
    {
        rememberChangedField("BR_BusinessPlaceCNPJ", this.bR_BusinessPlaceCNPJ);
        this.bR_BusinessPlaceCNPJ = bR_BusinessPlaceCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceStateTaxNumber</b>
     * </p>
     *
     * @param businessPlaceStateTaxNumber
     *            State Tax Number
     */
    public void setBusinessPlaceStateTaxNumber( @Nullable final String businessPlaceStateTaxNumber )
    {
        rememberChangedField("BusinessPlaceStateTaxNumber", this.businessPlaceStateTaxNumber);
        this.businessPlaceStateTaxNumber = businessPlaceStateTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusPlaceStateTaxNumberST</b>
     * </p>
     *
     * @param bR_BusPlaceStateTaxNumberST
     *            State Tax Number (ST)
     */
    public void setBR_BusPlaceStateTaxNumberST( @Nullable final String bR_BusPlaceStateTaxNumberST )
    {
        rememberChangedField("BR_BusPlaceStateTaxNumberST", this.bR_BusPlaceStateTaxNumberST);
        this.bR_BusPlaceStateTaxNumberST = bR_BusPlaceStateTaxNumberST;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusPlaceMunicipalTaxNumber</b>
     * </p>
     *
     * @param busPlaceMunicipalTaxNumber
     *            Municipal Tax Number
     */
    public void setBusPlaceMunicipalTaxNumber( @Nullable final String busPlaceMunicipalTaxNumber )
    {
        rememberChangedField("BusPlaceMunicipalTaxNumber", this.busPlaceMunicipalTaxNumber);
        this.busPlaceMunicipalTaxNumber = busPlaceMunicipalTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNAE</b>
     * </p>
     *
     * @param bR_BusinessPlaceCNAE
     *            Business Place CNAE
     */
    public void setBR_BusinessPlaceCNAE( @Nullable final String bR_BusinessPlaceCNAE )
    {
        rememberChangedField("BR_BusinessPlaceCNAE", this.bR_BusinessPlaceCNAE);
        this.bR_BusinessPlaceCNAE = bR_BusinessPlaceCNAE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceTaxRegimenCode</b>
     * </p>
     *
     * @param businessPlaceTaxRegimenCode
     *            Business Place CRT
     */
    public void setBusinessPlaceTaxRegimenCode( @Nullable final String businessPlaceTaxRegimenCode )
    {
        rememberChangedField("BusinessPlaceTaxRegimenCode", this.businessPlaceTaxRegimenCode);
        this.businessPlaceTaxRegimenCode = businessPlaceTaxRegimenCode;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmount</b>
     * </p>
     *
     * @param bR_NFTotalAmount
     *            Total value including all taxes
     */
    public void setBR_NFTotalAmount( @Nullable final BigDecimal bR_NFTotalAmount )
    {
        rememberChangedField("BR_NFTotalAmount", this.bR_NFTotalAmount);
        this.bR_NFTotalAmount = bR_NFTotalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Accounting Document
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFiscalYear</b>
     * </p>
     *
     * @param bR_NFFiscalYear
     *            Fiscal Year
     */
    public void setBR_NFFiscalYear( @Nullable final String bR_NFFiscalYear )
    {
        rememberChangedField("BR_NFFiscalYear", this.bR_NFFiscalYear);
        this.bR_NFFiscalYear = bR_NFFiscalYear;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFWithholdingAmount</b>
     * </p>
     *
     * @param bR_NFWithholdingAmount
     *            Withholding Amount
     */
    public void setBR_NFWithholdingAmount( @Nullable final BigDecimal bR_NFWithholdingAmount )
    {
        rememberChangedField("BR_NFWithholdingAmount", this.bR_NFWithholdingAmount);
        this.bR_NFWithholdingAmount = bR_NFWithholdingAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_PaymentForm</b>
     * </p>
     *
     * @param bR_PaymentForm
     *            Payment Form Indicator
     */
    public void setBR_PaymentForm( @Nullable final String bR_PaymentForm )
    {
        rememberChangedField("BR_PaymentForm", this.bR_PaymentForm);
        this.bR_PaymentForm = bR_PaymentForm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FreightPayer</b>
     * </p>
     *
     * @param freightPayer
     *            Freight Mode
     */
    public void setFreightPayer( @Nullable final String freightPayer )
    {
        rememberChangedField("FreightPayer", this.freightPayer);
        this.freightPayer = freightPayer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_ANTTCarrierRegistration</b>
     * </p>
     *
     * @param bR_ANTTCarrierRegistration
     *            Cargo Carrier ID
     */
    public void setBR_ANTTCarrierRegistration( @Nullable final String bR_ANTTCarrierRegistration )
    {
        rememberChangedField("BR_ANTTCarrierRegistration", this.bR_ANTTCarrierRegistration);
        this.bR_ANTTCarrierRegistration = bR_ANTTCarrierRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeNumber</b>
     * </p>
     *
     * @param bR_NFeNumber
     *            Nine-Digit Number
     */
    public void setBR_NFeNumber( @Nullable final String bR_NFeNumber )
    {
        rememberChangedField("BR_NFeNumber", this.bR_NFeNumber);
        this.bR_NFeNumber = bR_NFeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>WagonID</b>
     * </p>
     *
     * @param wagonID
     *            Wagon ID
     */
    public void setWagonID( @Nullable final String wagonID )
    {
        rememberChangedField("WagonID", this.wagonID);
        this.wagonID = wagonID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FerryBoatID</b>
     * </p>
     *
     * @param ferryBoatID
     *            Ferryboat ID
     */
    public void setFerryBoatID( @Nullable final String ferryBoatID )
    {
        rememberChangedField("FerryBoatID", this.ferryBoatID);
        this.ferryBoatID = ferryBoatID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportShipmentPlace</b>
     * </p>
     *
     * @param bR_NFExportShipmentPlace
     *            Shipment Place (Export)
     */
    public void setBR_NFExportShipmentPlace( @Nullable final String bR_NFExportShipmentPlace )
    {
        rememberChangedField("BR_NFExportShipmentPlace", this.bR_NFExportShipmentPlace);
        this.bR_NFExportShipmentPlace = bR_NFExportShipmentPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportShipmentRegion</b>
     * </p>
     *
     * @param bR_NFExportShipmentRegion
     *            Shipment Region
     */
    public void setBR_NFExportShipmentRegion( @Nullable final String bR_NFExportShipmentRegion )
    {
        rememberChangedField("BR_NFExportShipmentRegion", this.bR_NFExportShipmentRegion);
        this.bR_NFExportShipmentRegion = bR_NFExportShipmentRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportDispatchLocation</b>
     * </p>
     *
     * @param bR_NFExportDispatchLocation
     *            Dispatch Location
     */
    public void setBR_NFExportDispatchLocation( @Nullable final String bR_NFExportDispatchLocation )
    {
        rememberChangedField("BR_NFExportDispatchLocation", this.bR_NFExportDispatchLocation);
        this.bR_NFExportDispatchLocation = bR_NFExportDispatchLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIssueDate</b>
     * </p>
     *
     * @param bR_NFIssueDate
     *            Document Date
     */
    public void setBR_NFIssueDate( @Nullable final LocalDateTime bR_NFIssueDate )
    {
        rememberChangedField("BR_NFIssueDate", this.bR_NFIssueDate);
        this.bR_NFIssueDate = bR_NFIssueDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsMunicipal</b>
     * </p>
     *
     * @param bR_NFIsMunicipal
     *            Municipal Fiscal Document
     */
    public void setBR_NFIsMunicipal( @Nullable final Boolean bR_NFIsMunicipal )
    {
        rememberChangedField("BR_NFIsMunicipal", this.bR_NFIsMunicipal);
        this.bR_NFIsMunicipal = bR_NFIsMunicipal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOperationTypeDesc</b>
     * </p>
     *
     * @param bR_NFOperationTypeDesc
     *            Operation Type
     */
    public void setBR_NFOperationTypeDesc( @Nullable final String bR_NFOperationTypeDesc )
    {
        rememberChangedField("BR_NFOperationTypeDesc", this.bR_NFOperationTypeDesc);
        this.bR_NFOperationTypeDesc = bR_NFOperationTypeDesc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_IsNFe</b>
     * </p>
     *
     * @param bR_IsNFe
     *            Electronic Fiscal Document
     */
    public void setBR_IsNFe( @Nullable final Boolean bR_IsNFe )
    {
        rememberChangedField("BR_IsNFe", this.bR_IsNFe);
        this.bR_IsNFe = bR_IsNFe;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCancellationDate</b>
     * </p>
     *
     * @param bR_NFCancellationDate
     *            Cancellation Date
     */
    public void setBR_NFCancellationDate( @Nullable final LocalDateTime bR_NFCancellationDate )
    {
        rememberChangedField("BR_NFCancellationDate", this.bR_NFCancellationDate);
        this.bR_NFCancellationDate = bR_NFCancellationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFHasFollowOnDocument</b>
     * </p>
     *
     * @param bR_NFHasFollowOnDocument
     *            Follow-On Document
     */
    public void setBR_NFHasFollowOnDocument( @Nullable final Boolean bR_NFHasFollowOnDocument )
    {
        rememberChangedField("BR_NFHasFollowOnDocument", this.bR_NFHasFollowOnDocument);
        this.bR_NFHasFollowOnDocument = bR_NFHasFollowOnDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFReferenceDocument</b>
     * </p>
     *
     * @param bR_NFReferenceDocument
     *            The bR_NFReferenceDocument to set.
     */
    public void setBR_NFReferenceDocument( @Nullable final String bR_NFReferenceDocument )
    {
        rememberChangedField("BR_NFReferenceDocument", this.bR_NFReferenceDocument);
        this.bR_NFReferenceDocument = bR_NFReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>LicensePlate</b>
     * </p>
     *
     * @param licensePlate
     *            Vehicle License Plate
     */
    public void setLicensePlate( @Nullable final String licensePlate )
    {
        rememberChangedField("LicensePlate", this.licensePlate);
        this.licensePlate = licensePlate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleRegion</b>
     * </p>
     *
     * @param vehicleRegion
     *            Region of Vehicle
     */
    public void setVehicleRegion( @Nullable final String vehicleRegion )
    {
        rememberChangedField("VehicleRegion", this.vehicleRegion);
        this.vehicleRegion = vehicleRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_UtilsNFNumber</b>
     * </p>
     *
     * @param bR_UtilsNFNumber
     *            Number for Non-Electronic Documents
     */
    public void setBR_UtilsNFNumber( @Nullable final String bR_UtilsNFNumber )
    {
        rememberChangedField("BR_UtilsNFNumber", this.bR_UtilsNFNumber);
        this.bR_UtilsNFNumber = bR_UtilsNFNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPlaceType</b>
     * </p>
     *
     * @param bR_NFPartnerPlaceType
     *            Nota Fiscal Partner Place Type
     */
    public void setBR_NFPartnerPlaceType( @Nullable final String bR_NFPartnerPlaceType )
    {
        rememberChangedField("BR_NFPartnerPlaceType", this.bR_NFPartnerPlaceType);
        this.bR_NFPartnerPlaceType = bR_NFPartnerPlaceType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCalculatedByTaxService</b>
     * </p>
     *
     * @param bR_NFIsCalculatedByTaxService
     *            Tax Calculated by External Tax Calculation Engines
     */
    public void setBR_NFIsCalculatedByTaxService( @Nullable final Boolean bR_NFIsCalculatedByTaxService )
    {
        rememberChangedField("BR_NFIsCalculatedByTaxService", this.bR_NFIsCalculatedByTaxService);
        this.bR_NFIsCalculatedByTaxService = bR_NFIsCalculatedByTaxService;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeAmount</b>
     * </p>
     *
     * @param changeAmount
     *            Change Amount
     */
    public void setChangeAmount( @Nullable final BigDecimal changeAmount )
    {
        rememberChangedField("ChangeAmount", this.changeAmount);
        this.changeAmount = changeAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFiscalCouponDocModel</b>
     * </p>
     *
     * @param bR_NFFiscalCouponDocModel
     *            Fiscal Coupon Document Model
     */
    public void setBR_NFFiscalCouponDocModel( @Nullable final String bR_NFFiscalCouponDocModel )
    {
        rememberChangedField("BR_NFFiscalCouponDocModel", this.bR_NFFiscalCouponDocModel);
        this.bR_NFFiscalCouponDocModel = bR_NFFiscalCouponDocModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFOperationOrderNumber</b>
     * </p>
     *
     * @param bR_NFOperationOrderNumber
     *            Operation Order Counter Number
     */
    public void setBR_NFOperationOrderNumber( @Nullable final String bR_NFOperationOrderNumber )
    {
        rememberChangedField("BR_NFOperationOrderNumber", this.bR_NFOperationOrderNumber);
        this.bR_NFOperationOrderNumber = bR_NFOperationOrderNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerForeignIdn</b>
     * </p>
     *
     * @param bR_NFPartnerForeignIdn
     *            Foreign Identification
     */
    public void setBR_NFPartnerForeignIdn( @Nullable final String bR_NFPartnerForeignIdn )
    {
        rememberChangedField("BR_NFPartnerForeignIdn", this.bR_NFPartnerForeignIdn);
        this.bR_NFPartnerForeignIdn = bR_NFPartnerForeignIdn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeDocumentType</b>
     * </p>
     *
     * @param bR_CTeDocumentType
     *            CT-e Type
     */
    public void setBR_CTeDocumentType( @Nullable final String bR_CTeDocumentType )
    {
        rememberChangedField("BR_CTeDocumentType", this.bR_CTeDocumentType);
        this.bR_CTeDocumentType = bR_CTeDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeMainProductTransported</b>
     * </p>
     *
     * @param bR_CTeMainProductTransported
     *            Main Product
     */
    public void setBR_CTeMainProductTransported( @Nullable final String bR_CTeMainProductTransported )
    {
        rememberChangedField("BR_CTeMainProductTransported", this.bR_CTeMainProductTransported);
        this.bR_CTeMainProductTransported = bR_CTeMainProductTransported;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeTotalGoodsAmount</b>
     * </p>
     *
     * @param bR_CTeTotalGoodsAmount
     *            Total Amount of Goods
     */
    public void setBR_CTeTotalGoodsAmount( @Nullable final BigDecimal bR_CTeTotalGoodsAmount )
    {
        rememberChangedField("BR_CTeTotalGoodsAmount", this.bR_CTeTotalGoodsAmount);
        this.bR_CTeTotalGoodsAmount = bR_CTeTotalGoodsAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTePartnerServiceTaker</b>
     * </p>
     *
     * @param bR_CTePartnerServiceTaker
     *            CT-e Partner as Service Taker
     */
    public void setBR_CTePartnerServiceTaker( @Nullable final String bR_CTePartnerServiceTaker )
    {
        rememberChangedField("BR_CTePartnerServiceTaker", this.bR_CTePartnerServiceTaker);
        this.bR_CTePartnerServiceTaker = bR_CTePartnerServiceTaker;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeFiscalDocumentPartner</b>
     * </p>
     *
     * @param bR_CTeFiscalDocumentPartner
     *            CT-e Partner in Fiscal Document
     */
    public void setBR_CTeFiscalDocumentPartner( @Nullable final String bR_CTeFiscalDocumentPartner )
    {
        rememberChangedField("BR_CTeFiscalDocumentPartner", this.bR_CTeFiscalDocumentPartner);
        this.bR_CTeFiscalDocumentPartner = bR_CTeFiscalDocumentPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeServiceType</b>
     * </p>
     *
     * @param bR_CTeServiceType
     *            Service Type Indicator
     */
    public void setBR_CTeServiceType( @Nullable final String bR_CTeServiceType )
    {
        rememberChangedField("BR_CTeServiceType", this.bR_CTeServiceType);
        this.bR_CTeServiceType = bR_CTeServiceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeTransportationMode</b>
     * </p>
     *
     * @param bR_CTeTransportationMode
     *            Transportation Mode
     */
    public void setBR_CTeTransportationMode( @Nullable final String bR_CTeTransportationMode )
    {
        rememberChangedField("BR_CTeTransportationMode", this.bR_CTeTransportationMode);
        this.bR_CTeTransportationMode = bR_CTeTransportationMode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeEstimatedDeliveryDate</b>
     * </p>
     *
     * @param bR_CTeEstimatedDeliveryDate
     *            Estimated Delivery Date
     */
    public void setBR_CTeEstimatedDeliveryDate( @Nullable final LocalDateTime bR_CTeEstimatedDeliveryDate )
    {
        rememberChangedField("BR_CTeEstimatedDeliveryDate", this.bR_CTeEstimatedDeliveryDate);
        this.bR_CTeEstimatedDeliveryDate = bR_CTeEstimatedDeliveryDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeIsTruckFullyLoaded</b>
     * </p>
     *
     * @param bR_CTeIsTruckFullyLoaded
     *            Full Truck Load Indicator
     */
    public void setBR_CTeIsTruckFullyLoaded( @Nullable final Boolean bR_CTeIsTruckFullyLoaded )
    {
        rememberChangedField("BR_CTeIsTruckFullyLoaded", this.bR_CTeIsTruckFullyLoaded);
        this.bR_CTeIsTruckFullyLoaded = bR_CTeIsTruckFullyLoaded;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeJurisdictionCodeOrigin</b>
     * </p>
     *
     * @param bR_CTeJurisdictionCodeOrigin
     *            Jurisdiction Code of the Point of Origin
     */
    public void setBR_CTeJurisdictionCodeOrigin( @Nullable final String bR_CTeJurisdictionCodeOrigin )
    {
        rememberChangedField("BR_CTeJurisdictionCodeOrigin", this.bR_CTeJurisdictionCodeOrigin);
        this.bR_CTeJurisdictionCodeOrigin = bR_CTeJurisdictionCodeOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeJurisdictionCodeDest</b>
     * </p>
     *
     * @param bR_CTeJurisdictionCodeDest
     *            Jurisdiction Code of the Final Destination
     */
    public void setBR_CTeJurisdictionCodeDest( @Nullable final String bR_CTeJurisdictionCodeDest )
    {
        rememberChangedField("BR_CTeJurisdictionCodeDest", this.bR_CTeJurisdictionCodeDest);
        this.bR_CTeJurisdictionCodeDest = bR_CTeJurisdictionCodeDest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSVerificationCode</b>
     * </p>
     *
     * @param bR_NFSVerificationCode
     *            Verification Code
     */
    public void setBR_NFSVerificationCode( @Nullable final String bR_NFSVerificationCode )
    {
        rememberChangedField("BR_NFSVerificationCode", this.bR_NFSVerificationCode);
        this.bR_NFSVerificationCode = bR_NFSVerificationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSNumber</b>
     * </p>
     *
     * @param bR_NFSNumber
     *            Service NF-e Number
     */
    public void setBR_NFSNumber( @Nullable final String bR_NFSNumber )
    {
        rememberChangedField("BR_NFSNumber", this.bR_NFSNumber);
        this.bR_NFSNumber = bR_NFSNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFHasServiceItem</b>
     * </p>
     *
     * @param bR_NFHasServiceItem
     *            Service NF/NF-e
     */
    public void setBR_NFHasServiceItem( @Nullable final Boolean bR_NFHasServiceItem )
    {
        rememberChangedField("BR_NFHasServiceItem", this.bR_NFHasServiceItem);
        this.bR_NFHasServiceItem = bR_NFHasServiceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @param isBusinessPurposeCompleted
     *            The isBusinessPurposeCompleted to set.
     */
    public void setIsBusinessPurposeCompleted( @Nullable final String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorTransaction</b>
     * </p>
     *
     * @param bR_NFeIntermediatorTransaction
     *            Intermediator Indicator
     */
    public void setBR_NFeIntermediatorTransaction( @Nullable final String bR_NFeIntermediatorTransaction )
    {
        rememberChangedField("BR_NFeIntermediatorTransaction", this.bR_NFeIntermediatorTransaction);
        this.bR_NFeIntermediatorTransaction = bR_NFeIntermediatorTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorRegistry</b>
     * </p>
     *
     * @param bR_NFeIntermediatorRegistry
     *            Intermediator Identification Registry
     */
    public void setBR_NFeIntermediatorRegistry( @Nullable final String bR_NFeIntermediatorRegistry )
    {
        rememberChangedField("BR_NFeIntermediatorRegistry", this.bR_NFeIntermediatorRegistry);
        this.bR_NFeIntermediatorRegistry = bR_NFeIntermediatorRegistry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeIntermediatorCNPJ</b>
     * </p>
     *
     * @param bR_NFeIntermediatorCNPJ
     *            CNPJ of the Intermediator
     */
    public void setBR_NFeIntermediatorCNPJ( @Nullable final String bR_NFeIntermediatorCNPJ )
    {
        rememberChangedField("BR_NFeIntermediatorCNPJ", this.bR_NFeIntermediatorCNPJ);
        this.bR_NFeIntermediatorCNPJ = bR_NFeIntermediatorCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 999
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMessageText</b>
     * </p>
     *
     * @param bR_NFMessageText
     *            The bR_NFMessageText to set.
     */
    public void setBR_NFMessageText( @Nullable final String bR_NFMessageText )
    {
        rememberChangedField("BR_NFMessageText", this.bR_NFMessageText);
        this.bR_NFMessageText = bR_NFMessageText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalFiscalInfoText</b>
     * </p>
     *
     * @param bR_NFAdditionalFiscalInfoText
     *            The bR_NFAdditionalFiscalInfoText to set.
     */
    public void setBR_NFAdditionalFiscalInfoText( @Nullable final String bR_NFAdditionalFiscalInfoText )
    {
        rememberChangedField("BR_NFAdditionalFiscalInfoText", this.bR_NFAdditionalFiscalInfoText);
        this.bR_NFAdditionalFiscalInfoText = bR_NFAdditionalFiscalInfoText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalCompanyInfoText</b>
     * </p>
     *
     * @param bR_NFAdditionalCompanyInfoText
     *            The bR_NFAdditionalCompanyInfoText to set.
     */
    public void setBR_NFAdditionalCompanyInfoText( @Nullable final String bR_NFAdditionalCompanyInfoText )
    {
        rememberChangedField("BR_NFAdditionalCompanyInfoText", this.bR_NFAdditionalCompanyInfoText);
        this.bR_NFAdditionalCompanyInfoText = bR_NFAdditionalCompanyInfoText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFPartnerFunction", getBR_NFPartnerFunction());
        values.put("BR_NFPartner", getBR_NFPartner());
        values.put("BR_NFPartnerName1", getBR_NFPartnerName1());
        values.put("BR_NFPartnerName2", getBR_NFPartnerName2());
        values.put("BR_NFPartnerName3", getBR_NFPartnerName3());
        values.put("BR_NFPartnerName4", getBR_NFPartnerName4());
        values.put("PartnerIsOneTimeAccount", getPartnerIsOneTimeAccount());
        values.put("BR_NFPartnerType", getBR_NFPartnerType());
        values.put("BR_NFPartnerStreetName", getBR_NFPartnerStreetName());
        values.put("BusinessPartnerHouseNumber", getBusinessPartnerHouseNumber());
        values.put("BPHsNmbrSuplmntTxt", getBPHsNmbrSuplmntTxt());
        values.put("BR_NFPartnerCityName", getBR_NFPartnerCityName());
        values.put("BR_NFPartnerRegionCode", getBR_NFPartnerRegionCode());
        values.put("BR_NFPartnerDistrictName", getBR_NFPartnerDistrictName());
        values.put("BR_NFPartnerCountryCode", getBR_NFPartnerCountryCode());
        values.put("BR_NFPartnerPostalCode", getBR_NFPartnerPostalCode());
        values.put("BR_NFPartnerIsNaturalPerson", getBR_NFPartnerIsNaturalPerson());
        values.put("BR_NFPartnerCNPJ", getBR_NFPartnerCNPJ());
        values.put("BR_NFPartnerCPF", getBR_NFPartnerCPF());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("BR_NFPartnerStateTaxNumber", getBR_NFPartnerStateTaxNumber());
        values.put("BR_NFPartnerMunicipalTaxNumber", getBR_NFPartnerMunicipalTaxNumber());
        values.put("BR_NFPartnerStateTaxNumberST", getBR_NFPartnerStateTaxNumberST());
        values.put("BR_NFPartnerCNAE", getBR_NFPartnerCNAE());
        values.put("BR_NFPartnerTaxRegimenCode", getBR_NFPartnerTaxRegimenCode());
        values.put("BR_PartnerCFOPCategory", getBR_PartnerCFOPCategory());
        values.put("BR_SUFRAMACode", getBR_SUFRAMACode());
        values.put("BR_SPEDTaxCategory", getBR_SPEDTaxCategory());
        values.put("ReportingIncgOrOutgDate", getReportingIncgOrOutgDate());
        values.put("BR_NFPartnerTaxJurisdiction", getBR_NFPartnerTaxJurisdiction());
        values.put("BR_NFObservationText", getBR_NFObservationText());
        values.put("MeansOfTransportType", getMeansOfTransportType());
        values.put("MeansOfTransport", getMeansOfTransport());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("ShippingPoint", getShippingPoint());
        values.put("BR_NFShippingUnitBrand", getBR_NFShippingUnitBrand());
        values.put("BR_NFShippingUnitNumber", getBR_NFShippingUnitNumber());
        values.put("BR_NFNumberOfPackages", getBR_NFNumberOfPackages());
        values.put("BR_NFShippingUnit", getBR_NFShippingUnit());
        values.put("BR_NFArrivalOrDepartureDate", getBR_NFArrivalOrDepartureDate());
        values.put("HeaderWeightUnit", getHeaderWeightUnit());
        values.put("HeaderNetWeight", getHeaderNetWeight());
        values.put("HeaderGrossWeight", getHeaderGrossWeight());
        values.put("BR_NFArrivalOrDepartureTime", getBR_NFArrivalOrDepartureTime());
        values.put("BR_WhldgICMSForTranspCFOP", getBR_WhldgICMSForTranspCFOP());
        values.put("BR_WhldgICMSForTranspCity", getBR_WhldgICMSForTranspCity());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("BR_NFIsPrinted", getBR_NFIsPrinted());
        values.put("BR_NFIsCreatedManually", getBR_NFIsCreatedManually());
        values.put("BR_NFIsIncomingIssdByCust", getBR_NFIsIncomingIssdByCust());
        values.put("BR_NFIsCanceled", getBR_NFIsCanceled());
        values.put("BR_NFIsChargingInvoice", getBR_NFIsChargingInvoice());
        values.put("BR_NFDirection", getBR_NFDirection());
        values.put("BR_NFType", getBR_NFType());
        values.put("BR_NFDocumentType", getBR_NFDocumentType());
        values.put("BR_NFModel", getBR_NFModel());
        values.put("BR_NFNumber", getBR_NFNumber());
        values.put("BR_NFSeries", getBR_NFSeries());
        values.put("BR_NFSubSeries", getBR_NFSubSeries());
        values.put("BR_NFSituationCode", getBR_NFSituationCode());
        values.put("BR_NFIssuedBy", getBR_NFIssuedBy());
        values.put("BR_NFIsContingency", getBR_NFIsContingency());
        values.put("BR_NFAuthznProtocolNumber", getBR_NFAuthznProtocolNumber());
        values.put("BR_NFAuthenticationDate", getBR_NFAuthenticationDate());
        values.put("BR_NFAuthenticationTime", getBR_NFAuthenticationTime());
        values.put("BR_NFeXMLVersion", getBR_NFeXMLVersion());
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("BR_NFOriginalAmount", getBR_NFOriginalAmount());
        values.put("BR_NFDiscountAmount", getBR_NFDiscountAmount());
        values.put("BR_NFNetAmount", getBR_NFNetAmount());
        values.put("BR_NFCommitmentNote", getBR_NFCommitmentNote());
        values.put("SugarcaneHarvest", getSugarcaneHarvest());
        values.put("SugarcaneRefMonthYear", getSugarcaneRefMonthYear());
        values.put("SugarcaneCurMnthQtyUnit", getSugarcaneCurMnthQtyUnit());
        values.put("SugarcaneCurrentMonthQty", getSugarcaneCurrentMonthQty());
        values.put("SugarcaneLastMnthQtyUnit", getSugarcaneLastMnthQtyUnit());
        values.put("SugarcaneLastMnthQuantity", getSugarcaneLastMnthQuantity());
        values.put("SugarcaneSumBothMnthsQtyUnit", getSugarcaneSumBothMnthsQtyUnit());
        values.put("SugarcaneSumBothMonthsQty", getSugarcaneSumBothMonthsQty());
        values.put("SugarcaneSuppliesAmount", getSugarcaneSuppliesAmount());
        values.put("SugarcaneTotalDeductionAmount", getSugarcaneTotalDeductionAmount());
        values.put("SugarcaneSuppliesNetAmt", getSugarcaneSuppliesNetAmt());
        values.put("BR_NFeDocumentStatus", getBR_NFeDocumentStatus());
        values.put("BR_NFIsFinalConsumer", getBR_NFIsFinalConsumer());
        values.put("BR_NFeCustomerPresence", getBR_NFeCustomerPresence());
        values.put("BR_NFeDestination", getBR_NFeDestination());
        values.put("CompanyCode", getCompanyCode());
        values.put("BR_NFPostingDate", getBR_NFPostingDate());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("BR_BusinessPlaceCNPJ", getBR_BusinessPlaceCNPJ());
        values.put("BusinessPlaceStateTaxNumber", getBusinessPlaceStateTaxNumber());
        values.put("BR_BusPlaceStateTaxNumberST", getBR_BusPlaceStateTaxNumberST());
        values.put("BusPlaceMunicipalTaxNumber", getBusPlaceMunicipalTaxNumber());
        values.put("BR_BusinessPlaceCNAE", getBR_BusinessPlaceCNAE());
        values.put("BusinessPlaceTaxRegimenCode", getBusinessPlaceTaxRegimenCode());
        values.put("BR_NFTotalAmount", getBR_NFTotalAmount());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("BR_NFFiscalYear", getBR_NFFiscalYear());
        values.put("BR_NFWithholdingAmount", getBR_NFWithholdingAmount());
        values.put("BR_PaymentForm", getBR_PaymentForm());
        values.put("FreightPayer", getFreightPayer());
        values.put("BR_ANTTCarrierRegistration", getBR_ANTTCarrierRegistration());
        values.put("BR_NFeNumber", getBR_NFeNumber());
        values.put("WagonID", getWagonID());
        values.put("FerryBoatID", getFerryBoatID());
        values.put("BR_NFExportShipmentPlace", getBR_NFExportShipmentPlace());
        values.put("BR_NFExportShipmentRegion", getBR_NFExportShipmentRegion());
        values.put("BR_NFExportDispatchLocation", getBR_NFExportDispatchLocation());
        values.put("BR_NFIssueDate", getBR_NFIssueDate());
        values.put("BR_NFIsMunicipal", getBR_NFIsMunicipal());
        values.put("BR_NFOperationTypeDesc", getBR_NFOperationTypeDesc());
        values.put("BR_IsNFe", getBR_IsNFe());
        values.put("BR_NFCancellationDate", getBR_NFCancellationDate());
        values.put("BR_NFHasFollowOnDocument", getBR_NFHasFollowOnDocument());
        values.put("BR_NFReferenceDocument", getBR_NFReferenceDocument());
        values.put("LicensePlate", getLicensePlate());
        values.put("VehicleRegion", getVehicleRegion());
        values.put("BR_UtilsNFNumber", getBR_UtilsNFNumber());
        values.put("BR_NFPartnerPlaceType", getBR_NFPartnerPlaceType());
        values.put("BR_NFIsCalculatedByTaxService", getBR_NFIsCalculatedByTaxService());
        values.put("ChangeAmount", getChangeAmount());
        values.put("BR_NFFiscalCouponDocModel", getBR_NFFiscalCouponDocModel());
        values.put("BR_NFOperationOrderNumber", getBR_NFOperationOrderNumber());
        values.put("BR_NFPartnerForeignIdn", getBR_NFPartnerForeignIdn());
        values.put("BR_CTeDocumentType", getBR_CTeDocumentType());
        values.put("BR_CTeMainProductTransported", getBR_CTeMainProductTransported());
        values.put("BR_CTeTotalGoodsAmount", getBR_CTeTotalGoodsAmount());
        values.put("BR_CTePartnerServiceTaker", getBR_CTePartnerServiceTaker());
        values.put("BR_CTeFiscalDocumentPartner", getBR_CTeFiscalDocumentPartner());
        values.put("BR_CTeServiceType", getBR_CTeServiceType());
        values.put("BR_CTeTransportationMode", getBR_CTeTransportationMode());
        values.put("BR_CTeEstimatedDeliveryDate", getBR_CTeEstimatedDeliveryDate());
        values.put("BR_CTeIsTruckFullyLoaded", getBR_CTeIsTruckFullyLoaded());
        values.put("BR_CTeJurisdictionCodeOrigin", getBR_CTeJurisdictionCodeOrigin());
        values.put("BR_CTeJurisdictionCodeDest", getBR_CTeJurisdictionCodeDest());
        values.put("BR_NFSVerificationCode", getBR_NFSVerificationCode());
        values.put("BR_NFSNumber", getBR_NFSNumber());
        values.put("BR_NFHasServiceItem", getBR_NFHasServiceItem());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("BR_NFeIntermediatorTransaction", getBR_NFeIntermediatorTransaction());
        values.put("BR_NFeIntermediatorRegistry", getBR_NFeIntermediatorRegistry());
        values.put("BR_NFeIntermediatorCNPJ", getBR_NFeIntermediatorCNPJ());
        values.put("BR_NFMessageText", getBR_NFMessageText());
        values.put("BR_NFAdditionalFiscalInfoText", getBR_NFAdditionalFiscalInfoText());
        values.put("BR_NFAdditionalCompanyInfoText", getBR_NFAdditionalCompanyInfoText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerFunction") ) {
                final Object value = values.remove("BR_NFPartnerFunction");
                if( (value == null) || (!value.equals(getBR_NFPartnerFunction())) ) {
                    setBR_NFPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartner") ) {
                final Object value = values.remove("BR_NFPartner");
                if( (value == null) || (!value.equals(getBR_NFPartner())) ) {
                    setBR_NFPartner(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName1") ) {
                final Object value = values.remove("BR_NFPartnerName1");
                if( (value == null) || (!value.equals(getBR_NFPartnerName1())) ) {
                    setBR_NFPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName2") ) {
                final Object value = values.remove("BR_NFPartnerName2");
                if( (value == null) || (!value.equals(getBR_NFPartnerName2())) ) {
                    setBR_NFPartnerName2(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName3") ) {
                final Object value = values.remove("BR_NFPartnerName3");
                if( (value == null) || (!value.equals(getBR_NFPartnerName3())) ) {
                    setBR_NFPartnerName3(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName4") ) {
                final Object value = values.remove("BR_NFPartnerName4");
                if( (value == null) || (!value.equals(getBR_NFPartnerName4())) ) {
                    setBR_NFPartnerName4(((String) value));
                }
            }
            if( values.containsKey("PartnerIsOneTimeAccount") ) {
                final Object value = values.remove("PartnerIsOneTimeAccount");
                if( (value == null) || (!value.equals(getPartnerIsOneTimeAccount())) ) {
                    setPartnerIsOneTimeAccount(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFPartnerType") ) {
                final Object value = values.remove("BR_NFPartnerType");
                if( (value == null) || (!value.equals(getBR_NFPartnerType())) ) {
                    setBR_NFPartnerType(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerStreetName") ) {
                final Object value = values.remove("BR_NFPartnerStreetName");
                if( (value == null) || (!value.equals(getBR_NFPartnerStreetName())) ) {
                    setBR_NFPartnerStreetName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerHouseNumber") ) {
                final Object value = values.remove("BusinessPartnerHouseNumber");
                if( (value == null) || (!value.equals(getBusinessPartnerHouseNumber())) ) {
                    setBusinessPartnerHouseNumber(((String) value));
                }
            }
            if( values.containsKey("BPHsNmbrSuplmntTxt") ) {
                final Object value = values.remove("BPHsNmbrSuplmntTxt");
                if( (value == null) || (!value.equals(getBPHsNmbrSuplmntTxt())) ) {
                    setBPHsNmbrSuplmntTxt(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCityName") ) {
                final Object value = values.remove("BR_NFPartnerCityName");
                if( (value == null) || (!value.equals(getBR_NFPartnerCityName())) ) {
                    setBR_NFPartnerCityName(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerRegionCode") ) {
                final Object value = values.remove("BR_NFPartnerRegionCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerRegionCode())) ) {
                    setBR_NFPartnerRegionCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerDistrictName") ) {
                final Object value = values.remove("BR_NFPartnerDistrictName");
                if( (value == null) || (!value.equals(getBR_NFPartnerDistrictName())) ) {
                    setBR_NFPartnerDistrictName(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCountryCode") ) {
                final Object value = values.remove("BR_NFPartnerCountryCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerCountryCode())) ) {
                    setBR_NFPartnerCountryCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerPostalCode") ) {
                final Object value = values.remove("BR_NFPartnerPostalCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerPostalCode())) ) {
                    setBR_NFPartnerPostalCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerIsNaturalPerson") ) {
                final Object value = values.remove("BR_NFPartnerIsNaturalPerson");
                if( (value == null) || (!value.equals(getBR_NFPartnerIsNaturalPerson())) ) {
                    setBR_NFPartnerIsNaturalPerson(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCNPJ") ) {
                final Object value = values.remove("BR_NFPartnerCNPJ");
                if( (value == null) || (!value.equals(getBR_NFPartnerCNPJ())) ) {
                    setBR_NFPartnerCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCPF") ) {
                final Object value = values.remove("BR_NFPartnerCPF");
                if( (value == null) || (!value.equals(getBR_NFPartnerCPF())) ) {
                    setBR_NFPartnerCPF(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerStateTaxNumber") ) {
                final Object value = values.remove("BR_NFPartnerStateTaxNumber");
                if( (value == null) || (!value.equals(getBR_NFPartnerStateTaxNumber())) ) {
                    setBR_NFPartnerStateTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerMunicipalTaxNumber") ) {
                final Object value = values.remove("BR_NFPartnerMunicipalTaxNumber");
                if( (value == null) || (!value.equals(getBR_NFPartnerMunicipalTaxNumber())) ) {
                    setBR_NFPartnerMunicipalTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerStateTaxNumberST") ) {
                final Object value = values.remove("BR_NFPartnerStateTaxNumberST");
                if( (value == null) || (!value.equals(getBR_NFPartnerStateTaxNumberST())) ) {
                    setBR_NFPartnerStateTaxNumberST(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCNAE") ) {
                final Object value = values.remove("BR_NFPartnerCNAE");
                if( (value == null) || (!value.equals(getBR_NFPartnerCNAE())) ) {
                    setBR_NFPartnerCNAE(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerTaxRegimenCode") ) {
                final Object value = values.remove("BR_NFPartnerTaxRegimenCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerTaxRegimenCode())) ) {
                    setBR_NFPartnerTaxRegimenCode(((String) value));
                }
            }
            if( values.containsKey("BR_PartnerCFOPCategory") ) {
                final Object value = values.remove("BR_PartnerCFOPCategory");
                if( (value == null) || (!value.equals(getBR_PartnerCFOPCategory())) ) {
                    setBR_PartnerCFOPCategory(((String) value));
                }
            }
            if( values.containsKey("BR_SUFRAMACode") ) {
                final Object value = values.remove("BR_SUFRAMACode");
                if( (value == null) || (!value.equals(getBR_SUFRAMACode())) ) {
                    setBR_SUFRAMACode(((String) value));
                }
            }
            if( values.containsKey("BR_SPEDTaxCategory") ) {
                final Object value = values.remove("BR_SPEDTaxCategory");
                if( (value == null) || (!value.equals(getBR_SPEDTaxCategory())) ) {
                    setBR_SPEDTaxCategory(((String) value));
                }
            }
            if( values.containsKey("ReportingIncgOrOutgDate") ) {
                final Object value = values.remove("ReportingIncgOrOutgDate");
                if( (value == null) || (!value.equals(getReportingIncgOrOutgDate())) ) {
                    setReportingIncgOrOutgDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFPartnerTaxJurisdiction") ) {
                final Object value = values.remove("BR_NFPartnerTaxJurisdiction");
                if( (value == null) || (!value.equals(getBR_NFPartnerTaxJurisdiction())) ) {
                    setBR_NFPartnerTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("BR_NFObservationText") ) {
                final Object value = values.remove("BR_NFObservationText");
                if( (value == null) || (!value.equals(getBR_NFObservationText())) ) {
                    setBR_NFObservationText(((String) value));
                }
            }
            if( values.containsKey("MeansOfTransportType") ) {
                final Object value = values.remove("MeansOfTransportType");
                if( (value == null) || (!value.equals(getMeansOfTransportType())) ) {
                    setMeansOfTransportType(((String) value));
                }
            }
            if( values.containsKey("MeansOfTransport") ) {
                final Object value = values.remove("MeansOfTransport");
                if( (value == null) || (!value.equals(getMeansOfTransport())) ) {
                    setMeansOfTransport(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("BR_NFShippingUnitBrand") ) {
                final Object value = values.remove("BR_NFShippingUnitBrand");
                if( (value == null) || (!value.equals(getBR_NFShippingUnitBrand())) ) {
                    setBR_NFShippingUnitBrand(((String) value));
                }
            }
            if( values.containsKey("BR_NFShippingUnitNumber") ) {
                final Object value = values.remove("BR_NFShippingUnitNumber");
                if( (value == null) || (!value.equals(getBR_NFShippingUnitNumber())) ) {
                    setBR_NFShippingUnitNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFNumberOfPackages") ) {
                final Object value = values.remove("BR_NFNumberOfPackages");
                if( (value == null) || (!value.equals(getBR_NFNumberOfPackages())) ) {
                    setBR_NFNumberOfPackages(((String) value));
                }
            }
            if( values.containsKey("BR_NFShippingUnit") ) {
                final Object value = values.remove("BR_NFShippingUnit");
                if( (value == null) || (!value.equals(getBR_NFShippingUnit())) ) {
                    setBR_NFShippingUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFArrivalOrDepartureDate") ) {
                final Object value = values.remove("BR_NFArrivalOrDepartureDate");
                if( (value == null) || (!value.equals(getBR_NFArrivalOrDepartureDate())) ) {
                    setBR_NFArrivalOrDepartureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HeaderWeightUnit") ) {
                final Object value = values.remove("HeaderWeightUnit");
                if( (value == null) || (!value.equals(getHeaderWeightUnit())) ) {
                    setHeaderWeightUnit(((String) value));
                }
            }
            if( values.containsKey("HeaderNetWeight") ) {
                final Object value = values.remove("HeaderNetWeight");
                if( (value == null) || (!value.equals(getHeaderNetWeight())) ) {
                    setHeaderNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HeaderGrossWeight") ) {
                final Object value = values.remove("HeaderGrossWeight");
                if( (value == null) || (!value.equals(getHeaderGrossWeight())) ) {
                    setHeaderGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFArrivalOrDepartureTime") ) {
                final Object value = values.remove("BR_NFArrivalOrDepartureTime");
                if( (value == null) || (!value.equals(getBR_NFArrivalOrDepartureTime())) ) {
                    setBR_NFArrivalOrDepartureTime(((LocalTime) value));
                }
            }
            if( values.containsKey("BR_WhldgICMSForTranspCFOP") ) {
                final Object value = values.remove("BR_WhldgICMSForTranspCFOP");
                if( (value == null) || (!value.equals(getBR_WhldgICMSForTranspCFOP())) ) {
                    setBR_WhldgICMSForTranspCFOP(((String) value));
                }
            }
            if( values.containsKey("BR_WhldgICMSForTranspCity") ) {
                final Object value = values.remove("BR_WhldgICMSForTranspCity");
                if( (value == null) || (!value.equals(getBR_WhldgICMSForTranspCity())) ) {
                    setBR_WhldgICMSForTranspCity(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsPrinted") ) {
                final Object value = values.remove("BR_NFIsPrinted");
                if( (value == null) || (!value.equals(getBR_NFIsPrinted())) ) {
                    setBR_NFIsPrinted(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFIsCreatedManually") ) {
                final Object value = values.remove("BR_NFIsCreatedManually");
                if( (value == null) || (!value.equals(getBR_NFIsCreatedManually())) ) {
                    setBR_NFIsCreatedManually(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsIncomingIssdByCust") ) {
                final Object value = values.remove("BR_NFIsIncomingIssdByCust");
                if( (value == null) || (!value.equals(getBR_NFIsIncomingIssdByCust())) ) {
                    setBR_NFIsIncomingIssdByCust(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsCanceled") ) {
                final Object value = values.remove("BR_NFIsCanceled");
                if( (value == null) || (!value.equals(getBR_NFIsCanceled())) ) {
                    setBR_NFIsCanceled(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFIsChargingInvoice") ) {
                final Object value = values.remove("BR_NFIsChargingInvoice");
                if( (value == null) || (!value.equals(getBR_NFIsChargingInvoice())) ) {
                    setBR_NFIsChargingInvoice(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFDirection") ) {
                final Object value = values.remove("BR_NFDirection");
                if( (value == null) || (!value.equals(getBR_NFDirection())) ) {
                    setBR_NFDirection(((String) value));
                }
            }
            if( values.containsKey("BR_NFType") ) {
                final Object value = values.remove("BR_NFType");
                if( (value == null) || (!value.equals(getBR_NFType())) ) {
                    setBR_NFType(((String) value));
                }
            }
            if( values.containsKey("BR_NFDocumentType") ) {
                final Object value = values.remove("BR_NFDocumentType");
                if( (value == null) || (!value.equals(getBR_NFDocumentType())) ) {
                    setBR_NFDocumentType(((String) value));
                }
            }
            if( values.containsKey("BR_NFModel") ) {
                final Object value = values.remove("BR_NFModel");
                if( (value == null) || (!value.equals(getBR_NFModel())) ) {
                    setBR_NFModel(((String) value));
                }
            }
            if( values.containsKey("BR_NFNumber") ) {
                final Object value = values.remove("BR_NFNumber");
                if( (value == null) || (!value.equals(getBR_NFNumber())) ) {
                    setBR_NFNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFSeries") ) {
                final Object value = values.remove("BR_NFSeries");
                if( (value == null) || (!value.equals(getBR_NFSeries())) ) {
                    setBR_NFSeries(((String) value));
                }
            }
            if( values.containsKey("BR_NFSubSeries") ) {
                final Object value = values.remove("BR_NFSubSeries");
                if( (value == null) || (!value.equals(getBR_NFSubSeries())) ) {
                    setBR_NFSubSeries(((String) value));
                }
            }
            if( values.containsKey("BR_NFSituationCode") ) {
                final Object value = values.remove("BR_NFSituationCode");
                if( (value == null) || (!value.equals(getBR_NFSituationCode())) ) {
                    setBR_NFSituationCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFIssuedBy") ) {
                final Object value = values.remove("BR_NFIssuedBy");
                if( (value == null) || (!value.equals(getBR_NFIssuedBy())) ) {
                    setBR_NFIssuedBy(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsContingency") ) {
                final Object value = values.remove("BR_NFIsContingency");
                if( (value == null) || (!value.equals(getBR_NFIsContingency())) ) {
                    setBR_NFIsContingency(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFAuthznProtocolNumber") ) {
                final Object value = values.remove("BR_NFAuthznProtocolNumber");
                if( (value == null) || (!value.equals(getBR_NFAuthznProtocolNumber())) ) {
                    setBR_NFAuthznProtocolNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFAuthenticationDate") ) {
                final Object value = values.remove("BR_NFAuthenticationDate");
                if( (value == null) || (!value.equals(getBR_NFAuthenticationDate())) ) {
                    setBR_NFAuthenticationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFAuthenticationTime") ) {
                final Object value = values.remove("BR_NFAuthenticationTime");
                if( (value == null) || (!value.equals(getBR_NFAuthenticationTime())) ) {
                    setBR_NFAuthenticationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("BR_NFeXMLVersion") ) {
                final Object value = values.remove("BR_NFeXMLVersion");
                if( (value == null) || (!value.equals(getBR_NFeXMLVersion())) ) {
                    setBR_NFeXMLVersion(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("BR_NFOriginalAmount") ) {
                final Object value = values.remove("BR_NFOriginalAmount");
                if( (value == null) || (!value.equals(getBR_NFOriginalAmount())) ) {
                    setBR_NFOriginalAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFDiscountAmount") ) {
                final Object value = values.remove("BR_NFDiscountAmount");
                if( (value == null) || (!value.equals(getBR_NFDiscountAmount())) ) {
                    setBR_NFDiscountAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFNetAmount") ) {
                final Object value = values.remove("BR_NFNetAmount");
                if( (value == null) || (!value.equals(getBR_NFNetAmount())) ) {
                    setBR_NFNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFCommitmentNote") ) {
                final Object value = values.remove("BR_NFCommitmentNote");
                if( (value == null) || (!value.equals(getBR_NFCommitmentNote())) ) {
                    setBR_NFCommitmentNote(((String) value));
                }
            }
            if( values.containsKey("SugarcaneHarvest") ) {
                final Object value = values.remove("SugarcaneHarvest");
                if( (value == null) || (!value.equals(getSugarcaneHarvest())) ) {
                    setSugarcaneHarvest(((String) value));
                }
            }
            if( values.containsKey("SugarcaneRefMonthYear") ) {
                final Object value = values.remove("SugarcaneRefMonthYear");
                if( (value == null) || (!value.equals(getSugarcaneRefMonthYear())) ) {
                    setSugarcaneRefMonthYear(((String) value));
                }
            }
            if( values.containsKey("SugarcaneCurMnthQtyUnit") ) {
                final Object value = values.remove("SugarcaneCurMnthQtyUnit");
                if( (value == null) || (!value.equals(getSugarcaneCurMnthQtyUnit())) ) {
                    setSugarcaneCurMnthQtyUnit(((String) value));
                }
            }
            if( values.containsKey("SugarcaneCurrentMonthQty") ) {
                final Object value = values.remove("SugarcaneCurrentMonthQty");
                if( (value == null) || (!value.equals(getSugarcaneCurrentMonthQty())) ) {
                    setSugarcaneCurrentMonthQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("SugarcaneLastMnthQtyUnit") ) {
                final Object value = values.remove("SugarcaneLastMnthQtyUnit");
                if( (value == null) || (!value.equals(getSugarcaneLastMnthQtyUnit())) ) {
                    setSugarcaneLastMnthQtyUnit(((String) value));
                }
            }
            if( values.containsKey("SugarcaneLastMnthQuantity") ) {
                final Object value = values.remove("SugarcaneLastMnthQuantity");
                if( (value == null) || (!value.equals(getSugarcaneLastMnthQuantity())) ) {
                    setSugarcaneLastMnthQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SugarcaneSumBothMnthsQtyUnit") ) {
                final Object value = values.remove("SugarcaneSumBothMnthsQtyUnit");
                if( (value == null) || (!value.equals(getSugarcaneSumBothMnthsQtyUnit())) ) {
                    setSugarcaneSumBothMnthsQtyUnit(((String) value));
                }
            }
            if( values.containsKey("SugarcaneSumBothMonthsQty") ) {
                final Object value = values.remove("SugarcaneSumBothMonthsQty");
                if( (value == null) || (!value.equals(getSugarcaneSumBothMonthsQty())) ) {
                    setSugarcaneSumBothMonthsQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("SugarcaneSuppliesAmount") ) {
                final Object value = values.remove("SugarcaneSuppliesAmount");
                if( (value == null) || (!value.equals(getSugarcaneSuppliesAmount())) ) {
                    setSugarcaneSuppliesAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SugarcaneTotalDeductionAmount") ) {
                final Object value = values.remove("SugarcaneTotalDeductionAmount");
                if( (value == null) || (!value.equals(getSugarcaneTotalDeductionAmount())) ) {
                    setSugarcaneTotalDeductionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SugarcaneSuppliesNetAmt") ) {
                final Object value = values.remove("SugarcaneSuppliesNetAmt");
                if( (value == null) || (!value.equals(getSugarcaneSuppliesNetAmt())) ) {
                    setSugarcaneSuppliesNetAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFeDocumentStatus") ) {
                final Object value = values.remove("BR_NFeDocumentStatus");
                if( (value == null) || (!value.equals(getBR_NFeDocumentStatus())) ) {
                    setBR_NFeDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsFinalConsumer") ) {
                final Object value = values.remove("BR_NFIsFinalConsumer");
                if( (value == null) || (!value.equals(getBR_NFIsFinalConsumer())) ) {
                    setBR_NFIsFinalConsumer(((String) value));
                }
            }
            if( values.containsKey("BR_NFeCustomerPresence") ) {
                final Object value = values.remove("BR_NFeCustomerPresence");
                if( (value == null) || (!value.equals(getBR_NFeCustomerPresence())) ) {
                    setBR_NFeCustomerPresence(((String) value));
                }
            }
            if( values.containsKey("BR_NFeDestination") ) {
                final Object value = values.remove("BR_NFeDestination");
                if( (value == null) || (!value.equals(getBR_NFeDestination())) ) {
                    setBR_NFeDestination(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPostingDate") ) {
                final Object value = values.remove("BR_NFPostingDate");
                if( (value == null) || (!value.equals(getBR_NFPostingDate())) ) {
                    setBR_NFPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((String) value));
                }
            }
            if( values.containsKey("BR_BusinessPlaceCNPJ") ) {
                final Object value = values.remove("BR_BusinessPlaceCNPJ");
                if( (value == null) || (!value.equals(getBR_BusinessPlaceCNPJ())) ) {
                    setBR_BusinessPlaceCNPJ(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceStateTaxNumber") ) {
                final Object value = values.remove("BusinessPlaceStateTaxNumber");
                if( (value == null) || (!value.equals(getBusinessPlaceStateTaxNumber())) ) {
                    setBusinessPlaceStateTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BR_BusPlaceStateTaxNumberST") ) {
                final Object value = values.remove("BR_BusPlaceStateTaxNumberST");
                if( (value == null) || (!value.equals(getBR_BusPlaceStateTaxNumberST())) ) {
                    setBR_BusPlaceStateTaxNumberST(((String) value));
                }
            }
            if( values.containsKey("BusPlaceMunicipalTaxNumber") ) {
                final Object value = values.remove("BusPlaceMunicipalTaxNumber");
                if( (value == null) || (!value.equals(getBusPlaceMunicipalTaxNumber())) ) {
                    setBusPlaceMunicipalTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BR_BusinessPlaceCNAE") ) {
                final Object value = values.remove("BR_BusinessPlaceCNAE");
                if( (value == null) || (!value.equals(getBR_BusinessPlaceCNAE())) ) {
                    setBR_BusinessPlaceCNAE(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceTaxRegimenCode") ) {
                final Object value = values.remove("BusinessPlaceTaxRegimenCode");
                if( (value == null) || (!value.equals(getBusinessPlaceTaxRegimenCode())) ) {
                    setBusinessPlaceTaxRegimenCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFTotalAmount") ) {
                final Object value = values.remove("BR_NFTotalAmount");
                if( (value == null) || (!value.equals(getBR_NFTotalAmount())) ) {
                    setBR_NFTotalAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("BR_NFFiscalYear") ) {
                final Object value = values.remove("BR_NFFiscalYear");
                if( (value == null) || (!value.equals(getBR_NFFiscalYear())) ) {
                    setBR_NFFiscalYear(((String) value));
                }
            }
            if( values.containsKey("BR_NFWithholdingAmount") ) {
                final Object value = values.remove("BR_NFWithholdingAmount");
                if( (value == null) || (!value.equals(getBR_NFWithholdingAmount())) ) {
                    setBR_NFWithholdingAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_PaymentForm") ) {
                final Object value = values.remove("BR_PaymentForm");
                if( (value == null) || (!value.equals(getBR_PaymentForm())) ) {
                    setBR_PaymentForm(((String) value));
                }
            }
            if( values.containsKey("FreightPayer") ) {
                final Object value = values.remove("FreightPayer");
                if( (value == null) || (!value.equals(getFreightPayer())) ) {
                    setFreightPayer(((String) value));
                }
            }
            if( values.containsKey("BR_ANTTCarrierRegistration") ) {
                final Object value = values.remove("BR_ANTTCarrierRegistration");
                if( (value == null) || (!value.equals(getBR_ANTTCarrierRegistration())) ) {
                    setBR_ANTTCarrierRegistration(((String) value));
                }
            }
            if( values.containsKey("BR_NFeNumber") ) {
                final Object value = values.remove("BR_NFeNumber");
                if( (value == null) || (!value.equals(getBR_NFeNumber())) ) {
                    setBR_NFeNumber(((String) value));
                }
            }
            if( values.containsKey("WagonID") ) {
                final Object value = values.remove("WagonID");
                if( (value == null) || (!value.equals(getWagonID())) ) {
                    setWagonID(((String) value));
                }
            }
            if( values.containsKey("FerryBoatID") ) {
                final Object value = values.remove("FerryBoatID");
                if( (value == null) || (!value.equals(getFerryBoatID())) ) {
                    setFerryBoatID(((String) value));
                }
            }
            if( values.containsKey("BR_NFExportShipmentPlace") ) {
                final Object value = values.remove("BR_NFExportShipmentPlace");
                if( (value == null) || (!value.equals(getBR_NFExportShipmentPlace())) ) {
                    setBR_NFExportShipmentPlace(((String) value));
                }
            }
            if( values.containsKey("BR_NFExportShipmentRegion") ) {
                final Object value = values.remove("BR_NFExportShipmentRegion");
                if( (value == null) || (!value.equals(getBR_NFExportShipmentRegion())) ) {
                    setBR_NFExportShipmentRegion(((String) value));
                }
            }
            if( values.containsKey("BR_NFExportDispatchLocation") ) {
                final Object value = values.remove("BR_NFExportDispatchLocation");
                if( (value == null) || (!value.equals(getBR_NFExportDispatchLocation())) ) {
                    setBR_NFExportDispatchLocation(((String) value));
                }
            }
            if( values.containsKey("BR_NFIssueDate") ) {
                final Object value = values.remove("BR_NFIssueDate");
                if( (value == null) || (!value.equals(getBR_NFIssueDate())) ) {
                    setBR_NFIssueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFIsMunicipal") ) {
                final Object value = values.remove("BR_NFIsMunicipal");
                if( (value == null) || (!value.equals(getBR_NFIsMunicipal())) ) {
                    setBR_NFIsMunicipal(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFOperationTypeDesc") ) {
                final Object value = values.remove("BR_NFOperationTypeDesc");
                if( (value == null) || (!value.equals(getBR_NFOperationTypeDesc())) ) {
                    setBR_NFOperationTypeDesc(((String) value));
                }
            }
            if( values.containsKey("BR_IsNFe") ) {
                final Object value = values.remove("BR_IsNFe");
                if( (value == null) || (!value.equals(getBR_IsNFe())) ) {
                    setBR_IsNFe(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFCancellationDate") ) {
                final Object value = values.remove("BR_NFCancellationDate");
                if( (value == null) || (!value.equals(getBR_NFCancellationDate())) ) {
                    setBR_NFCancellationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFHasFollowOnDocument") ) {
                final Object value = values.remove("BR_NFHasFollowOnDocument");
                if( (value == null) || (!value.equals(getBR_NFHasFollowOnDocument())) ) {
                    setBR_NFHasFollowOnDocument(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFReferenceDocument") ) {
                final Object value = values.remove("BR_NFReferenceDocument");
                if( (value == null) || (!value.equals(getBR_NFReferenceDocument())) ) {
                    setBR_NFReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("LicensePlate") ) {
                final Object value = values.remove("LicensePlate");
                if( (value == null) || (!value.equals(getLicensePlate())) ) {
                    setLicensePlate(((String) value));
                }
            }
            if( values.containsKey("VehicleRegion") ) {
                final Object value = values.remove("VehicleRegion");
                if( (value == null) || (!value.equals(getVehicleRegion())) ) {
                    setVehicleRegion(((String) value));
                }
            }
            if( values.containsKey("BR_UtilsNFNumber") ) {
                final Object value = values.remove("BR_UtilsNFNumber");
                if( (value == null) || (!value.equals(getBR_UtilsNFNumber())) ) {
                    setBR_UtilsNFNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerPlaceType") ) {
                final Object value = values.remove("BR_NFPartnerPlaceType");
                if( (value == null) || (!value.equals(getBR_NFPartnerPlaceType())) ) {
                    setBR_NFPartnerPlaceType(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsCalculatedByTaxService") ) {
                final Object value = values.remove("BR_NFIsCalculatedByTaxService");
                if( (value == null) || (!value.equals(getBR_NFIsCalculatedByTaxService())) ) {
                    setBR_NFIsCalculatedByTaxService(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeAmount") ) {
                final Object value = values.remove("ChangeAmount");
                if( (value == null) || (!value.equals(getChangeAmount())) ) {
                    setChangeAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFFiscalCouponDocModel") ) {
                final Object value = values.remove("BR_NFFiscalCouponDocModel");
                if( (value == null) || (!value.equals(getBR_NFFiscalCouponDocModel())) ) {
                    setBR_NFFiscalCouponDocModel(((String) value));
                }
            }
            if( values.containsKey("BR_NFOperationOrderNumber") ) {
                final Object value = values.remove("BR_NFOperationOrderNumber");
                if( (value == null) || (!value.equals(getBR_NFOperationOrderNumber())) ) {
                    setBR_NFOperationOrderNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerForeignIdn") ) {
                final Object value = values.remove("BR_NFPartnerForeignIdn");
                if( (value == null) || (!value.equals(getBR_NFPartnerForeignIdn())) ) {
                    setBR_NFPartnerForeignIdn(((String) value));
                }
            }
            if( values.containsKey("BR_CTeDocumentType") ) {
                final Object value = values.remove("BR_CTeDocumentType");
                if( (value == null) || (!value.equals(getBR_CTeDocumentType())) ) {
                    setBR_CTeDocumentType(((String) value));
                }
            }
            if( values.containsKey("BR_CTeMainProductTransported") ) {
                final Object value = values.remove("BR_CTeMainProductTransported");
                if( (value == null) || (!value.equals(getBR_CTeMainProductTransported())) ) {
                    setBR_CTeMainProductTransported(((String) value));
                }
            }
            if( values.containsKey("BR_CTeTotalGoodsAmount") ) {
                final Object value = values.remove("BR_CTeTotalGoodsAmount");
                if( (value == null) || (!value.equals(getBR_CTeTotalGoodsAmount())) ) {
                    setBR_CTeTotalGoodsAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_CTePartnerServiceTaker") ) {
                final Object value = values.remove("BR_CTePartnerServiceTaker");
                if( (value == null) || (!value.equals(getBR_CTePartnerServiceTaker())) ) {
                    setBR_CTePartnerServiceTaker(((String) value));
                }
            }
            if( values.containsKey("BR_CTeFiscalDocumentPartner") ) {
                final Object value = values.remove("BR_CTeFiscalDocumentPartner");
                if( (value == null) || (!value.equals(getBR_CTeFiscalDocumentPartner())) ) {
                    setBR_CTeFiscalDocumentPartner(((String) value));
                }
            }
            if( values.containsKey("BR_CTeServiceType") ) {
                final Object value = values.remove("BR_CTeServiceType");
                if( (value == null) || (!value.equals(getBR_CTeServiceType())) ) {
                    setBR_CTeServiceType(((String) value));
                }
            }
            if( values.containsKey("BR_CTeTransportationMode") ) {
                final Object value = values.remove("BR_CTeTransportationMode");
                if( (value == null) || (!value.equals(getBR_CTeTransportationMode())) ) {
                    setBR_CTeTransportationMode(((String) value));
                }
            }
            if( values.containsKey("BR_CTeEstimatedDeliveryDate") ) {
                final Object value = values.remove("BR_CTeEstimatedDeliveryDate");
                if( (value == null) || (!value.equals(getBR_CTeEstimatedDeliveryDate())) ) {
                    setBR_CTeEstimatedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_CTeIsTruckFullyLoaded") ) {
                final Object value = values.remove("BR_CTeIsTruckFullyLoaded");
                if( (value == null) || (!value.equals(getBR_CTeIsTruckFullyLoaded())) ) {
                    setBR_CTeIsTruckFullyLoaded(((Boolean) value));
                }
            }
            if( values.containsKey("BR_CTeJurisdictionCodeOrigin") ) {
                final Object value = values.remove("BR_CTeJurisdictionCodeOrigin");
                if( (value == null) || (!value.equals(getBR_CTeJurisdictionCodeOrigin())) ) {
                    setBR_CTeJurisdictionCodeOrigin(((String) value));
                }
            }
            if( values.containsKey("BR_CTeJurisdictionCodeDest") ) {
                final Object value = values.remove("BR_CTeJurisdictionCodeDest");
                if( (value == null) || (!value.equals(getBR_CTeJurisdictionCodeDest())) ) {
                    setBR_CTeJurisdictionCodeDest(((String) value));
                }
            }
            if( values.containsKey("BR_NFSVerificationCode") ) {
                final Object value = values.remove("BR_NFSVerificationCode");
                if( (value == null) || (!value.equals(getBR_NFSVerificationCode())) ) {
                    setBR_NFSVerificationCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFSNumber") ) {
                final Object value = values.remove("BR_NFSNumber");
                if( (value == null) || (!value.equals(getBR_NFSNumber())) ) {
                    setBR_NFSNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFHasServiceItem") ) {
                final Object value = values.remove("BR_NFHasServiceItem");
                if( (value == null) || (!value.equals(getBR_NFHasServiceItem())) ) {
                    setBR_NFHasServiceItem(((Boolean) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("BR_NFeIntermediatorTransaction") ) {
                final Object value = values.remove("BR_NFeIntermediatorTransaction");
                if( (value == null) || (!value.equals(getBR_NFeIntermediatorTransaction())) ) {
                    setBR_NFeIntermediatorTransaction(((String) value));
                }
            }
            if( values.containsKey("BR_NFeIntermediatorRegistry") ) {
                final Object value = values.remove("BR_NFeIntermediatorRegistry");
                if( (value == null) || (!value.equals(getBR_NFeIntermediatorRegistry())) ) {
                    setBR_NFeIntermediatorRegistry(((String) value));
                }
            }
            if( values.containsKey("BR_NFeIntermediatorCNPJ") ) {
                final Object value = values.remove("BR_NFeIntermediatorCNPJ");
                if( (value == null) || (!value.equals(getBR_NFeIntermediatorCNPJ())) ) {
                    setBR_NFeIntermediatorCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_NFMessageText") ) {
                final Object value = values.remove("BR_NFMessageText");
                if( (value == null) || (!value.equals(getBR_NFMessageText())) ) {
                    setBR_NFMessageText(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdditionalFiscalInfoText") ) {
                final Object value = values.remove("BR_NFAdditionalFiscalInfoText");
                if( (value == null) || (!value.equals(getBR_NFAdditionalFiscalInfoText())) ) {
                    setBR_NFAdditionalFiscalInfoText(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdditionalCompanyInfoText") ) {
                final Object value = values.remove("BR_NFAdditionalCompanyInfoText");
                if( (value == null) || (!value.equals(getBR_NFAdditionalCompanyInfoText())) ) {
                    setBR_NFAdditionalCompanyInfoText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFAdditionalInformation") ) {
                final Object value = (values).remove("to_BR_NFAdditionalInformation");
                if( value instanceof Iterable ) {
                    if( toBR_NFAdditionalInformation == null ) {
                        toBR_NFAdditionalInformation = Lists.newArrayList();
                    } else {
                        toBR_NFAdditionalInformation = Lists.newArrayList(toBR_NFAdditionalInformation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFAdditionalInformation entity;
                        if( toBR_NFAdditionalInformation.size() > i ) {
                            entity = toBR_NFAdditionalInformation.get(i);
                        } else {
                            entity = new BR_NFAdditionalInformation();
                            toBR_NFAdditionalInformation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFDocumentReference") ) {
                final Object value = (values).remove("to_BR_NFDocumentReference");
                if( value instanceof Iterable ) {
                    if( toBR_NFDocumentReference == null ) {
                        toBR_NFDocumentReference = Lists.newArrayList();
                    } else {
                        toBR_NFDocumentReference = Lists.newArrayList(toBR_NFDocumentReference);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFDocumentReference entity;
                        if( toBR_NFDocumentReference.size() > i ) {
                            entity = toBR_NFDocumentReference.get(i);
                        } else {
                            entity = new BR_NFDocumentReference();
                            toBR_NFDocumentReference.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFePayment") ) {
                final Object value = (values).remove("to_BR_NFePayment");
                if( value instanceof Iterable ) {
                    if( toBR_NFePayment == null ) {
                        toBR_NFePayment = Lists.newArrayList();
                    } else {
                        toBR_NFePayment = Lists.newArrayList(toBR_NFePayment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFePayment entity;
                        if( toBR_NFePayment.size() > i ) {
                            entity = toBR_NFePayment.get(i);
                        } else {
                            entity = new BR_NFePayment();
                            toBR_NFePayment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFExportDeclaration") ) {
                final Object value = (values).remove("to_BR_NFExportDeclaration");
                if( value instanceof Map ) {
                    if( toBR_NFExportDeclaration == null ) {
                        toBR_NFExportDeclaration = new BR_NFExportDeclaration();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFExportDeclaration.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFHeaderText") ) {
                final Object value = (values).remove("to_BR_NFHeaderText");
                if( value instanceof Iterable ) {
                    if( toBR_NFHeaderText == null ) {
                        toBR_NFHeaderText = Lists.newArrayList();
                    } else {
                        toBR_NFHeaderText = Lists.newArrayList(toBR_NFHeaderText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFHeaderText entity;
                        if( toBR_NFHeaderText.size() > i ) {
                            entity = toBR_NFHeaderText.get(i);
                        } else {
                            entity = new BR_NFHeaderText();
                            toBR_NFHeaderText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFImportDocument") ) {
                final Object value = (values).remove("to_BR_NFImportDocument");
                if( value instanceof Iterable ) {
                    if( toBR_NFImportDocument == null ) {
                        toBR_NFImportDocument = Lists.newArrayList();
                    } else {
                        toBR_NFImportDocument = Lists.newArrayList(toBR_NFImportDocument);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFImportDocument entity;
                        if( toBR_NFImportDocument.size() > i ) {
                            entity = toBR_NFImportDocument.get(i);
                        } else {
                            entity = new BR_NFImportDocument();
                            toBR_NFImportDocument.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Iterable ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = Lists.newArrayList();
                    } else {
                        toBR_NFItem = Lists.newArrayList(toBR_NFItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFItem entity;
                        if( toBR_NFItem.size() > i ) {
                            entity = toBR_NFItem.get(i);
                        } else {
                            entity = new BR_NFItem();
                            toBR_NFItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFPartner") ) {
                final Object value = (values).remove("to_BR_NFPartner");
                if( value instanceof Iterable ) {
                    if( toBR_NFPartner == null ) {
                        toBR_NFPartner = Lists.newArrayList();
                    } else {
                        toBR_NFPartner = Lists.newArrayList(toBR_NFPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFPartner entity;
                        if( toBR_NFPartner.size() > i ) {
                            entity = toBR_NFPartner.get(i);
                        } else {
                            entity = new BR_NFPartner();
                            toBR_NFPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFReferencedProcess") ) {
                final Object value = (values).remove("to_BR_NFReferencedProcess");
                if( value instanceof Iterable ) {
                    if( toBR_NFReferencedProcess == null ) {
                        toBR_NFReferencedProcess = Lists.newArrayList();
                    } else {
                        toBR_NFReferencedProcess = Lists.newArrayList(toBR_NFReferencedProcess);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFReferencedProcess entity;
                        if( toBR_NFReferencedProcess.size() > i ) {
                            entity = toBR_NFReferencedProcess.get(i);
                        } else {
                            entity = new BR_NFReferencedProcess();
                            toBR_NFReferencedProcess.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFSugarCaneDeductible") ) {
                final Object value = (values).remove("to_BR_NFSugarCaneDeductible");
                if( value instanceof Iterable ) {
                    if( toBR_NFSugarCaneDeductible == null ) {
                        toBR_NFSugarCaneDeductible = Lists.newArrayList();
                    } else {
                        toBR_NFSugarCaneDeductible = Lists.newArrayList(toBR_NFSugarCaneDeductible);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFSugarCaneDeductible entity;
                        if( toBR_NFSugarCaneDeductible.size() > i ) {
                            entity = toBR_NFSugarCaneDeductible.get(i);
                        } else {
                            entity = new BR_NFSugarCaneDeductible();
                            toBR_NFSugarCaneDeductible.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFSugarCaneSupply") ) {
                final Object value = (values).remove("to_BR_NFSugarCaneSupply");
                if( value instanceof Iterable ) {
                    if( toBR_NFSugarCaneSupply == null ) {
                        toBR_NFSugarCaneSupply = Lists.newArrayList();
                    } else {
                        toBR_NFSugarCaneSupply = Lists.newArrayList(toBR_NFSugarCaneSupply);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFSugarCaneSupply entity;
                        if( toBR_NFSugarCaneSupply.size() > i ) {
                            entity = toBR_NFSugarCaneSupply.get(i);
                        } else {
                            entity = new BR_NFSugarCaneSupply();
                            toBR_NFSugarCaneSupply.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFTradeNote") ) {
                final Object value = (values).remove("to_BR_NFTradeNote");
                if( value instanceof Iterable ) {
                    if( toBR_NFTradeNote == null ) {
                        toBR_NFTradeNote = Lists.newArrayList();
                    } else {
                        toBR_NFTradeNote = Lists.newArrayList(toBR_NFTradeNote);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFTradeNote entity;
                        if( toBR_NFTradeNote.size() > i ) {
                            entity = toBR_NFTradeNote.get(i);
                        } else {
                            entity = new BR_NFTradeNote();
                            toBR_NFTradeNote.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFTrailer") ) {
                final Object value = (values).remove("to_BR_NFTrailer");
                if( value instanceof Iterable ) {
                    if( toBR_NFTrailer == null ) {
                        toBR_NFTrailer = Lists.newArrayList();
                    } else {
                        toBR_NFTrailer = Lists.newArrayList(toBR_NFTrailer);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFTrailer entity;
                        if( toBR_NFTrailer.size() > i ) {
                            entity = toBR_NFTrailer.get(i);
                        } else {
                            entity = new BR_NFTrailer();
                            toBR_NFTrailer.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFTransportedVolume") ) {
                final Object value = (values).remove("to_BR_NFTransportedVolume");
                if( value instanceof Iterable ) {
                    if( toBR_NFTransportedVolume == null ) {
                        toBR_NFTransportedVolume = Lists.newArrayList();
                    } else {
                        toBR_NFTransportedVolume = Lists.newArrayList(toBR_NFTransportedVolume);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFTransportedVolume entity;
                        if( toBR_NFTransportedVolume.size() > i ) {
                            entity = toBR_NFTransportedVolume.get(i);
                        } else {
                            entity = new BR_NFTransportedVolume();
                            toBR_NFTransportedVolume.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_OneTimePartner") ) {
                final Object value = (values).remove("to_BR_OneTimePartner");
                if( value instanceof Iterable ) {
                    if( toBR_OneTimePartner == null ) {
                        toBR_OneTimePartner = Lists.newArrayList();
                    } else {
                        toBR_OneTimePartner = Lists.newArrayList(toBR_OneTimePartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_OneTimePartner entity;
                        if( toBR_OneTimePartner.size() > i ) {
                            entity = toBR_OneTimePartner.get(i);
                        } else {
                            entity = new BR_OneTimePartner();
                            toBR_OneTimePartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_TechnicalResponsible") ) {
                final Object value = (values).remove("to_BR_TechnicalResponsible");
                if( value instanceof Map ) {
                    if( toBR_TechnicalResponsible == null ) {
                        toBR_TechnicalResponsible = new BR_TechnicalResponsible();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_TechnicalResponsible.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFAdditionalInformation != null ) {
            (values).put("to_BR_NFAdditionalInformation", toBR_NFAdditionalInformation);
        }
        if( toBR_NFDocumentReference != null ) {
            (values).put("to_BR_NFDocumentReference", toBR_NFDocumentReference);
        }
        if( toBR_NFePayment != null ) {
            (values).put("to_BR_NFePayment", toBR_NFePayment);
        }
        if( toBR_NFExportDeclaration != null ) {
            (values).put("to_BR_NFExportDeclaration", toBR_NFExportDeclaration);
        }
        if( toBR_NFHeaderText != null ) {
            (values).put("to_BR_NFHeaderText", toBR_NFHeaderText);
        }
        if( toBR_NFImportDocument != null ) {
            (values).put("to_BR_NFImportDocument", toBR_NFImportDocument);
        }
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        if( toBR_NFPartner != null ) {
            (values).put("to_BR_NFPartner", toBR_NFPartner);
        }
        if( toBR_NFReferencedProcess != null ) {
            (values).put("to_BR_NFReferencedProcess", toBR_NFReferencedProcess);
        }
        if( toBR_NFSugarCaneDeductible != null ) {
            (values).put("to_BR_NFSugarCaneDeductible", toBR_NFSugarCaneDeductible);
        }
        if( toBR_NFSugarCaneSupply != null ) {
            (values).put("to_BR_NFSugarCaneSupply", toBR_NFSugarCaneSupply);
        }
        if( toBR_NFTradeNote != null ) {
            (values).put("to_BR_NFTradeNote", toBR_NFTradeNote);
        }
        if( toBR_NFTrailer != null ) {
            (values).put("to_BR_NFTrailer", toBR_NFTrailer);
        }
        if( toBR_NFTransportedVolume != null ) {
            (values).put("to_BR_NFTransportedVolume", toBR_NFTransportedVolume);
        }
        if( toBR_OneTimePartner != null ) {
            (values).put("to_BR_OneTimePartner", toBR_OneTimePartner);
        }
        if( toBR_TechnicalResponsible != null ) {
            (values).put("to_BR_TechnicalResponsible", toBR_TechnicalResponsible);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFAdditionalInformation</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_BR_NFAdditionalInformation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFAdditionalInformation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFAdditionalInformation> fetchBR_NFAdditionalInformation()
    {
        return fetchFieldAsList("to_BR_NFAdditionalInformation", BR_NFAdditionalInformation.class);
    }

    /**
     * Retrieval of associated <b>BR_NFAdditionalInformation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionalInformation</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionalInformation</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFAdditionalInformation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFAdditionalInformation> getBR_NFAdditionalInformationOrFetch()
    {
        if( toBR_NFAdditionalInformation == null ) {
            toBR_NFAdditionalInformation = fetchBR_NFAdditionalInformation();
        }
        return toBR_NFAdditionalInformation;
    }

    /**
     * Retrieval of associated <b>BR_NFAdditionalInformation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionalInformation</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFAdditionalInformation</b> is already loaded, the
     *         result will contain the <b>BR_NFAdditionalInformation</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFAdditionalInformation>> getBR_NFAdditionalInformationIfPresent()
    {
        return Option.of(toBR_NFAdditionalInformation);
    }

    /**
     * Overwrites the list of associated <b>BR_NFAdditionalInformation</b> entities for the loaded navigation property
     * <b>to_BR_NFAdditionalInformation</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionalInformation</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFAdditionalInformation</b> entities.
     */
    public void setBR_NFAdditionalInformation( @Nonnull final List<BR_NFAdditionalInformation> value )
    {
        if( toBR_NFAdditionalInformation == null ) {
            toBR_NFAdditionalInformation = Lists.newArrayList();
        }
        toBR_NFAdditionalInformation.clear();
        toBR_NFAdditionalInformation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFAdditionalInformation</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionalInformation</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionalInformation</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFAdditionalInformation</b> entities.
     */
    public void addBR_NFAdditionalInformation( BR_NFAdditionalInformation... entity )
    {
        if( toBR_NFAdditionalInformation == null ) {
            toBR_NFAdditionalInformation = Lists.newArrayList();
        }
        toBR_NFAdditionalInformation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFDocumentReference</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFDocumentReference</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFDocumentReference</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFDocumentReference> fetchBR_NFDocumentReference()
    {
        return fetchFieldAsList("to_BR_NFDocumentReference", BR_NFDocumentReference.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocumentReference</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFDocumentReference</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDocumentReference</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocumentReference</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFDocumentReference> getBR_NFDocumentReferenceOrFetch()
    {
        if( toBR_NFDocumentReference == null ) {
            toBR_NFDocumentReference = fetchBR_NFDocumentReference();
        }
        return toBR_NFDocumentReference;
    }

    /**
     * Retrieval of associated <b>BR_NFDocumentReference</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFDocumentReference</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDocumentReference</b> is already loaded, the result
     *         will contain the <b>BR_NFDocumentReference</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFDocumentReference>> getBR_NFDocumentReferenceIfPresent()
    {
        return Option.of(toBR_NFDocumentReference);
    }

    /**
     * Overwrites the list of associated <b>BR_NFDocumentReference</b> entities for the loaded navigation property
     * <b>to_BR_NFDocumentReference</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDocumentReference</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFDocumentReference</b> entities.
     */
    public void setBR_NFDocumentReference( @Nonnull final List<BR_NFDocumentReference> value )
    {
        if( toBR_NFDocumentReference == null ) {
            toBR_NFDocumentReference = Lists.newArrayList();
        }
        toBR_NFDocumentReference.clear();
        toBR_NFDocumentReference.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFDocumentReference</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFDocumentReference</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDocumentReference</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFDocumentReference</b> entities.
     */
    public void addBR_NFDocumentReference( BR_NFDocumentReference... entity )
    {
        if( toBR_NFDocumentReference == null ) {
            toBR_NFDocumentReference = Lists.newArrayList();
        }
        toBR_NFDocumentReference.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFePayment</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_NFePayment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFePayment</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFePayment> fetchBR_NFePayment()
    {
        return fetchFieldAsList("to_BR_NFePayment", BR_NFePayment.class);
    }

    /**
     * Retrieval of associated <b>BR_NFePayment</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFePayment</b>.
     * <p>
     * If the navigation property <b>to_BR_NFePayment</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFePayment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFePayment> getBR_NFePaymentOrFetch()
    {
        if( toBR_NFePayment == null ) {
            toBR_NFePayment = fetchBR_NFePayment();
        }
        return toBR_NFePayment;
    }

    /**
     * Retrieval of associated <b>BR_NFePayment</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFePayment</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFePayment</b> is already loaded, the result will
     *         contain the <b>BR_NFePayment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFePayment>> getBR_NFePaymentIfPresent()
    {
        return Option.of(toBR_NFePayment);
    }

    /**
     * Overwrites the list of associated <b>BR_NFePayment</b> entities for the loaded navigation property
     * <b>to_BR_NFePayment</b>.
     * <p>
     * If the navigation property <b>to_BR_NFePayment</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFePayment</b> entities.
     */
    public void setBR_NFePayment( @Nonnull final List<BR_NFePayment> value )
    {
        if( toBR_NFePayment == null ) {
            toBR_NFePayment = Lists.newArrayList();
        }
        toBR_NFePayment.clear();
        toBR_NFePayment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFePayment</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFePayment</b>.
     * <p>
     * If the navigation property <b>to_BR_NFePayment</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFePayment</b> entities.
     */
    public void addBR_NFePayment( BR_NFePayment... entity )
    {
        if( toBR_NFePayment == null ) {
            toBR_NFePayment = Lists.newArrayList();
        }
        toBR_NFePayment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFExportDeclaration</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFExportDeclaration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFExportDeclaration</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFExportDeclaration fetchBR_NFExportDeclaration()
    {
        return fetchFieldAsSingle("to_BR_NFExportDeclaration", BR_NFExportDeclaration.class);
    }

    /**
     * Retrieval of associated <b>BR_NFExportDeclaration</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BR_NFExportDeclaration</b>.
     * <p>
     * If the navigation property <b>to_BR_NFExportDeclaration</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFExportDeclaration</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFExportDeclaration getBR_NFExportDeclarationOrFetch()
    {
        if( toBR_NFExportDeclaration == null ) {
            toBR_NFExportDeclaration = fetchBR_NFExportDeclaration();
        }
        return toBR_NFExportDeclaration;
    }

    /**
     * Retrieval of associated <b>BR_NFExportDeclaration</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BR_NFExportDeclaration</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFExportDeclaration</b> is already loaded, the result
     *         will contain the <b>BR_NFExportDeclaration</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BR_NFExportDeclaration> getBR_NFExportDeclarationIfPresent()
    {
        return Option.of(toBR_NFExportDeclaration);
    }

    /**
     * Overwrites the associated <b>BR_NFExportDeclaration</b> entity for the loaded navigation property
     * <b>to_BR_NFExportDeclaration</b>.
     *
     * @param value
     *            New <b>BR_NFExportDeclaration</b> entity.
     */
    public void setBR_NFExportDeclaration( final BR_NFExportDeclaration value )
    {
        toBR_NFExportDeclaration = value;
    }

    /**
     * Fetches the <b>BR_NFHeaderText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_NFHeaderText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFHeaderText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFHeaderText> fetchBR_NFHeaderText()
    {
        return fetchFieldAsList("to_BR_NFHeaderText", BR_NFHeaderText.class);
    }

    /**
     * Retrieval of associated <b>BR_NFHeaderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFHeaderText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFHeaderText</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFHeaderText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFHeaderText> getBR_NFHeaderTextOrFetch()
    {
        if( toBR_NFHeaderText == null ) {
            toBR_NFHeaderText = fetchBR_NFHeaderText();
        }
        return toBR_NFHeaderText;
    }

    /**
     * Retrieval of associated <b>BR_NFHeaderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFHeaderText</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFHeaderText</b> is already loaded, the result will
     *         contain the <b>BR_NFHeaderText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFHeaderText>> getBR_NFHeaderTextIfPresent()
    {
        return Option.of(toBR_NFHeaderText);
    }

    /**
     * Overwrites the list of associated <b>BR_NFHeaderText</b> entities for the loaded navigation property
     * <b>to_BR_NFHeaderText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFHeaderText</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFHeaderText</b> entities.
     */
    public void setBR_NFHeaderText( @Nonnull final List<BR_NFHeaderText> value )
    {
        if( toBR_NFHeaderText == null ) {
            toBR_NFHeaderText = Lists.newArrayList();
        }
        toBR_NFHeaderText.clear();
        toBR_NFHeaderText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFHeaderText</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFHeaderText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFHeaderText</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFHeaderText</b> entities.
     */
    public void addBR_NFHeaderText( BR_NFHeaderText... entity )
    {
        if( toBR_NFHeaderText == null ) {
            toBR_NFHeaderText = Lists.newArrayList();
        }
        toBR_NFHeaderText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFImportDocument</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFImportDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFImportDocument</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFImportDocument> fetchBR_NFImportDocument()
    {
        return fetchFieldAsList("to_BR_NFImportDocument", BR_NFImportDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFImportDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFImportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFImportDocument</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFImportDocument</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFImportDocument> getBR_NFImportDocumentOrFetch()
    {
        if( toBR_NFImportDocument == null ) {
            toBR_NFImportDocument = fetchBR_NFImportDocument();
        }
        return toBR_NFImportDocument;
    }

    /**
     * Retrieval of associated <b>BR_NFImportDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFImportDocument</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFImportDocument</b> is already loaded, the result
     *         will contain the <b>BR_NFImportDocument</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFImportDocument>> getBR_NFImportDocumentIfPresent()
    {
        return Option.of(toBR_NFImportDocument);
    }

    /**
     * Overwrites the list of associated <b>BR_NFImportDocument</b> entities for the loaded navigation property
     * <b>to_BR_NFImportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFImportDocument</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFImportDocument</b> entities.
     */
    public void setBR_NFImportDocument( @Nonnull final List<BR_NFImportDocument> value )
    {
        if( toBR_NFImportDocument == null ) {
            toBR_NFImportDocument = Lists.newArrayList();
        }
        toBR_NFImportDocument.clear();
        toBR_NFImportDocument.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFImportDocument</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFImportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFImportDocument</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFImportDocument</b> entities.
     */
    public void addBR_NFImportDocument( BR_NFImportDocument... entity )
    {
        if( toBR_NFImportDocument == null ) {
            toBR_NFImportDocument = Lists.newArrayList();
        }
        toBR_NFImportDocument.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFItem</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFItem</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItem> fetchBR_NFItem()
    {
        return fetchFieldAsList("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItem> getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<BR_NFItem>> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the list of associated <b>BR_NFItem</b> entities for the loaded navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFItem</b> entities.
     */
    public void setBR_NFItem( @Nonnull final List<BR_NFItem> value )
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = Lists.newArrayList();
        }
        toBR_NFItem.clear();
        toBR_NFItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFItem</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFItem</b> entities.
     */
    public void addBR_NFItem( BR_NFItem... entity )
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = Lists.newArrayList();
        }
        toBR_NFItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFPartner</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFPartner</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFPartner> fetchBR_NFPartner()
    {
        return fetchFieldAsList("to_BR_NFPartner", BR_NFPartner.class);
    }

    /**
     * Retrieval of associated <b>BR_NFPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFPartner</b>.
     * <p>
     * If the navigation property <b>to_BR_NFPartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFPartner> getBR_NFPartnerOrFetch()
    {
        if( toBR_NFPartner == null ) {
            toBR_NFPartner = fetchBR_NFPartner();
        }
        return toBR_NFPartner;
    }

    /**
     * Retrieval of associated <b>BR_NFPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFPartner</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFPartner</b> is already loaded, the result will
     *         contain the <b>BR_NFPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFPartner>> getBR_NFPartnerIfPresent()
    {
        return Option.of(toBR_NFPartner);
    }

    /**
     * Overwrites the list of associated <b>BR_NFPartner</b> entities for the loaded navigation property
     * <b>to_BR_NFPartner</b>.
     * <p>
     * If the navigation property <b>to_BR_NFPartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFPartner</b> entities.
     */
    public void setBR_NFPartner( @Nonnull final List<BR_NFPartner> value )
    {
        if( toBR_NFPartner == null ) {
            toBR_NFPartner = Lists.newArrayList();
        }
        toBR_NFPartner.clear();
        toBR_NFPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFPartner</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFPartner</b>.
     * <p>
     * If the navigation property <b>to_BR_NFPartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFPartner</b> entities.
     */
    public void addBR_NFPartner( BR_NFPartner... entity )
    {
        if( toBR_NFPartner == null ) {
            toBR_NFPartner = Lists.newArrayList();
        }
        toBR_NFPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFReferencedProcess</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFReferencedProcess</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFReferencedProcess</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFReferencedProcess> fetchBR_NFReferencedProcess()
    {
        return fetchFieldAsList("to_BR_NFReferencedProcess", BR_NFReferencedProcess.class);
    }

    /**
     * Retrieval of associated <b>BR_NFReferencedProcess</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFReferencedProcess</b>.
     * <p>
     * If the navigation property <b>to_BR_NFReferencedProcess</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFReferencedProcess</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFReferencedProcess> getBR_NFReferencedProcessOrFetch()
    {
        if( toBR_NFReferencedProcess == null ) {
            toBR_NFReferencedProcess = fetchBR_NFReferencedProcess();
        }
        return toBR_NFReferencedProcess;
    }

    /**
     * Retrieval of associated <b>BR_NFReferencedProcess</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFReferencedProcess</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFReferencedProcess</b> is already loaded, the result
     *         will contain the <b>BR_NFReferencedProcess</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFReferencedProcess>> getBR_NFReferencedProcessIfPresent()
    {
        return Option.of(toBR_NFReferencedProcess);
    }

    /**
     * Overwrites the list of associated <b>BR_NFReferencedProcess</b> entities for the loaded navigation property
     * <b>to_BR_NFReferencedProcess</b>.
     * <p>
     * If the navigation property <b>to_BR_NFReferencedProcess</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFReferencedProcess</b> entities.
     */
    public void setBR_NFReferencedProcess( @Nonnull final List<BR_NFReferencedProcess> value )
    {
        if( toBR_NFReferencedProcess == null ) {
            toBR_NFReferencedProcess = Lists.newArrayList();
        }
        toBR_NFReferencedProcess.clear();
        toBR_NFReferencedProcess.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFReferencedProcess</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFReferencedProcess</b>.
     * <p>
     * If the navigation property <b>to_BR_NFReferencedProcess</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFReferencedProcess</b> entities.
     */
    public void addBR_NFReferencedProcess( BR_NFReferencedProcess... entity )
    {
        if( toBR_NFReferencedProcess == null ) {
            toBR_NFReferencedProcess = Lists.newArrayList();
        }
        toBR_NFReferencedProcess.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFSugarCaneDeductible</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BR_NFSugarCaneDeductible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFSugarCaneDeductible</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFSugarCaneDeductible> fetchBR_NFSugarCaneDeductible()
    {
        return fetchFieldAsList("to_BR_NFSugarCaneDeductible", BR_NFSugarCaneDeductible.class);
    }

    /**
     * Retrieval of associated <b>BR_NFSugarCaneDeductible</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneDeductible</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneDeductible</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFSugarCaneDeductible</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFSugarCaneDeductible> getBR_NFSugarCaneDeductibleOrFetch()
    {
        if( toBR_NFSugarCaneDeductible == null ) {
            toBR_NFSugarCaneDeductible = fetchBR_NFSugarCaneDeductible();
        }
        return toBR_NFSugarCaneDeductible;
    }

    /**
     * Retrieval of associated <b>BR_NFSugarCaneDeductible</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneDeductible</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFSugarCaneDeductible</b> is already loaded, the
     *         result will contain the <b>BR_NFSugarCaneDeductible</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFSugarCaneDeductible>> getBR_NFSugarCaneDeductibleIfPresent()
    {
        return Option.of(toBR_NFSugarCaneDeductible);
    }

    /**
     * Overwrites the list of associated <b>BR_NFSugarCaneDeductible</b> entities for the loaded navigation property
     * <b>to_BR_NFSugarCaneDeductible</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneDeductible</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFSugarCaneDeductible</b> entities.
     */
    public void setBR_NFSugarCaneDeductible( @Nonnull final List<BR_NFSugarCaneDeductible> value )
    {
        if( toBR_NFSugarCaneDeductible == null ) {
            toBR_NFSugarCaneDeductible = Lists.newArrayList();
        }
        toBR_NFSugarCaneDeductible.clear();
        toBR_NFSugarCaneDeductible.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFSugarCaneDeductible</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneDeductible</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneDeductible</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFSugarCaneDeductible</b> entities.
     */
    public void addBR_NFSugarCaneDeductible( BR_NFSugarCaneDeductible... entity )
    {
        if( toBR_NFSugarCaneDeductible == null ) {
            toBR_NFSugarCaneDeductible = Lists.newArrayList();
        }
        toBR_NFSugarCaneDeductible.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFSugarCaneSupply</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFSugarCaneSupply</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFSugarCaneSupply</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFSugarCaneSupply> fetchBR_NFSugarCaneSupply()
    {
        return fetchFieldAsList("to_BR_NFSugarCaneSupply", BR_NFSugarCaneSupply.class);
    }

    /**
     * Retrieval of associated <b>BR_NFSugarCaneSupply</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneSupply</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneSupply</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFSugarCaneSupply</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFSugarCaneSupply> getBR_NFSugarCaneSupplyOrFetch()
    {
        if( toBR_NFSugarCaneSupply == null ) {
            toBR_NFSugarCaneSupply = fetchBR_NFSugarCaneSupply();
        }
        return toBR_NFSugarCaneSupply;
    }

    /**
     * Retrieval of associated <b>BR_NFSugarCaneSupply</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneSupply</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFSugarCaneSupply</b> is already loaded, the result
     *         will contain the <b>BR_NFSugarCaneSupply</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFSugarCaneSupply>> getBR_NFSugarCaneSupplyIfPresent()
    {
        return Option.of(toBR_NFSugarCaneSupply);
    }

    /**
     * Overwrites the list of associated <b>BR_NFSugarCaneSupply</b> entities for the loaded navigation property
     * <b>to_BR_NFSugarCaneSupply</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneSupply</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFSugarCaneSupply</b> entities.
     */
    public void setBR_NFSugarCaneSupply( @Nonnull final List<BR_NFSugarCaneSupply> value )
    {
        if( toBR_NFSugarCaneSupply == null ) {
            toBR_NFSugarCaneSupply = Lists.newArrayList();
        }
        toBR_NFSugarCaneSupply.clear();
        toBR_NFSugarCaneSupply.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFSugarCaneSupply</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFSugarCaneSupply</b>.
     * <p>
     * If the navigation property <b>to_BR_NFSugarCaneSupply</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFSugarCaneSupply</b> entities.
     */
    public void addBR_NFSugarCaneSupply( BR_NFSugarCaneSupply... entity )
    {
        if( toBR_NFSugarCaneSupply == null ) {
            toBR_NFSugarCaneSupply = Lists.newArrayList();
        }
        toBR_NFSugarCaneSupply.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFTradeNote</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_NFTradeNote</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFTradeNote</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTradeNote> fetchBR_NFTradeNote()
    {
        return fetchFieldAsList("to_BR_NFTradeNote", BR_NFTradeNote.class);
    }

    /**
     * Retrieval of associated <b>BR_NFTradeNote</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFTradeNote</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTradeNote</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFTradeNote</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTradeNote> getBR_NFTradeNoteOrFetch()
    {
        if( toBR_NFTradeNote == null ) {
            toBR_NFTradeNote = fetchBR_NFTradeNote();
        }
        return toBR_NFTradeNote;
    }

    /**
     * Retrieval of associated <b>BR_NFTradeNote</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFTradeNote</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFTradeNote</b> is already loaded, the result will
     *         contain the <b>BR_NFTradeNote</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFTradeNote>> getBR_NFTradeNoteIfPresent()
    {
        return Option.of(toBR_NFTradeNote);
    }

    /**
     * Overwrites the list of associated <b>BR_NFTradeNote</b> entities for the loaded navigation property
     * <b>to_BR_NFTradeNote</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTradeNote</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFTradeNote</b> entities.
     */
    public void setBR_NFTradeNote( @Nonnull final List<BR_NFTradeNote> value )
    {
        if( toBR_NFTradeNote == null ) {
            toBR_NFTradeNote = Lists.newArrayList();
        }
        toBR_NFTradeNote.clear();
        toBR_NFTradeNote.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFTradeNote</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFTradeNote</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTradeNote</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFTradeNote</b> entities.
     */
    public void addBR_NFTradeNote( BR_NFTradeNote... entity )
    {
        if( toBR_NFTradeNote == null ) {
            toBR_NFTradeNote = Lists.newArrayList();
        }
        toBR_NFTradeNote.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFTrailer</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFTrailer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFTrailer</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTrailer> fetchBR_NFTrailer()
    {
        return fetchFieldAsList("to_BR_NFTrailer", BR_NFTrailer.class);
    }

    /**
     * Retrieval of associated <b>BR_NFTrailer</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFTrailer</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTrailer</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFTrailer</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTrailer> getBR_NFTrailerOrFetch()
    {
        if( toBR_NFTrailer == null ) {
            toBR_NFTrailer = fetchBR_NFTrailer();
        }
        return toBR_NFTrailer;
    }

    /**
     * Retrieval of associated <b>BR_NFTrailer</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFTrailer</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFTrailer</b> is already loaded, the result will
     *         contain the <b>BR_NFTrailer</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFTrailer>> getBR_NFTrailerIfPresent()
    {
        return Option.of(toBR_NFTrailer);
    }

    /**
     * Overwrites the list of associated <b>BR_NFTrailer</b> entities for the loaded navigation property
     * <b>to_BR_NFTrailer</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTrailer</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFTrailer</b> entities.
     */
    public void setBR_NFTrailer( @Nonnull final List<BR_NFTrailer> value )
    {
        if( toBR_NFTrailer == null ) {
            toBR_NFTrailer = Lists.newArrayList();
        }
        toBR_NFTrailer.clear();
        toBR_NFTrailer.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFTrailer</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFTrailer</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTrailer</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFTrailer</b> entities.
     */
    public void addBR_NFTrailer( BR_NFTrailer... entity )
    {
        if( toBR_NFTrailer == null ) {
            toBR_NFTrailer = Lists.newArrayList();
        }
        toBR_NFTrailer.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFTransportedVolume</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFTransportedVolume</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFTransportedVolume</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTransportedVolume> fetchBR_NFTransportedVolume()
    {
        return fetchFieldAsList("to_BR_NFTransportedVolume", BR_NFTransportedVolume.class);
    }

    /**
     * Retrieval of associated <b>BR_NFTransportedVolume</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFTransportedVolume</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTransportedVolume</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFTransportedVolume</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTransportedVolume> getBR_NFTransportedVolumeOrFetch()
    {
        if( toBR_NFTransportedVolume == null ) {
            toBR_NFTransportedVolume = fetchBR_NFTransportedVolume();
        }
        return toBR_NFTransportedVolume;
    }

    /**
     * Retrieval of associated <b>BR_NFTransportedVolume</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFTransportedVolume</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFTransportedVolume</b> is already loaded, the result
     *         will contain the <b>BR_NFTransportedVolume</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFTransportedVolume>> getBR_NFTransportedVolumeIfPresent()
    {
        return Option.of(toBR_NFTransportedVolume);
    }

    /**
     * Overwrites the list of associated <b>BR_NFTransportedVolume</b> entities for the loaded navigation property
     * <b>to_BR_NFTransportedVolume</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTransportedVolume</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFTransportedVolume</b> entities.
     */
    public void setBR_NFTransportedVolume( @Nonnull final List<BR_NFTransportedVolume> value )
    {
        if( toBR_NFTransportedVolume == null ) {
            toBR_NFTransportedVolume = Lists.newArrayList();
        }
        toBR_NFTransportedVolume.clear();
        toBR_NFTransportedVolume.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFTransportedVolume</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFTransportedVolume</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTransportedVolume</b> of a queried <b>BR_NFDocument</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFTransportedVolume</b> entities.
     */
    public void addBR_NFTransportedVolume( BR_NFTransportedVolume... entity )
    {
        if( toBR_NFTransportedVolume == null ) {
            toBR_NFTransportedVolume = Lists.newArrayList();
        }
        toBR_NFTransportedVolume.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_OneTimePartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_OneTimePartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_OneTimePartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_OneTimePartner> fetchBR_OneTimePartner()
    {
        return fetchFieldAsList("to_BR_OneTimePartner", BR_OneTimePartner.class);
    }

    /**
     * Retrieval of associated <b>BR_OneTimePartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_OneTimePartner</b>.
     * <p>
     * If the navigation property <b>to_BR_OneTimePartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_OneTimePartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_OneTimePartner> getBR_OneTimePartnerOrFetch()
    {
        if( toBR_OneTimePartner == null ) {
            toBR_OneTimePartner = fetchBR_OneTimePartner();
        }
        return toBR_OneTimePartner;
    }

    /**
     * Retrieval of associated <b>BR_OneTimePartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_OneTimePartner</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_OneTimePartner</b> is already loaded, the result will
     *         contain the <b>BR_OneTimePartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_OneTimePartner>> getBR_OneTimePartnerIfPresent()
    {
        return Option.of(toBR_OneTimePartner);
    }

    /**
     * Overwrites the list of associated <b>BR_OneTimePartner</b> entities for the loaded navigation property
     * <b>to_BR_OneTimePartner</b>.
     * <p>
     * If the navigation property <b>to_BR_OneTimePartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_OneTimePartner</b> entities.
     */
    public void setBR_OneTimePartner( @Nonnull final List<BR_OneTimePartner> value )
    {
        if( toBR_OneTimePartner == null ) {
            toBR_OneTimePartner = Lists.newArrayList();
        }
        toBR_OneTimePartner.clear();
        toBR_OneTimePartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_OneTimePartner</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_OneTimePartner</b>.
     * <p>
     * If the navigation property <b>to_BR_OneTimePartner</b> of a queried <b>BR_NFDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_OneTimePartner</b> entities.
     */
    public void addBR_OneTimePartner( BR_OneTimePartner... entity )
    {
        if( toBR_OneTimePartner == null ) {
            toBR_OneTimePartner = Lists.newArrayList();
        }
        toBR_OneTimePartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_TechnicalResponsible</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_TechnicalResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_TechnicalResponsible</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_TechnicalResponsible fetchBR_TechnicalResponsible()
    {
        return fetchFieldAsSingle("to_BR_TechnicalResponsible", BR_TechnicalResponsible.class);
    }

    /**
     * Retrieval of associated <b>BR_TechnicalResponsible</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BR_TechnicalResponsible</b>.
     * <p>
     * If the navigation property <b>to_BR_TechnicalResponsible</b> of a queried <b>BR_NFDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_TechnicalResponsible</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_TechnicalResponsible getBR_TechnicalResponsibleOrFetch()
    {
        if( toBR_TechnicalResponsible == null ) {
            toBR_TechnicalResponsible = fetchBR_TechnicalResponsible();
        }
        return toBR_TechnicalResponsible;
    }

    /**
     * Retrieval of associated <b>BR_TechnicalResponsible</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BR_TechnicalResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_TechnicalResponsible</b> is already loaded, the
     *         result will contain the <b>BR_TechnicalResponsible</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BR_TechnicalResponsible> getBR_TechnicalResponsibleIfPresent()
    {
        return Option.of(toBR_TechnicalResponsible);
    }

    /**
     * Overwrites the associated <b>BR_TechnicalResponsible</b> entity for the loaded navigation property
     * <b>to_BR_TechnicalResponsible</b>.
     *
     * @param value
     *            New <b>BR_TechnicalResponsible</b> entity.
     */
    public void setBR_TechnicalResponsible( final BR_TechnicalResponsible value )
    {
        toBR_TechnicalResponsible = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFDocument instances.
     *
     */
    public final static class BR_NFDocumentBuilder
    {

        private List<BR_NFAdditionalInformation> toBR_NFAdditionalInformation = Lists.newArrayList();
        private List<BR_NFDocumentReference> toBR_NFDocumentReference = Lists.newArrayList();
        private List<BR_NFePayment> toBR_NFePayment = Lists.newArrayList();
        private BR_NFExportDeclaration toBR_NFExportDeclaration;
        private List<BR_NFHeaderText> toBR_NFHeaderText = Lists.newArrayList();
        private List<BR_NFImportDocument> toBR_NFImportDocument = Lists.newArrayList();
        private List<BR_NFItem> toBR_NFItem = Lists.newArrayList();
        private List<BR_NFPartner> toBR_NFPartner = Lists.newArrayList();
        private String bR_NFPartner = null;
        private List<BR_NFReferencedProcess> toBR_NFReferencedProcess = Lists.newArrayList();
        private List<BR_NFSugarCaneDeductible> toBR_NFSugarCaneDeductible = Lists.newArrayList();
        private List<BR_NFSugarCaneSupply> toBR_NFSugarCaneSupply = Lists.newArrayList();
        private List<BR_NFTradeNote> toBR_NFTradeNote = Lists.newArrayList();
        private List<BR_NFTrailer> toBR_NFTrailer = Lists.newArrayList();
        private List<BR_NFTransportedVolume> toBR_NFTransportedVolume = Lists.newArrayList();
        private List<BR_OneTimePartner> toBR_OneTimePartner = Lists.newArrayList();
        private BR_TechnicalResponsible toBR_TechnicalResponsible;

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFAdditionalInformation(
            final List<BR_NFAdditionalInformation> value )
        {
            toBR_NFAdditionalInformation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFAdditionalInformation</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFAdditionalInformation</b>.
         *
         * @param value
         *            The BR_NFAdditionalInformations to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFAdditionalInformation( BR_NFAdditionalInformation... value )
        {
            return toBR_NFAdditionalInformation(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFDocumentReference( final List<BR_NFDocumentReference> value )
        {
            toBR_NFDocumentReference.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDocumentReference</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFDocumentReference</b>.
         *
         * @param value
         *            The BR_NFDocumentReferences to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFDocumentReference( BR_NFDocumentReference... value )
        {
            return toBR_NFDocumentReference(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFePayment( final List<BR_NFePayment> value )
        {
            toBR_NFePayment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFePayment</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFePayment</b>.
         *
         * @param value
         *            The BR_NFePayments to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFePayment( BR_NFePayment... value )
        {
            return toBR_NFePayment(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFExportDeclaration( final BR_NFExportDeclaration value )
        {
            toBR_NFExportDeclaration = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFExportDeclaration</b> for <b>BR_NFDocument</b> to single
         * <b>BR_NFExportDeclaration</b>.
         *
         * @param value
         *            The BR_NFExportDeclaration to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFExportDeclaration( final BR_NFExportDeclaration value )
        {
            return toBR_NFExportDeclaration(value);
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFHeaderText( final List<BR_NFHeaderText> value )
        {
            toBR_NFHeaderText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFHeaderText</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFHeaderText</b>.
         *
         * @param value
         *            The BR_NFHeaderTexts to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFHeaderText( BR_NFHeaderText... value )
        {
            return toBR_NFHeaderText(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFImportDocument( final List<BR_NFImportDocument> value )
        {
            toBR_NFImportDocument.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFImportDocument</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFImportDocument</b>.
         *
         * @param value
         *            The BR_NFImportDocuments to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFImportDocument( BR_NFImportDocument... value )
        {
            return toBR_NFImportDocument(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFItem( final List<BR_NFItem> value )
        {
            toBR_NFItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItems to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFItem( BR_NFItem... value )
        {
            return toBR_NFItem(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFPartner( final List<BR_NFPartner> value )
        {
            toBR_NFPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFPartner</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFPartner</b>.
         *
         * @param value
         *            The BR_NFPartners to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFPartner( BR_NFPartner... value )
        {
            return toBR_NFPartner(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BR_NFPartner</b>
         * </p>
         *
         * @param value
         *            The bR_NFPartner to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFPartner( final String value )
        {
            bR_NFPartner = value;
            return this;
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFReferencedProcess( final List<BR_NFReferencedProcess> value )
        {
            toBR_NFReferencedProcess.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFReferencedProcess</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFReferencedProcess</b>.
         *
         * @param value
         *            The BR_NFReferencedProcesss to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFReferencedProcess( BR_NFReferencedProcess... value )
        {
            return toBR_NFReferencedProcess(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFSugarCaneDeductible(
            final List<BR_NFSugarCaneDeductible> value )
        {
            toBR_NFSugarCaneDeductible.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFSugarCaneDeductible</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFSugarCaneDeductible</b>.
         *
         * @param value
         *            The BR_NFSugarCaneDeductibles to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFSugarCaneDeductible( BR_NFSugarCaneDeductible... value )
        {
            return toBR_NFSugarCaneDeductible(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFSugarCaneSupply( final List<BR_NFSugarCaneSupply> value )
        {
            toBR_NFSugarCaneSupply.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFSugarCaneSupply</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFSugarCaneSupply</b>.
         *
         * @param value
         *            The BR_NFSugarCaneSupplys to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFSugarCaneSupply( BR_NFSugarCaneSupply... value )
        {
            return toBR_NFSugarCaneSupply(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFTradeNote( final List<BR_NFTradeNote> value )
        {
            toBR_NFTradeNote.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFTradeNote</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFTradeNote</b>.
         *
         * @param value
         *            The BR_NFTradeNotes to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFTradeNote( BR_NFTradeNote... value )
        {
            return toBR_NFTradeNote(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFTrailer( final List<BR_NFTrailer> value )
        {
            toBR_NFTrailer.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFTrailer</b> for <b>BR_NFDocument</b> to multiple <b>BR_NFTrailer</b>.
         *
         * @param value
         *            The BR_NFTrailers to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFTrailer( BR_NFTrailer... value )
        {
            return toBR_NFTrailer(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_NFTransportedVolume( final List<BR_NFTransportedVolume> value )
        {
            toBR_NFTransportedVolume.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFTransportedVolume</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_NFTransportedVolume</b>.
         *
         * @param value
         *            The BR_NFTransportedVolumes to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_NFTransportedVolume( BR_NFTransportedVolume... value )
        {
            return toBR_NFTransportedVolume(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_OneTimePartner( final List<BR_OneTimePartner> value )
        {
            toBR_OneTimePartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_OneTimePartner</b> for <b>BR_NFDocument</b> to multiple
         * <b>BR_OneTimePartner</b>.
         *
         * @param value
         *            The BR_OneTimePartners to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_OneTimePartner( BR_OneTimePartner... value )
        {
            return toBR_OneTimePartner(Lists.newArrayList(value));
        }

        private BR_NFDocument.BR_NFDocumentBuilder toBR_TechnicalResponsible( final BR_TechnicalResponsible value )
        {
            toBR_TechnicalResponsible = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_TechnicalResponsible</b> for <b>BR_NFDocument</b> to single
         * <b>BR_TechnicalResponsible</b>.
         *
         * @param value
         *            The BR_TechnicalResponsible to build this BR_NFDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocument.BR_NFDocumentBuilder bR_TechnicalResponsible( final BR_TechnicalResponsible value )
        {
            return toBR_TechnicalResponsible(value);
        }

    }

}
