/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFDocumentReferenceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFDocumentReferenceOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFDocumentReferenceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Document Reference
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFDocumentReferenceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFDocumentReference extends VdmEntity<BR_NFDocumentReference>
{

    /**
     * Selector for all available fields of BR_NFDocumentReference.
     *
     */
    public final static BR_NFDocumentReferenceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFDocumentReferenceField<String> BR_NOTA_FISCAL =
        new BR_NFDocumentReferenceField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocRefSequenceNumber</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "BR_NFDocRefSequenceNumber" )
    @JsonProperty( "BR_NFDocRefSequenceNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFDocRefSequenceNumber" )
    private String bR_NFDocRefSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDocRefSequenceNumber</b> field to query operations.
     *
     */
    public final static BR_NFDocumentReferenceField<String> BRNF_DOC_REF_SEQUENCE_NUMBER =
        new BR_NFDocumentReferenceField<String>("BR_NFDocRefSequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentReferenceType</b>
     * </p>
     *
     * @return Document Reference Type
     */
    @SerializedName( "BR_NFDocumentReferenceType" )
    @JsonProperty( "BR_NFDocumentReferenceType" )
    @Nullable
    @ODataField( odataName = "BR_NFDocumentReferenceType" )
    private String bR_NFDocumentReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDocumentReferenceType</b> field to query operations.
     *
     */
    public final static BR_NFDocumentReferenceField<String> BRNF_DOCUMENT_REFERENCE_TYPE =
        new BR_NFDocumentReferenceField<String>("BR_NFDocumentReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocReferenceAccessKey</b>
     * </p>
     *
     * @return 44-Digit Access Key
     */
    @SerializedName( "BR_NFDocReferenceAccessKey" )
    @JsonProperty( "BR_NFDocReferenceAccessKey" )
    @Nullable
    @ODataField( odataName = "BR_NFDocReferenceAccessKey" )
    private String bR_NFDocReferenceAccessKey;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDocReferenceAccessKey</b> field to query operations.
     *
     */
    public final static BR_NFDocumentReferenceField<String> BRNF_DOC_REFERENCE_ACCESS_KEY =
        new BR_NFDocumentReferenceField<String>("BR_NFDocReferenceAccessKey");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFDocumentReference</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFDocumentReferenceOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFDocumentReferenceOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFDocumentReference> getType()
    {
        return BR_NFDocumentReference.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocRefSequenceNumber</b>
     * </p>
     *
     * @param bR_NFDocRefSequenceNumber
     *            Counter
     */
    public void setBR_NFDocRefSequenceNumber( @Nullable final String bR_NFDocRefSequenceNumber )
    {
        rememberChangedField("BR_NFDocRefSequenceNumber", this.bR_NFDocRefSequenceNumber);
        this.bR_NFDocRefSequenceNumber = bR_NFDocRefSequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentReferenceType</b>
     * </p>
     *
     * @param bR_NFDocumentReferenceType
     *            Document Reference Type
     */
    public void setBR_NFDocumentReferenceType( @Nullable final String bR_NFDocumentReferenceType )
    {
        rememberChangedField("BR_NFDocumentReferenceType", this.bR_NFDocumentReferenceType);
        this.bR_NFDocumentReferenceType = bR_NFDocumentReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocReferenceAccessKey</b>
     * </p>
     *
     * @param bR_NFDocReferenceAccessKey
     *            44-Digit Access Key
     */
    public void setBR_NFDocReferenceAccessKey( @Nullable final String bR_NFDocReferenceAccessKey )
    {
        rememberChangedField("BR_NFDocReferenceAccessKey", this.bR_NFDocReferenceAccessKey);
        this.bR_NFDocReferenceAccessKey = bR_NFDocReferenceAccessKey;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFDocumentReference";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFDocRefSequenceNumber", getBR_NFDocRefSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFDocRefSequenceNumber", getBR_NFDocRefSequenceNumber());
        values.put("BR_NFDocumentReferenceType", getBR_NFDocumentReferenceType());
        values.put("BR_NFDocReferenceAccessKey", getBR_NFDocReferenceAccessKey());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFDocRefSequenceNumber") ) {
                final Object value = values.remove("BR_NFDocRefSequenceNumber");
                if( (value == null) || (!value.equals(getBR_NFDocRefSequenceNumber())) ) {
                    setBR_NFDocRefSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFDocumentReferenceType") ) {
                final Object value = values.remove("BR_NFDocumentReferenceType");
                if( (value == null) || (!value.equals(getBR_NFDocumentReferenceType())) ) {
                    setBR_NFDocumentReferenceType(((String) value));
                }
            }
            if( values.containsKey("BR_NFDocReferenceAccessKey") ) {
                final Object value = values.remove("BR_NFDocReferenceAccessKey");
                if( (value == null) || (!value.equals(getBR_NFDocReferenceAccessKey())) ) {
                    setBR_NFDocReferenceAccessKey(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFDocumentReferenceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFDocumentReferenceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFDocumentReferenceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFDocumentReferenceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFDocumentReference</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFDocumentReference</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFDocumentReference instances.
     *
     */
    public final static class BR_NFDocumentReferenceBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFDocumentReference.BR_NFDocumentReferenceBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFDocumentReference</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFDocumentReference with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFDocumentReference.BR_NFDocumentReferenceBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
