/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFExportDeclarationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFExportDeclarationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFExportDeclarationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * BR Export Declaration Data for NF
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFExportDeclarationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFExportDeclaration extends VdmEntity<BR_NFExportDeclaration>
{

    /**
     * Selector for all available fields of BR_NFExportDeclaration.
     *
     */
    public final static BR_NFExportDeclarationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<String> BR_NOTA_FISCAL =
        new BR_NFExportDeclarationField<String>("BR_NotaFiscal");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUE</b>
     * </p>
     *
     * @return Export Declaration Number
     */
    @SerializedName( "BR_DUE" )
    @JsonProperty( "BR_DUE" )
    @Nullable
    @ODataField( odataName = "BR_DUE" )
    private String bR_DUE;
    /**
     * Use with available fluent helpers to apply the <b>BR_DUE</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<String> BRDUE = new BR_NFExportDeclarationField<String>("BR_DUE");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEIssuedDate</b>
     * </p>
     *
     * @return Export Declaration Issued Date
     */
    @SerializedName( "BR_DUEIssuedDate" )
    @JsonProperty( "BR_DUEIssuedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_DUEIssuedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_DUEIssuedDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_DUEIssuedDate</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<LocalDateTime> BRDUE_ISSUED_DATE =
        new BR_NFExportDeclarationField<LocalDateTime>("BR_DUEIssuedDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEType</b>
     * </p>
     *
     * @return Export Declaration Type
     */
    @SerializedName( "BR_DUEType" )
    @JsonProperty( "BR_DUEType" )
    @Nullable
    @ODataField( odataName = "BR_DUEType" )
    private String bR_DUEType;
    /**
     * Use with available fluent helpers to apply the <b>BR_DUEType</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<String> BRDUE_TYPE =
        new BR_NFExportDeclarationField<String>("BR_DUEType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLading</b>
     * </p>
     *
     * @return Bill of Lading Number
     */
    @SerializedName( "BR_BillOfLading" )
    @JsonProperty( "BR_BillOfLading" )
    @Nullable
    @ODataField( odataName = "BR_BillOfLading" )
    private String bR_BillOfLading;
    /**
     * Use with available fluent helpers to apply the <b>BR_BillOfLading</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<String> BR_BILL_OF_LADING =
        new BR_NFExportDeclarationField<String>("BR_BillOfLading");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLadingDate</b>
     * </p>
     *
     * @return Bill of Lading Date
     */
    @SerializedName( "BR_BillOfLadingDate" )
    @JsonProperty( "BR_BillOfLadingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_BillOfLadingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_BillOfLadingDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_BillOfLadingDate</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<LocalDateTime> BR_BILL_OF_LADING_DATE =
        new BR_NFExportDeclarationField<LocalDateTime>("BR_BillOfLadingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLadingType</b>
     * </p>
     *
     * @return Bill of Lading Type
     */
    @SerializedName( "BR_BillOfLadingType" )
    @JsonProperty( "BR_BillOfLadingType" )
    @Nullable
    @ODataField( odataName = "BR_BillOfLadingType" )
    private String bR_BillOfLadingType;
    /**
     * Use with available fluent helpers to apply the <b>BR_BillOfLadingType</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<String> BR_BILL_OF_LADING_TYPE =
        new BR_NFExportDeclarationField<String>("BR_BillOfLadingType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEExportConfirmationDate</b>
     * </p>
     *
     * @return Export Confirmation Date
     */
    @SerializedName( "BR_DUEExportConfirmationDate" )
    @JsonProperty( "BR_DUEExportConfirmationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_DUEExportConfirmationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_DUEExportConfirmationDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_DUEExportConfirmationDate</b> field to query operations.
     *
     */
    public final static BR_NFExportDeclarationField<LocalDateTime> BRDUE_EXPORT_CONFIRMATION_DATE =
        new BR_NFExportDeclarationField<LocalDateTime>("BR_DUEExportConfirmationDate");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFExportDeclaration</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFExportDeclarationOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFExportDeclarationOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFExportDeclaration> getType()
    {
        return BR_NFExportDeclaration.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUE</b>
     * </p>
     *
     * @param bR_DUE
     *            Export Declaration Number
     */
    public void setBR_DUE( @Nullable final String bR_DUE )
    {
        rememberChangedField("BR_DUE", this.bR_DUE);
        this.bR_DUE = bR_DUE;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEIssuedDate</b>
     * </p>
     *
     * @param bR_DUEIssuedDate
     *            Export Declaration Issued Date
     */
    public void setBR_DUEIssuedDate( @Nullable final LocalDateTime bR_DUEIssuedDate )
    {
        rememberChangedField("BR_DUEIssuedDate", this.bR_DUEIssuedDate);
        this.bR_DUEIssuedDate = bR_DUEIssuedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEType</b>
     * </p>
     *
     * @param bR_DUEType
     *            Export Declaration Type
     */
    public void setBR_DUEType( @Nullable final String bR_DUEType )
    {
        rememberChangedField("BR_DUEType", this.bR_DUEType);
        this.bR_DUEType = bR_DUEType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLading</b>
     * </p>
     *
     * @param bR_BillOfLading
     *            Bill of Lading Number
     */
    public void setBR_BillOfLading( @Nullable final String bR_BillOfLading )
    {
        rememberChangedField("BR_BillOfLading", this.bR_BillOfLading);
        this.bR_BillOfLading = bR_BillOfLading;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLadingDate</b>
     * </p>
     *
     * @param bR_BillOfLadingDate
     *            Bill of Lading Date
     */
    public void setBR_BillOfLadingDate( @Nullable final LocalDateTime bR_BillOfLadingDate )
    {
        rememberChangedField("BR_BillOfLadingDate", this.bR_BillOfLadingDate);
        this.bR_BillOfLadingDate = bR_BillOfLadingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_BillOfLadingType</b>
     * </p>
     *
     * @param bR_BillOfLadingType
     *            Bill of Lading Type
     */
    public void setBR_BillOfLadingType( @Nullable final String bR_BillOfLadingType )
    {
        rememberChangedField("BR_BillOfLadingType", this.bR_BillOfLadingType);
        this.bR_BillOfLadingType = bR_BillOfLadingType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_DUEExportConfirmationDate</b>
     * </p>
     *
     * @param bR_DUEExportConfirmationDate
     *            Export Confirmation Date
     */
    public void setBR_DUEExportConfirmationDate( @Nullable final LocalDateTime bR_DUEExportConfirmationDate )
    {
        rememberChangedField("BR_DUEExportConfirmationDate", this.bR_DUEExportConfirmationDate);
        this.bR_DUEExportConfirmationDate = bR_DUEExportConfirmationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFExportDeclaration";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_DUE", getBR_DUE());
        values.put("BR_DUEIssuedDate", getBR_DUEIssuedDate());
        values.put("BR_DUEType", getBR_DUEType());
        values.put("BR_BillOfLading", getBR_BillOfLading());
        values.put("BR_BillOfLadingDate", getBR_BillOfLadingDate());
        values.put("BR_BillOfLadingType", getBR_BillOfLadingType());
        values.put("BR_DUEExportConfirmationDate", getBR_DUEExportConfirmationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_DUE") ) {
                final Object value = values.remove("BR_DUE");
                if( (value == null) || (!value.equals(getBR_DUE())) ) {
                    setBR_DUE(((String) value));
                }
            }
            if( values.containsKey("BR_DUEIssuedDate") ) {
                final Object value = values.remove("BR_DUEIssuedDate");
                if( (value == null) || (!value.equals(getBR_DUEIssuedDate())) ) {
                    setBR_DUEIssuedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_DUEType") ) {
                final Object value = values.remove("BR_DUEType");
                if( (value == null) || (!value.equals(getBR_DUEType())) ) {
                    setBR_DUEType(((String) value));
                }
            }
            if( values.containsKey("BR_BillOfLading") ) {
                final Object value = values.remove("BR_BillOfLading");
                if( (value == null) || (!value.equals(getBR_BillOfLading())) ) {
                    setBR_BillOfLading(((String) value));
                }
            }
            if( values.containsKey("BR_BillOfLadingDate") ) {
                final Object value = values.remove("BR_BillOfLadingDate");
                if( (value == null) || (!value.equals(getBR_BillOfLadingDate())) ) {
                    setBR_BillOfLadingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_BillOfLadingType") ) {
                final Object value = values.remove("BR_BillOfLadingType");
                if( (value == null) || (!value.equals(getBR_BillOfLadingType())) ) {
                    setBR_BillOfLadingType(((String) value));
                }
            }
            if( values.containsKey("BR_DUEExportConfirmationDate") ) {
                final Object value = values.remove("BR_DUEExportConfirmationDate");
                if( (value == null) || (!value.equals(getBR_DUEExportConfirmationDate())) ) {
                    setBR_DUEExportConfirmationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFExportDeclarationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFExportDeclarationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFExportDeclarationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFExportDeclarationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFExportDeclaration</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFExportDeclaration</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFExportDeclaration instances.
     *
     */
    public final static class BR_NFExportDeclarationBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFExportDeclaration.BR_NFExportDeclarationBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFExportDeclaration</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFExportDeclaration with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFExportDeclaration.BR_NFExportDeclarationBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
