/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFExportDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFExportDocumentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFExportDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Export Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFExportDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFExportDocument extends VdmEntity<BR_NFExportDocument>
{

    /**
     * Selector for all available fields of BR_NFExportDocument.
     *
     */
    public final static BR_NFExportDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BR_NOTA_FISCAL =
        new BR_NFExportDocumentField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BR_NOTA_FISCAL_ITEM =
        new BR_NFExportDocumentField<String>("BR_NotaFiscalItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtSqncNumber</b>
     * </p>
     *
     * @return Export Sequence Nmbr
     */
    @Key
    @SerializedName( "BR_NFItemExprtSqncNumber" )
    @JsonProperty( "BR_NFItemExprtSqncNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFItemExprtSqncNumber" )
    private String bR_NFItemExprtSqncNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemExprtSqncNumber</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BRNF_ITEM_EXPRT_SQNC_NUMBER =
        new BR_NFExportDocumentField<String>("BR_NFItemExprtSqncNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BASE_UNIT = new BR_NFExportDocumentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtRegNumber</b>
     * </p>
     *
     * @return Export Register Number
     */
    @SerializedName( "BR_NFItemExprtRegNumber" )
    @JsonProperty( "BR_NFItemExprtRegNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFItemExprtRegNumber" )
    private String bR_NFItemExprtRegNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemExprtRegNumber</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BRNF_ITEM_EXPRT_REG_NUMBER =
        new BR_NFExportDocumentField<String>("BR_NFItemExprtRegNumber");
    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtNFeAccessKey</b>
     * </p>
     *
     * @return Export NF-e Key
     */
    @SerializedName( "BR_NFItemExprtNFeAccessKey" )
    @JsonProperty( "BR_NFItemExprtNFeAccessKey" )
    @Nullable
    @ODataField( odataName = "BR_NFItemExprtNFeAccessKey" )
    private String bR_NFItemExprtNFeAccessKey;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemExprtNFeAccessKey</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BRNF_ITEM_EXPRT_N_FE_ACCESS_KEY =
        new BR_NFExportDocumentField<String>("BR_NFItemExprtNFeAccessKey");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExportRealQty</b>
     * </p>
     *
     * @return Quantity of Export Item
     */
    @SerializedName( "BR_NFItemExportRealQty" )
    @JsonProperty( "BR_NFItemExportRealQty" )
    @Nullable
    @ODataField( odataName = "BR_NFItemExportRealQty" )
    private BigDecimal bR_NFItemExportRealQty;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemExportRealQty</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<BigDecimal> BRNF_ITEM_EXPORT_REAL_QTY =
        new BR_NFExportDocumentField<BigDecimal>("BR_NFItemExportRealQty");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItmExprtDrwbkConcession</b>
     * </p>
     *
     * @return OBSOLETE: Number of drawback concession
     */
    @SerializedName( "BR_NFItmExprtDrwbkConcession" )
    @JsonProperty( "BR_NFItmExprtDrwbkConcession" )
    @Nullable
    @ODataField( odataName = "BR_NFItmExprtDrwbkConcession" )
    private String bR_NFItmExprtDrwbkConcession;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItmExprtDrwbkConcession</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BRNF_ITM_EXPRT_DRWBK_CONCESSION =
        new BR_NFExportDocumentField<String>("BR_NFItmExprtDrwbkConcession");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportDrawbackConcession</b>
     * </p>
     *
     * @return Drawback Concession
     */
    @SerializedName( "BR_NFExportDrawbackConcession" )
    @JsonProperty( "BR_NFExportDrawbackConcession" )
    @Nullable
    @ODataField( odataName = "BR_NFExportDrawbackConcession" )
    private String bR_NFExportDrawbackConcession;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExportDrawbackConcession</b> field to query operations.
     *
     */
    public final static BR_NFExportDocumentField<String> BRNF_EXPORT_DRAWBACK_CONCESSION =
        new BR_NFExportDocumentField<String>("BR_NFExportDrawbackConcession");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFExportDocument</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFExportDocument</b> to single <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFItem toBR_NFItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFExportDocumentOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFExportDocumentOneToOneLink<BR_NFDocument>("to_BR_NFDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFExportDocumentOneToOneLink<BR_NFItem> TO_BRNF_ITEM =
        new BR_NFExportDocumentOneToOneLink<BR_NFItem>("to_BR_NFItem");

    @Nonnull
    @Override
    public Class<BR_NFExportDocument> getType()
    {
        return BR_NFExportDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtSqncNumber</b>
     * </p>
     *
     * @param bR_NFItemExprtSqncNumber
     *            Export Sequence Nmbr
     */
    public void setBR_NFItemExprtSqncNumber( @Nullable final String bR_NFItemExprtSqncNumber )
    {
        rememberChangedField("BR_NFItemExprtSqncNumber", this.bR_NFItemExprtSqncNumber);
        this.bR_NFItemExprtSqncNumber = bR_NFItemExprtSqncNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtRegNumber</b>
     * </p>
     *
     * @param bR_NFItemExprtRegNumber
     *            Export Register Number
     */
    public void setBR_NFItemExprtRegNumber( @Nullable final String bR_NFItemExprtRegNumber )
    {
        rememberChangedField("BR_NFItemExprtRegNumber", this.bR_NFItemExprtRegNumber);
        this.bR_NFItemExprtRegNumber = bR_NFItemExprtRegNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExprtNFeAccessKey</b>
     * </p>
     *
     * @param bR_NFItemExprtNFeAccessKey
     *            Export NF-e Key
     */
    public void setBR_NFItemExprtNFeAccessKey( @Nullable final String bR_NFItemExprtNFeAccessKey )
    {
        rememberChangedField("BR_NFItemExprtNFeAccessKey", this.bR_NFItemExprtNFeAccessKey);
        this.bR_NFItemExprtNFeAccessKey = bR_NFItemExprtNFeAccessKey;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExportRealQty</b>
     * </p>
     *
     * @param bR_NFItemExportRealQty
     *            Quantity of Export Item
     */
    public void setBR_NFItemExportRealQty( @Nullable final BigDecimal bR_NFItemExportRealQty )
    {
        rememberChangedField("BR_NFItemExportRealQty", this.bR_NFItemExportRealQty);
        this.bR_NFItemExportRealQty = bR_NFItemExportRealQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItmExprtDrwbkConcession</b>
     * </p>
     *
     * @param bR_NFItmExprtDrwbkConcession
     *            OBSOLETE: Number of drawback concession
     */
    public void setBR_NFItmExprtDrwbkConcession( @Nullable final String bR_NFItmExprtDrwbkConcession )
    {
        rememberChangedField("BR_NFItmExprtDrwbkConcession", this.bR_NFItmExprtDrwbkConcession);
        this.bR_NFItmExprtDrwbkConcession = bR_NFItmExprtDrwbkConcession;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExportDrawbackConcession</b>
     * </p>
     *
     * @param bR_NFExportDrawbackConcession
     *            Drawback Concession
     */
    public void setBR_NFExportDrawbackConcession( @Nullable final String bR_NFExportDrawbackConcession )
    {
        rememberChangedField("BR_NFExportDrawbackConcession", this.bR_NFExportDrawbackConcession);
        this.bR_NFExportDrawbackConcession = bR_NFExportDrawbackConcession;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFExportDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        result.put("BR_NFItemExprtSqncNumber", getBR_NFItemExprtSqncNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("BR_NFItemExprtSqncNumber", getBR_NFItemExprtSqncNumber());
        values.put("BaseUnit", getBaseUnit());
        values.put("BR_NFItemExprtRegNumber", getBR_NFItemExprtRegNumber());
        values.put("BR_NFItemExprtNFeAccessKey", getBR_NFItemExprtNFeAccessKey());
        values.put("BR_NFItemExportRealQty", getBR_NFItemExportRealQty());
        values.put("BR_NFItmExprtDrwbkConcession", getBR_NFItmExprtDrwbkConcession());
        values.put("BR_NFExportDrawbackConcession", getBR_NFExportDrawbackConcession());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemExprtSqncNumber") ) {
                final Object value = values.remove("BR_NFItemExprtSqncNumber");
                if( (value == null) || (!value.equals(getBR_NFItemExprtSqncNumber())) ) {
                    setBR_NFItemExprtSqncNumber(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemExprtRegNumber") ) {
                final Object value = values.remove("BR_NFItemExprtRegNumber");
                if( (value == null) || (!value.equals(getBR_NFItemExprtRegNumber())) ) {
                    setBR_NFItemExprtRegNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemExprtNFeAccessKey") ) {
                final Object value = values.remove("BR_NFItemExprtNFeAccessKey");
                if( (value == null) || (!value.equals(getBR_NFItemExprtNFeAccessKey())) ) {
                    setBR_NFItemExprtNFeAccessKey(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemExportRealQty") ) {
                final Object value = values.remove("BR_NFItemExportRealQty");
                if( (value == null) || (!value.equals(getBR_NFItemExportRealQty())) ) {
                    setBR_NFItemExportRealQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItmExprtDrwbkConcession") ) {
                final Object value = values.remove("BR_NFItmExprtDrwbkConcession");
                if( (value == null) || (!value.equals(getBR_NFItmExprtDrwbkConcession())) ) {
                    setBR_NFItmExprtDrwbkConcession(((String) value));
                }
            }
            if( values.containsKey("BR_NFExportDrawbackConcession") ) {
                final Object value = values.remove("BR_NFExportDrawbackConcession");
                if( (value == null) || (!value.equals(getBR_NFExportDrawbackConcession())) ) {
                    setBR_NFExportDrawbackConcession(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Map ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = new BR_NFItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFExportDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFExportDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFExportDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFExportDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFExportDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFExportDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Fetches the <b>BR_NFItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem fetchBR_NFItem()
    {
        return fetchFieldAsSingle("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFExportDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFExportDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFItem> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the associated <b>BR_NFItem</b> entity for the loaded navigation property <b>to_BR_NFItem</b>.
     *
     * @param value
     *            New <b>BR_NFItem</b> entity.
     */
    public void setBR_NFItem( final BR_NFItem value )
    {
        toBR_NFItem = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFExportDocument instances.
     *
     */
    public final static class BR_NFExportDocumentBuilder
    {

        private BR_NFDocument toBR_NFDoc;
        private BR_NFItem toBR_NFItem;

        private BR_NFExportDocument.BR_NFExportDocumentBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFExportDocument</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFExportDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFExportDocument.BR_NFExportDocumentBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

        private BR_NFExportDocument.BR_NFExportDocumentBuilder toBR_NFItem( final BR_NFItem value )
        {
            toBR_NFItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFExportDocument</b> to single <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItem to build this BR_NFExportDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFExportDocument.BR_NFExportDocumentBuilder bR_NFItem( final BR_NFItem value )
        {
            return toBR_NFItem(value);
        }

    }

}
