/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFExportDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument BR_NFExportDocument}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BR_NFExportDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFExportDocumentByKeyFluentHelper, BR_NFExportDocument, BR_NFExportDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     * BR_NFExportDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFExportDocument}
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFExportDocument}
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFItemExprtSqncNumber
     *            Export Sequence Nmbr
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public BR_NFExportDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFItemExprtSqncNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NotaFiscalItem", bR_NotaFiscalItem);
        this.key.put("BR_NFItemExprtSqncNumber", bR_NFItemExprtSqncNumber);
    }

    @Override
    @Nonnull
    protected Class<BR_NFExportDocument> getEntityClass()
    {
        return BR_NFExportDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
