/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFFuelField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFFuelOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFFuelSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Fuel Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFFuelType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFFuel extends VdmEntity<BR_NFFuel>
{

    /**
     * Selector for all available fields of BR_NFFuel.
     *
     */
    public final static BR_NFFuelSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BR_NOTA_FISCAL = new BR_NFFuelField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BR_NOTA_FISCAL_ITEM = new BR_NFFuelField<String>("BR_NotaFiscalItem");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_ANPCode</b>
     * </p>
     *
     * @return ANP Product Code
     */
    @SerializedName( "BR_ANPCode" )
    @JsonProperty( "BR_ANPCode" )
    @Nullable
    @ODataField( odataName = "BR_ANPCode" )
    private String bR_ANPCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_ANPCode</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRANP_CODE = new BR_NFFuelField<String>("BR_ANPCode");
    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFRegisterCODIF</b>
     * </p>
     *
     * @return CODIF Code
     */
    @SerializedName( "BR_NFRegisterCODIF" )
    @JsonProperty( "BR_NFRegisterCODIF" )
    @Nullable
    @ODataField( odataName = "BR_NFRegisterCODIF" )
    private String bR_NFRegisterCODIF;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFRegisterCODIF</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRNF_REGISTER_CODIF = new BR_NFFuelField<String>("BR_NFRegisterCODIF");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeEnvrmtTemperatureFuelQty</b>
     * </p>
     *
     * @return Fuel Quantity at Room Temperature
     */
    @SerializedName( "BR_NFeEnvrmtTemperatureFuelQty" )
    @JsonProperty( "BR_NFeEnvrmtTemperatureFuelQty" )
    @Nullable
    @ODataField( odataName = "BR_NFeEnvrmtTemperatureFuelQty" )
    private BigDecimal bR_NFeEnvrmtTemperatureFuelQty;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeEnvrmtTemperatureFuelQty</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRN_FE_ENVRMT_TEMPERATURE_FUEL_QTY =
        new BR_NFFuelField<BigDecimal>("BR_NFeEnvrmtTemperatureFuelQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelConsumerRegion</b>
     * </p>
     *
     * @return Region of Fuel Consumption
     */
    @SerializedName( "BR_NFeFuelConsumerRegion" )
    @JsonProperty( "BR_NFeFuelConsumerRegion" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelConsumerRegion" )
    private String bR_NFeFuelConsumerRegion;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelConsumerRegion</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRN_FE_FUEL_CONSUMER_REGION =
        new BR_NFFuelField<String>("BR_NFeFuelConsumerRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPercentageNaturalGasUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_NFPercentageNaturalGasUnit" )
    @JsonProperty( "BR_NFPercentageNaturalGasUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFPercentageNaturalGasUnit" )
    private String bR_NFPercentageNaturalGasUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPercentageNaturalGasUnit</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRNF_PERCENTAGE_NATURAL_GAS_UNIT =
        new BR_NFFuelField<String>("BR_NFPercentageNaturalGasUnit");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNaturalGasPercent</b>
     * </p>
     *
     * @return Natural Gas
     */
    @SerializedName( "BR_NFNaturalGasPercent" )
    @JsonProperty( "BR_NFNaturalGasPercent" )
    @Nullable
    @ODataField( odataName = "BR_NFNaturalGasPercent" )
    private BigDecimal bR_NFNaturalGasPercent;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNaturalGasPercent</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRNF_NATURAL_GAS_PERCENT =
        new BR_NFFuelField<BigDecimal>("BR_NFNaturalGasPercent");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxBaseQuantity</b>
     * </p>
     *
     * @return Tax Base Quantity
     */
    @SerializedName( "BR_NFFuelCIDETaxBaseQuantity" )
    @JsonProperty( "BR_NFFuelCIDETaxBaseQuantity" )
    @Nullable
    @ODataField( odataName = "BR_NFFuelCIDETaxBaseQuantity" )
    private BigDecimal bR_NFFuelCIDETaxBaseQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFuelCIDETaxBaseQuantity</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRNF_FUEL_CIDE_TAX_BASE_QUANTITY =
        new BR_NFFuelField<BigDecimal>("BR_NFFuelCIDETaxBaseQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxRate</b>
     * </p>
     *
     * @return CIDE Tax Rate (value)
     */
    @SerializedName( "BR_NFFuelCIDETaxRate" )
    @JsonProperty( "BR_NFFuelCIDETaxRate" )
    @Nullable
    @ODataField( odataName = "BR_NFFuelCIDETaxRate" )
    private BigDecimal bR_NFFuelCIDETaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFuelCIDETaxRate</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRNF_FUEL_CIDE_TAX_RATE =
        new BR_NFFuelField<BigDecimal>("BR_NFFuelCIDETaxRate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxAmount</b>
     * </p>
     *
     * @return CIDE Amount
     */
    @SerializedName( "BR_NFFuelCIDETaxAmount" )
    @JsonProperty( "BR_NFFuelCIDETaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFFuelCIDETaxAmount" )
    private BigDecimal bR_NFFuelCIDETaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFuelCIDETaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRNF_FUEL_CIDE_TAX_AMOUNT =
        new BR_NFFuelField<BigDecimal>("BR_NFFuelCIDETaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelNozzle</b>
     * </p>
     *
     * @return Nozzle Number
     */
    @SerializedName( "BR_NFeFuelNozzle" )
    @JsonProperty( "BR_NFeFuelNozzle" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelNozzle" )
    private String bR_NFeFuelNozzle;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelNozzle</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRN_FE_FUEL_NOZZLE = new BR_NFFuelField<String>("BR_NFeFuelNozzle");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelPump</b>
     * </p>
     *
     * @return Pump Number
     */
    @SerializedName( "BR_NFeFuelPump" )
    @JsonProperty( "BR_NFeFuelPump" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelPump" )
    private String bR_NFeFuelPump;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelPump</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRN_FE_FUEL_PUMP = new BR_NFFuelField<String>("BR_NFeFuelPump");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelTank</b>
     * </p>
     *
     * @return Tank Number
     */
    @SerializedName( "BR_NFeFuelTank" )
    @JsonProperty( "BR_NFeFuelTank" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelTank" )
    private String bR_NFeFuelTank;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelTank</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRN_FE_FUEL_TANK = new BR_NFFuelField<String>("BR_NFeFuelTank");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelGaugeStartQuantity</b>
     * </p>
     *
     * @return Start Value of Gauge
     */
    @SerializedName( "BR_NFeFuelGaugeStartQuantity" )
    @JsonProperty( "BR_NFeFuelGaugeStartQuantity" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelGaugeStartQuantity" )
    private BigDecimal bR_NFeFuelGaugeStartQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelGaugeStartQuantity</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRN_FE_FUEL_GAUGE_START_QUANTITY =
        new BR_NFFuelField<BigDecimal>("BR_NFeFuelGaugeStartQuantity");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelGaugeEndQuantity</b>
     * </p>
     *
     * @return End Value of Gauge
     */
    @SerializedName( "BR_NFeFuelGaugeEndQuantity" )
    @JsonProperty( "BR_NFeFuelGaugeEndQuantity" )
    @Nullable
    @ODataField( odataName = "BR_NFeFuelGaugeEndQuantity" )
    private BigDecimal bR_NFeFuelGaugeEndQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeFuelGaugeEndQuantity</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRN_FE_FUEL_GAUGE_END_QUANTITY =
        new BR_NFFuelField<BigDecimal>("BR_NFeFuelGaugeEndQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPRatioUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_GLPRatioUnit" )
    @JsonProperty( "BR_GLPRatioUnit" )
    @Nullable
    @ODataField( odataName = "BR_GLPRatioUnit" )
    private String bR_GLPRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLPRatioUnit</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRGLP_RATIO_UNIT = new BR_NFFuelField<String>("BR_GLPRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPRatio</b>
     * </p>
     *
     * @return Oil Derived from Gas
     */
    @SerializedName( "BR_GLPRatio" )
    @JsonProperty( "BR_GLPRatio" )
    @Nullable
    @ODataField( odataName = "BR_GLPRatio" )
    private BigDecimal bR_GLPRatio;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLPRatio</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRGLP_RATIO = new BR_NFFuelField<BigDecimal>("BR_GLPRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNNRatioUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_GLGNNRatioUnit" )
    @JsonProperty( "BR_GLGNNRatioUnit" )
    @Nullable
    @ODataField( odataName = "BR_GLGNNRatioUnit" )
    private String bR_GLGNNRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLGNNRatioUnit</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRGLGNN_RATIO_UNIT = new BR_NFFuelField<String>("BR_GLGNNRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNNRatio</b>
     * </p>
     *
     * @return National Natural Gas
     */
    @SerializedName( "BR_GLGNNRatio" )
    @JsonProperty( "BR_GLGNNRatio" )
    @Nullable
    @ODataField( odataName = "BR_GLGNNRatio" )
    private BigDecimal bR_GLGNNRatio;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLGNNRatio</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRGLGNN_RATIO = new BR_NFFuelField<BigDecimal>("BR_GLGNNRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNIRatioUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_GLGNIRatioUnit" )
    @JsonProperty( "BR_GLGNIRatioUnit" )
    @Nullable
    @ODataField( odataName = "BR_GLGNIRatioUnit" )
    private String bR_GLGNIRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLGNIRatioUnit</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BRGLGNI_RATIO_UNIT = new BR_NFFuelField<String>("BR_GLGNIRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNIRatio</b>
     * </p>
     *
     * @return Imported Natural Gas
     */
    @SerializedName( "BR_GLGNIRatio" )
    @JsonProperty( "BR_GLGNIRatio" )
    @Nullable
    @ODataField( odataName = "BR_GLGNIRatio" )
    private BigDecimal bR_GLGNIRatio;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLGNIRatio</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRGLGNI_RATIO = new BR_NFFuelField<BigDecimal>("BR_GLGNIRatio");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPNetValueAmount</b>
     * </p>
     *
     * @return Fuel Net Amount
     */
    @SerializedName( "BR_GLPNetValueAmount" )
    @JsonProperty( "BR_GLPNetValueAmount" )
    @Nullable
    @ODataField( odataName = "BR_GLPNetValueAmount" )
    private BigDecimal bR_GLPNetValueAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_GLPNetValueAmount</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRGLP_NET_VALUE_AMOUNT =
        new BR_NFFuelField<BigDecimal>("BR_GLPNetValueAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFBiodieselMixingIndexRate</b>
     * </p>
     *
     * @return Biodiesel Mixing Index in Diesel B
     */
    @SerializedName( "BR_NFBiodieselMixingIndexRate" )
    @JsonProperty( "BR_NFBiodieselMixingIndexRate" )
    @Nullable
    @ODataField( odataName = "BR_NFBiodieselMixingIndexRate" )
    private BigDecimal bR_NFBiodieselMixingIndexRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFBiodieselMixingIndexRate</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<BigDecimal> BRNF_BIODIESEL_MIXING_INDEX_RATE =
        new BR_NFFuelField<BigDecimal>("BR_NFBiodieselMixingIndexRate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFFuelField<String>("SalesDocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static BR_NFFuelField<String> BASE_UNIT = new BR_NFFuelField<String>("BaseUnit");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFFuel</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFFuel</b> to single <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFItem toBR_NFItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFFuelOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFFuelOneToOneLink<BR_NFDocument>("to_BR_NFDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFFuelOneToOneLink<BR_NFItem> TO_BRNF_ITEM =
        new BR_NFFuelOneToOneLink<BR_NFItem>("to_BR_NFItem");

    @Nonnull
    @Override
    public Class<BR_NFFuel> getType()
    {
        return BR_NFFuel.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_ANPCode</b>
     * </p>
     *
     * @param bR_ANPCode
     *            ANP Product Code
     */
    public void setBR_ANPCode( @Nullable final String bR_ANPCode )
    {
        rememberChangedField("BR_ANPCode", this.bR_ANPCode);
        this.bR_ANPCode = bR_ANPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFRegisterCODIF</b>
     * </p>
     *
     * @param bR_NFRegisterCODIF
     *            CODIF Code
     */
    public void setBR_NFRegisterCODIF( @Nullable final String bR_NFRegisterCODIF )
    {
        rememberChangedField("BR_NFRegisterCODIF", this.bR_NFRegisterCODIF);
        this.bR_NFRegisterCODIF = bR_NFRegisterCODIF;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeEnvrmtTemperatureFuelQty</b>
     * </p>
     *
     * @param bR_NFeEnvrmtTemperatureFuelQty
     *            Fuel Quantity at Room Temperature
     */
    public void setBR_NFeEnvrmtTemperatureFuelQty( @Nullable final BigDecimal bR_NFeEnvrmtTemperatureFuelQty )
    {
        rememberChangedField("BR_NFeEnvrmtTemperatureFuelQty", this.bR_NFeEnvrmtTemperatureFuelQty);
        this.bR_NFeEnvrmtTemperatureFuelQty = bR_NFeEnvrmtTemperatureFuelQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelConsumerRegion</b>
     * </p>
     *
     * @param bR_NFeFuelConsumerRegion
     *            Region of Fuel Consumption
     */
    public void setBR_NFeFuelConsumerRegion( @Nullable final String bR_NFeFuelConsumerRegion )
    {
        rememberChangedField("BR_NFeFuelConsumerRegion", this.bR_NFeFuelConsumerRegion);
        this.bR_NFeFuelConsumerRegion = bR_NFeFuelConsumerRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPercentageNaturalGasUnit</b>
     * </p>
     *
     * @param bR_NFPercentageNaturalGasUnit
     *            Unit of Measurement
     */
    public void setBR_NFPercentageNaturalGasUnit( @Nullable final String bR_NFPercentageNaturalGasUnit )
    {
        rememberChangedField("BR_NFPercentageNaturalGasUnit", this.bR_NFPercentageNaturalGasUnit);
        this.bR_NFPercentageNaturalGasUnit = bR_NFPercentageNaturalGasUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNaturalGasPercent</b>
     * </p>
     *
     * @param bR_NFNaturalGasPercent
     *            Natural Gas
     */
    public void setBR_NFNaturalGasPercent( @Nullable final BigDecimal bR_NFNaturalGasPercent )
    {
        rememberChangedField("BR_NFNaturalGasPercent", this.bR_NFNaturalGasPercent);
        this.bR_NFNaturalGasPercent = bR_NFNaturalGasPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxBaseQuantity</b>
     * </p>
     *
     * @param bR_NFFuelCIDETaxBaseQuantity
     *            Tax Base Quantity
     */
    public void setBR_NFFuelCIDETaxBaseQuantity( @Nullable final BigDecimal bR_NFFuelCIDETaxBaseQuantity )
    {
        rememberChangedField("BR_NFFuelCIDETaxBaseQuantity", this.bR_NFFuelCIDETaxBaseQuantity);
        this.bR_NFFuelCIDETaxBaseQuantity = bR_NFFuelCIDETaxBaseQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxRate</b>
     * </p>
     *
     * @param bR_NFFuelCIDETaxRate
     *            CIDE Tax Rate (value)
     */
    public void setBR_NFFuelCIDETaxRate( @Nullable final BigDecimal bR_NFFuelCIDETaxRate )
    {
        rememberChangedField("BR_NFFuelCIDETaxRate", this.bR_NFFuelCIDETaxRate);
        this.bR_NFFuelCIDETaxRate = bR_NFFuelCIDETaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFuelCIDETaxAmount</b>
     * </p>
     *
     * @param bR_NFFuelCIDETaxAmount
     *            CIDE Amount
     */
    public void setBR_NFFuelCIDETaxAmount( @Nullable final BigDecimal bR_NFFuelCIDETaxAmount )
    {
        rememberChangedField("BR_NFFuelCIDETaxAmount", this.bR_NFFuelCIDETaxAmount);
        this.bR_NFFuelCIDETaxAmount = bR_NFFuelCIDETaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelNozzle</b>
     * </p>
     *
     * @param bR_NFeFuelNozzle
     *            Nozzle Number
     */
    public void setBR_NFeFuelNozzle( @Nullable final String bR_NFeFuelNozzle )
    {
        rememberChangedField("BR_NFeFuelNozzle", this.bR_NFeFuelNozzle);
        this.bR_NFeFuelNozzle = bR_NFeFuelNozzle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelPump</b>
     * </p>
     *
     * @param bR_NFeFuelPump
     *            Pump Number
     */
    public void setBR_NFeFuelPump( @Nullable final String bR_NFeFuelPump )
    {
        rememberChangedField("BR_NFeFuelPump", this.bR_NFeFuelPump);
        this.bR_NFeFuelPump = bR_NFeFuelPump;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelTank</b>
     * </p>
     *
     * @param bR_NFeFuelTank
     *            Tank Number
     */
    public void setBR_NFeFuelTank( @Nullable final String bR_NFeFuelTank )
    {
        rememberChangedField("BR_NFeFuelTank", this.bR_NFeFuelTank);
        this.bR_NFeFuelTank = bR_NFeFuelTank;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelGaugeStartQuantity</b>
     * </p>
     *
     * @param bR_NFeFuelGaugeStartQuantity
     *            Start Value of Gauge
     */
    public void setBR_NFeFuelGaugeStartQuantity( @Nullable final BigDecimal bR_NFeFuelGaugeStartQuantity )
    {
        rememberChangedField("BR_NFeFuelGaugeStartQuantity", this.bR_NFeFuelGaugeStartQuantity);
        this.bR_NFeFuelGaugeStartQuantity = bR_NFeFuelGaugeStartQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeFuelGaugeEndQuantity</b>
     * </p>
     *
     * @param bR_NFeFuelGaugeEndQuantity
     *            End Value of Gauge
     */
    public void setBR_NFeFuelGaugeEndQuantity( @Nullable final BigDecimal bR_NFeFuelGaugeEndQuantity )
    {
        rememberChangedField("BR_NFeFuelGaugeEndQuantity", this.bR_NFeFuelGaugeEndQuantity);
        this.bR_NFeFuelGaugeEndQuantity = bR_NFeFuelGaugeEndQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPRatioUnit</b>
     * </p>
     *
     * @param bR_GLPRatioUnit
     *            Unit of Measurement
     */
    public void setBR_GLPRatioUnit( @Nullable final String bR_GLPRatioUnit )
    {
        rememberChangedField("BR_GLPRatioUnit", this.bR_GLPRatioUnit);
        this.bR_GLPRatioUnit = bR_GLPRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPRatio</b>
     * </p>
     *
     * @param bR_GLPRatio
     *            Oil Derived from Gas
     */
    public void setBR_GLPRatio( @Nullable final BigDecimal bR_GLPRatio )
    {
        rememberChangedField("BR_GLPRatio", this.bR_GLPRatio);
        this.bR_GLPRatio = bR_GLPRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNNRatioUnit</b>
     * </p>
     *
     * @param bR_GLGNNRatioUnit
     *            Unit of Measurement
     */
    public void setBR_GLGNNRatioUnit( @Nullable final String bR_GLGNNRatioUnit )
    {
        rememberChangedField("BR_GLGNNRatioUnit", this.bR_GLGNNRatioUnit);
        this.bR_GLGNNRatioUnit = bR_GLGNNRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNNRatio</b>
     * </p>
     *
     * @param bR_GLGNNRatio
     *            National Natural Gas
     */
    public void setBR_GLGNNRatio( @Nullable final BigDecimal bR_GLGNNRatio )
    {
        rememberChangedField("BR_GLGNNRatio", this.bR_GLGNNRatio);
        this.bR_GLGNNRatio = bR_GLGNNRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNIRatioUnit</b>
     * </p>
     *
     * @param bR_GLGNIRatioUnit
     *            Unit of Measurement
     */
    public void setBR_GLGNIRatioUnit( @Nullable final String bR_GLGNIRatioUnit )
    {
        rememberChangedField("BR_GLGNIRatioUnit", this.bR_GLGNIRatioUnit);
        this.bR_GLGNIRatioUnit = bR_GLGNIRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLGNIRatio</b>
     * </p>
     *
     * @param bR_GLGNIRatio
     *            Imported Natural Gas
     */
    public void setBR_GLGNIRatio( @Nullable final BigDecimal bR_GLGNIRatio )
    {
        rememberChangedField("BR_GLGNIRatio", this.bR_GLGNIRatio);
        this.bR_GLGNIRatio = bR_GLGNIRatio;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_GLPNetValueAmount</b>
     * </p>
     *
     * @param bR_GLPNetValueAmount
     *            Fuel Net Amount
     */
    public void setBR_GLPNetValueAmount( @Nullable final BigDecimal bR_GLPNetValueAmount )
    {
        rememberChangedField("BR_GLPNetValueAmount", this.bR_GLPNetValueAmount);
        this.bR_GLPNetValueAmount = bR_GLPNetValueAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFBiodieselMixingIndexRate</b>
     * </p>
     *
     * @param bR_NFBiodieselMixingIndexRate
     *            Biodiesel Mixing Index in Diesel B
     */
    public void setBR_NFBiodieselMixingIndexRate( @Nullable final BigDecimal bR_NFBiodieselMixingIndexRate )
    {
        rememberChangedField("BR_NFBiodieselMixingIndexRate", this.bR_NFBiodieselMixingIndexRate);
        this.bR_NFBiodieselMixingIndexRate = bR_NFBiodieselMixingIndexRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFFuel";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("BR_ANPCode", getBR_ANPCode());
        values.put("BR_NFRegisterCODIF", getBR_NFRegisterCODIF());
        values.put("BR_NFeEnvrmtTemperatureFuelQty", getBR_NFeEnvrmtTemperatureFuelQty());
        values.put("BR_NFeFuelConsumerRegion", getBR_NFeFuelConsumerRegion());
        values.put("BR_NFPercentageNaturalGasUnit", getBR_NFPercentageNaturalGasUnit());
        values.put("BR_NFNaturalGasPercent", getBR_NFNaturalGasPercent());
        values.put("BR_NFFuelCIDETaxBaseQuantity", getBR_NFFuelCIDETaxBaseQuantity());
        values.put("BR_NFFuelCIDETaxRate", getBR_NFFuelCIDETaxRate());
        values.put("BR_NFFuelCIDETaxAmount", getBR_NFFuelCIDETaxAmount());
        values.put("BR_NFeFuelNozzle", getBR_NFeFuelNozzle());
        values.put("BR_NFeFuelPump", getBR_NFeFuelPump());
        values.put("BR_NFeFuelTank", getBR_NFeFuelTank());
        values.put("BR_NFeFuelGaugeStartQuantity", getBR_NFeFuelGaugeStartQuantity());
        values.put("BR_NFeFuelGaugeEndQuantity", getBR_NFeFuelGaugeEndQuantity());
        values.put("BR_GLPRatioUnit", getBR_GLPRatioUnit());
        values.put("BR_GLPRatio", getBR_GLPRatio());
        values.put("BR_GLGNNRatioUnit", getBR_GLGNNRatioUnit());
        values.put("BR_GLGNNRatio", getBR_GLGNNRatio());
        values.put("BR_GLGNIRatioUnit", getBR_GLGNIRatioUnit());
        values.put("BR_GLGNIRatio", getBR_GLGNIRatio());
        values.put("BR_GLPNetValueAmount", getBR_GLPNetValueAmount());
        values.put("BR_NFBiodieselMixingIndexRate", getBR_NFBiodieselMixingIndexRate());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("BR_ANPCode") ) {
                final Object value = values.remove("BR_ANPCode");
                if( (value == null) || (!value.equals(getBR_ANPCode())) ) {
                    setBR_ANPCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFRegisterCODIF") ) {
                final Object value = values.remove("BR_NFRegisterCODIF");
                if( (value == null) || (!value.equals(getBR_NFRegisterCODIF())) ) {
                    setBR_NFRegisterCODIF(((String) value));
                }
            }
            if( values.containsKey("BR_NFeEnvrmtTemperatureFuelQty") ) {
                final Object value = values.remove("BR_NFeEnvrmtTemperatureFuelQty");
                if( (value == null) || (!value.equals(getBR_NFeEnvrmtTemperatureFuelQty())) ) {
                    setBR_NFeEnvrmtTemperatureFuelQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFeFuelConsumerRegion") ) {
                final Object value = values.remove("BR_NFeFuelConsumerRegion");
                if( (value == null) || (!value.equals(getBR_NFeFuelConsumerRegion())) ) {
                    setBR_NFeFuelConsumerRegion(((String) value));
                }
            }
            if( values.containsKey("BR_NFPercentageNaturalGasUnit") ) {
                final Object value = values.remove("BR_NFPercentageNaturalGasUnit");
                if( (value == null) || (!value.equals(getBR_NFPercentageNaturalGasUnit())) ) {
                    setBR_NFPercentageNaturalGasUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFNaturalGasPercent") ) {
                final Object value = values.remove("BR_NFNaturalGasPercent");
                if( (value == null) || (!value.equals(getBR_NFNaturalGasPercent())) ) {
                    setBR_NFNaturalGasPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFFuelCIDETaxBaseQuantity") ) {
                final Object value = values.remove("BR_NFFuelCIDETaxBaseQuantity");
                if( (value == null) || (!value.equals(getBR_NFFuelCIDETaxBaseQuantity())) ) {
                    setBR_NFFuelCIDETaxBaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFFuelCIDETaxRate") ) {
                final Object value = values.remove("BR_NFFuelCIDETaxRate");
                if( (value == null) || (!value.equals(getBR_NFFuelCIDETaxRate())) ) {
                    setBR_NFFuelCIDETaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFFuelCIDETaxAmount") ) {
                final Object value = values.remove("BR_NFFuelCIDETaxAmount");
                if( (value == null) || (!value.equals(getBR_NFFuelCIDETaxAmount())) ) {
                    setBR_NFFuelCIDETaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFeFuelNozzle") ) {
                final Object value = values.remove("BR_NFeFuelNozzle");
                if( (value == null) || (!value.equals(getBR_NFeFuelNozzle())) ) {
                    setBR_NFeFuelNozzle(((String) value));
                }
            }
            if( values.containsKey("BR_NFeFuelPump") ) {
                final Object value = values.remove("BR_NFeFuelPump");
                if( (value == null) || (!value.equals(getBR_NFeFuelPump())) ) {
                    setBR_NFeFuelPump(((String) value));
                }
            }
            if( values.containsKey("BR_NFeFuelTank") ) {
                final Object value = values.remove("BR_NFeFuelTank");
                if( (value == null) || (!value.equals(getBR_NFeFuelTank())) ) {
                    setBR_NFeFuelTank(((String) value));
                }
            }
            if( values.containsKey("BR_NFeFuelGaugeStartQuantity") ) {
                final Object value = values.remove("BR_NFeFuelGaugeStartQuantity");
                if( (value == null) || (!value.equals(getBR_NFeFuelGaugeStartQuantity())) ) {
                    setBR_NFeFuelGaugeStartQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFeFuelGaugeEndQuantity") ) {
                final Object value = values.remove("BR_NFeFuelGaugeEndQuantity");
                if( (value == null) || (!value.equals(getBR_NFeFuelGaugeEndQuantity())) ) {
                    setBR_NFeFuelGaugeEndQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_GLPRatioUnit") ) {
                final Object value = values.remove("BR_GLPRatioUnit");
                if( (value == null) || (!value.equals(getBR_GLPRatioUnit())) ) {
                    setBR_GLPRatioUnit(((String) value));
                }
            }
            if( values.containsKey("BR_GLPRatio") ) {
                final Object value = values.remove("BR_GLPRatio");
                if( (value == null) || (!value.equals(getBR_GLPRatio())) ) {
                    setBR_GLPRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_GLGNNRatioUnit") ) {
                final Object value = values.remove("BR_GLGNNRatioUnit");
                if( (value == null) || (!value.equals(getBR_GLGNNRatioUnit())) ) {
                    setBR_GLGNNRatioUnit(((String) value));
                }
            }
            if( values.containsKey("BR_GLGNNRatio") ) {
                final Object value = values.remove("BR_GLGNNRatio");
                if( (value == null) || (!value.equals(getBR_GLGNNRatio())) ) {
                    setBR_GLGNNRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_GLGNIRatioUnit") ) {
                final Object value = values.remove("BR_GLGNIRatioUnit");
                if( (value == null) || (!value.equals(getBR_GLGNIRatioUnit())) ) {
                    setBR_GLGNIRatioUnit(((String) value));
                }
            }
            if( values.containsKey("BR_GLGNIRatio") ) {
                final Object value = values.remove("BR_GLGNIRatio");
                if( (value == null) || (!value.equals(getBR_GLGNIRatio())) ) {
                    setBR_GLGNIRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_GLPNetValueAmount") ) {
                final Object value = values.remove("BR_GLPNetValueAmount");
                if( (value == null) || (!value.equals(getBR_GLPNetValueAmount())) ) {
                    setBR_GLPNetValueAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFBiodieselMixingIndexRate") ) {
                final Object value = values.remove("BR_NFBiodieselMixingIndexRate");
                if( (value == null) || (!value.equals(getBR_NFBiodieselMixingIndexRate())) ) {
                    setBR_NFBiodieselMixingIndexRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Map ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = new BR_NFItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFFuelField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFFuelField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFFuelField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFFuelField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFFuel</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFFuel</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Fetches the <b>BR_NFItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem fetchBR_NFItem()
    {
        return fetchFieldAsSingle("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFFuel</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFFuel</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFItem> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the associated <b>BR_NFItem</b> entity for the loaded navigation property <b>to_BR_NFItem</b>.
     *
     * @param value
     *            New <b>BR_NFItem</b> entity.
     */
    public void setBR_NFItem( final BR_NFItem value )
    {
        toBR_NFItem = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFFuel instances.
     *
     */
    public final static class BR_NFFuelBuilder
    {

        private BR_NFDocument toBR_NFDoc;
        private BR_NFItem toBR_NFItem;

        private BR_NFFuel.BR_NFFuelBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFFuel</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFFuel with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFFuel.BR_NFFuelBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

        private BR_NFFuel.BR_NFFuelBuilder toBR_NFItem( final BR_NFItem value )
        {
            toBR_NFItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFFuel</b> to single <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItem to build this BR_NFFuel with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFFuel.BR_NFFuelBuilder bR_NFItem( final BR_NFItem value )
        {
            return toBR_NFItem(value);
        }

    }

}
