/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFFuelOriginIndicatorSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
 * BR_NFFuelOriginIndicator} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BR_NFFuelOriginIndicatorByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFFuelOriginIndicatorByKeyFluentHelper, BR_NFFuelOriginIndicator, BR_NFFuelOriginIndicatorSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     * BR_NFFuelOriginIndicator} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFFuelOriginIndicator}
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFFuelOriginIndicator}
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFOriginRegion
     *            UF of origin of producer or importer
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param bR_NFImportIndicatorFuelOrigin
     *            Import indicator
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BR_NFFuelOriginIndicatorByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportIndicatorFuelOrigin,
        final String bR_NFOriginRegion )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NotaFiscalItem", bR_NotaFiscalItem);
        this.key.put("BR_NFImportIndicatorFuelOrigin", bR_NFImportIndicatorFuelOrigin);
        this.key.put("BR_NFOriginRegion", bR_NFOriginRegion);
    }

    @Override
    @Nonnull
    protected Class<BR_NFFuelOriginIndicator> getEntityClass()
    {
        return BR_NFFuelOriginIndicator.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
