/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFHeaderTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText BR_NFHeaderText} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class BR_NFHeaderTextByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFHeaderTextByKeyFluentHelper, BR_NFHeaderText, BR_NFHeaderTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText BR_NFHeaderText}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFHeaderText}
     * @param bR_NFTextType
     *            NF text type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param bR_NFTextSequenceNumber
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFHeaderText}
     */
    public BR_NFHeaderTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NFTextType,
        final String bR_NFTextSequenceNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NFTextType", bR_NFTextType);
        this.key.put("BR_NFTextSequenceNumber", bR_NFTextSequenceNumber);
    }

    @Override
    @Nonnull
    protected Class<BR_NFHeaderText> getEntityClass()
    {
        return BR_NFHeaderText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
