/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFImportDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFImportDocumentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFImportDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Import Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFImportDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFImportDocument extends VdmEntity<BR_NFImportDocument>
{

    /**
     * Selector for all available fields of BR_NFImportDocument.
     *
     */
    public final static BR_NFImportDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BR_NOTA_FISCAL =
        new BR_NFImportDocumentField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDocument</b>
     * </p>
     *
     * @return Import Document
     */
    @Key
    @SerializedName( "BR_NFImportDocument" )
    @JsonProperty( "BR_NFImportDocument" )
    @Nullable
    @ODataField( odataName = "BR_NFImportDocument" )
    private String bR_NFImportDocument;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFImportDocument</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_IMPORT_DOCUMENT =
        new BR_NFImportDocumentField<String>("BR_NFImportDocument");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDocRegistrationDate</b>
     * </p>
     *
     * @return Registration Date
     */
    @SerializedName( "BR_NFImportDocRegistrationDate" )
    @JsonProperty( "BR_NFImportDocRegistrationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFImportDocRegistrationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFImportDocRegistrationDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFImportDocRegistrationDate</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<LocalDateTime> BRNF_IMPORT_DOC_REGISTRATION_DATE =
        new BR_NFImportDocumentField<LocalDateTime>("BR_NFImportDocRegistrationDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceDesc</b>
     * </p>
     *
     * @return Customs Clearance Place
     */
    @SerializedName( "BR_NFCustomsClearanceDesc" )
    @JsonProperty( "BR_NFCustomsClearanceDesc" )
    @Nullable
    @ODataField( odataName = "BR_NFCustomsClearanceDesc" )
    private String bR_NFCustomsClearanceDesc;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFCustomsClearanceDesc</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_CUSTOMS_CLEARANCE_DESC =
        new BR_NFImportDocumentField<String>("BR_NFCustomsClearanceDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceTaxRegion</b>
     * </p>
     *
     * @return Customs Clearance Region
     */
    @SerializedName( "BR_NFCustomsClearanceTaxRegion" )
    @JsonProperty( "BR_NFCustomsClearanceTaxRegion" )
    @Nullable
    @ODataField( odataName = "BR_NFCustomsClearanceTaxRegion" )
    private String bR_NFCustomsClearanceTaxRegion;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFCustomsClearanceTaxRegion</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_CUSTOMS_CLEARANCE_TAX_REGION =
        new BR_NFImportDocumentField<String>("BR_NFCustomsClearanceTaxRegion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceDate</b>
     * </p>
     *
     * @return Customs Clearance Date
     */
    @SerializedName( "BR_NFCustomsClearanceDate" )
    @JsonProperty( "BR_NFCustomsClearanceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFCustomsClearanceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFCustomsClearanceDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFCustomsClearanceDate</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<LocalDateTime> BRNF_CUSTOMS_CLEARANCE_DATE =
        new BR_NFImportDocumentField<LocalDateTime>("BR_NFCustomsClearanceDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExporter</b>
     * </p>
     *
     * @return Exporter code
     */
    @SerializedName( "BR_NFExporter" )
    @JsonProperty( "BR_NFExporter" )
    @Nullable
    @ODataField( odataName = "BR_NFExporter" )
    private String bR_NFExporter;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExporter</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_EXPORTER =
        new BR_NFImportDocumentField<String>("BR_NFExporter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDeclarationType</b>
     * </p>
     *
     * @return Import Document Declaration Type
     */
    @SerializedName( "BR_NFImportDeclarationType" )
    @JsonProperty( "BR_NFImportDeclarationType" )
    @Nullable
    @ODataField( odataName = "BR_NFImportDeclarationType" )
    private String bR_NFImportDeclarationType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFImportDeclarationType</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_IMPORT_DECLARATION_TYPE =
        new BR_NFImportDocumentField<String>("BR_NFImportDeclarationType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImpDocMeansOfTransport</b>
     * </p>
     *
     * @return Means of Transport
     */
    @SerializedName( "BR_NFImpDocMeansOfTransport" )
    @JsonProperty( "BR_NFImpDocMeansOfTransport" )
    @Nullable
    @ODataField( odataName = "BR_NFImpDocMeansOfTransport" )
    private String bR_NFImpDocMeansOfTransport;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFImpDocMeansOfTransport</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_IMP_DOC_MEANS_OF_TRANSPORT =
        new BR_NFImportDocumentField<String>("BR_NFImpDocMeansOfTransport");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMaritimeFreightAmount</b>
     * </p>
     *
     * @return Maritime Freight
     */
    @SerializedName( "BR_NFMaritimeFreightAmount" )
    @JsonProperty( "BR_NFMaritimeFreightAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFMaritimeFreightAmount" )
    private BigDecimal bR_NFMaritimeFreightAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMaritimeFreightAmount</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<BigDecimal> BRNF_MARITIME_FREIGHT_AMOUNT =
        new BR_NFImportDocumentField<BigDecimal>("BR_NFMaritimeFreightAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIntermediateMode</b>
     * </p>
     *
     * @return Intermediate mode
     */
    @SerializedName( "BR_NFIntermediateMode" )
    @JsonProperty( "BR_NFIntermediateMode" )
    @Nullable
    @ODataField( odataName = "BR_NFIntermediateMode" )
    private String bR_NFIntermediateMode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIntermediateMode</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_INTERMEDIATE_MODE =
        new BR_NFImportDocumentField<String>("BR_NFIntermediateMode");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFBuyerRequesterCNPJ</b>
     * </p>
     *
     * @return CNPJ of the Buyer or Requester
     */
    @SerializedName( "BR_NFBuyerRequesterCNPJ" )
    @JsonProperty( "BR_NFBuyerRequesterCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_NFBuyerRequesterCNPJ" )
    private String bR_NFBuyerRequesterCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFBuyerRequesterCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_BUYER_REQUESTER_CNPJ =
        new BR_NFImportDocumentField<String>("BR_NFBuyerRequesterCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFThirdPartyRegion</b>
     * </p>
     *
     * @return Region of Third Party
     */
    @SerializedName( "BR_NFThirdPartyRegion" )
    @JsonProperty( "BR_NFThirdPartyRegion" )
    @Nullable
    @ODataField( odataName = "BR_NFThirdPartyRegion" )
    private String bR_NFThirdPartyRegion;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFThirdPartyRegion</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> BRNF_THIRD_PARTY_REGION =
        new BR_NFImportDocumentField<String>("BR_NFThirdPartyRegion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsMaritimeFrtInTotalAmt</b>
     * </p>
     *
     * @return Maritime Freight in Total
     */
    @SerializedName( "BR_NFIsMaritimeFrtInTotalAmt" )
    @JsonProperty( "BR_NFIsMaritimeFrtInTotalAmt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsMaritimeFrtInTotalAmt" )
    private Boolean bR_NFIsMaritimeFrtInTotalAmt;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsMaritimeFrtInTotalAmt</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<Boolean> BRNF_IS_MARITIME_FRT_IN_TOTAL_AMT =
        new BR_NFImportDocumentField<Boolean>("BR_NFIsMaritimeFrtInTotalAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFImportDocumentField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFImportDocumentField<String>("SalesDocumentCurrency");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFImportDocument</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFImportDocumentOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFImportDocumentOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFImportDocument> getType()
    {
        return BR_NFImportDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDocument</b>
     * </p>
     *
     * @param bR_NFImportDocument
     *            Import Document
     */
    public void setBR_NFImportDocument( @Nullable final String bR_NFImportDocument )
    {
        rememberChangedField("BR_NFImportDocument", this.bR_NFImportDocument);
        this.bR_NFImportDocument = bR_NFImportDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDocRegistrationDate</b>
     * </p>
     *
     * @param bR_NFImportDocRegistrationDate
     *            Registration Date
     */
    public void setBR_NFImportDocRegistrationDate( @Nullable final LocalDateTime bR_NFImportDocRegistrationDate )
    {
        rememberChangedField("BR_NFImportDocRegistrationDate", this.bR_NFImportDocRegistrationDate);
        this.bR_NFImportDocRegistrationDate = bR_NFImportDocRegistrationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceDesc</b>
     * </p>
     *
     * @param bR_NFCustomsClearanceDesc
     *            Customs Clearance Place
     */
    public void setBR_NFCustomsClearanceDesc( @Nullable final String bR_NFCustomsClearanceDesc )
    {
        rememberChangedField("BR_NFCustomsClearanceDesc", this.bR_NFCustomsClearanceDesc);
        this.bR_NFCustomsClearanceDesc = bR_NFCustomsClearanceDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceTaxRegion</b>
     * </p>
     *
     * @param bR_NFCustomsClearanceTaxRegion
     *            Customs Clearance Region
     */
    public void setBR_NFCustomsClearanceTaxRegion( @Nullable final String bR_NFCustomsClearanceTaxRegion )
    {
        rememberChangedField("BR_NFCustomsClearanceTaxRegion", this.bR_NFCustomsClearanceTaxRegion);
        this.bR_NFCustomsClearanceTaxRegion = bR_NFCustomsClearanceTaxRegion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFCustomsClearanceDate</b>
     * </p>
     *
     * @param bR_NFCustomsClearanceDate
     *            Customs Clearance Date
     */
    public void setBR_NFCustomsClearanceDate( @Nullable final LocalDateTime bR_NFCustomsClearanceDate )
    {
        rememberChangedField("BR_NFCustomsClearanceDate", this.bR_NFCustomsClearanceDate);
        this.bR_NFCustomsClearanceDate = bR_NFCustomsClearanceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExporter</b>
     * </p>
     *
     * @param bR_NFExporter
     *            Exporter code
     */
    public void setBR_NFExporter( @Nullable final String bR_NFExporter )
    {
        rememberChangedField("BR_NFExporter", this.bR_NFExporter);
        this.bR_NFExporter = bR_NFExporter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImportDeclarationType</b>
     * </p>
     *
     * @param bR_NFImportDeclarationType
     *            Import Document Declaration Type
     */
    public void setBR_NFImportDeclarationType( @Nullable final String bR_NFImportDeclarationType )
    {
        rememberChangedField("BR_NFImportDeclarationType", this.bR_NFImportDeclarationType);
        this.bR_NFImportDeclarationType = bR_NFImportDeclarationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFImpDocMeansOfTransport</b>
     * </p>
     *
     * @param bR_NFImpDocMeansOfTransport
     *            Means of Transport
     */
    public void setBR_NFImpDocMeansOfTransport( @Nullable final String bR_NFImpDocMeansOfTransport )
    {
        rememberChangedField("BR_NFImpDocMeansOfTransport", this.bR_NFImpDocMeansOfTransport);
        this.bR_NFImpDocMeansOfTransport = bR_NFImpDocMeansOfTransport;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMaritimeFreightAmount</b>
     * </p>
     *
     * @param bR_NFMaritimeFreightAmount
     *            Maritime Freight
     */
    public void setBR_NFMaritimeFreightAmount( @Nullable final BigDecimal bR_NFMaritimeFreightAmount )
    {
        rememberChangedField("BR_NFMaritimeFreightAmount", this.bR_NFMaritimeFreightAmount);
        this.bR_NFMaritimeFreightAmount = bR_NFMaritimeFreightAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIntermediateMode</b>
     * </p>
     *
     * @param bR_NFIntermediateMode
     *            Intermediate mode
     */
    public void setBR_NFIntermediateMode( @Nullable final String bR_NFIntermediateMode )
    {
        rememberChangedField("BR_NFIntermediateMode", this.bR_NFIntermediateMode);
        this.bR_NFIntermediateMode = bR_NFIntermediateMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFBuyerRequesterCNPJ</b>
     * </p>
     *
     * @param bR_NFBuyerRequesterCNPJ
     *            CNPJ of the Buyer or Requester
     */
    public void setBR_NFBuyerRequesterCNPJ( @Nullable final String bR_NFBuyerRequesterCNPJ )
    {
        rememberChangedField("BR_NFBuyerRequesterCNPJ", this.bR_NFBuyerRequesterCNPJ);
        this.bR_NFBuyerRequesterCNPJ = bR_NFBuyerRequesterCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFThirdPartyRegion</b>
     * </p>
     *
     * @param bR_NFThirdPartyRegion
     *            Region of Third Party
     */
    public void setBR_NFThirdPartyRegion( @Nullable final String bR_NFThirdPartyRegion )
    {
        rememberChangedField("BR_NFThirdPartyRegion", this.bR_NFThirdPartyRegion);
        this.bR_NFThirdPartyRegion = bR_NFThirdPartyRegion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsMaritimeFrtInTotalAmt</b>
     * </p>
     *
     * @param bR_NFIsMaritimeFrtInTotalAmt
     *            Maritime Freight in Total
     */
    public void setBR_NFIsMaritimeFrtInTotalAmt( @Nullable final Boolean bR_NFIsMaritimeFrtInTotalAmt )
    {
        rememberChangedField("BR_NFIsMaritimeFrtInTotalAmt", this.bR_NFIsMaritimeFrtInTotalAmt);
        this.bR_NFIsMaritimeFrtInTotalAmt = bR_NFIsMaritimeFrtInTotalAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFImportDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFImportDocument", getBR_NFImportDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFImportDocument", getBR_NFImportDocument());
        values.put("BR_NFImportDocRegistrationDate", getBR_NFImportDocRegistrationDate());
        values.put("BR_NFCustomsClearanceDesc", getBR_NFCustomsClearanceDesc());
        values.put("BR_NFCustomsClearanceTaxRegion", getBR_NFCustomsClearanceTaxRegion());
        values.put("BR_NFCustomsClearanceDate", getBR_NFCustomsClearanceDate());
        values.put("BR_NFExporter", getBR_NFExporter());
        values.put("BR_NFImportDeclarationType", getBR_NFImportDeclarationType());
        values.put("BR_NFImpDocMeansOfTransport", getBR_NFImpDocMeansOfTransport());
        values.put("BR_NFMaritimeFreightAmount", getBR_NFMaritimeFreightAmount());
        values.put("BR_NFIntermediateMode", getBR_NFIntermediateMode());
        values.put("BR_NFBuyerRequesterCNPJ", getBR_NFBuyerRequesterCNPJ());
        values.put("BR_NFThirdPartyRegion", getBR_NFThirdPartyRegion());
        values.put("BR_NFIsMaritimeFrtInTotalAmt", getBR_NFIsMaritimeFrtInTotalAmt());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFImportDocument") ) {
                final Object value = values.remove("BR_NFImportDocument");
                if( (value == null) || (!value.equals(getBR_NFImportDocument())) ) {
                    setBR_NFImportDocument(((String) value));
                }
            }
            if( values.containsKey("BR_NFImportDocRegistrationDate") ) {
                final Object value = values.remove("BR_NFImportDocRegistrationDate");
                if( (value == null) || (!value.equals(getBR_NFImportDocRegistrationDate())) ) {
                    setBR_NFImportDocRegistrationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFCustomsClearanceDesc") ) {
                final Object value = values.remove("BR_NFCustomsClearanceDesc");
                if( (value == null) || (!value.equals(getBR_NFCustomsClearanceDesc())) ) {
                    setBR_NFCustomsClearanceDesc(((String) value));
                }
            }
            if( values.containsKey("BR_NFCustomsClearanceTaxRegion") ) {
                final Object value = values.remove("BR_NFCustomsClearanceTaxRegion");
                if( (value == null) || (!value.equals(getBR_NFCustomsClearanceTaxRegion())) ) {
                    setBR_NFCustomsClearanceTaxRegion(((String) value));
                }
            }
            if( values.containsKey("BR_NFCustomsClearanceDate") ) {
                final Object value = values.remove("BR_NFCustomsClearanceDate");
                if( (value == null) || (!value.equals(getBR_NFCustomsClearanceDate())) ) {
                    setBR_NFCustomsClearanceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFExporter") ) {
                final Object value = values.remove("BR_NFExporter");
                if( (value == null) || (!value.equals(getBR_NFExporter())) ) {
                    setBR_NFExporter(((String) value));
                }
            }
            if( values.containsKey("BR_NFImportDeclarationType") ) {
                final Object value = values.remove("BR_NFImportDeclarationType");
                if( (value == null) || (!value.equals(getBR_NFImportDeclarationType())) ) {
                    setBR_NFImportDeclarationType(((String) value));
                }
            }
            if( values.containsKey("BR_NFImpDocMeansOfTransport") ) {
                final Object value = values.remove("BR_NFImpDocMeansOfTransport");
                if( (value == null) || (!value.equals(getBR_NFImpDocMeansOfTransport())) ) {
                    setBR_NFImpDocMeansOfTransport(((String) value));
                }
            }
            if( values.containsKey("BR_NFMaritimeFreightAmount") ) {
                final Object value = values.remove("BR_NFMaritimeFreightAmount");
                if( (value == null) || (!value.equals(getBR_NFMaritimeFreightAmount())) ) {
                    setBR_NFMaritimeFreightAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFIntermediateMode") ) {
                final Object value = values.remove("BR_NFIntermediateMode");
                if( (value == null) || (!value.equals(getBR_NFIntermediateMode())) ) {
                    setBR_NFIntermediateMode(((String) value));
                }
            }
            if( values.containsKey("BR_NFBuyerRequesterCNPJ") ) {
                final Object value = values.remove("BR_NFBuyerRequesterCNPJ");
                if( (value == null) || (!value.equals(getBR_NFBuyerRequesterCNPJ())) ) {
                    setBR_NFBuyerRequesterCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_NFThirdPartyRegion") ) {
                final Object value = values.remove("BR_NFThirdPartyRegion");
                if( (value == null) || (!value.equals(getBR_NFThirdPartyRegion())) ) {
                    setBR_NFThirdPartyRegion(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsMaritimeFrtInTotalAmt") ) {
                final Object value = values.remove("BR_NFIsMaritimeFrtInTotalAmt");
                if( (value == null) || (!value.equals(getBR_NFIsMaritimeFrtInTotalAmt())) ) {
                    setBR_NFIsMaritimeFrtInTotalAmt(((Boolean) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFImportDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFImportDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFImportDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFImportDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFImportDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFImportDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFImportDocument instances.
     *
     */
    public final static class BR_NFImportDocumentBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFImportDocument.BR_NFImportDocumentBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFImportDocument</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFImportDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFImportDocument.BR_NFImportDocumentBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
