/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFItem extends VdmEntity<BR_NFItem>
{

    /**
     * Selector for all available fields of BR_NFItem.
     *
     */
    public final static BR_NFItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_NOTA_FISCAL = new BR_NFItemField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_NOTA_FISCAL_ITEM = new BR_NFItemField<String>("BR_NotaFiscalItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSTaxSituation</b>
     * </p>
     *
     * @return ICMS Tax Situation
     */
    @SerializedName( "BR_ICMSTaxSituation" )
    @JsonProperty( "BR_ICMSTaxSituation" )
    @Nullable
    @ODataField( odataName = "BR_ICMSTaxSituation" )
    private String bR_ICMSTaxSituation;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSTaxSituation</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMS_TAX_SITUATION = new BR_NFItemField<String>("BR_ICMSTaxSituation");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPITaxSituation</b>
     * </p>
     *
     * @return IPI Tax Situation
     */
    @SerializedName( "BR_IPITaxSituation" )
    @JsonProperty( "BR_IPITaxSituation" )
    @Nullable
    @ODataField( odataName = "BR_IPITaxSituation" )
    private String bR_IPITaxSituation;
    /**
     * Use with available fluent helpers to apply the <b>BR_IPITaxSituation</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRIPI_TAX_SITUATION = new BR_NFItemField<String>("BR_IPITaxSituation");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSTaxSituation</b>
     * </p>
     *
     * @return ISS Tax Situation
     */
    @SerializedName( "BR_ISSTaxSituation" )
    @JsonProperty( "BR_ISSTaxSituation" )
    @Nullable
    @ODataField( odataName = "BR_ISSTaxSituation" )
    private String bR_ISSTaxSituation;
    /**
     * Use with available fluent helpers to apply the <b>BR_ISSTaxSituation</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRISS_TAX_SITUATION = new BR_NFItemField<String>("BR_ISSTaxSituation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSTaxSituation</b>
     * </p>
     *
     * @return COFINS Tax Situation
     */
    @SerializedName( "BR_COFINSTaxSituation" )
    @JsonProperty( "BR_COFINSTaxSituation" )
    @Nullable
    @ODataField( odataName = "BR_COFINSTaxSituation" )
    private String bR_COFINSTaxSituation;
    /**
     * Use with available fluent helpers to apply the <b>BR_COFINSTaxSituation</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCOFINS_TAX_SITUATION =
        new BR_NFItemField<String>("BR_COFINSTaxSituation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISTaxSituation</b>
     * </p>
     *
     * @return PIS Tax Situation
     */
    @SerializedName( "BR_PISTaxSituation" )
    @JsonProperty( "BR_PISTaxSituation" )
    @Nullable
    @ODataField( odataName = "BR_PISTaxSituation" )
    private String bR_PISTaxSituation;
    /**
     * Use with available fluent helpers to apply the <b>BR_PISTaxSituation</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRPIS_TAX_SITUATION = new BR_NFItemField<String>("BR_PISTaxSituation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSBaseDetn</b>
     * </p>
     *
     * @return ICMS Base Determination
     */
    @SerializedName( "BR_ICMSBaseDetn" )
    @JsonProperty( "BR_ICMSBaseDetn" )
    @Nullable
    @ODataField( odataName = "BR_ICMSBaseDetn" )
    private String bR_ICMSBaseDetn;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSBaseDetn</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMS_BASE_DETN = new BR_NFItemField<String>("BR_ICMSBaseDetn");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTBaseDetermination</b>
     * </p>
     *
     * @return ICMS ST Base Determination
     */
    @SerializedName( "BR_ICMSSTBaseDetermination" )
    @JsonProperty( "BR_ICMSSTBaseDetermination" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTBaseDetermination" )
    private String bR_ICMSSTBaseDetermination;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTBaseDetermination</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMSST_BASE_DETERMINATION =
        new BR_NFItemField<String>("BR_ICMSSTBaseDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTLegalClassfctn</b>
     * </p>
     *
     * @return ICMS ST Legal Classification Code
     */
    @SerializedName( "BR_ICMSSTLegalClassfctn" )
    @JsonProperty( "BR_ICMSSTLegalClassfctn" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTLegalClassfctn" )
    private String bR_ICMSSTLegalClassfctn;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTLegalClassfctn</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMSST_LEGAL_CLASSFCTN =
        new BR_NFItemField<String>("BR_ICMSSTLegalClassfctn");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_SubstituteICMSAmount</b>
     * </p>
     *
     * @return Substitute ICMS Amount Charged in Previous Transaction
     */
    @SerializedName( "BR_SubstituteICMSAmount" )
    @JsonProperty( "BR_SubstituteICMSAmount" )
    @Nullable
    @ODataField( odataName = "BR_SubstituteICMSAmount" )
    private BigDecimal bR_SubstituteICMSAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_SubstituteICMSAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_SUBSTITUTE_ICMS_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_SubstituteICMSAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSExemptionReason</b>
     * </p>
     *
     * @return Exemption Reason
     */
    @SerializedName( "BR_ICMSExemptionReason" )
    @JsonProperty( "BR_ICMSExemptionReason" )
    @Nullable
    @ODataField( odataName = "BR_ICMSExemptionReason" )
    private String bR_ICMSExemptionReason;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSExemptionReason</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMS_EXEMPTION_REASON =
        new BR_NFItemField<String>("BR_ICMSExemptionReason");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDefermentAmount</b>
     * </p>
     *
     * @return Deferment Amount
     */
    @SerializedName( "BR_ICMSDefermentAmount" )
    @JsonProperty( "BR_ICMSDefermentAmount" )
    @Nullable
    @ODataField( odataName = "BR_ICMSDefermentAmount" )
    private BigDecimal bR_ICMSDefermentAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSDefermentAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMS_DEFERMENT_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_ICMSDefermentAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDeferralTaxRate</b>
     * </p>
     *
     * @return Tax Rate for ICMS Deferral
     */
    @SerializedName( "BR_ICMSDeferralTaxRate" )
    @JsonProperty( "BR_ICMSDeferralTaxRate" )
    @Nullable
    @ODataField( odataName = "BR_ICMSDeferralTaxRate" )
    private BigDecimal bR_ICMSDeferralTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSDeferralTaxRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMS_DEFERRAL_TAX_RATE =
        new BR_NFItemField<BigDecimal>("BR_ICMSDeferralTaxRate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_WithholdingICMSSTBaseAmount</b>
     * </p>
     *
     * @return Withholding ICMS ST Base
     */
    @SerializedName( "BR_WithholdingICMSSTBaseAmount" )
    @JsonProperty( "BR_WithholdingICMSSTBaseAmount" )
    @Nullable
    @ODataField( odataName = "BR_WithholdingICMSSTBaseAmount" )
    private BigDecimal bR_WithholdingICMSSTBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_WithholdingICMSSTBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_WITHHOLDING_ICMSST_BASE_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_WithholdingICMSSTBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_WithholdingICMSSTAmount</b>
     * </p>
     *
     * @return Withholding ICMS ST Amount
     */
    @SerializedName( "BR_WithholdingICMSSTAmount" )
    @JsonProperty( "BR_WithholdingICMSSTAmount" )
    @Nullable
    @ODataField( odataName = "BR_WithholdingICMSSTAmount" )
    private BigDecimal bR_WithholdingICMSSTAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_WithholdingICMSSTAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_WITHHOLDING_ICMSST_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_WithholdingICMSSTAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPILegalClassification</b>
     * </p>
     *
     * @return IPI Classification Code
     */
    @SerializedName( "BR_IPILegalClassification" )
    @JsonProperty( "BR_IPILegalClassification" )
    @Nullable
    @ODataField( odataName = "BR_IPILegalClassification" )
    private String bR_IPILegalClassification;
    /**
     * Use with available fluent helpers to apply the <b>BR_IPILegalClassification</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRIPI_LEGAL_CLASSIFICATION =
        new BR_NFItemField<String>("BR_IPILegalClassification");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_TobaccoBeverageIPIClassfctn</b>
     * </p>
     *
     * @return IPI Tobacco/Beverage
     */
    @SerializedName( "BR_TobaccoBeverageIPIClassfctn" )
    @JsonProperty( "BR_TobaccoBeverageIPIClassfctn" )
    @Nullable
    @ODataField( odataName = "BR_TobaccoBeverageIPIClassfctn" )
    private String bR_TobaccoBeverageIPIClassfctn;
    /**
     * Use with available fluent helpers to apply the <b>BR_TobaccoBeverageIPIClassfctn</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_TOBACCO_BEVERAGE_IPI_CLASSFCTN =
        new BR_NFItemField<String>("BR_TobaccoBeverageIPIClassfctn");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPIControlSealCode</b>
     * </p>
     *
     * @return IPI Control Seal Code
     */
    @SerializedName( "BR_IPIControlSealCode" )
    @JsonProperty( "BR_IPIControlSealCode" )
    @Nullable
    @ODataField( odataName = "BR_IPIControlSealCode" )
    private String bR_IPIControlSealCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_IPIControlSealCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRIPI_CONTROL_SEAL_CODE =
        new BR_NFItemField<String>("BR_IPIControlSealCode");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPIControlSealQuantityValue</b>
     * </p>
     *
     * @return IPI Control Seal Quantity
     */
    @SerializedName( "BR_IPIControlSealQuantityValue" )
    @JsonProperty( "BR_IPIControlSealQuantityValue" )
    @Nullable
    @ODataField( odataName = "BR_IPIControlSealQuantityValue" )
    private BigDecimal bR_IPIControlSealQuantityValue;
    /**
     * Use with available fluent helpers to apply the <b>BR_IPIControlSealQuantityValue</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRIPI_CONTROL_SEAL_QUANTITY_VALUE =
        new BR_NFItemField<BigDecimal>("BR_IPIControlSealQuantityValue");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> COST_CENTER = new BR_NFItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Centers
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PROFIT_CENTER = new BR_NFItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> INTERNAL_ORDER = new BR_NFItemField<String>("InternalOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PROJECT_NETWORK = new BR_NFItemField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> WBS_ELEMENT_INTERNAL_ID =
        new BR_NFItemField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Objects
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> COST_OBJECT = new BR_NFItemField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> SEGMENT = new BR_NFItemField<String>("Segment");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetFreightAmount</b>
     * </p>
     *
     * @return Net freight value in document currency
     */
    @SerializedName( "BR_NFNetFreightAmount" )
    @JsonProperty( "BR_NFNetFreightAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFNetFreightAmount" )
    private BigDecimal bR_NFNetFreightAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNetFreightAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_NET_FREIGHT_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFNetFreightAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetInsuranceAmount</b>
     * </p>
     *
     * @return Net insurance value in document currency
     */
    @SerializedName( "BR_NFNetInsuranceAmount" )
    @JsonProperty( "BR_NFNetInsuranceAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFNetInsuranceAmount" )
    private BigDecimal bR_NFNetInsuranceAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNetInsuranceAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_NET_INSURANCE_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFNetInsuranceAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetOtherExpensesAmount</b>
     * </p>
     *
     * @return Net expenses in document currency
     */
    @SerializedName( "BR_NFNetOtherExpensesAmount" )
    @JsonProperty( "BR_NFNetOtherExpensesAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFNetOtherExpensesAmount" )
    private BigDecimal bR_NFNetOtherExpensesAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNetOtherExpensesAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_NET_OTHER_EXPENSES_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFNetOtherExpensesAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price Including Tax
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> NET_PRICE_AMOUNT = new BR_NFItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetValueAmount</b>
     * </p>
     *
     * @return Net Amount
     */
    @SerializedName( "NetValueAmount" )
    @JsonProperty( "NetValueAmount" )
    @Nullable
    @ODataField( odataName = "NetValueAmount" )
    private BigDecimal netValueAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetValueAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> NET_VALUE_AMOUNT = new BR_NFItemField<BigDecimal>("NetValueAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemType</b>
     * </p>
     *
     * @return NF Item Type
     */
    @SerializedName( "BR_NFItemType" )
    @JsonProperty( "BR_NFItemType" )
    @Nullable
    @ODataField( odataName = "BR_NFItemType" )
    private String bR_NFItemType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemType</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_ITEM_TYPE = new BR_NFItemField<String>("BR_NFItemType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSOrISSIsIncludedInPrice</b>
     * </p>
     *
     * @return Value and price including ICMS/ISS
     */
    @SerializedName( "BR_ICMSOrISSIsIncludedInPrice" )
    @JsonProperty( "BR_ICMSOrISSIsIncludedInPrice" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_ICMSOrISSIsIncludedInPrice" )
    private Boolean bR_ICMSOrISSIsIncludedInPrice;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSOrISSIsIncludedInPrice</b> field to query operations.
     *
     */
    public final static BR_NFItemField<Boolean> BRICMS_OR_ISS_IS_INCLUDED_IN_PRICE =
        new BR_NFItemField<Boolean>("BR_ICMSOrISSIsIncludedInPrice");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemIsStatistical</b>
     * </p>
     *
     * @return Statistical Item
     */
    @SerializedName( "BR_NFItemIsStatistical" )
    @JsonProperty( "BR_NFItemIsStatistical" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFItemIsStatistical" )
    private Boolean bR_NFItemIsStatistical;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemIsStatistical</b> field to query operations.
     *
     */
    public final static BR_NFItemField<Boolean> BRNF_ITEM_IS_STATISTICAL =
        new BR_NFItemField<Boolean>("BR_NFItemIsStatistical");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsServiceItem</b>
     * </p>
     *
     * @return Service tax - no ICMS/IPI calculation
     */
    @SerializedName( "BR_NFIsServiceItem" )
    @JsonProperty( "BR_NFIsServiceItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFIsServiceItem" )
    private Boolean bR_NFIsServiceItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsServiceItem</b> field to query operations.
     *
     */
    public final static BR_NFItemField<Boolean> BRNF_IS_SERVICE_ITEM =
        new BR_NFItemField<Boolean>("BR_NFIsServiceItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> MATERIAL = new BR_NFItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> MATERIAL_NAME = new BR_NFItemField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> VALUATION_AREA = new BR_NFItemField<String>("ValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> VALUATION_TYPE = new BR_NFItemField<String>("ValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> MATERIAL_GROUP = new BR_NFItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCategory</b>
     * </p>
     *
     * @return Material CFOP category
     */
    @SerializedName( "BR_CFOPCategory" )
    @JsonProperty( "BR_CFOPCategory" )
    @Nullable
    @ODataField( odataName = "BR_CFOPCategory" )
    private String bR_CFOPCategory;
    /**
     * Use with available fluent helpers to apply the <b>BR_CFOPCategory</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCFOP_CATEGORY = new BR_NFItemField<String>("BR_CFOPCategory");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "QuantityInBaseUnit" )
    @JsonProperty( "QuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInBaseUnit" )
    private BigDecimal quantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> QUANTITY_IN_BASE_UNIT =
        new BR_NFItemField<BigDecimal>("QuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BASE_UNIT = new BR_NFItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PLANT = new BR_NFItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BATCH = new BR_NFItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentType</b>
     * </p>
     *
     * @return Reference type
     */
    @SerializedName( "BR_NFSourceDocumentType" )
    @JsonProperty( "BR_NFSourceDocumentType" )
    @Nullable
    @ODataField( odataName = "BR_NFSourceDocumentType" )
    private String bR_NFSourceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSourceDocumentType</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_SOURCE_DOCUMENT_TYPE =
        new BR_NFItemField<String>("BR_NFSourceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentNumber</b>
     * </p>
     *
     * @return Source Document Key
     */
    @SerializedName( "BR_NFSourceDocumentNumber" )
    @JsonProperty( "BR_NFSourceDocumentNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFSourceDocumentNumber" )
    private String bR_NFSourceDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSourceDocumentNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_SOURCE_DOCUMENT_NUMBER =
        new BR_NFItemField<String>("BR_NFSourceDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentItem</b>
     * </p>
     *
     * @return Reference item to source document
     */
    @SerializedName( "BR_NFSourceDocumentItem" )
    @JsonProperty( "BR_NFSourceDocumentItem" )
    @Nullable
    @ODataField( odataName = "BR_NFSourceDocumentItem" )
    private String bR_NFSourceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSourceDocumentItem</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_SOURCE_DOCUMENT_ITEM =
        new BR_NFItemField<String>("BR_NFSourceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReferenceNFNumber</b>
     * </p>
     *
     * @return Reference NF
     */
    @SerializedName( "BR_ReferenceNFNumber" )
    @JsonProperty( "BR_ReferenceNFNumber" )
    @Nullable
    @ODataField( odataName = "BR_ReferenceNFNumber" )
    private String bR_ReferenceNFNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_ReferenceNFNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_REFERENCE_NF_NUMBER =
        new BR_NFItemField<String>("BR_ReferenceNFNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReferenceNFItem</b>
     * </p>
     *
     * @return NF Reference Item
     */
    @SerializedName( "BR_ReferenceNFItem" )
    @JsonProperty( "BR_ReferenceNFItem" )
    @Nullable
    @ODataField( odataName = "BR_ReferenceNFItem" )
    private String bR_ReferenceNFItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_ReferenceNFItem</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_REFERENCE_NF_ITEM = new BR_NFItemField<String>("BR_ReferenceNFItem");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPercentReturned</b>
     * </p>
     *
     * @return Quantity Returned
     */
    @SerializedName( "BR_NFPercentReturned" )
    @JsonProperty( "BR_NFPercentReturned" )
    @Nullable
    @ODataField( odataName = "BR_NFPercentReturned" )
    private BigDecimal bR_NFPercentReturned;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPercentReturned</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_PERCENT_RETURNED =
        new BR_NFItemField<BigDecimal>("BR_NFPercentReturned");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetDiscountAmount</b>
     * </p>
     *
     * @return Net Discount Amount
     */
    @SerializedName( "BR_NFNetDiscountAmount" )
    @JsonProperty( "BR_NFNetDiscountAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFNetDiscountAmount" )
    private BigDecimal bR_NFNetDiscountAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFNetDiscountAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_NET_DISCOUNT_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFNetDiscountAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExemptedICMSAmount</b>
     * </p>
     *
     * @return ICMS Exemption Amount
     */
    @SerializedName( "BR_ExemptedICMSAmount" )
    @JsonProperty( "BR_ExemptedICMSAmount" )
    @Nullable
    @ODataField( odataName = "BR_ExemptedICMSAmount" )
    private BigDecimal bR_ExemptedICMSAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_ExemptedICMSAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EXEMPTED_ICMS_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_ExemptedICMSAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSStatisticalExemptionAmt</b>
     * </p>
     *
     * @return Statistical Exemption Value of ICMS
     */
    @SerializedName( "BR_ICMSStatisticalExemptionAmt" )
    @JsonProperty( "BR_ICMSStatisticalExemptionAmt" )
    @Nullable
    @ODataField( odataName = "BR_ICMSStatisticalExemptionAmt" )
    private BigDecimal bR_ICMSStatisticalExemptionAmt;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSStatisticalExemptionAmt</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMS_STATISTICAL_EXEMPTION_AMT =
        new BR_NFItemField<BigDecimal>("BR_ICMSStatisticalExemptionAmt");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTMarginAddedPercent</b>
     * </p>
     *
     * @return Margin percentage of value Added from ICMS ST
     */
    @SerializedName( "BR_ICMSSTMarginAddedPercent" )
    @JsonProperty( "BR_ICMSSTMarginAddedPercent" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTMarginAddedPercent" )
    private BigDecimal bR_ICMSSTMarginAddedPercent;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTMarginAddedPercent</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMSST_MARGIN_ADDED_PERCENT =
        new BR_NFItemField<BigDecimal>("BR_ICMSSTMarginAddedPercent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CPRBIsRelevant</b>
     * </p>
     *
     * @return CPRB Relevance
     */
    @SerializedName( "BR_CPRBIsRelevant" )
    @JsonProperty( "BR_CPRBIsRelevant" )
    @Nullable
    @ODataField( odataName = "BR_CPRBIsRelevant" )
    private String bR_CPRBIsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>BR_CPRBIsRelevant</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCPRB_IS_RELEVANT = new BR_NFItemField<String>("BR_CPRBIsRelevant");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmount</b>
     * </p>
     *
     * @return Net value/Freight/Insurance/Expenses/Discount
     */
    @SerializedName( "BR_NFTotalAmount" )
    @JsonProperty( "BR_NFTotalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFTotalAmount" )
    private BigDecimal bR_NFTotalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTotalAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_TOTAL_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFTotalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCode</b>
     * </p>
     *
     * @return CFOP Code and Extension
     */
    @SerializedName( "BR_CFOPCode" )
    @JsonProperty( "BR_CFOPCode" )
    @Nullable
    @ODataField( odataName = "BR_CFOPCode" )
    private String bR_CFOPCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_CFOPCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCFOP_CODE = new BR_NFItemField<String>("BR_CFOPCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialOrigin</b>
     * </p>
     *
     * @return Material Origin
     */
    @SerializedName( "BR_MaterialOrigin" )
    @JsonProperty( "BR_MaterialOrigin" )
    @Nullable
    @ODataField( odataName = "BR_MaterialOrigin" )
    private String bR_MaterialOrigin;
    /**
     * Use with available fluent helpers to apply the <b>BR_MaterialOrigin</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_MATERIAL_ORIGIN = new BR_NFItemField<String>("BR_MaterialOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialUsage</b>
     * </p>
     *
     * @return Material Usage
     */
    @SerializedName( "BR_MaterialUsage" )
    @JsonProperty( "BR_MaterialUsage" )
    @Nullable
    @ODataField( odataName = "BR_MaterialUsage" )
    private String bR_MaterialUsage;
    /**
     * Use with available fluent helpers to apply the <b>BR_MaterialUsage</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_MATERIAL_USAGE = new BR_NFItemField<String>("BR_MaterialUsage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProducedInhouse</b>
     * </p>
     *
     * @return Produced in-House
     */
    @SerializedName( "IsProducedInhouse" )
    @JsonProperty( "IsProducedInhouse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProducedInhouse" )
    private Boolean isProducedInhouse;
    /**
     * Use with available fluent helpers to apply the <b>IsProducedInhouse</b> field to query operations.
     *
     */
    public final static BR_NFItemField<Boolean> IS_PRODUCED_INHOUSE = new BR_NFItemField<Boolean>("IsProducedInhouse");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>NCMCode</b>
     * </p>
     *
     * @return Control Code
     */
    @SerializedName( "NCMCode" )
    @JsonProperty( "NCMCode" )
    @Nullable
    @ODataField( odataName = "NCMCode" )
    private String nCMCode;
    /**
     * Use with available fluent helpers to apply the <b>NCMCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> NCM_CODE = new BR_NFItemField<String>("NCMCode");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NBSCode</b>
     * </p>
     *
     * @return NBS Code
     */
    @SerializedName( "BR_NBSCode" )
    @JsonProperty( "BR_NBSCode" )
    @Nullable
    @ODataField( odataName = "BR_NBSCode" )
    private String bR_NBSCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NBSCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNBS_CODE = new BR_NFItemField<String>("BR_NBSCode");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_EFDREINFServiceCode</b>
     * </p>
     *
     * @return EFD-REINF Service Type Code
     */
    @SerializedName( "BR_EFDREINFServiceCode" )
    @JsonProperty( "BR_EFDREINFServiceCode" )
    @Nullable
    @ODataField( odataName = "BR_EFDREINFServiceCode" )
    private String bR_EFDREINFServiceCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_EFDREINFServiceCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BREFDREINF_SERVICE_CODE =
        new BR_NFItemField<String>("BR_EFDREINFServiceCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_LC116ServiceCode</b>
     * </p>
     *
     * @return LC 116 Service Type Code
     */
    @SerializedName( "BR_LC116ServiceCode" )
    @JsonProperty( "BR_LC116ServiceCode" )
    @Nullable
    @ODataField( odataName = "BR_LC116ServiceCode" )
    private String bR_LC116ServiceCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_LC116ServiceCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> B_R_L_C116_SERVICE_CODE =
        new BR_NFItemField<String>("BR_LC116ServiceCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSBenefitCode</b>
     * </p>
     *
     * @return Benefit Code for ISS Tax
     */
    @SerializedName( "BR_ISSBenefitCode" )
    @JsonProperty( "BR_ISSBenefitCode" )
    @Nullable
    @ODataField( odataName = "BR_ISSBenefitCode" )
    private String bR_ISSBenefitCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_ISSBenefitCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRISS_BENEFIT_CODE = new BR_NFItemField<String>("BR_ISSBenefitCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_CSTISSCode</b>
     * </p>
     *
     * @return CST for ISS Defined by Municipality
     */
    @SerializedName( "BR_CSTISSCode" )
    @JsonProperty( "BR_CSTISSCode" )
    @Nullable
    @ODataField( odataName = "BR_CSTISSCode" )
    private String bR_CSTISSCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_CSTISSCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCSTISS_CODE = new BR_NFItemField<String>("BR_CSTISSCode");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFApproximateTotalTaxAmount</b>
     * </p>
     *
     * @return Approximate Tax
     */
    @SerializedName( "BR_NFApproximateTotalTaxAmount" )
    @JsonProperty( "BR_NFApproximateTotalTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFApproximateTotalTaxAmount" )
    private BigDecimal bR_NFApproximateTotalTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFApproximateTotalTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_APPROXIMATE_TOTAL_TAX_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFApproximateTotalTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCINumber</b>
     * </p>
     *
     * @return FCI Number
     */
    @SerializedName( "BR_FCINumber" )
    @JsonProperty( "BR_FCINumber" )
    @Nullable
    @ODataField( odataName = "BR_FCINumber" )
    private String bR_FCINumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCINumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRFCI_NUMBER = new BR_NFItemField<String>("BR_FCINumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSTaxLaw</b>
     * </p>
     *
     * @return Tax Law ICMS
     */
    @SerializedName( "BR_ICMSTaxLaw" )
    @JsonProperty( "BR_ICMSTaxLaw" )
    @Nullable
    @ODataField( odataName = "BR_ICMSTaxLaw" )
    private String bR_ICMSTaxLaw;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSTaxLaw</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMS_TAX_LAW = new BR_NFItemField<String>("BR_ICMSTaxLaw");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPITaxLaw</b>
     * </p>
     *
     * @return Tax Law IPI
     */
    @SerializedName( "BR_IPITaxLaw" )
    @JsonProperty( "BR_IPITaxLaw" )
    @Nullable
    @ODataField( odataName = "BR_IPITaxLaw" )
    private String bR_IPITaxLaw;
    /**
     * Use with available fluent helpers to apply the <b>BR_IPITaxLaw</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRIPI_TAX_LAW = new BR_NFItemField<String>("BR_IPITaxLaw");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSTaxLaw</b>
     * </p>
     *
     * @return ISS Tax Law
     */
    @SerializedName( "BR_ISSTaxLaw" )
    @JsonProperty( "BR_ISSTaxLaw" )
    @Nullable
    @ODataField( odataName = "BR_ISSTaxLaw" )
    private String bR_ISSTaxLaw;
    /**
     * Use with available fluent helpers to apply the <b>BR_ISSTaxLaw</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRISS_TAX_LAW = new BR_NFItemField<String>("BR_ISSTaxLaw");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSTaxLaw</b>
     * </p>
     *
     * @return COFINS Tax Law
     */
    @SerializedName( "BR_COFINSTaxLaw" )
    @JsonProperty( "BR_COFINSTaxLaw" )
    @Nullable
    @ODataField( odataName = "BR_COFINSTaxLaw" )
    private String bR_COFINSTaxLaw;
    /**
     * Use with available fluent helpers to apply the <b>BR_COFINSTaxLaw</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCOFINS_TAX_LAW = new BR_NFItemField<String>("BR_COFINSTaxLaw");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISTaxLaw</b>
     * </p>
     *
     * @return Tax Law PIS
     */
    @SerializedName( "BR_PISTaxLaw" )
    @JsonProperty( "BR_PISTaxLaw" )
    @Nullable
    @ODataField( odataName = "BR_PISTaxLaw" )
    private String bR_PISTaxLaw;
    /**
     * Use with available fluent helpers to apply the <b>BR_PISTaxLaw</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRPIS_TAX_LAW = new BR_NFItemField<String>("BR_PISTaxLaw");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> GL_ACCOUNT = new BR_NFItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PURCHASE_ORDER = new BR_NFItemField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Purchase Order Item
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PURCHASE_ORDER_ITEM = new BR_NFItemField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @return European Article Number
     */
    @SerializedName( "InternationalArticleNumber" )
    @JsonProperty( "InternationalArticleNumber" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumber" )
    private String internationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> INTERNATIONAL_ARTICLE_NUMBER =
        new BR_NFItemField<String>("InternationalArticleNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExternalItemNumber</b>
     * </p>
     *
     * @return External Item Number
     */
    @SerializedName( "BR_NFExternalItemNumber" )
    @JsonProperty( "BR_NFExternalItemNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFExternalItemNumber" )
    private String bR_NFExternalItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExternalItemNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_EXTERNAL_ITEM_NUMBER =
        new BR_NFItemField<String>("BR_NFExternalItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_RECOPINumber</b>
     * </p>
     *
     * @return Registro e Controle das Operações com o Papel Imune
     */
    @SerializedName( "BR_RECOPINumber" )
    @JsonProperty( "BR_RECOPINumber" )
    @Nullable
    @ODataField( odataName = "BR_RECOPINumber" )
    private String bR_RECOPINumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_RECOPINumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRRECOPI_NUMBER = new BR_NFItemField<String>("BR_RECOPINumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSSuspensionProcess</b>
     * </p>
     *
     * @return Process Number
     */
    @SerializedName( "BR_ISSSuspensionProcess" )
    @JsonProperty( "BR_ISSSuspensionProcess" )
    @Nullable
    @ODataField( odataName = "BR_ISSSuspensionProcess" )
    private String bR_ISSSuspensionProcess;
    /**
     * Use with available fluent helpers to apply the <b>BR_ISSSuspensionProcess</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRISS_SUSPENSION_PROCESS =
        new BR_NFItemField<String>("BR_ISSSuspensionProcess");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTributaryQuantity</b>
     * </p>
     *
     * @return Tributary Quantity
     */
    @SerializedName( "BR_NFTributaryQuantity" )
    @JsonProperty( "BR_NFTributaryQuantity" )
    @Nullable
    @ODataField( odataName = "BR_NFTributaryQuantity" )
    private BigDecimal bR_NFTributaryQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTributaryQuantity</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_TRIBUTARY_QUANTITY =
        new BR_NFItemField<BigDecimal>("BR_NFTributaryQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTributaryUnit</b>
     * </p>
     *
     * @return Tributary Unit of Measure
     */
    @SerializedName( "BR_NFTributaryUnit" )
    @JsonProperty( "BR_NFTributaryUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFTributaryUnit" )
    private String bR_NFTributaryUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTributaryUnit</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_TRIBUTARY_UNIT = new BR_NFItemField<String>("BR_NFTributaryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPhysicalMvtOfMaterial</b>
     * </p>
     *
     * @return Material Movement
     */
    @SerializedName( "BR_NFIsPhysicalMvtOfMaterial" )
    @JsonProperty( "BR_NFIsPhysicalMvtOfMaterial" )
    @Nullable
    @ODataField( odataName = "BR_NFIsPhysicalMvtOfMaterial" )
    private String bR_NFIsPhysicalMvtOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsPhysicalMvtOfMaterial</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_IS_PHYSICAL_MVT_OF_MATERIAL =
        new BR_NFItemField<String>("BR_NFIsPhysicalMvtOfMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasTaxIncentive</b>
     * </p>
     *
     * @return Tax Incentive
     */
    @SerializedName( "BR_NFItemHasTaxIncentive" )
    @JsonProperty( "BR_NFItemHasTaxIncentive" )
    @Nullable
    @ODataField( odataName = "BR_NFItemHasTaxIncentive" )
    private String bR_NFItemHasTaxIncentive;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemHasTaxIncentive</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_ITEM_HAS_TAX_INCENTIVE =
        new BR_NFItemField<String>("BR_NFItemHasTaxIncentive");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPriceAmountWithTaxes</b>
     * </p>
     *
     * @return Net Price Including Tax
     */
    @SerializedName( "BR_NFPriceAmountWithTaxes" )
    @JsonProperty( "BR_NFPriceAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFPriceAmountWithTaxes" )
    private BigDecimal bR_NFPriceAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPriceAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_PRICE_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFPriceAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFValueAmountWithTaxes</b>
     * </p>
     *
     * @return Net Value including taxes
     */
    @SerializedName( "BR_NFValueAmountWithTaxes" )
    @JsonProperty( "BR_NFValueAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFValueAmountWithTaxes" )
    private BigDecimal bR_NFValueAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFValueAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_VALUE_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFValueAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDiscountAmountWithTaxes</b>
     * </p>
     *
     * @return Discount value including taxes
     */
    @SerializedName( "BR_NFDiscountAmountWithTaxes" )
    @JsonProperty( "BR_NFDiscountAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFDiscountAmountWithTaxes" )
    private BigDecimal bR_NFDiscountAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDiscountAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_DISCOUNT_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFDiscountAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFreightAmountWithTaxes</b>
     * </p>
     *
     * @return Freight value including taxes
     */
    @SerializedName( "BR_NFFreightAmountWithTaxes" )
    @JsonProperty( "BR_NFFreightAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFFreightAmountWithTaxes" )
    private BigDecimal bR_NFFreightAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFreightAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_FREIGHT_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFFreightAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFInsuranceAmountWithTaxes</b>
     * </p>
     *
     * @return Insurance value including taxes
     */
    @SerializedName( "BR_NFInsuranceAmountWithTaxes" )
    @JsonProperty( "BR_NFInsuranceAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFInsuranceAmountWithTaxes" )
    private BigDecimal bR_NFInsuranceAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFInsuranceAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_INSURANCE_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFInsuranceAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExpensesAmountWithTaxes</b>
     * </p>
     *
     * @return Expenses including taxes
     */
    @SerializedName( "BR_NFExpensesAmountWithTaxes" )
    @JsonProperty( "BR_NFExpensesAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFExpensesAmountWithTaxes" )
    private BigDecimal bR_NFExpensesAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExpensesAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_EXPENSES_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFExpensesAmountWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExemptedICMSWithTaxes</b>
     * </p>
     *
     * @return Exemption Value of ICMS Including Taxes
     */
    @SerializedName( "BR_NFExemptedICMSWithTaxes" )
    @JsonProperty( "BR_NFExemptedICMSWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFExemptedICMSWithTaxes" )
    private BigDecimal bR_NFExemptedICMSWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFExemptedICMSWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_EXEMPTED_ICMS_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFExemptedICMSWithTaxes");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmountWithTaxes</b>
     * </p>
     *
     * @return Net value/Freight/Insurance/Expenses/Discount
     */
    @SerializedName( "BR_NFTotalAmountWithTaxes" )
    @JsonProperty( "BR_NFTotalAmountWithTaxes" )
    @Nullable
    @ODataField( odataName = "BR_NFTotalAmountWithTaxes" )
    private BigDecimal bR_NFTotalAmountWithTaxes;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTotalAmountWithTaxes</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_TOTAL_AMOUNT_WITH_TAXES =
        new BR_NFItemField<BigDecimal>("BR_NFTotalAmountWithTaxes");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "BR_TaxCode" )
    @JsonProperty( "BR_TaxCode" )
    @Nullable
    @ODataField( odataName = "BR_TaxCode" )
    private String bR_TaxCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_TaxCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_TAX_CODE = new BR_NFItemField<String>("BR_TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ActivityNumber</b>
     * </p>
     *
     * @return Activity Number
     */
    @SerializedName( "ActivityNumber" )
    @JsonProperty( "ActivityNumber" )
    @Nullable
    @ODataField( odataName = "ActivityNumber" )
    private String activityNumber;
    /**
     * Use with available fluent helpers to apply the <b>ActivityNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> ACTIVITY_NUMBER = new BR_NFItemField<String>("ActivityNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditCalculationBaseCode</b>
     * </p>
     *
     * @return Credit Basis
     */
    @SerializedName( "CreditCalculationBaseCode" )
    @JsonProperty( "CreditCalculationBaseCode" )
    @Nullable
    @ODataField( odataName = "CreditCalculationBaseCode" )
    private String creditCalculationBaseCode;
    /**
     * Use with available fluent helpers to apply the <b>CreditCalculationBaseCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> CREDIT_CALCULATION_BASE_CODE =
        new BR_NFItemField<String>("CreditCalculationBaseCode");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReducnPctEffctvCalcBasis</b>
     * </p>
     *
     * @return Reduction Percentage of Effective Calculation Basis
     */
    @SerializedName( "BR_ReducnPctEffctvCalcBasis" )
    @JsonProperty( "BR_ReducnPctEffctvCalcBasis" )
    @Nullable
    @ODataField( odataName = "BR_ReducnPctEffctvCalcBasis" )
    private BigDecimal bR_ReducnPctEffctvCalcBasis;
    /**
     * Use with available fluent helpers to apply the <b>BR_ReducnPctEffctvCalcBasis</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_REDUCN_PCT_EFFCTV_CALC_BASIS =
        new BR_NFItemField<BigDecimal>("BR_ReducnPctEffctvCalcBasis");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffctvCalcBasisAmount</b>
     * </p>
     *
     * @return Effective Calculation Basis Amount
     */
    @SerializedName( "BR_EffctvCalcBasisAmount" )
    @JsonProperty( "BR_EffctvCalcBasisAmount" )
    @Nullable
    @ODataField( odataName = "BR_EffctvCalcBasisAmount" )
    private BigDecimal bR_EffctvCalcBasisAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_EffctvCalcBasisAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EFFCTV_CALC_BASIS_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_EffctvCalcBasisAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffectiveICMSRate</b>
     * </p>
     *
     * @return Effective ICMS Rate
     */
    @SerializedName( "BR_EffectiveICMSRate" )
    @JsonProperty( "BR_EffectiveICMSRate" )
    @Nullable
    @ODataField( odataName = "BR_EffectiveICMSRate" )
    private BigDecimal bR_EffectiveICMSRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_EffectiveICMSRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EFFECTIVE_ICMS_RATE =
        new BR_NFItemField<BigDecimal>("BR_EffectiveICMSRate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffectiveICMSAmount</b>
     * </p>
     *
     * @return Effective ICMS Amount
     */
    @SerializedName( "BR_EffectiveICMSAmount" )
    @JsonProperty( "BR_EffectiveICMSAmount" )
    @Nullable
    @ODataField( odataName = "BR_EffectiveICMSAmount" )
    private BigDecimal bR_EffectiveICMSAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_EffectiveICMSAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EFFECTIVE_ICMS_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_EffectiveICMSAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductionIsInRelevantScale</b>
     * </p>
     *
     * @return Scale Production Indicator
     */
    @SerializedName( "ProductionIsInRelevantScale" )
    @JsonProperty( "ProductionIsInRelevantScale" )
    @Nullable
    @ODataField( odataName = "ProductionIsInRelevantScale" )
    private String productionIsInRelevantScale;
    /**
     * Use with available fluent helpers to apply the <b>ProductionIsInRelevantScale</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> PRODUCTION_IS_IN_RELEVANT_SCALE =
        new BR_NFItemField<String>("ProductionIsInRelevantScale");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_ManufacturerCNPJ</b>
     * </p>
     *
     * @return Manufacturer CNPJ
     */
    @SerializedName( "BR_ManufacturerCNPJ" )
    @JsonProperty( "BR_ManufacturerCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_ManufacturerCNPJ" )
    private String bR_ManufacturerCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_ManufacturerCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_MANUFACTURER_CNPJ = new BR_NFItemField<String>("BR_ManufacturerCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TaxIncentiveCode</b>
     * </p>
     *
     * @return State Tax Incentive Code
     */
    @SerializedName( "TaxIncentiveCode" )
    @JsonProperty( "TaxIncentiveCode" )
    @Nullable
    @ODataField( odataName = "TaxIncentiveCode" )
    private String taxIncentiveCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxIncentiveCode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> TAX_INCENTIVE_CODE = new BR_NFItemField<String>("TaxIncentiveCode");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTDestTaxBaseAmount</b>
     * </p>
     *
     * @return ICMS ST Basis Destination State
     */
    @SerializedName( "BR_ICMSSTDestTaxBaseAmount" )
    @JsonProperty( "BR_ICMSSTDestTaxBaseAmount" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTDestTaxBaseAmount" )
    private BigDecimal bR_ICMSSTDestTaxBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTDestTaxBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMSST_DEST_TAX_BASE_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_ICMSSTDestTaxBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTDestTaxAmount</b>
     * </p>
     *
     * @return ICMS ST for Destination State
     */
    @SerializedName( "BR_ICMSSTDestTaxAmount" )
    @JsonProperty( "BR_ICMSSTDestTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTDestTaxAmount" )
    private BigDecimal bR_ICMSSTDestTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTDestTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMSST_DEST_TAX_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_ICMSSTDestTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSSTWithheldBaseAmt</b>
     * </p>
     *
     * @return Withheld FCP Calculation Basis
     */
    @SerializedName( "BR_FCPOnICMSSTWithheldBaseAmt" )
    @JsonProperty( "BR_FCPOnICMSSTWithheldBaseAmt" )
    @Nullable
    @ODataField( odataName = "BR_FCPOnICMSSTWithheldBaseAmt" )
    private BigDecimal bR_FCPOnICMSSTWithheldBaseAmt;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPOnICMSSTWithheldBaseAmt</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFCP_ON_ICMSST_WITHHELD_BASE_AMT =
        new BR_NFItemField<BigDecimal>("BR_FCPOnICMSSTWithheldBaseAmt");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPonICMSSTWithheldRate</b>
     * </p>
     *
     * @return Withheld FCP ST
     */
    @SerializedName( "BR_FCPonICMSSTWithheldRate" )
    @JsonProperty( "BR_FCPonICMSSTWithheldRate" )
    @Nullable
    @ODataField( odataName = "BR_FCPonICMSSTWithheldRate" )
    private BigDecimal bR_FCPonICMSSTWithheldRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPonICMSSTWithheldRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFC_PON_ICMSST_WITHHELD_RATE =
        new BR_NFItemField<BigDecimal>("BR_FCPonICMSSTWithheldRate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomsChargesAmount</b>
     * </p>
     *
     * @return Customs Expense Amount
     */
    @SerializedName( "CustomsChargesAmount" )
    @JsonProperty( "CustomsChargesAmount" )
    @Nullable
    @ODataField( odataName = "CustomsChargesAmount" )
    private BigDecimal customsChargesAmount;
    /**
     * Use with available fluent helpers to apply the <b>CustomsChargesAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> CUSTOMS_CHARGES_AMOUNT =
        new BR_NFItemField<BigDecimal>("CustomsChargesAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSSTWithheldAmount</b>
     * </p>
     *
     * @return Withheld FCP ST Amount
     */
    @SerializedName( "BR_FCPOnICMSSTWithheldAmount" )
    @JsonProperty( "BR_FCPOnICMSSTWithheldAmount" )
    @Nullable
    @ODataField( odataName = "BR_FCPOnICMSSTWithheldAmount" )
    private BigDecimal bR_FCPOnICMSSTWithheldAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPOnICMSSTWithheldAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFCP_ON_ICMSST_WITHHELD_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_FCPOnICMSSTWithheldAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_IOFTaxAmount</b>
     * </p>
     *
     * @return IOF Amount
     */
    @SerializedName( "BR_IOFTaxAmount" )
    @JsonProperty( "BR_IOFTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_IOFTaxAmount" )
    private BigDecimal bR_IOFTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_IOFTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRIOF_TAX_AMOUNT = new BR_NFItemField<BigDecimal>("BR_IOFTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTRateIncludingFCP</b>
     * </p>
     *
     * @return Final Consumer Rate
     */
    @SerializedName( "BR_ICMSSTRateIncludingFCP" )
    @JsonProperty( "BR_ICMSSTRateIncludingFCP" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTRateIncludingFCP" )
    private BigDecimal bR_ICMSSTRateIncludingFCP;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTRateIncludingFCP</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMSST_RATE_INCLUDING_FCP =
        new BR_NFItemField<BigDecimal>("BR_ICMSSTRateIncludingFCP");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeStatisticalAmount</b>
     * </p>
     *
     * @return Statistical Amount
     */
    @SerializedName( "BR_NFeStatisticalAmount" )
    @JsonProperty( "BR_NFeStatisticalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFeStatisticalAmount" )
    private BigDecimal bR_NFeStatisticalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeStatisticalAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRN_FE_STATISTICAL_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFeStatisticalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFItemField<String>("SalesDocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNAE</b>
     * </p>
     *
     * @return CNAE Code for Partner
     */
    @SerializedName( "BR_NFPartnerCNAE" )
    @JsonProperty( "BR_NFPartnerCNAE" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCNAE" )
    private String bR_NFPartnerCNAE;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCNAE</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_PARTNER_CNAE = new BR_NFItemField<String>("BR_NFPartnerCNAE");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNAE</b>
     * </p>
     *
     * @return CNAE Business Place Code
     */
    @SerializedName( "BR_BusinessPlaceCNAE" )
    @JsonProperty( "BR_BusinessPlaceCNAE" )
    @Nullable
    @ODataField( odataName = "BR_BusinessPlaceCNAE" )
    private String bR_BusinessPlaceCNAE;
    /**
     * Use with available fluent helpers to apply the <b>BR_BusinessPlaceCNAE</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_BUSINESS_PLACE_CNAE =
        new BR_NFItemField<String>("BR_BusinessPlaceCNAE");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFreightNature</b>
     * </p>
     *
     * @return Freight Nature Indicator
     */
    @SerializedName( "BR_NFFreightNature" )
    @JsonProperty( "BR_NFFreightNature" )
    @Nullable
    @ODataField( odataName = "BR_NFFreightNature" )
    private String bR_NFFreightNature;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFFreightNature</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_FREIGHT_NATURE = new BR_NFItemField<String>("BR_NFFreightNature");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_InternalBarcode</b>
     * </p>
     *
     * @return Internal Barcode
     */
    @SerializedName( "BR_InternalBarcode" )
    @JsonProperty( "BR_InternalBarcode" )
    @Nullable
    @ODataField( odataName = "BR_InternalBarcode" )
    private String bR_InternalBarcode;
    /**
     * Use with available fluent helpers to apply the <b>BR_InternalBarcode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_INTERNAL_BARCODE = new BR_NFItemField<String>("BR_InternalBarcode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_InternalTributaryBarcode</b>
     * </p>
     *
     * @return Internal Tributary Barcode
     */
    @SerializedName( "BR_InternalTributaryBarcode" )
    @JsonProperty( "BR_InternalTributaryBarcode" )
    @Nullable
    @ODataField( odataName = "BR_InternalTributaryBarcode" )
    private String bR_InternalTributaryBarcode;
    /**
     * Use with available fluent helpers to apply the <b>BR_InternalTributaryBarcode</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BR_INTERNAL_TRIBUTARY_BARCODE =
        new BR_NFItemField<String>("BR_InternalTributaryBarcode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPISSTInTotalAmount</b>
     * </p>
     *
     * @return Indicator of PIS ST in the Nota Fiscal Total
     */
    @SerializedName( "BR_NFIsPISSTInTotalAmount" )
    @JsonProperty( "BR_NFIsPISSTInTotalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFIsPISSTInTotalAmount" )
    private String bR_NFIsPISSTInTotalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsPISSTInTotalAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_IS_PISST_IN_TOTAL_AMOUNT =
        new BR_NFItemField<String>("BR_NFIsPISSTInTotalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISSTInNFTotal</b>
     * </p>
     *
     * @return Indicator of PIS ST in the Nota Fiscal Total
     */
    @SerializedName( "BR_PISSTInNFTotal" )
    @JsonProperty( "BR_PISSTInNFTotal" )
    @Nullable
    @ODataField( odataName = "BR_PISSTInNFTotal" )
    private String bR_PISSTInNFTotal;
    /**
     * Use with available fluent helpers to apply the <b>BR_PISSTInNFTotal</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRPISST_IN_NF_TOTAL = new BR_NFItemField<String>("BR_PISSTInNFTotal");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISSTTaxAmount</b>
     * </p>
     *
     * @return PIS ST Value
     */
    @SerializedName( "BR_PISSTTaxAmount" )
    @JsonProperty( "BR_PISSTTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_PISSTTaxAmount" )
    private BigDecimal bR_PISSTTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_PISSTTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRPISST_TAX_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_PISSTTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCOFINSSTInTotalAmount</b>
     * </p>
     *
     * @return Indicator of COFINS ST in the Nota Fiscal Total
     */
    @SerializedName( "BR_NFIsCOFINSSTInTotalAmount" )
    @JsonProperty( "BR_NFIsCOFINSSTInTotalAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFIsCOFINSSTInTotalAmount" )
    private String bR_NFIsCOFINSSTInTotalAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFIsCOFINSSTInTotalAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_IS_COFINSST_IN_TOTAL_AMOUNT =
        new BR_NFItemField<String>("BR_NFIsCOFINSSTInTotalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSSTInNFTotal</b>
     * </p>
     *
     * @return Indicator of COFINS ST in the Nota Fiscal Total
     */
    @SerializedName( "BR_COFINSSTInNFTotal" )
    @JsonProperty( "BR_COFINSSTInNFTotal" )
    @Nullable
    @ODataField( odataName = "BR_COFINSSTInNFTotal" )
    private String bR_COFINSSTInNFTotal;
    /**
     * Use with available fluent helpers to apply the <b>BR_COFINSSTInNFTotal</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRCOFINSST_IN_NF_TOTAL =
        new BR_NFItemField<String>("BR_COFINSSTInNFTotal");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSSTTaxAmount</b>
     * </p>
     *
     * @return COFINS ST Value
     */
    @SerializedName( "BR_COFINSSTTaxAmount" )
    @JsonProperty( "BR_COFINSSTTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_COFINSSTTaxAmount" )
    private BigDecimal bR_COFINSSTTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_COFINSSTTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRCOFINSST_TAX_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_COFINSSTTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDefermentPercent</b>
     * </p>
     *
     * @return ICMS Deferral Percentage
     */
    @SerializedName( "BR_ICMSDefermentPercent" )
    @JsonProperty( "BR_ICMSDefermentPercent" )
    @Nullable
    @ODataField( odataName = "BR_ICMSDefermentPercent" )
    private BigDecimal bR_ICMSDefermentPercent;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSDefermentPercent</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRICMS_DEFERMENT_PERCENT =
        new BR_NFItemField<BigDecimal>("BR_ICMSDefermentPercent");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDefermentAmount</b>
     * </p>
     *
     * @return Deferred FCP Amount
     */
    @SerializedName( "BR_FCPOnICMSDefermentAmount" )
    @JsonProperty( "BR_FCPOnICMSDefermentAmount" )
    @Nullable
    @ODataField( odataName = "BR_FCPOnICMSDefermentAmount" )
    private BigDecimal bR_FCPOnICMSDefermentAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPOnICMSDefermentAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFCP_ON_ICMS_DEFERMENT_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_FCPOnICMSDefermentAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDeferralTaxRate</b>
     * </p>
     *
     * @return Tax Rate for FCP Deferral
     */
    @SerializedName( "BR_FCPOnICMSDeferralTaxRate" )
    @JsonProperty( "BR_FCPOnICMSDeferralTaxRate" )
    @Nullable
    @ODataField( odataName = "BR_FCPOnICMSDeferralTaxRate" )
    private BigDecimal bR_FCPOnICMSDeferralTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPOnICMSDeferralTaxRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFCP_ON_ICMS_DEFERRAL_TAX_RATE =
        new BR_NFItemField<BigDecimal>("BR_FCPOnICMSDeferralTaxRate");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDefermentPercent</b>
     * </p>
     *
     * @return FCP Deferral Percentage
     */
    @SerializedName( "BR_FCPOnICMSDefermentPercent" )
    @JsonProperty( "BR_FCPOnICMSDefermentPercent" )
    @Nullable
    @ODataField( odataName = "BR_FCPOnICMSDefermentPercent" )
    private BigDecimal bR_FCPOnICMSDefermentPercent;
    /**
     * Use with available fluent helpers to apply the <b>BR_FCPOnICMSDefermentPercent</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRFCP_ON_ICMS_DEFERMENT_PERCENT =
        new BR_NFItemField<BigDecimal>("BR_FCPOnICMSDefermentPercent");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExemptedICMSSTAmount</b>
     * </p>
     *
     * @return Exemption Amount of ICMS ST
     */
    @SerializedName( "BR_ExemptedICMSSTAmount" )
    @JsonProperty( "BR_ExemptedICMSSTAmount" )
    @Nullable
    @ODataField( odataName = "BR_ExemptedICMSSTAmount" )
    private BigDecimal bR_ExemptedICMSSTAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_ExemptedICMSSTAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EXEMPTED_ICMSST_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_ExemptedICMSSTAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTExemptionReason</b>
     * </p>
     *
     * @return ICMS ST Exemption Reason
     */
    @SerializedName( "BR_ICMSSTExemptionReason" )
    @JsonProperty( "BR_ICMSSTExemptionReason" )
    @Nullable
    @ODataField( odataName = "BR_ICMSSTExemptionReason" )
    private String bR_ICMSSTExemptionReason;
    /**
     * Use with available fluent helpers to apply the <b>BR_ICMSSTExemptionReason</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRICMSST_EXEMPTION_REASON =
        new BR_NFItemField<String>("BR_ICMSSTExemptionReason");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExclICMSAmtFromPISAndCOFINS</b>
     * </p>
     *
     * @return ICMS Value Excluded from PIS/COFINS Calculation Base
     */
    @SerializedName( "BR_ExclICMSAmtFromPISAndCOFINS" )
    @JsonProperty( "BR_ExclICMSAmtFromPISAndCOFINS" )
    @Nullable
    @ODataField( odataName = "BR_ExclICMSAmtFromPISAndCOFINS" )
    private BigDecimal bR_ExclICMSAmtFromPISAndCOFINS;
    /**
     * Use with available fluent helpers to apply the <b>BR_ExclICMSAmtFromPISAndCOFINS</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BR_EXCL_ICMS_AMT_FROM_PIS_AND_COFINS =
        new BR_NFItemField<BigDecimal>("BR_ExclICMSAmtFromPISAndCOFINS");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSDeferredAmount</b>
     * </p>
     *
     * @return ICMS deferred amount
     */
    @SerializedName( "BR_NFMonoICMSDeferredAmount" )
    @JsonProperty( "BR_NFMonoICMSDeferredAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFMonoICMSDeferredAmount" )
    private BigDecimal bR_NFMonoICMSDeferredAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMonoICMSDeferredAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_MONO_ICMS_DEFERRED_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFMonoICMSDeferredAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSRetainedTaxRate</b>
     * </p>
     *
     * @return Ad rem tax rate of ICMS retained established for the product
     */
    @SerializedName( "BR_NFAdRemICMSRetainedTaxRate" )
    @JsonProperty( "BR_NFAdRemICMSRetainedTaxRate" )
    @Nullable
    @ODataField( odataName = "BR_NFAdRemICMSRetainedTaxRate" )
    private BigDecimal bR_NFAdRemICMSRetainedTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdRemICMSRetainedTaxRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_AD_REM_ICMS_RETAINED_TAX_RATE =
        new BR_NFItemField<BigDecimal>("BR_NFAdRemICMSRetainedTaxRate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSRetainedAmount</b>
     * </p>
     *
     * @return ICMS retained amount
     */
    @SerializedName( "BR_NFMonoICMSRetainedAmount" )
    @JsonProperty( "BR_NFMonoICMSRetainedAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFMonoICMSRetainedAmount" )
    private BigDecimal bR_NFMonoICMSRetainedAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMonoICMSRetainedAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_MONO_ICMS_RETAINED_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFMonoICMSRetainedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoRetainedTaxedQuantity</b>
     * </p>
     *
     * @return Retained taxed quantity
     */
    @SerializedName( "BR_NFMonoRetainedTaxedQuantity" )
    @JsonProperty( "BR_NFMonoRetainedTaxedQuantity" )
    @Nullable
    @ODataField( odataName = "BR_NFMonoRetainedTaxedQuantity" )
    private BigDecimal bR_NFMonoRetainedTaxedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMonoRetainedTaxedQuantity</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_MONO_RETAINED_TAXED_QUANTITY =
        new BR_NFItemField<BigDecimal>("BR_NFMonoRetainedTaxedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSReductionReason</b>
     * </p>
     *
     * @return Reason for ad rem reduction
     */
    @SerializedName( "BR_NFAdRemICMSReductionReason" )
    @JsonProperty( "BR_NFAdRemICMSReductionReason" )
    @Nullable
    @ODataField( odataName = "BR_NFAdRemICMSReductionReason" )
    private String bR_NFAdRemICMSReductionReason;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdRemICMSReductionReason</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_AD_REM_ICMS_REDUCTION_REASON =
        new BR_NFItemField<String>("BR_NFAdRemICMSReductionReason");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSReductionRate</b>
     * </p>
     *
     * @return ICMS ad rem percentage of reduction
     */
    @SerializedName( "BR_NFAdRemICMSReductionRate" )
    @JsonProperty( "BR_NFAdRemICMSReductionRate" )
    @Nullable
    @ODataField( odataName = "BR_NFAdRemICMSReductionRate" )
    private BigDecimal bR_NFAdRemICMSReductionRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdRemICMSReductionRate</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_AD_REM_ICMS_REDUCTION_RATE =
        new BR_NFItemField<BigDecimal>("BR_NFAdRemICMSReductionRate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSOperationAmount</b>
     * </p>
     *
     * @return ICMS operation amount
     */
    @SerializedName( "BR_NFMonoICMSOperationAmount" )
    @JsonProperty( "BR_NFMonoICMSOperationAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFMonoICMSOperationAmount" )
    private BigDecimal bR_NFMonoICMSOperationAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMonoICMSOperationAmount</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_MONO_ICMS_OPERATION_AMOUNT =
        new BR_NFItemField<BigDecimal>("BR_NFMonoICMSOperationAmount");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSDeferralPercent</b>
     * </p>
     *
     * @return ICMS ad rem deferral percentage
     */
    @SerializedName( "BR_NFAdRemICMSDeferralPercent" )
    @JsonProperty( "BR_NFAdRemICMSDeferralPercent" )
    @Nullable
    @ODataField( odataName = "BR_NFAdRemICMSDeferralPercent" )
    private BigDecimal bR_NFAdRemICMSDeferralPercent;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdRemICMSDeferralPercent</b> field to query operations.
     *
     */
    public final static BR_NFItemField<BigDecimal> BRNF_AD_REM_ICMS_DEFERRAL_PERCENT =
        new BR_NFItemField<BigDecimal>("BR_NFAdRemICMSDeferralPercent");
    /**
     * Constraints: Not nullable, Maximum length: 999
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMessageText</b>
     * </p>
     *
     * @return The bR_NFMessageText contained in this entity.
     */
    @SerializedName( "BR_NFMessageText" )
    @JsonProperty( "BR_NFMessageText" )
    @Nullable
    @ODataField( odataName = "BR_NFMessageText" )
    private String bR_NFMessageText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFMessageText</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_MESSAGE_TEXT = new BR_NFItemField<String>("BR_NFMessageText");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalProductInfoText</b>
     * </p>
     *
     * @return The bR_NFAdditionalProductInfoText contained in this entity.
     */
    @SerializedName( "BR_NFAdditionalProductInfoText" )
    @JsonProperty( "BR_NFAdditionalProductInfoText" )
    @Nullable
    @ODataField( odataName = "BR_NFAdditionalProductInfoText" )
    private String bR_NFAdditionalProductInfoText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFAdditionalProductInfoText</b> field to query operations.
     *
     */
    public final static BR_NFItemField<String> BRNF_ADDITIONAL_PRODUCT_INFO_TEXT =
        new BR_NFItemField<String>("BR_NFAdditionalProductInfoText");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFItem</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Navigation property <b>to_BR_NFAdditionImportDoc</b> for <b>BR_NFItem</b> to multiple
     * <b>BR_NFAdditionImportDoc</b>.
     *
     */
    @SerializedName( "to_BR_NFAdditionImportDoc" )
    @JsonProperty( "to_BR_NFAdditionImportDoc" )
    @ODataField( odataName = "to_BR_NFAdditionImportDoc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFAdditionImportDoc> toBR_NFAdditionImportDoc;
    /**
     * Navigation property <b>to_BR_NFePharmaceutical</b> for <b>BR_NFItem</b> to single <b>BR_NFePharmaceutical</b>.
     *
     */
    @SerializedName( "to_BR_NFePharmaceutical" )
    @JsonProperty( "to_BR_NFePharmaceutical" )
    @ODataField( odataName = "to_BR_NFePharmaceutical" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFePharmaceutical toBR_NFePharmaceutical;
    /**
     * Navigation property <b>to_BR_NFeProductTraceability</b> for <b>BR_NFItem</b> to multiple
     * <b>BR_NFeProductTraceability</b>.
     *
     */
    @SerializedName( "to_BR_NFeProductTraceability" )
    @JsonProperty( "to_BR_NFeProductTraceability" )
    @ODataField( odataName = "to_BR_NFeProductTraceability" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFeProductTraceability> toBR_NFeProductTraceability;
    /**
     * Navigation property <b>to_BR_NFExportDocument</b> for <b>BR_NFItem</b> to multiple <b>BR_NFExportDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFExportDocument" )
    @JsonProperty( "to_BR_NFExportDocument" )
    @ODataField( odataName = "to_BR_NFExportDocument" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFExportDocument> toBR_NFExportDocument;
    /**
     * Navigation property <b>to_BR_NFFuel</b> for <b>BR_NFItem</b> to single <b>BR_NFFuel</b>.
     *
     */
    @SerializedName( "to_BR_NFFuel" )
    @JsonProperty( "to_BR_NFFuel" )
    @ODataField( odataName = "to_BR_NFFuel" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFFuel toBR_NFFuel;
    /**
     * Navigation property <b>to_BR_NFFuelOriginIndicator</b> for <b>BR_NFItem</b> to multiple
     * <b>BR_NFFuelOriginIndicator</b>.
     *
     */
    @SerializedName( "to_BR_NFFuelOriginIndicator" )
    @JsonProperty( "to_BR_NFFuelOriginIndicator" )
    @ODataField( odataName = "to_BR_NFFuelOriginIndicator" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFFuelOriginIndicator> toBR_NFFuelOriginIndicator;
    /**
     * Navigation property <b>to_BR_NFItemAdditionalInfo</b> for <b>BR_NFItem</b> to multiple
     * <b>BR_NFItemAdditionalInfo</b>.
     *
     */
    @SerializedName( "to_BR_NFItemAdditionalInfo" )
    @JsonProperty( "to_BR_NFItemAdditionalInfo" )
    @ODataField( odataName = "to_BR_NFItemAdditionalInfo" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFItemAdditionalInfo> toBR_NFItemAdditionalInfo;
    /**
     * Navigation property <b>to_BR_NFItemNVE</b> for <b>BR_NFItem</b> to multiple <b>BR_NFItemNVE</b>.
     *
     */
    @SerializedName( "to_BR_NFItemNVE" )
    @JsonProperty( "to_BR_NFItemNVE" )
    @ODataField( odataName = "to_BR_NFItemNVE" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFItemNVE> toBR_NFItemNVE;
    /**
     * Navigation property <b>to_BR_NFItemText</b> for <b>BR_NFItem</b> to multiple <b>BR_NFItemText</b>.
     *
     */
    @SerializedName( "to_BR_NFItemText" )
    @JsonProperty( "to_BR_NFItemText" )
    @ODataField( odataName = "to_BR_NFItemText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFItemText> toBR_NFItemText;
    /**
     * Navigation property <b>to_BR_NFTax</b> for <b>BR_NFItem</b> to multiple <b>BR_NFTAX</b>.
     *
     */
    @SerializedName( "to_BR_NFTax" )
    @JsonProperty( "to_BR_NFTax" )
    @ODataField( odataName = "to_BR_NFTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BR_NFTAX> toBR_NFTax;
    /**
     * Navigation property <b>to_BR_NFVehicle</b> for <b>BR_NFItem</b> to single <b>BR_NFVehicle</b>.
     *
     */
    @SerializedName( "to_BR_NFVehicle" )
    @JsonProperty( "to_BR_NFVehicle" )
    @ODataField( odataName = "to_BR_NFVehicle" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFVehicle toBR_NFVehicle;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFItemOneToOneLink<BR_NFDocument>("to_BR_NFDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFAdditionImportDoc</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemLink<BR_NFAdditionImportDoc> TO_BRNF_ADDITION_IMPORT_DOC =
        new BR_NFItemLink<BR_NFAdditionImportDoc>("to_BR_NFAdditionImportDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFePharmaceutical</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemOneToOneLink<BR_NFePharmaceutical> TO_BRN_FE_PHARMACEUTICAL =
        new BR_NFItemOneToOneLink<BR_NFePharmaceutical>("to_BR_NFePharmaceutical");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFeProductTraceability</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemLink<BR_NFeProductTraceability> TO_BRN_FE_PRODUCT_TRACEABILITY =
        new BR_NFItemLink<BR_NFeProductTraceability>("to_BR_NFeProductTraceability");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFExportDocument</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemLink<BR_NFExportDocument> TO_BRNF_EXPORT_DOCUMENT =
        new BR_NFItemLink<BR_NFExportDocument>("to_BR_NFExportDocument");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFFuel</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemOneToOneLink<BR_NFFuel> TO_BRNF_FUEL =
        new BR_NFItemOneToOneLink<BR_NFFuel>("to_BR_NFFuel");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFFuelOriginIndicator</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemLink<BR_NFFuelOriginIndicator> TO_BRNF_FUEL_ORIGIN_INDICATOR =
        new BR_NFItemLink<BR_NFFuelOriginIndicator>("to_BR_NFFuelOriginIndicator");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItemAdditionalInfo</b> navigation property to query
     * operations.
     *
     */
    public final static BR_NFItemLink<BR_NFItemAdditionalInfo> TO_BRNF_ITEM_ADDITIONAL_INFO =
        new BR_NFItemLink<BR_NFItemAdditionalInfo>("to_BR_NFItemAdditionalInfo");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItemNVE</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemLink<BR_NFItemNVE> TO_BRNF_ITEM_NVE =
        new BR_NFItemLink<BR_NFItemNVE>("to_BR_NFItemNVE");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItemText</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemLink<BR_NFItemText> TO_BRNF_ITEM_TEXT =
        new BR_NFItemLink<BR_NFItemText>("to_BR_NFItemText");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFTax</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemLink<BR_NFTAX> TO_BRNF_TAX = new BR_NFItemLink<BR_NFTAX>("to_BR_NFTax");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFVehicle</b> navigation property to query operations.
     *
     */
    public final static BR_NFItemOneToOneLink<BR_NFVehicle> TO_BRNF_VEHICLE =
        new BR_NFItemOneToOneLink<BR_NFVehicle>("to_BR_NFVehicle");

    @Nonnull
    @Override
    public Class<BR_NFItem> getType()
    {
        return BR_NFItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSTaxSituation</b>
     * </p>
     *
     * @param bR_ICMSTaxSituation
     *            ICMS Tax Situation
     */
    public void setBR_ICMSTaxSituation( @Nullable final String bR_ICMSTaxSituation )
    {
        rememberChangedField("BR_ICMSTaxSituation", this.bR_ICMSTaxSituation);
        this.bR_ICMSTaxSituation = bR_ICMSTaxSituation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPITaxSituation</b>
     * </p>
     *
     * @param bR_IPITaxSituation
     *            IPI Tax Situation
     */
    public void setBR_IPITaxSituation( @Nullable final String bR_IPITaxSituation )
    {
        rememberChangedField("BR_IPITaxSituation", this.bR_IPITaxSituation);
        this.bR_IPITaxSituation = bR_IPITaxSituation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSTaxSituation</b>
     * </p>
     *
     * @param bR_ISSTaxSituation
     *            ISS Tax Situation
     */
    public void setBR_ISSTaxSituation( @Nullable final String bR_ISSTaxSituation )
    {
        rememberChangedField("BR_ISSTaxSituation", this.bR_ISSTaxSituation);
        this.bR_ISSTaxSituation = bR_ISSTaxSituation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSTaxSituation</b>
     * </p>
     *
     * @param bR_COFINSTaxSituation
     *            COFINS Tax Situation
     */
    public void setBR_COFINSTaxSituation( @Nullable final String bR_COFINSTaxSituation )
    {
        rememberChangedField("BR_COFINSTaxSituation", this.bR_COFINSTaxSituation);
        this.bR_COFINSTaxSituation = bR_COFINSTaxSituation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISTaxSituation</b>
     * </p>
     *
     * @param bR_PISTaxSituation
     *            PIS Tax Situation
     */
    public void setBR_PISTaxSituation( @Nullable final String bR_PISTaxSituation )
    {
        rememberChangedField("BR_PISTaxSituation", this.bR_PISTaxSituation);
        this.bR_PISTaxSituation = bR_PISTaxSituation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSBaseDetn</b>
     * </p>
     *
     * @param bR_ICMSBaseDetn
     *            ICMS Base Determination
     */
    public void setBR_ICMSBaseDetn( @Nullable final String bR_ICMSBaseDetn )
    {
        rememberChangedField("BR_ICMSBaseDetn", this.bR_ICMSBaseDetn);
        this.bR_ICMSBaseDetn = bR_ICMSBaseDetn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTBaseDetermination</b>
     * </p>
     *
     * @param bR_ICMSSTBaseDetermination
     *            ICMS ST Base Determination
     */
    public void setBR_ICMSSTBaseDetermination( @Nullable final String bR_ICMSSTBaseDetermination )
    {
        rememberChangedField("BR_ICMSSTBaseDetermination", this.bR_ICMSSTBaseDetermination);
        this.bR_ICMSSTBaseDetermination = bR_ICMSSTBaseDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTLegalClassfctn</b>
     * </p>
     *
     * @param bR_ICMSSTLegalClassfctn
     *            ICMS ST Legal Classification Code
     */
    public void setBR_ICMSSTLegalClassfctn( @Nullable final String bR_ICMSSTLegalClassfctn )
    {
        rememberChangedField("BR_ICMSSTLegalClassfctn", this.bR_ICMSSTLegalClassfctn);
        this.bR_ICMSSTLegalClassfctn = bR_ICMSSTLegalClassfctn;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_SubstituteICMSAmount</b>
     * </p>
     *
     * @param bR_SubstituteICMSAmount
     *            Substitute ICMS Amount Charged in Previous Transaction
     */
    public void setBR_SubstituteICMSAmount( @Nullable final BigDecimal bR_SubstituteICMSAmount )
    {
        rememberChangedField("BR_SubstituteICMSAmount", this.bR_SubstituteICMSAmount);
        this.bR_SubstituteICMSAmount = bR_SubstituteICMSAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSExemptionReason</b>
     * </p>
     *
     * @param bR_ICMSExemptionReason
     *            Exemption Reason
     */
    public void setBR_ICMSExemptionReason( @Nullable final String bR_ICMSExemptionReason )
    {
        rememberChangedField("BR_ICMSExemptionReason", this.bR_ICMSExemptionReason);
        this.bR_ICMSExemptionReason = bR_ICMSExemptionReason;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDefermentAmount</b>
     * </p>
     *
     * @param bR_ICMSDefermentAmount
     *            Deferment Amount
     */
    public void setBR_ICMSDefermentAmount( @Nullable final BigDecimal bR_ICMSDefermentAmount )
    {
        rememberChangedField("BR_ICMSDefermentAmount", this.bR_ICMSDefermentAmount);
        this.bR_ICMSDefermentAmount = bR_ICMSDefermentAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDeferralTaxRate</b>
     * </p>
     *
     * @param bR_ICMSDeferralTaxRate
     *            Tax Rate for ICMS Deferral
     */
    public void setBR_ICMSDeferralTaxRate( @Nullable final BigDecimal bR_ICMSDeferralTaxRate )
    {
        rememberChangedField("BR_ICMSDeferralTaxRate", this.bR_ICMSDeferralTaxRate);
        this.bR_ICMSDeferralTaxRate = bR_ICMSDeferralTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_WithholdingICMSSTBaseAmount</b>
     * </p>
     *
     * @param bR_WithholdingICMSSTBaseAmount
     *            Withholding ICMS ST Base
     */
    public void setBR_WithholdingICMSSTBaseAmount( @Nullable final BigDecimal bR_WithholdingICMSSTBaseAmount )
    {
        rememberChangedField("BR_WithholdingICMSSTBaseAmount", this.bR_WithholdingICMSSTBaseAmount);
        this.bR_WithholdingICMSSTBaseAmount = bR_WithholdingICMSSTBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_WithholdingICMSSTAmount</b>
     * </p>
     *
     * @param bR_WithholdingICMSSTAmount
     *            Withholding ICMS ST Amount
     */
    public void setBR_WithholdingICMSSTAmount( @Nullable final BigDecimal bR_WithholdingICMSSTAmount )
    {
        rememberChangedField("BR_WithholdingICMSSTAmount", this.bR_WithholdingICMSSTAmount);
        this.bR_WithholdingICMSSTAmount = bR_WithholdingICMSSTAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPILegalClassification</b>
     * </p>
     *
     * @param bR_IPILegalClassification
     *            IPI Classification Code
     */
    public void setBR_IPILegalClassification( @Nullable final String bR_IPILegalClassification )
    {
        rememberChangedField("BR_IPILegalClassification", this.bR_IPILegalClassification);
        this.bR_IPILegalClassification = bR_IPILegalClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_TobaccoBeverageIPIClassfctn</b>
     * </p>
     *
     * @param bR_TobaccoBeverageIPIClassfctn
     *            IPI Tobacco/Beverage
     */
    public void setBR_TobaccoBeverageIPIClassfctn( @Nullable final String bR_TobaccoBeverageIPIClassfctn )
    {
        rememberChangedField("BR_TobaccoBeverageIPIClassfctn", this.bR_TobaccoBeverageIPIClassfctn);
        this.bR_TobaccoBeverageIPIClassfctn = bR_TobaccoBeverageIPIClassfctn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPIControlSealCode</b>
     * </p>
     *
     * @param bR_IPIControlSealCode
     *            IPI Control Seal Code
     */
    public void setBR_IPIControlSealCode( @Nullable final String bR_IPIControlSealCode )
    {
        rememberChangedField("BR_IPIControlSealCode", this.bR_IPIControlSealCode);
        this.bR_IPIControlSealCode = bR_IPIControlSealCode;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPIControlSealQuantityValue</b>
     * </p>
     *
     * @param bR_IPIControlSealQuantityValue
     *            IPI Control Seal Quantity
     */
    public void setBR_IPIControlSealQuantityValue( @Nullable final BigDecimal bR_IPIControlSealQuantityValue )
    {
        rememberChangedField("BR_IPIControlSealQuantityValue", this.bR_IPIControlSealQuantityValue);
        this.bR_IPIControlSealQuantityValue = bR_IPIControlSealQuantityValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Centers
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Order Number
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Objects
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetFreightAmount</b>
     * </p>
     *
     * @param bR_NFNetFreightAmount
     *            Net freight value in document currency
     */
    public void setBR_NFNetFreightAmount( @Nullable final BigDecimal bR_NFNetFreightAmount )
    {
        rememberChangedField("BR_NFNetFreightAmount", this.bR_NFNetFreightAmount);
        this.bR_NFNetFreightAmount = bR_NFNetFreightAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetInsuranceAmount</b>
     * </p>
     *
     * @param bR_NFNetInsuranceAmount
     *            Net insurance value in document currency
     */
    public void setBR_NFNetInsuranceAmount( @Nullable final BigDecimal bR_NFNetInsuranceAmount )
    {
        rememberChangedField("BR_NFNetInsuranceAmount", this.bR_NFNetInsuranceAmount);
        this.bR_NFNetInsuranceAmount = bR_NFNetInsuranceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetOtherExpensesAmount</b>
     * </p>
     *
     * @param bR_NFNetOtherExpensesAmount
     *            Net expenses in document currency
     */
    public void setBR_NFNetOtherExpensesAmount( @Nullable final BigDecimal bR_NFNetOtherExpensesAmount )
    {
        rememberChangedField("BR_NFNetOtherExpensesAmount", this.bR_NFNetOtherExpensesAmount);
        this.bR_NFNetOtherExpensesAmount = bR_NFNetOtherExpensesAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price Including Tax
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetValueAmount</b>
     * </p>
     *
     * @param netValueAmount
     *            Net Amount
     */
    public void setNetValueAmount( @Nullable final BigDecimal netValueAmount )
    {
        rememberChangedField("NetValueAmount", this.netValueAmount);
        this.netValueAmount = netValueAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemType</b>
     * </p>
     *
     * @param bR_NFItemType
     *            NF Item Type
     */
    public void setBR_NFItemType( @Nullable final String bR_NFItemType )
    {
        rememberChangedField("BR_NFItemType", this.bR_NFItemType);
        this.bR_NFItemType = bR_NFItemType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSOrISSIsIncludedInPrice</b>
     * </p>
     *
     * @param bR_ICMSOrISSIsIncludedInPrice
     *            Value and price including ICMS/ISS
     */
    public void setBR_ICMSOrISSIsIncludedInPrice( @Nullable final Boolean bR_ICMSOrISSIsIncludedInPrice )
    {
        rememberChangedField("BR_ICMSOrISSIsIncludedInPrice", this.bR_ICMSOrISSIsIncludedInPrice);
        this.bR_ICMSOrISSIsIncludedInPrice = bR_ICMSOrISSIsIncludedInPrice;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemIsStatistical</b>
     * </p>
     *
     * @param bR_NFItemIsStatistical
     *            Statistical Item
     */
    public void setBR_NFItemIsStatistical( @Nullable final Boolean bR_NFItemIsStatistical )
    {
        rememberChangedField("BR_NFItemIsStatistical", this.bR_NFItemIsStatistical);
        this.bR_NFItemIsStatistical = bR_NFItemIsStatistical;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsServiceItem</b>
     * </p>
     *
     * @param bR_NFIsServiceItem
     *            Service tax - no ICMS/IPI calculation
     */
    public void setBR_NFIsServiceItem( @Nullable final Boolean bR_NFIsServiceItem )
    {
        rememberChangedField("BR_NFIsServiceItem", this.bR_NFIsServiceItem);
        this.bR_NFIsServiceItem = bR_NFIsServiceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCategory</b>
     * </p>
     *
     * @param bR_CFOPCategory
     *            Material CFOP category
     */
    public void setBR_CFOPCategory( @Nullable final String bR_CFOPCategory )
    {
        rememberChangedField("BR_CFOPCategory", this.bR_CFOPCategory);
        this.bR_CFOPCategory = bR_CFOPCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @param quantityInBaseUnit
     *            Quantity
     */
    public void setQuantityInBaseUnit( @Nullable final BigDecimal quantityInBaseUnit )
    {
        rememberChangedField("QuantityInBaseUnit", this.quantityInBaseUnit);
        this.quantityInBaseUnit = quantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentType</b>
     * </p>
     *
     * @param bR_NFSourceDocumentType
     *            Reference type
     */
    public void setBR_NFSourceDocumentType( @Nullable final String bR_NFSourceDocumentType )
    {
        rememberChangedField("BR_NFSourceDocumentType", this.bR_NFSourceDocumentType);
        this.bR_NFSourceDocumentType = bR_NFSourceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentNumber</b>
     * </p>
     *
     * @param bR_NFSourceDocumentNumber
     *            Source Document Key
     */
    public void setBR_NFSourceDocumentNumber( @Nullable final String bR_NFSourceDocumentNumber )
    {
        rememberChangedField("BR_NFSourceDocumentNumber", this.bR_NFSourceDocumentNumber);
        this.bR_NFSourceDocumentNumber = bR_NFSourceDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSourceDocumentItem</b>
     * </p>
     *
     * @param bR_NFSourceDocumentItem
     *            Reference item to source document
     */
    public void setBR_NFSourceDocumentItem( @Nullable final String bR_NFSourceDocumentItem )
    {
        rememberChangedField("BR_NFSourceDocumentItem", this.bR_NFSourceDocumentItem);
        this.bR_NFSourceDocumentItem = bR_NFSourceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReferenceNFNumber</b>
     * </p>
     *
     * @param bR_ReferenceNFNumber
     *            Reference NF
     */
    public void setBR_ReferenceNFNumber( @Nullable final String bR_ReferenceNFNumber )
    {
        rememberChangedField("BR_ReferenceNFNumber", this.bR_ReferenceNFNumber);
        this.bR_ReferenceNFNumber = bR_ReferenceNFNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReferenceNFItem</b>
     * </p>
     *
     * @param bR_ReferenceNFItem
     *            NF Reference Item
     */
    public void setBR_ReferenceNFItem( @Nullable final String bR_ReferenceNFItem )
    {
        rememberChangedField("BR_ReferenceNFItem", this.bR_ReferenceNFItem);
        this.bR_ReferenceNFItem = bR_ReferenceNFItem;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPercentReturned</b>
     * </p>
     *
     * @param bR_NFPercentReturned
     *            Quantity Returned
     */
    public void setBR_NFPercentReturned( @Nullable final BigDecimal bR_NFPercentReturned )
    {
        rememberChangedField("BR_NFPercentReturned", this.bR_NFPercentReturned);
        this.bR_NFPercentReturned = bR_NFPercentReturned;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFNetDiscountAmount</b>
     * </p>
     *
     * @param bR_NFNetDiscountAmount
     *            Net Discount Amount
     */
    public void setBR_NFNetDiscountAmount( @Nullable final BigDecimal bR_NFNetDiscountAmount )
    {
        rememberChangedField("BR_NFNetDiscountAmount", this.bR_NFNetDiscountAmount);
        this.bR_NFNetDiscountAmount = bR_NFNetDiscountAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExemptedICMSAmount</b>
     * </p>
     *
     * @param bR_ExemptedICMSAmount
     *            ICMS Exemption Amount
     */
    public void setBR_ExemptedICMSAmount( @Nullable final BigDecimal bR_ExemptedICMSAmount )
    {
        rememberChangedField("BR_ExemptedICMSAmount", this.bR_ExemptedICMSAmount);
        this.bR_ExemptedICMSAmount = bR_ExemptedICMSAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSStatisticalExemptionAmt</b>
     * </p>
     *
     * @param bR_ICMSStatisticalExemptionAmt
     *            Statistical Exemption Value of ICMS
     */
    public void setBR_ICMSStatisticalExemptionAmt( @Nullable final BigDecimal bR_ICMSStatisticalExemptionAmt )
    {
        rememberChangedField("BR_ICMSStatisticalExemptionAmt", this.bR_ICMSStatisticalExemptionAmt);
        this.bR_ICMSStatisticalExemptionAmt = bR_ICMSStatisticalExemptionAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTMarginAddedPercent</b>
     * </p>
     *
     * @param bR_ICMSSTMarginAddedPercent
     *            Margin percentage of value Added from ICMS ST
     */
    public void setBR_ICMSSTMarginAddedPercent( @Nullable final BigDecimal bR_ICMSSTMarginAddedPercent )
    {
        rememberChangedField("BR_ICMSSTMarginAddedPercent", this.bR_ICMSSTMarginAddedPercent);
        this.bR_ICMSSTMarginAddedPercent = bR_ICMSSTMarginAddedPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CPRBIsRelevant</b>
     * </p>
     *
     * @param bR_CPRBIsRelevant
     *            CPRB Relevance
     */
    public void setBR_CPRBIsRelevant( @Nullable final String bR_CPRBIsRelevant )
    {
        rememberChangedField("BR_CPRBIsRelevant", this.bR_CPRBIsRelevant);
        this.bR_CPRBIsRelevant = bR_CPRBIsRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmount</b>
     * </p>
     *
     * @param bR_NFTotalAmount
     *            Net value/Freight/Insurance/Expenses/Discount
     */
    public void setBR_NFTotalAmount( @Nullable final BigDecimal bR_NFTotalAmount )
    {
        rememberChangedField("BR_NFTotalAmount", this.bR_NFTotalAmount);
        this.bR_NFTotalAmount = bR_NFTotalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCode</b>
     * </p>
     *
     * @param bR_CFOPCode
     *            CFOP Code and Extension
     */
    public void setBR_CFOPCode( @Nullable final String bR_CFOPCode )
    {
        rememberChangedField("BR_CFOPCode", this.bR_CFOPCode);
        this.bR_CFOPCode = bR_CFOPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialOrigin</b>
     * </p>
     *
     * @param bR_MaterialOrigin
     *            Material Origin
     */
    public void setBR_MaterialOrigin( @Nullable final String bR_MaterialOrigin )
    {
        rememberChangedField("BR_MaterialOrigin", this.bR_MaterialOrigin);
        this.bR_MaterialOrigin = bR_MaterialOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialUsage</b>
     * </p>
     *
     * @param bR_MaterialUsage
     *            Material Usage
     */
    public void setBR_MaterialUsage( @Nullable final String bR_MaterialUsage )
    {
        rememberChangedField("BR_MaterialUsage", this.bR_MaterialUsage);
        this.bR_MaterialUsage = bR_MaterialUsage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProducedInhouse</b>
     * </p>
     *
     * @param isProducedInhouse
     *            Produced in-House
     */
    public void setIsProducedInhouse( @Nullable final Boolean isProducedInhouse )
    {
        rememberChangedField("IsProducedInhouse", this.isProducedInhouse);
        this.isProducedInhouse = isProducedInhouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>NCMCode</b>
     * </p>
     *
     * @param nCMCode
     *            Control Code
     */
    public void setNCMCode( @Nullable final String nCMCode )
    {
        rememberChangedField("NCMCode", this.nCMCode);
        this.nCMCode = nCMCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NBSCode</b>
     * </p>
     *
     * @param bR_NBSCode
     *            NBS Code
     */
    public void setBR_NBSCode( @Nullable final String bR_NBSCode )
    {
        rememberChangedField("BR_NBSCode", this.bR_NBSCode);
        this.bR_NBSCode = bR_NBSCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>BR_EFDREINFServiceCode</b>
     * </p>
     *
     * @param bR_EFDREINFServiceCode
     *            EFD-REINF Service Type Code
     */
    public void setBR_EFDREINFServiceCode( @Nullable final String bR_EFDREINFServiceCode )
    {
        rememberChangedField("BR_EFDREINFServiceCode", this.bR_EFDREINFServiceCode);
        this.bR_EFDREINFServiceCode = bR_EFDREINFServiceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BR_LC116ServiceCode</b>
     * </p>
     *
     * @param bR_LC116ServiceCode
     *            LC 116 Service Type Code
     */
    public void setBR_LC116ServiceCode( @Nullable final String bR_LC116ServiceCode )
    {
        rememberChangedField("BR_LC116ServiceCode", this.bR_LC116ServiceCode);
        this.bR_LC116ServiceCode = bR_LC116ServiceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSBenefitCode</b>
     * </p>
     *
     * @param bR_ISSBenefitCode
     *            Benefit Code for ISS Tax
     */
    public void setBR_ISSBenefitCode( @Nullable final String bR_ISSBenefitCode )
    {
        rememberChangedField("BR_ISSBenefitCode", this.bR_ISSBenefitCode);
        this.bR_ISSBenefitCode = bR_ISSBenefitCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_CSTISSCode</b>
     * </p>
     *
     * @param bR_CSTISSCode
     *            CST for ISS Defined by Municipality
     */
    public void setBR_CSTISSCode( @Nullable final String bR_CSTISSCode )
    {
        rememberChangedField("BR_CSTISSCode", this.bR_CSTISSCode);
        this.bR_CSTISSCode = bR_CSTISSCode;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFApproximateTotalTaxAmount</b>
     * </p>
     *
     * @param bR_NFApproximateTotalTaxAmount
     *            Approximate Tax
     */
    public void setBR_NFApproximateTotalTaxAmount( @Nullable final BigDecimal bR_NFApproximateTotalTaxAmount )
    {
        rememberChangedField("BR_NFApproximateTotalTaxAmount", this.bR_NFApproximateTotalTaxAmount);
        this.bR_NFApproximateTotalTaxAmount = bR_NFApproximateTotalTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCINumber</b>
     * </p>
     *
     * @param bR_FCINumber
     *            FCI Number
     */
    public void setBR_FCINumber( @Nullable final String bR_FCINumber )
    {
        rememberChangedField("BR_FCINumber", this.bR_FCINumber);
        this.bR_FCINumber = bR_FCINumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSTaxLaw</b>
     * </p>
     *
     * @param bR_ICMSTaxLaw
     *            Tax Law ICMS
     */
    public void setBR_ICMSTaxLaw( @Nullable final String bR_ICMSTaxLaw )
    {
        rememberChangedField("BR_ICMSTaxLaw", this.bR_ICMSTaxLaw);
        this.bR_ICMSTaxLaw = bR_ICMSTaxLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_IPITaxLaw</b>
     * </p>
     *
     * @param bR_IPITaxLaw
     *            Tax Law IPI
     */
    public void setBR_IPITaxLaw( @Nullable final String bR_IPITaxLaw )
    {
        rememberChangedField("BR_IPITaxLaw", this.bR_IPITaxLaw);
        this.bR_IPITaxLaw = bR_IPITaxLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSTaxLaw</b>
     * </p>
     *
     * @param bR_ISSTaxLaw
     *            ISS Tax Law
     */
    public void setBR_ISSTaxLaw( @Nullable final String bR_ISSTaxLaw )
    {
        rememberChangedField("BR_ISSTaxLaw", this.bR_ISSTaxLaw);
        this.bR_ISSTaxLaw = bR_ISSTaxLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSTaxLaw</b>
     * </p>
     *
     * @param bR_COFINSTaxLaw
     *            COFINS Tax Law
     */
    public void setBR_COFINSTaxLaw( @Nullable final String bR_COFINSTaxLaw )
    {
        rememberChangedField("BR_COFINSTaxLaw", this.bR_COFINSTaxLaw);
        this.bR_COFINSTaxLaw = bR_COFINSTaxLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISTaxLaw</b>
     * </p>
     *
     * @param bR_PISTaxLaw
     *            Tax Law PIS
     */
    public void setBR_PISTaxLaw( @Nullable final String bR_PISTaxLaw )
    {
        rememberChangedField("BR_PISTaxLaw", this.bR_PISTaxLaw);
        this.bR_PISTaxLaw = bR_PISTaxLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Purchase Order Item
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @param internationalArticleNumber
     *            European Article Number
     */
    public void setInternationalArticleNumber( @Nullable final String internationalArticleNumber )
    {
        rememberChangedField("InternationalArticleNumber", this.internationalArticleNumber);
        this.internationalArticleNumber = internationalArticleNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExternalItemNumber</b>
     * </p>
     *
     * @param bR_NFExternalItemNumber
     *            External Item Number
     */
    public void setBR_NFExternalItemNumber( @Nullable final String bR_NFExternalItemNumber )
    {
        rememberChangedField("BR_NFExternalItemNumber", this.bR_NFExternalItemNumber);
        this.bR_NFExternalItemNumber = bR_NFExternalItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_RECOPINumber</b>
     * </p>
     *
     * @param bR_RECOPINumber
     *            Registro e Controle das Operações com o Papel Imune
     */
    public void setBR_RECOPINumber( @Nullable final String bR_RECOPINumber )
    {
        rememberChangedField("BR_RECOPINumber", this.bR_RECOPINumber);
        this.bR_RECOPINumber = bR_RECOPINumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_ISSSuspensionProcess</b>
     * </p>
     *
     * @param bR_ISSSuspensionProcess
     *            Process Number
     */
    public void setBR_ISSSuspensionProcess( @Nullable final String bR_ISSSuspensionProcess )
    {
        rememberChangedField("BR_ISSSuspensionProcess", this.bR_ISSSuspensionProcess);
        this.bR_ISSSuspensionProcess = bR_ISSSuspensionProcess;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTributaryQuantity</b>
     * </p>
     *
     * @param bR_NFTributaryQuantity
     *            Tributary Quantity
     */
    public void setBR_NFTributaryQuantity( @Nullable final BigDecimal bR_NFTributaryQuantity )
    {
        rememberChangedField("BR_NFTributaryQuantity", this.bR_NFTributaryQuantity);
        this.bR_NFTributaryQuantity = bR_NFTributaryQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTributaryUnit</b>
     * </p>
     *
     * @param bR_NFTributaryUnit
     *            Tributary Unit of Measure
     */
    public void setBR_NFTributaryUnit( @Nullable final String bR_NFTributaryUnit )
    {
        rememberChangedField("BR_NFTributaryUnit", this.bR_NFTributaryUnit);
        this.bR_NFTributaryUnit = bR_NFTributaryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPhysicalMvtOfMaterial</b>
     * </p>
     *
     * @param bR_NFIsPhysicalMvtOfMaterial
     *            Material Movement
     */
    public void setBR_NFIsPhysicalMvtOfMaterial( @Nullable final String bR_NFIsPhysicalMvtOfMaterial )
    {
        rememberChangedField("BR_NFIsPhysicalMvtOfMaterial", this.bR_NFIsPhysicalMvtOfMaterial);
        this.bR_NFIsPhysicalMvtOfMaterial = bR_NFIsPhysicalMvtOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasTaxIncentive</b>
     * </p>
     *
     * @param bR_NFItemHasTaxIncentive
     *            Tax Incentive
     */
    public void setBR_NFItemHasTaxIncentive( @Nullable final String bR_NFItemHasTaxIncentive )
    {
        rememberChangedField("BR_NFItemHasTaxIncentive", this.bR_NFItemHasTaxIncentive);
        this.bR_NFItemHasTaxIncentive = bR_NFItemHasTaxIncentive;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPriceAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFPriceAmountWithTaxes
     *            Net Price Including Tax
     */
    public void setBR_NFPriceAmountWithTaxes( @Nullable final BigDecimal bR_NFPriceAmountWithTaxes )
    {
        rememberChangedField("BR_NFPriceAmountWithTaxes", this.bR_NFPriceAmountWithTaxes);
        this.bR_NFPriceAmountWithTaxes = bR_NFPriceAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFValueAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFValueAmountWithTaxes
     *            Net Value including taxes
     */
    public void setBR_NFValueAmountWithTaxes( @Nullable final BigDecimal bR_NFValueAmountWithTaxes )
    {
        rememberChangedField("BR_NFValueAmountWithTaxes", this.bR_NFValueAmountWithTaxes);
        this.bR_NFValueAmountWithTaxes = bR_NFValueAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDiscountAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFDiscountAmountWithTaxes
     *            Discount value including taxes
     */
    public void setBR_NFDiscountAmountWithTaxes( @Nullable final BigDecimal bR_NFDiscountAmountWithTaxes )
    {
        rememberChangedField("BR_NFDiscountAmountWithTaxes", this.bR_NFDiscountAmountWithTaxes);
        this.bR_NFDiscountAmountWithTaxes = bR_NFDiscountAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFreightAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFFreightAmountWithTaxes
     *            Freight value including taxes
     */
    public void setBR_NFFreightAmountWithTaxes( @Nullable final BigDecimal bR_NFFreightAmountWithTaxes )
    {
        rememberChangedField("BR_NFFreightAmountWithTaxes", this.bR_NFFreightAmountWithTaxes);
        this.bR_NFFreightAmountWithTaxes = bR_NFFreightAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFInsuranceAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFInsuranceAmountWithTaxes
     *            Insurance value including taxes
     */
    public void setBR_NFInsuranceAmountWithTaxes( @Nullable final BigDecimal bR_NFInsuranceAmountWithTaxes )
    {
        rememberChangedField("BR_NFInsuranceAmountWithTaxes", this.bR_NFInsuranceAmountWithTaxes);
        this.bR_NFInsuranceAmountWithTaxes = bR_NFInsuranceAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExpensesAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFExpensesAmountWithTaxes
     *            Expenses including taxes
     */
    public void setBR_NFExpensesAmountWithTaxes( @Nullable final BigDecimal bR_NFExpensesAmountWithTaxes )
    {
        rememberChangedField("BR_NFExpensesAmountWithTaxes", this.bR_NFExpensesAmountWithTaxes);
        this.bR_NFExpensesAmountWithTaxes = bR_NFExpensesAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFExemptedICMSWithTaxes</b>
     * </p>
     *
     * @param bR_NFExemptedICMSWithTaxes
     *            Exemption Value of ICMS Including Taxes
     */
    public void setBR_NFExemptedICMSWithTaxes( @Nullable final BigDecimal bR_NFExemptedICMSWithTaxes )
    {
        rememberChangedField("BR_NFExemptedICMSWithTaxes", this.bR_NFExemptedICMSWithTaxes);
        this.bR_NFExemptedICMSWithTaxes = bR_NFExemptedICMSWithTaxes;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTotalAmountWithTaxes</b>
     * </p>
     *
     * @param bR_NFTotalAmountWithTaxes
     *            Net value/Freight/Insurance/Expenses/Discount
     */
    public void setBR_NFTotalAmountWithTaxes( @Nullable final BigDecimal bR_NFTotalAmountWithTaxes )
    {
        rememberChangedField("BR_NFTotalAmountWithTaxes", this.bR_NFTotalAmountWithTaxes);
        this.bR_NFTotalAmountWithTaxes = bR_NFTotalAmountWithTaxes;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxCode</b>
     * </p>
     *
     * @param bR_TaxCode
     *            Tax on Sales/Purchases Code
     */
    public void setBR_TaxCode( @Nullable final String bR_TaxCode )
    {
        rememberChangedField("BR_TaxCode", this.bR_TaxCode);
        this.bR_TaxCode = bR_TaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ActivityNumber</b>
     * </p>
     *
     * @param activityNumber
     *            Activity Number
     */
    public void setActivityNumber( @Nullable final String activityNumber )
    {
        rememberChangedField("ActivityNumber", this.activityNumber);
        this.activityNumber = activityNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditCalculationBaseCode</b>
     * </p>
     *
     * @param creditCalculationBaseCode
     *            Credit Basis
     */
    public void setCreditCalculationBaseCode( @Nullable final String creditCalculationBaseCode )
    {
        rememberChangedField("CreditCalculationBaseCode", this.creditCalculationBaseCode);
        this.creditCalculationBaseCode = creditCalculationBaseCode;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ReducnPctEffctvCalcBasis</b>
     * </p>
     *
     * @param bR_ReducnPctEffctvCalcBasis
     *            Reduction Percentage of Effective Calculation Basis
     */
    public void setBR_ReducnPctEffctvCalcBasis( @Nullable final BigDecimal bR_ReducnPctEffctvCalcBasis )
    {
        rememberChangedField("BR_ReducnPctEffctvCalcBasis", this.bR_ReducnPctEffctvCalcBasis);
        this.bR_ReducnPctEffctvCalcBasis = bR_ReducnPctEffctvCalcBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffctvCalcBasisAmount</b>
     * </p>
     *
     * @param bR_EffctvCalcBasisAmount
     *            Effective Calculation Basis Amount
     */
    public void setBR_EffctvCalcBasisAmount( @Nullable final BigDecimal bR_EffctvCalcBasisAmount )
    {
        rememberChangedField("BR_EffctvCalcBasisAmount", this.bR_EffctvCalcBasisAmount);
        this.bR_EffctvCalcBasisAmount = bR_EffctvCalcBasisAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffectiveICMSRate</b>
     * </p>
     *
     * @param bR_EffectiveICMSRate
     *            Effective ICMS Rate
     */
    public void setBR_EffectiveICMSRate( @Nullable final BigDecimal bR_EffectiveICMSRate )
    {
        rememberChangedField("BR_EffectiveICMSRate", this.bR_EffectiveICMSRate);
        this.bR_EffectiveICMSRate = bR_EffectiveICMSRate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_EffectiveICMSAmount</b>
     * </p>
     *
     * @param bR_EffectiveICMSAmount
     *            Effective ICMS Amount
     */
    public void setBR_EffectiveICMSAmount( @Nullable final BigDecimal bR_EffectiveICMSAmount )
    {
        rememberChangedField("BR_EffectiveICMSAmount", this.bR_EffectiveICMSAmount);
        this.bR_EffectiveICMSAmount = bR_EffectiveICMSAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductionIsInRelevantScale</b>
     * </p>
     *
     * @param productionIsInRelevantScale
     *            Scale Production Indicator
     */
    public void setProductionIsInRelevantScale( @Nullable final String productionIsInRelevantScale )
    {
        rememberChangedField("ProductionIsInRelevantScale", this.productionIsInRelevantScale);
        this.productionIsInRelevantScale = productionIsInRelevantScale;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_ManufacturerCNPJ</b>
     * </p>
     *
     * @param bR_ManufacturerCNPJ
     *            Manufacturer CNPJ
     */
    public void setBR_ManufacturerCNPJ( @Nullable final String bR_ManufacturerCNPJ )
    {
        rememberChangedField("BR_ManufacturerCNPJ", this.bR_ManufacturerCNPJ);
        this.bR_ManufacturerCNPJ = bR_ManufacturerCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TaxIncentiveCode</b>
     * </p>
     *
     * @param taxIncentiveCode
     *            State Tax Incentive Code
     */
    public void setTaxIncentiveCode( @Nullable final String taxIncentiveCode )
    {
        rememberChangedField("TaxIncentiveCode", this.taxIncentiveCode);
        this.taxIncentiveCode = taxIncentiveCode;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTDestTaxBaseAmount</b>
     * </p>
     *
     * @param bR_ICMSSTDestTaxBaseAmount
     *            ICMS ST Basis Destination State
     */
    public void setBR_ICMSSTDestTaxBaseAmount( @Nullable final BigDecimal bR_ICMSSTDestTaxBaseAmount )
    {
        rememberChangedField("BR_ICMSSTDestTaxBaseAmount", this.bR_ICMSSTDestTaxBaseAmount);
        this.bR_ICMSSTDestTaxBaseAmount = bR_ICMSSTDestTaxBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTDestTaxAmount</b>
     * </p>
     *
     * @param bR_ICMSSTDestTaxAmount
     *            ICMS ST for Destination State
     */
    public void setBR_ICMSSTDestTaxAmount( @Nullable final BigDecimal bR_ICMSSTDestTaxAmount )
    {
        rememberChangedField("BR_ICMSSTDestTaxAmount", this.bR_ICMSSTDestTaxAmount);
        this.bR_ICMSSTDestTaxAmount = bR_ICMSSTDestTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSSTWithheldBaseAmt</b>
     * </p>
     *
     * @param bR_FCPOnICMSSTWithheldBaseAmt
     *            Withheld FCP Calculation Basis
     */
    public void setBR_FCPOnICMSSTWithheldBaseAmt( @Nullable final BigDecimal bR_FCPOnICMSSTWithheldBaseAmt )
    {
        rememberChangedField("BR_FCPOnICMSSTWithheldBaseAmt", this.bR_FCPOnICMSSTWithheldBaseAmt);
        this.bR_FCPOnICMSSTWithheldBaseAmt = bR_FCPOnICMSSTWithheldBaseAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPonICMSSTWithheldRate</b>
     * </p>
     *
     * @param bR_FCPonICMSSTWithheldRate
     *            Withheld FCP ST
     */
    public void setBR_FCPonICMSSTWithheldRate( @Nullable final BigDecimal bR_FCPonICMSSTWithheldRate )
    {
        rememberChangedField("BR_FCPonICMSSTWithheldRate", this.bR_FCPonICMSSTWithheldRate);
        this.bR_FCPonICMSSTWithheldRate = bR_FCPonICMSSTWithheldRate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomsChargesAmount</b>
     * </p>
     *
     * @param customsChargesAmount
     *            Customs Expense Amount
     */
    public void setCustomsChargesAmount( @Nullable final BigDecimal customsChargesAmount )
    {
        rememberChangedField("CustomsChargesAmount", this.customsChargesAmount);
        this.customsChargesAmount = customsChargesAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSSTWithheldAmount</b>
     * </p>
     *
     * @param bR_FCPOnICMSSTWithheldAmount
     *            Withheld FCP ST Amount
     */
    public void setBR_FCPOnICMSSTWithheldAmount( @Nullable final BigDecimal bR_FCPOnICMSSTWithheldAmount )
    {
        rememberChangedField("BR_FCPOnICMSSTWithheldAmount", this.bR_FCPOnICMSSTWithheldAmount);
        this.bR_FCPOnICMSSTWithheldAmount = bR_FCPOnICMSSTWithheldAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_IOFTaxAmount</b>
     * </p>
     *
     * @param bR_IOFTaxAmount
     *            IOF Amount
     */
    public void setBR_IOFTaxAmount( @Nullable final BigDecimal bR_IOFTaxAmount )
    {
        rememberChangedField("BR_IOFTaxAmount", this.bR_IOFTaxAmount);
        this.bR_IOFTaxAmount = bR_IOFTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTRateIncludingFCP</b>
     * </p>
     *
     * @param bR_ICMSSTRateIncludingFCP
     *            Final Consumer Rate
     */
    public void setBR_ICMSSTRateIncludingFCP( @Nullable final BigDecimal bR_ICMSSTRateIncludingFCP )
    {
        rememberChangedField("BR_ICMSSTRateIncludingFCP", this.bR_ICMSSTRateIncludingFCP);
        this.bR_ICMSSTRateIncludingFCP = bR_ICMSSTRateIncludingFCP;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeStatisticalAmount</b>
     * </p>
     *
     * @param bR_NFeStatisticalAmount
     *            Statistical Amount
     */
    public void setBR_NFeStatisticalAmount( @Nullable final BigDecimal bR_NFeStatisticalAmount )
    {
        rememberChangedField("BR_NFeStatisticalAmount", this.bR_NFeStatisticalAmount);
        this.bR_NFeStatisticalAmount = bR_NFeStatisticalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNAE</b>
     * </p>
     *
     * @param bR_NFPartnerCNAE
     *            CNAE Code for Partner
     */
    public void setBR_NFPartnerCNAE( @Nullable final String bR_NFPartnerCNAE )
    {
        rememberChangedField("BR_NFPartnerCNAE", this.bR_NFPartnerCNAE);
        this.bR_NFPartnerCNAE = bR_NFPartnerCNAE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BR_BusinessPlaceCNAE</b>
     * </p>
     *
     * @param bR_BusinessPlaceCNAE
     *            CNAE Business Place Code
     */
    public void setBR_BusinessPlaceCNAE( @Nullable final String bR_BusinessPlaceCNAE )
    {
        rememberChangedField("BR_BusinessPlaceCNAE", this.bR_BusinessPlaceCNAE);
        this.bR_BusinessPlaceCNAE = bR_BusinessPlaceCNAE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFFreightNature</b>
     * </p>
     *
     * @param bR_NFFreightNature
     *            Freight Nature Indicator
     */
    public void setBR_NFFreightNature( @Nullable final String bR_NFFreightNature )
    {
        rememberChangedField("BR_NFFreightNature", this.bR_NFFreightNature);
        this.bR_NFFreightNature = bR_NFFreightNature;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_InternalBarcode</b>
     * </p>
     *
     * @param bR_InternalBarcode
     *            Internal Barcode
     */
    public void setBR_InternalBarcode( @Nullable final String bR_InternalBarcode )
    {
        rememberChangedField("BR_InternalBarcode", this.bR_InternalBarcode);
        this.bR_InternalBarcode = bR_InternalBarcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BR_InternalTributaryBarcode</b>
     * </p>
     *
     * @param bR_InternalTributaryBarcode
     *            Internal Tributary Barcode
     */
    public void setBR_InternalTributaryBarcode( @Nullable final String bR_InternalTributaryBarcode )
    {
        rememberChangedField("BR_InternalTributaryBarcode", this.bR_InternalTributaryBarcode);
        this.bR_InternalTributaryBarcode = bR_InternalTributaryBarcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsPISSTInTotalAmount</b>
     * </p>
     *
     * @param bR_NFIsPISSTInTotalAmount
     *            Indicator of PIS ST in the Nota Fiscal Total
     */
    public void setBR_NFIsPISSTInTotalAmount( @Nullable final String bR_NFIsPISSTInTotalAmount )
    {
        rememberChangedField("BR_NFIsPISSTInTotalAmount", this.bR_NFIsPISSTInTotalAmount);
        this.bR_NFIsPISSTInTotalAmount = bR_NFIsPISSTInTotalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISSTInNFTotal</b>
     * </p>
     *
     * @param bR_PISSTInNFTotal
     *            Indicator of PIS ST in the Nota Fiscal Total
     */
    public void setBR_PISSTInNFTotal( @Nullable final String bR_PISSTInNFTotal )
    {
        rememberChangedField("BR_PISSTInNFTotal", this.bR_PISSTInNFTotal);
        this.bR_PISSTInNFTotal = bR_PISSTInNFTotal;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_PISSTTaxAmount</b>
     * </p>
     *
     * @param bR_PISSTTaxAmount
     *            PIS ST Value
     */
    public void setBR_PISSTTaxAmount( @Nullable final BigDecimal bR_PISSTTaxAmount )
    {
        rememberChangedField("BR_PISSTTaxAmount", this.bR_PISSTTaxAmount);
        this.bR_PISSTTaxAmount = bR_PISSTTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFIsCOFINSSTInTotalAmount</b>
     * </p>
     *
     * @param bR_NFIsCOFINSSTInTotalAmount
     *            Indicator of COFINS ST in the Nota Fiscal Total
     */
    public void setBR_NFIsCOFINSSTInTotalAmount( @Nullable final String bR_NFIsCOFINSSTInTotalAmount )
    {
        rememberChangedField("BR_NFIsCOFINSSTInTotalAmount", this.bR_NFIsCOFINSSTInTotalAmount);
        this.bR_NFIsCOFINSSTInTotalAmount = bR_NFIsCOFINSSTInTotalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSSTInNFTotal</b>
     * </p>
     *
     * @param bR_COFINSSTInNFTotal
     *            Indicator of COFINS ST in the Nota Fiscal Total
     */
    public void setBR_COFINSSTInNFTotal( @Nullable final String bR_COFINSSTInNFTotal )
    {
        rememberChangedField("BR_COFINSSTInNFTotal", this.bR_COFINSSTInNFTotal);
        this.bR_COFINSSTInNFTotal = bR_COFINSSTInNFTotal;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_COFINSSTTaxAmount</b>
     * </p>
     *
     * @param bR_COFINSSTTaxAmount
     *            COFINS ST Value
     */
    public void setBR_COFINSSTTaxAmount( @Nullable final BigDecimal bR_COFINSSTTaxAmount )
    {
        rememberChangedField("BR_COFINSSTTaxAmount", this.bR_COFINSSTTaxAmount);
        this.bR_COFINSSTTaxAmount = bR_COFINSSTTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSDefermentPercent</b>
     * </p>
     *
     * @param bR_ICMSDefermentPercent
     *            ICMS Deferral Percentage
     */
    public void setBR_ICMSDefermentPercent( @Nullable final BigDecimal bR_ICMSDefermentPercent )
    {
        rememberChangedField("BR_ICMSDefermentPercent", this.bR_ICMSDefermentPercent);
        this.bR_ICMSDefermentPercent = bR_ICMSDefermentPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDefermentAmount</b>
     * </p>
     *
     * @param bR_FCPOnICMSDefermentAmount
     *            Deferred FCP Amount
     */
    public void setBR_FCPOnICMSDefermentAmount( @Nullable final BigDecimal bR_FCPOnICMSDefermentAmount )
    {
        rememberChangedField("BR_FCPOnICMSDefermentAmount", this.bR_FCPOnICMSDefermentAmount);
        this.bR_FCPOnICMSDefermentAmount = bR_FCPOnICMSDefermentAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDeferralTaxRate</b>
     * </p>
     *
     * @param bR_FCPOnICMSDeferralTaxRate
     *            Tax Rate for FCP Deferral
     */
    public void setBR_FCPOnICMSDeferralTaxRate( @Nullable final BigDecimal bR_FCPOnICMSDeferralTaxRate )
    {
        rememberChangedField("BR_FCPOnICMSDeferralTaxRate", this.bR_FCPOnICMSDeferralTaxRate);
        this.bR_FCPOnICMSDeferralTaxRate = bR_FCPOnICMSDeferralTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_FCPOnICMSDefermentPercent</b>
     * </p>
     *
     * @param bR_FCPOnICMSDefermentPercent
     *            FCP Deferral Percentage
     */
    public void setBR_FCPOnICMSDefermentPercent( @Nullable final BigDecimal bR_FCPOnICMSDefermentPercent )
    {
        rememberChangedField("BR_FCPOnICMSDefermentPercent", this.bR_FCPOnICMSDefermentPercent);
        this.bR_FCPOnICMSDefermentPercent = bR_FCPOnICMSDefermentPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExemptedICMSSTAmount</b>
     * </p>
     *
     * @param bR_ExemptedICMSSTAmount
     *            Exemption Amount of ICMS ST
     */
    public void setBR_ExemptedICMSSTAmount( @Nullable final BigDecimal bR_ExemptedICMSSTAmount )
    {
        rememberChangedField("BR_ExemptedICMSSTAmount", this.bR_ExemptedICMSSTAmount);
        this.bR_ExemptedICMSSTAmount = bR_ExemptedICMSSTAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ICMSSTExemptionReason</b>
     * </p>
     *
     * @param bR_ICMSSTExemptionReason
     *            ICMS ST Exemption Reason
     */
    public void setBR_ICMSSTExemptionReason( @Nullable final String bR_ICMSSTExemptionReason )
    {
        rememberChangedField("BR_ICMSSTExemptionReason", this.bR_ICMSSTExemptionReason);
        this.bR_ICMSSTExemptionReason = bR_ICMSSTExemptionReason;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_ExclICMSAmtFromPISAndCOFINS</b>
     * </p>
     *
     * @param bR_ExclICMSAmtFromPISAndCOFINS
     *            ICMS Value Excluded from PIS/COFINS Calculation Base
     */
    public void setBR_ExclICMSAmtFromPISAndCOFINS( @Nullable final BigDecimal bR_ExclICMSAmtFromPISAndCOFINS )
    {
        rememberChangedField("BR_ExclICMSAmtFromPISAndCOFINS", this.bR_ExclICMSAmtFromPISAndCOFINS);
        this.bR_ExclICMSAmtFromPISAndCOFINS = bR_ExclICMSAmtFromPISAndCOFINS;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSDeferredAmount</b>
     * </p>
     *
     * @param bR_NFMonoICMSDeferredAmount
     *            ICMS deferred amount
     */
    public void setBR_NFMonoICMSDeferredAmount( @Nullable final BigDecimal bR_NFMonoICMSDeferredAmount )
    {
        rememberChangedField("BR_NFMonoICMSDeferredAmount", this.bR_NFMonoICMSDeferredAmount);
        this.bR_NFMonoICMSDeferredAmount = bR_NFMonoICMSDeferredAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSRetainedTaxRate</b>
     * </p>
     *
     * @param bR_NFAdRemICMSRetainedTaxRate
     *            Ad rem tax rate of ICMS retained established for the product
     */
    public void setBR_NFAdRemICMSRetainedTaxRate( @Nullable final BigDecimal bR_NFAdRemICMSRetainedTaxRate )
    {
        rememberChangedField("BR_NFAdRemICMSRetainedTaxRate", this.bR_NFAdRemICMSRetainedTaxRate);
        this.bR_NFAdRemICMSRetainedTaxRate = bR_NFAdRemICMSRetainedTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSRetainedAmount</b>
     * </p>
     *
     * @param bR_NFMonoICMSRetainedAmount
     *            ICMS retained amount
     */
    public void setBR_NFMonoICMSRetainedAmount( @Nullable final BigDecimal bR_NFMonoICMSRetainedAmount )
    {
        rememberChangedField("BR_NFMonoICMSRetainedAmount", this.bR_NFMonoICMSRetainedAmount);
        this.bR_NFMonoICMSRetainedAmount = bR_NFMonoICMSRetainedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoRetainedTaxedQuantity</b>
     * </p>
     *
     * @param bR_NFMonoRetainedTaxedQuantity
     *            Retained taxed quantity
     */
    public void setBR_NFMonoRetainedTaxedQuantity( @Nullable final BigDecimal bR_NFMonoRetainedTaxedQuantity )
    {
        rememberChangedField("BR_NFMonoRetainedTaxedQuantity", this.bR_NFMonoRetainedTaxedQuantity);
        this.bR_NFMonoRetainedTaxedQuantity = bR_NFMonoRetainedTaxedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSReductionReason</b>
     * </p>
     *
     * @param bR_NFAdRemICMSReductionReason
     *            Reason for ad rem reduction
     */
    public void setBR_NFAdRemICMSReductionReason( @Nullable final String bR_NFAdRemICMSReductionReason )
    {
        rememberChangedField("BR_NFAdRemICMSReductionReason", this.bR_NFAdRemICMSReductionReason);
        this.bR_NFAdRemICMSReductionReason = bR_NFAdRemICMSReductionReason;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSReductionRate</b>
     * </p>
     *
     * @param bR_NFAdRemICMSReductionRate
     *            ICMS ad rem percentage of reduction
     */
    public void setBR_NFAdRemICMSReductionRate( @Nullable final BigDecimal bR_NFAdRemICMSReductionRate )
    {
        rememberChangedField("BR_NFAdRemICMSReductionRate", this.bR_NFAdRemICMSReductionRate);
        this.bR_NFAdRemICMSReductionRate = bR_NFAdRemICMSReductionRate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMonoICMSOperationAmount</b>
     * </p>
     *
     * @param bR_NFMonoICMSOperationAmount
     *            ICMS operation amount
     */
    public void setBR_NFMonoICMSOperationAmount( @Nullable final BigDecimal bR_NFMonoICMSOperationAmount )
    {
        rememberChangedField("BR_NFMonoICMSOperationAmount", this.bR_NFMonoICMSOperationAmount);
        this.bR_NFMonoICMSOperationAmount = bR_NFMonoICMSOperationAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdRemICMSDeferralPercent</b>
     * </p>
     *
     * @param bR_NFAdRemICMSDeferralPercent
     *            ICMS ad rem deferral percentage
     */
    public void setBR_NFAdRemICMSDeferralPercent( @Nullable final BigDecimal bR_NFAdRemICMSDeferralPercent )
    {
        rememberChangedField("BR_NFAdRemICMSDeferralPercent", this.bR_NFAdRemICMSDeferralPercent);
        this.bR_NFAdRemICMSDeferralPercent = bR_NFAdRemICMSDeferralPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 999
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFMessageText</b>
     * </p>
     *
     * @param bR_NFMessageText
     *            The bR_NFMessageText to set.
     */
    public void setBR_NFMessageText( @Nullable final String bR_NFMessageText )
    {
        rememberChangedField("BR_NFMessageText", this.bR_NFMessageText);
        this.bR_NFMessageText = bR_NFMessageText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFAdditionalProductInfoText</b>
     * </p>
     *
     * @param bR_NFAdditionalProductInfoText
     *            The bR_NFAdditionalProductInfoText to set.
     */
    public void setBR_NFAdditionalProductInfoText( @Nullable final String bR_NFAdditionalProductInfoText )
    {
        rememberChangedField("BR_NFAdditionalProductInfoText", this.bR_NFAdditionalProductInfoText);
        this.bR_NFAdditionalProductInfoText = bR_NFAdditionalProductInfoText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("BR_ICMSTaxSituation", getBR_ICMSTaxSituation());
        values.put("BR_IPITaxSituation", getBR_IPITaxSituation());
        values.put("BR_ISSTaxSituation", getBR_ISSTaxSituation());
        values.put("BR_COFINSTaxSituation", getBR_COFINSTaxSituation());
        values.put("BR_PISTaxSituation", getBR_PISTaxSituation());
        values.put("BR_ICMSBaseDetn", getBR_ICMSBaseDetn());
        values.put("BR_ICMSSTBaseDetermination", getBR_ICMSSTBaseDetermination());
        values.put("BR_ICMSSTLegalClassfctn", getBR_ICMSSTLegalClassfctn());
        values.put("BR_SubstituteICMSAmount", getBR_SubstituteICMSAmount());
        values.put("BR_ICMSExemptionReason", getBR_ICMSExemptionReason());
        values.put("BR_ICMSDefermentAmount", getBR_ICMSDefermentAmount());
        values.put("BR_ICMSDeferralTaxRate", getBR_ICMSDeferralTaxRate());
        values.put("BR_WithholdingICMSSTBaseAmount", getBR_WithholdingICMSSTBaseAmount());
        values.put("BR_WithholdingICMSSTAmount", getBR_WithholdingICMSSTAmount());
        values.put("BR_IPILegalClassification", getBR_IPILegalClassification());
        values.put("BR_TobaccoBeverageIPIClassfctn", getBR_TobaccoBeverageIPIClassfctn());
        values.put("BR_IPIControlSealCode", getBR_IPIControlSealCode());
        values.put("BR_IPIControlSealQuantityValue", getBR_IPIControlSealQuantityValue());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("InternalOrder", getInternalOrder());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("CostObject", getCostObject());
        values.put("Segment", getSegment());
        values.put("BR_NFNetFreightAmount", getBR_NFNetFreightAmount());
        values.put("BR_NFNetInsuranceAmount", getBR_NFNetInsuranceAmount());
        values.put("BR_NFNetOtherExpensesAmount", getBR_NFNetOtherExpensesAmount());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetValueAmount", getNetValueAmount());
        values.put("BR_NFItemType", getBR_NFItemType());
        values.put("BR_ICMSOrISSIsIncludedInPrice", getBR_ICMSOrISSIsIncludedInPrice());
        values.put("BR_NFItemIsStatistical", getBR_NFItemIsStatistical());
        values.put("BR_NFIsServiceItem", getBR_NFIsServiceItem());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("BR_CFOPCategory", getBR_CFOPCategory());
        values.put("QuantityInBaseUnit", getQuantityInBaseUnit());
        values.put("BaseUnit", getBaseUnit());
        values.put("Plant", getPlant());
        values.put("Batch", getBatch());
        values.put("BR_NFSourceDocumentType", getBR_NFSourceDocumentType());
        values.put("BR_NFSourceDocumentNumber", getBR_NFSourceDocumentNumber());
        values.put("BR_NFSourceDocumentItem", getBR_NFSourceDocumentItem());
        values.put("BR_ReferenceNFNumber", getBR_ReferenceNFNumber());
        values.put("BR_ReferenceNFItem", getBR_ReferenceNFItem());
        values.put("BR_NFPercentReturned", getBR_NFPercentReturned());
        values.put("BR_NFNetDiscountAmount", getBR_NFNetDiscountAmount());
        values.put("BR_ExemptedICMSAmount", getBR_ExemptedICMSAmount());
        values.put("BR_ICMSStatisticalExemptionAmt", getBR_ICMSStatisticalExemptionAmt());
        values.put("BR_ICMSSTMarginAddedPercent", getBR_ICMSSTMarginAddedPercent());
        values.put("BR_CPRBIsRelevant", getBR_CPRBIsRelevant());
        values.put("BR_NFTotalAmount", getBR_NFTotalAmount());
        values.put("BR_CFOPCode", getBR_CFOPCode());
        values.put("BR_MaterialOrigin", getBR_MaterialOrigin());
        values.put("BR_MaterialUsage", getBR_MaterialUsage());
        values.put("IsProducedInhouse", getIsProducedInhouse());
        values.put("NCMCode", getNCMCode());
        values.put("BR_NBSCode", getBR_NBSCode());
        values.put("BR_EFDREINFServiceCode", getBR_EFDREINFServiceCode());
        values.put("BR_LC116ServiceCode", getBR_LC116ServiceCode());
        values.put("BR_ISSBenefitCode", getBR_ISSBenefitCode());
        values.put("BR_CSTISSCode", getBR_CSTISSCode());
        values.put("BR_NFApproximateTotalTaxAmount", getBR_NFApproximateTotalTaxAmount());
        values.put("BR_FCINumber", getBR_FCINumber());
        values.put("BR_ICMSTaxLaw", getBR_ICMSTaxLaw());
        values.put("BR_IPITaxLaw", getBR_IPITaxLaw());
        values.put("BR_ISSTaxLaw", getBR_ISSTaxLaw());
        values.put("BR_COFINSTaxLaw", getBR_COFINSTaxLaw());
        values.put("BR_PISTaxLaw", getBR_PISTaxLaw());
        values.put("GLAccount", getGLAccount());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("InternationalArticleNumber", getInternationalArticleNumber());
        values.put("BR_NFExternalItemNumber", getBR_NFExternalItemNumber());
        values.put("BR_RECOPINumber", getBR_RECOPINumber());
        values.put("BR_ISSSuspensionProcess", getBR_ISSSuspensionProcess());
        values.put("BR_NFTributaryQuantity", getBR_NFTributaryQuantity());
        values.put("BR_NFTributaryUnit", getBR_NFTributaryUnit());
        values.put("BR_NFIsPhysicalMvtOfMaterial", getBR_NFIsPhysicalMvtOfMaterial());
        values.put("BR_NFItemHasTaxIncentive", getBR_NFItemHasTaxIncentive());
        values.put("BR_NFPriceAmountWithTaxes", getBR_NFPriceAmountWithTaxes());
        values.put("BR_NFValueAmountWithTaxes", getBR_NFValueAmountWithTaxes());
        values.put("BR_NFDiscountAmountWithTaxes", getBR_NFDiscountAmountWithTaxes());
        values.put("BR_NFFreightAmountWithTaxes", getBR_NFFreightAmountWithTaxes());
        values.put("BR_NFInsuranceAmountWithTaxes", getBR_NFInsuranceAmountWithTaxes());
        values.put("BR_NFExpensesAmountWithTaxes", getBR_NFExpensesAmountWithTaxes());
        values.put("BR_NFExemptedICMSWithTaxes", getBR_NFExemptedICMSWithTaxes());
        values.put("BR_NFTotalAmountWithTaxes", getBR_NFTotalAmountWithTaxes());
        values.put("BR_TaxCode", getBR_TaxCode());
        values.put("ActivityNumber", getActivityNumber());
        values.put("CreditCalculationBaseCode", getCreditCalculationBaseCode());
        values.put("BR_ReducnPctEffctvCalcBasis", getBR_ReducnPctEffctvCalcBasis());
        values.put("BR_EffctvCalcBasisAmount", getBR_EffctvCalcBasisAmount());
        values.put("BR_EffectiveICMSRate", getBR_EffectiveICMSRate());
        values.put("BR_EffectiveICMSAmount", getBR_EffectiveICMSAmount());
        values.put("ProductionIsInRelevantScale", getProductionIsInRelevantScale());
        values.put("BR_ManufacturerCNPJ", getBR_ManufacturerCNPJ());
        values.put("TaxIncentiveCode", getTaxIncentiveCode());
        values.put("BR_ICMSSTDestTaxBaseAmount", getBR_ICMSSTDestTaxBaseAmount());
        values.put("BR_ICMSSTDestTaxAmount", getBR_ICMSSTDestTaxAmount());
        values.put("BR_FCPOnICMSSTWithheldBaseAmt", getBR_FCPOnICMSSTWithheldBaseAmt());
        values.put("BR_FCPonICMSSTWithheldRate", getBR_FCPonICMSSTWithheldRate());
        values.put("CustomsChargesAmount", getCustomsChargesAmount());
        values.put("BR_FCPOnICMSSTWithheldAmount", getBR_FCPOnICMSSTWithheldAmount());
        values.put("BR_IOFTaxAmount", getBR_IOFTaxAmount());
        values.put("BR_ICMSSTRateIncludingFCP", getBR_ICMSSTRateIncludingFCP());
        values.put("BR_NFeStatisticalAmount", getBR_NFeStatisticalAmount());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        values.put("BR_NFPartnerCNAE", getBR_NFPartnerCNAE());
        values.put("BR_BusinessPlaceCNAE", getBR_BusinessPlaceCNAE());
        values.put("BR_NFFreightNature", getBR_NFFreightNature());
        values.put("BR_InternalBarcode", getBR_InternalBarcode());
        values.put("BR_InternalTributaryBarcode", getBR_InternalTributaryBarcode());
        values.put("BR_NFIsPISSTInTotalAmount", getBR_NFIsPISSTInTotalAmount());
        values.put("BR_PISSTInNFTotal", getBR_PISSTInNFTotal());
        values.put("BR_PISSTTaxAmount", getBR_PISSTTaxAmount());
        values.put("BR_NFIsCOFINSSTInTotalAmount", getBR_NFIsCOFINSSTInTotalAmount());
        values.put("BR_COFINSSTInNFTotal", getBR_COFINSSTInNFTotal());
        values.put("BR_COFINSSTTaxAmount", getBR_COFINSSTTaxAmount());
        values.put("BR_ICMSDefermentPercent", getBR_ICMSDefermentPercent());
        values.put("BR_FCPOnICMSDefermentAmount", getBR_FCPOnICMSDefermentAmount());
        values.put("BR_FCPOnICMSDeferralTaxRate", getBR_FCPOnICMSDeferralTaxRate());
        values.put("BR_FCPOnICMSDefermentPercent", getBR_FCPOnICMSDefermentPercent());
        values.put("BR_ExemptedICMSSTAmount", getBR_ExemptedICMSSTAmount());
        values.put("BR_ICMSSTExemptionReason", getBR_ICMSSTExemptionReason());
        values.put("BR_ExclICMSAmtFromPISAndCOFINS", getBR_ExclICMSAmtFromPISAndCOFINS());
        values.put("BR_NFMonoICMSDeferredAmount", getBR_NFMonoICMSDeferredAmount());
        values.put("BR_NFAdRemICMSRetainedTaxRate", getBR_NFAdRemICMSRetainedTaxRate());
        values.put("BR_NFMonoICMSRetainedAmount", getBR_NFMonoICMSRetainedAmount());
        values.put("BR_NFMonoRetainedTaxedQuantity", getBR_NFMonoRetainedTaxedQuantity());
        values.put("BR_NFAdRemICMSReductionReason", getBR_NFAdRemICMSReductionReason());
        values.put("BR_NFAdRemICMSReductionRate", getBR_NFAdRemICMSReductionRate());
        values.put("BR_NFMonoICMSOperationAmount", getBR_NFMonoICMSOperationAmount());
        values.put("BR_NFAdRemICMSDeferralPercent", getBR_NFAdRemICMSDeferralPercent());
        values.put("BR_NFMessageText", getBR_NFMessageText());
        values.put("BR_NFAdditionalProductInfoText", getBR_NFAdditionalProductInfoText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSTaxSituation") ) {
                final Object value = values.remove("BR_ICMSTaxSituation");
                if( (value == null) || (!value.equals(getBR_ICMSTaxSituation())) ) {
                    setBR_ICMSTaxSituation(((String) value));
                }
            }
            if( values.containsKey("BR_IPITaxSituation") ) {
                final Object value = values.remove("BR_IPITaxSituation");
                if( (value == null) || (!value.equals(getBR_IPITaxSituation())) ) {
                    setBR_IPITaxSituation(((String) value));
                }
            }
            if( values.containsKey("BR_ISSTaxSituation") ) {
                final Object value = values.remove("BR_ISSTaxSituation");
                if( (value == null) || (!value.equals(getBR_ISSTaxSituation())) ) {
                    setBR_ISSTaxSituation(((String) value));
                }
            }
            if( values.containsKey("BR_COFINSTaxSituation") ) {
                final Object value = values.remove("BR_COFINSTaxSituation");
                if( (value == null) || (!value.equals(getBR_COFINSTaxSituation())) ) {
                    setBR_COFINSTaxSituation(((String) value));
                }
            }
            if( values.containsKey("BR_PISTaxSituation") ) {
                final Object value = values.remove("BR_PISTaxSituation");
                if( (value == null) || (!value.equals(getBR_PISTaxSituation())) ) {
                    setBR_PISTaxSituation(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSBaseDetn") ) {
                final Object value = values.remove("BR_ICMSBaseDetn");
                if( (value == null) || (!value.equals(getBR_ICMSBaseDetn())) ) {
                    setBR_ICMSBaseDetn(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSSTBaseDetermination") ) {
                final Object value = values.remove("BR_ICMSSTBaseDetermination");
                if( (value == null) || (!value.equals(getBR_ICMSSTBaseDetermination())) ) {
                    setBR_ICMSSTBaseDetermination(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSSTLegalClassfctn") ) {
                final Object value = values.remove("BR_ICMSSTLegalClassfctn");
                if( (value == null) || (!value.equals(getBR_ICMSSTLegalClassfctn())) ) {
                    setBR_ICMSSTLegalClassfctn(((String) value));
                }
            }
            if( values.containsKey("BR_SubstituteICMSAmount") ) {
                final Object value = values.remove("BR_SubstituteICMSAmount");
                if( (value == null) || (!value.equals(getBR_SubstituteICMSAmount())) ) {
                    setBR_SubstituteICMSAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSExemptionReason") ) {
                final Object value = values.remove("BR_ICMSExemptionReason");
                if( (value == null) || (!value.equals(getBR_ICMSExemptionReason())) ) {
                    setBR_ICMSExemptionReason(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSDefermentAmount") ) {
                final Object value = values.remove("BR_ICMSDefermentAmount");
                if( (value == null) || (!value.equals(getBR_ICMSDefermentAmount())) ) {
                    setBR_ICMSDefermentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSDeferralTaxRate") ) {
                final Object value = values.remove("BR_ICMSDeferralTaxRate");
                if( (value == null) || (!value.equals(getBR_ICMSDeferralTaxRate())) ) {
                    setBR_ICMSDeferralTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_WithholdingICMSSTBaseAmount") ) {
                final Object value = values.remove("BR_WithholdingICMSSTBaseAmount");
                if( (value == null) || (!value.equals(getBR_WithholdingICMSSTBaseAmount())) ) {
                    setBR_WithholdingICMSSTBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_WithholdingICMSSTAmount") ) {
                final Object value = values.remove("BR_WithholdingICMSSTAmount");
                if( (value == null) || (!value.equals(getBR_WithholdingICMSSTAmount())) ) {
                    setBR_WithholdingICMSSTAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_IPILegalClassification") ) {
                final Object value = values.remove("BR_IPILegalClassification");
                if( (value == null) || (!value.equals(getBR_IPILegalClassification())) ) {
                    setBR_IPILegalClassification(((String) value));
                }
            }
            if( values.containsKey("BR_TobaccoBeverageIPIClassfctn") ) {
                final Object value = values.remove("BR_TobaccoBeverageIPIClassfctn");
                if( (value == null) || (!value.equals(getBR_TobaccoBeverageIPIClassfctn())) ) {
                    setBR_TobaccoBeverageIPIClassfctn(((String) value));
                }
            }
            if( values.containsKey("BR_IPIControlSealCode") ) {
                final Object value = values.remove("BR_IPIControlSealCode");
                if( (value == null) || (!value.equals(getBR_IPIControlSealCode())) ) {
                    setBR_IPIControlSealCode(((String) value));
                }
            }
            if( values.containsKey("BR_IPIControlSealQuantityValue") ) {
                final Object value = values.remove("BR_IPIControlSealQuantityValue");
                if( (value == null) || (!value.equals(getBR_IPIControlSealQuantityValue())) ) {
                    setBR_IPIControlSealQuantityValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("BR_NFNetFreightAmount") ) {
                final Object value = values.remove("BR_NFNetFreightAmount");
                if( (value == null) || (!value.equals(getBR_NFNetFreightAmount())) ) {
                    setBR_NFNetFreightAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFNetInsuranceAmount") ) {
                final Object value = values.remove("BR_NFNetInsuranceAmount");
                if( (value == null) || (!value.equals(getBR_NFNetInsuranceAmount())) ) {
                    setBR_NFNetInsuranceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFNetOtherExpensesAmount") ) {
                final Object value = values.remove("BR_NFNetOtherExpensesAmount");
                if( (value == null) || (!value.equals(getBR_NFNetOtherExpensesAmount())) ) {
                    setBR_NFNetOtherExpensesAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetValueAmount") ) {
                final Object value = values.remove("NetValueAmount");
                if( (value == null) || (!value.equals(getNetValueAmount())) ) {
                    setNetValueAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemType") ) {
                final Object value = values.remove("BR_NFItemType");
                if( (value == null) || (!value.equals(getBR_NFItemType())) ) {
                    setBR_NFItemType(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSOrISSIsIncludedInPrice") ) {
                final Object value = values.remove("BR_ICMSOrISSIsIncludedInPrice");
                if( (value == null) || (!value.equals(getBR_ICMSOrISSIsIncludedInPrice())) ) {
                    setBR_ICMSOrISSIsIncludedInPrice(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFItemIsStatistical") ) {
                final Object value = values.remove("BR_NFItemIsStatistical");
                if( (value == null) || (!value.equals(getBR_NFItemIsStatistical())) ) {
                    setBR_NFItemIsStatistical(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFIsServiceItem") ) {
                final Object value = values.remove("BR_NFIsServiceItem");
                if( (value == null) || (!value.equals(getBR_NFIsServiceItem())) ) {
                    setBR_NFIsServiceItem(((Boolean) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("BR_CFOPCategory") ) {
                final Object value = values.remove("BR_CFOPCategory");
                if( (value == null) || (!value.equals(getBR_CFOPCategory())) ) {
                    setBR_CFOPCategory(((String) value));
                }
            }
            if( values.containsKey("QuantityInBaseUnit") ) {
                final Object value = values.remove("QuantityInBaseUnit");
                if( (value == null) || (!value.equals(getQuantityInBaseUnit())) ) {
                    setQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BR_NFSourceDocumentType") ) {
                final Object value = values.remove("BR_NFSourceDocumentType");
                if( (value == null) || (!value.equals(getBR_NFSourceDocumentType())) ) {
                    setBR_NFSourceDocumentType(((String) value));
                }
            }
            if( values.containsKey("BR_NFSourceDocumentNumber") ) {
                final Object value = values.remove("BR_NFSourceDocumentNumber");
                if( (value == null) || (!value.equals(getBR_NFSourceDocumentNumber())) ) {
                    setBR_NFSourceDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFSourceDocumentItem") ) {
                final Object value = values.remove("BR_NFSourceDocumentItem");
                if( (value == null) || (!value.equals(getBR_NFSourceDocumentItem())) ) {
                    setBR_NFSourceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BR_ReferenceNFNumber") ) {
                final Object value = values.remove("BR_ReferenceNFNumber");
                if( (value == null) || (!value.equals(getBR_ReferenceNFNumber())) ) {
                    setBR_ReferenceNFNumber(((String) value));
                }
            }
            if( values.containsKey("BR_ReferenceNFItem") ) {
                final Object value = values.remove("BR_ReferenceNFItem");
                if( (value == null) || (!value.equals(getBR_ReferenceNFItem())) ) {
                    setBR_ReferenceNFItem(((String) value));
                }
            }
            if( values.containsKey("BR_NFPercentReturned") ) {
                final Object value = values.remove("BR_NFPercentReturned");
                if( (value == null) || (!value.equals(getBR_NFPercentReturned())) ) {
                    setBR_NFPercentReturned(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFNetDiscountAmount") ) {
                final Object value = values.remove("BR_NFNetDiscountAmount");
                if( (value == null) || (!value.equals(getBR_NFNetDiscountAmount())) ) {
                    setBR_NFNetDiscountAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ExemptedICMSAmount") ) {
                final Object value = values.remove("BR_ExemptedICMSAmount");
                if( (value == null) || (!value.equals(getBR_ExemptedICMSAmount())) ) {
                    setBR_ExemptedICMSAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSStatisticalExemptionAmt") ) {
                final Object value = values.remove("BR_ICMSStatisticalExemptionAmt");
                if( (value == null) || (!value.equals(getBR_ICMSStatisticalExemptionAmt())) ) {
                    setBR_ICMSStatisticalExemptionAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSSTMarginAddedPercent") ) {
                final Object value = values.remove("BR_ICMSSTMarginAddedPercent");
                if( (value == null) || (!value.equals(getBR_ICMSSTMarginAddedPercent())) ) {
                    setBR_ICMSSTMarginAddedPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_CPRBIsRelevant") ) {
                final Object value = values.remove("BR_CPRBIsRelevant");
                if( (value == null) || (!value.equals(getBR_CPRBIsRelevant())) ) {
                    setBR_CPRBIsRelevant(((String) value));
                }
            }
            if( values.containsKey("BR_NFTotalAmount") ) {
                final Object value = values.remove("BR_NFTotalAmount");
                if( (value == null) || (!value.equals(getBR_NFTotalAmount())) ) {
                    setBR_NFTotalAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_CFOPCode") ) {
                final Object value = values.remove("BR_CFOPCode");
                if( (value == null) || (!value.equals(getBR_CFOPCode())) ) {
                    setBR_CFOPCode(((String) value));
                }
            }
            if( values.containsKey("BR_MaterialOrigin") ) {
                final Object value = values.remove("BR_MaterialOrigin");
                if( (value == null) || (!value.equals(getBR_MaterialOrigin())) ) {
                    setBR_MaterialOrigin(((String) value));
                }
            }
            if( values.containsKey("BR_MaterialUsage") ) {
                final Object value = values.remove("BR_MaterialUsage");
                if( (value == null) || (!value.equals(getBR_MaterialUsage())) ) {
                    setBR_MaterialUsage(((String) value));
                }
            }
            if( values.containsKey("IsProducedInhouse") ) {
                final Object value = values.remove("IsProducedInhouse");
                if( (value == null) || (!value.equals(getIsProducedInhouse())) ) {
                    setIsProducedInhouse(((Boolean) value));
                }
            }
            if( values.containsKey("NCMCode") ) {
                final Object value = values.remove("NCMCode");
                if( (value == null) || (!value.equals(getNCMCode())) ) {
                    setNCMCode(((String) value));
                }
            }
            if( values.containsKey("BR_NBSCode") ) {
                final Object value = values.remove("BR_NBSCode");
                if( (value == null) || (!value.equals(getBR_NBSCode())) ) {
                    setBR_NBSCode(((String) value));
                }
            }
            if( values.containsKey("BR_EFDREINFServiceCode") ) {
                final Object value = values.remove("BR_EFDREINFServiceCode");
                if( (value == null) || (!value.equals(getBR_EFDREINFServiceCode())) ) {
                    setBR_EFDREINFServiceCode(((String) value));
                }
            }
            if( values.containsKey("BR_LC116ServiceCode") ) {
                final Object value = values.remove("BR_LC116ServiceCode");
                if( (value == null) || (!value.equals(getBR_LC116ServiceCode())) ) {
                    setBR_LC116ServiceCode(((String) value));
                }
            }
            if( values.containsKey("BR_ISSBenefitCode") ) {
                final Object value = values.remove("BR_ISSBenefitCode");
                if( (value == null) || (!value.equals(getBR_ISSBenefitCode())) ) {
                    setBR_ISSBenefitCode(((String) value));
                }
            }
            if( values.containsKey("BR_CSTISSCode") ) {
                final Object value = values.remove("BR_CSTISSCode");
                if( (value == null) || (!value.equals(getBR_CSTISSCode())) ) {
                    setBR_CSTISSCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFApproximateTotalTaxAmount") ) {
                final Object value = values.remove("BR_NFApproximateTotalTaxAmount");
                if( (value == null) || (!value.equals(getBR_NFApproximateTotalTaxAmount())) ) {
                    setBR_NFApproximateTotalTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCINumber") ) {
                final Object value = values.remove("BR_FCINumber");
                if( (value == null) || (!value.equals(getBR_FCINumber())) ) {
                    setBR_FCINumber(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSTaxLaw") ) {
                final Object value = values.remove("BR_ICMSTaxLaw");
                if( (value == null) || (!value.equals(getBR_ICMSTaxLaw())) ) {
                    setBR_ICMSTaxLaw(((String) value));
                }
            }
            if( values.containsKey("BR_IPITaxLaw") ) {
                final Object value = values.remove("BR_IPITaxLaw");
                if( (value == null) || (!value.equals(getBR_IPITaxLaw())) ) {
                    setBR_IPITaxLaw(((String) value));
                }
            }
            if( values.containsKey("BR_ISSTaxLaw") ) {
                final Object value = values.remove("BR_ISSTaxLaw");
                if( (value == null) || (!value.equals(getBR_ISSTaxLaw())) ) {
                    setBR_ISSTaxLaw(((String) value));
                }
            }
            if( values.containsKey("BR_COFINSTaxLaw") ) {
                final Object value = values.remove("BR_COFINSTaxLaw");
                if( (value == null) || (!value.equals(getBR_COFINSTaxLaw())) ) {
                    setBR_COFINSTaxLaw(((String) value));
                }
            }
            if( values.containsKey("BR_PISTaxLaw") ) {
                final Object value = values.remove("BR_PISTaxLaw");
                if( (value == null) || (!value.equals(getBR_PISTaxLaw())) ) {
                    setBR_PISTaxLaw(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumber") ) {
                final Object value = values.remove("InternationalArticleNumber");
                if( (value == null) || (!value.equals(getInternationalArticleNumber())) ) {
                    setInternationalArticleNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFExternalItemNumber") ) {
                final Object value = values.remove("BR_NFExternalItemNumber");
                if( (value == null) || (!value.equals(getBR_NFExternalItemNumber())) ) {
                    setBR_NFExternalItemNumber(((String) value));
                }
            }
            if( values.containsKey("BR_RECOPINumber") ) {
                final Object value = values.remove("BR_RECOPINumber");
                if( (value == null) || (!value.equals(getBR_RECOPINumber())) ) {
                    setBR_RECOPINumber(((String) value));
                }
            }
            if( values.containsKey("BR_ISSSuspensionProcess") ) {
                final Object value = values.remove("BR_ISSSuspensionProcess");
                if( (value == null) || (!value.equals(getBR_ISSSuspensionProcess())) ) {
                    setBR_ISSSuspensionProcess(((String) value));
                }
            }
            if( values.containsKey("BR_NFTributaryQuantity") ) {
                final Object value = values.remove("BR_NFTributaryQuantity");
                if( (value == null) || (!value.equals(getBR_NFTributaryQuantity())) ) {
                    setBR_NFTributaryQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFTributaryUnit") ) {
                final Object value = values.remove("BR_NFTributaryUnit");
                if( (value == null) || (!value.equals(getBR_NFTributaryUnit())) ) {
                    setBR_NFTributaryUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsPhysicalMvtOfMaterial") ) {
                final Object value = values.remove("BR_NFIsPhysicalMvtOfMaterial");
                if( (value == null) || (!value.equals(getBR_NFIsPhysicalMvtOfMaterial())) ) {
                    setBR_NFIsPhysicalMvtOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemHasTaxIncentive") ) {
                final Object value = values.remove("BR_NFItemHasTaxIncentive");
                if( (value == null) || (!value.equals(getBR_NFItemHasTaxIncentive())) ) {
                    setBR_NFItemHasTaxIncentive(((String) value));
                }
            }
            if( values.containsKey("BR_NFPriceAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFPriceAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFPriceAmountWithTaxes())) ) {
                    setBR_NFPriceAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFValueAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFValueAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFValueAmountWithTaxes())) ) {
                    setBR_NFValueAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFDiscountAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFDiscountAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFDiscountAmountWithTaxes())) ) {
                    setBR_NFDiscountAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFFreightAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFFreightAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFFreightAmountWithTaxes())) ) {
                    setBR_NFFreightAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFInsuranceAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFInsuranceAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFInsuranceAmountWithTaxes())) ) {
                    setBR_NFInsuranceAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFExpensesAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFExpensesAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFExpensesAmountWithTaxes())) ) {
                    setBR_NFExpensesAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFExemptedICMSWithTaxes") ) {
                final Object value = values.remove("BR_NFExemptedICMSWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFExemptedICMSWithTaxes())) ) {
                    setBR_NFExemptedICMSWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFTotalAmountWithTaxes") ) {
                final Object value = values.remove("BR_NFTotalAmountWithTaxes");
                if( (value == null) || (!value.equals(getBR_NFTotalAmountWithTaxes())) ) {
                    setBR_NFTotalAmountWithTaxes(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_TaxCode") ) {
                final Object value = values.remove("BR_TaxCode");
                if( (value == null) || (!value.equals(getBR_TaxCode())) ) {
                    setBR_TaxCode(((String) value));
                }
            }
            if( values.containsKey("ActivityNumber") ) {
                final Object value = values.remove("ActivityNumber");
                if( (value == null) || (!value.equals(getActivityNumber())) ) {
                    setActivityNumber(((String) value));
                }
            }
            if( values.containsKey("CreditCalculationBaseCode") ) {
                final Object value = values.remove("CreditCalculationBaseCode");
                if( (value == null) || (!value.equals(getCreditCalculationBaseCode())) ) {
                    setCreditCalculationBaseCode(((String) value));
                }
            }
            if( values.containsKey("BR_ReducnPctEffctvCalcBasis") ) {
                final Object value = values.remove("BR_ReducnPctEffctvCalcBasis");
                if( (value == null) || (!value.equals(getBR_ReducnPctEffctvCalcBasis())) ) {
                    setBR_ReducnPctEffctvCalcBasis(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_EffctvCalcBasisAmount") ) {
                final Object value = values.remove("BR_EffctvCalcBasisAmount");
                if( (value == null) || (!value.equals(getBR_EffctvCalcBasisAmount())) ) {
                    setBR_EffctvCalcBasisAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_EffectiveICMSRate") ) {
                final Object value = values.remove("BR_EffectiveICMSRate");
                if( (value == null) || (!value.equals(getBR_EffectiveICMSRate())) ) {
                    setBR_EffectiveICMSRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_EffectiveICMSAmount") ) {
                final Object value = values.remove("BR_EffectiveICMSAmount");
                if( (value == null) || (!value.equals(getBR_EffectiveICMSAmount())) ) {
                    setBR_EffectiveICMSAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionIsInRelevantScale") ) {
                final Object value = values.remove("ProductionIsInRelevantScale");
                if( (value == null) || (!value.equals(getProductionIsInRelevantScale())) ) {
                    setProductionIsInRelevantScale(((String) value));
                }
            }
            if( values.containsKey("BR_ManufacturerCNPJ") ) {
                final Object value = values.remove("BR_ManufacturerCNPJ");
                if( (value == null) || (!value.equals(getBR_ManufacturerCNPJ())) ) {
                    setBR_ManufacturerCNPJ(((String) value));
                }
            }
            if( values.containsKey("TaxIncentiveCode") ) {
                final Object value = values.remove("TaxIncentiveCode");
                if( (value == null) || (!value.equals(getTaxIncentiveCode())) ) {
                    setTaxIncentiveCode(((String) value));
                }
            }
            if( values.containsKey("BR_ICMSSTDestTaxBaseAmount") ) {
                final Object value = values.remove("BR_ICMSSTDestTaxBaseAmount");
                if( (value == null) || (!value.equals(getBR_ICMSSTDestTaxBaseAmount())) ) {
                    setBR_ICMSSTDestTaxBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSSTDestTaxAmount") ) {
                final Object value = values.remove("BR_ICMSSTDestTaxAmount");
                if( (value == null) || (!value.equals(getBR_ICMSSTDestTaxAmount())) ) {
                    setBR_ICMSSTDestTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPOnICMSSTWithheldBaseAmt") ) {
                final Object value = values.remove("BR_FCPOnICMSSTWithheldBaseAmt");
                if( (value == null) || (!value.equals(getBR_FCPOnICMSSTWithheldBaseAmt())) ) {
                    setBR_FCPOnICMSSTWithheldBaseAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPonICMSSTWithheldRate") ) {
                final Object value = values.remove("BR_FCPonICMSSTWithheldRate");
                if( (value == null) || (!value.equals(getBR_FCPonICMSSTWithheldRate())) ) {
                    setBR_FCPonICMSSTWithheldRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomsChargesAmount") ) {
                final Object value = values.remove("CustomsChargesAmount");
                if( (value == null) || (!value.equals(getCustomsChargesAmount())) ) {
                    setCustomsChargesAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPOnICMSSTWithheldAmount") ) {
                final Object value = values.remove("BR_FCPOnICMSSTWithheldAmount");
                if( (value == null) || (!value.equals(getBR_FCPOnICMSSTWithheldAmount())) ) {
                    setBR_FCPOnICMSSTWithheldAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_IOFTaxAmount") ) {
                final Object value = values.remove("BR_IOFTaxAmount");
                if( (value == null) || (!value.equals(getBR_IOFTaxAmount())) ) {
                    setBR_IOFTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSSTRateIncludingFCP") ) {
                final Object value = values.remove("BR_ICMSSTRateIncludingFCP");
                if( (value == null) || (!value.equals(getBR_ICMSSTRateIncludingFCP())) ) {
                    setBR_ICMSSTRateIncludingFCP(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFeStatisticalAmount") ) {
                final Object value = values.remove("BR_NFeStatisticalAmount");
                if( (value == null) || (!value.equals(getBR_NFeStatisticalAmount())) ) {
                    setBR_NFeStatisticalAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCNAE") ) {
                final Object value = values.remove("BR_NFPartnerCNAE");
                if( (value == null) || (!value.equals(getBR_NFPartnerCNAE())) ) {
                    setBR_NFPartnerCNAE(((String) value));
                }
            }
            if( values.containsKey("BR_BusinessPlaceCNAE") ) {
                final Object value = values.remove("BR_BusinessPlaceCNAE");
                if( (value == null) || (!value.equals(getBR_BusinessPlaceCNAE())) ) {
                    setBR_BusinessPlaceCNAE(((String) value));
                }
            }
            if( values.containsKey("BR_NFFreightNature") ) {
                final Object value = values.remove("BR_NFFreightNature");
                if( (value == null) || (!value.equals(getBR_NFFreightNature())) ) {
                    setBR_NFFreightNature(((String) value));
                }
            }
            if( values.containsKey("BR_InternalBarcode") ) {
                final Object value = values.remove("BR_InternalBarcode");
                if( (value == null) || (!value.equals(getBR_InternalBarcode())) ) {
                    setBR_InternalBarcode(((String) value));
                }
            }
            if( values.containsKey("BR_InternalTributaryBarcode") ) {
                final Object value = values.remove("BR_InternalTributaryBarcode");
                if( (value == null) || (!value.equals(getBR_InternalTributaryBarcode())) ) {
                    setBR_InternalTributaryBarcode(((String) value));
                }
            }
            if( values.containsKey("BR_NFIsPISSTInTotalAmount") ) {
                final Object value = values.remove("BR_NFIsPISSTInTotalAmount");
                if( (value == null) || (!value.equals(getBR_NFIsPISSTInTotalAmount())) ) {
                    setBR_NFIsPISSTInTotalAmount(((String) value));
                }
            }
            if( values.containsKey("BR_PISSTInNFTotal") ) {
                final Object value = values.remove("BR_PISSTInNFTotal");
                if( (value == null) || (!value.equals(getBR_PISSTInNFTotal())) ) {
                    setBR_PISSTInNFTotal(((String) value));
                }
            }
            if( values.containsKey("BR_PISSTTaxAmount") ) {
                final Object value = values.remove("BR_PISSTTaxAmount");
                if( (value == null) || (!value.equals(getBR_PISSTTaxAmount())) ) {
                    setBR_PISSTTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFIsCOFINSSTInTotalAmount") ) {
                final Object value = values.remove("BR_NFIsCOFINSSTInTotalAmount");
                if( (value == null) || (!value.equals(getBR_NFIsCOFINSSTInTotalAmount())) ) {
                    setBR_NFIsCOFINSSTInTotalAmount(((String) value));
                }
            }
            if( values.containsKey("BR_COFINSSTInNFTotal") ) {
                final Object value = values.remove("BR_COFINSSTInNFTotal");
                if( (value == null) || (!value.equals(getBR_COFINSSTInNFTotal())) ) {
                    setBR_COFINSSTInNFTotal(((String) value));
                }
            }
            if( values.containsKey("BR_COFINSSTTaxAmount") ) {
                final Object value = values.remove("BR_COFINSSTTaxAmount");
                if( (value == null) || (!value.equals(getBR_COFINSSTTaxAmount())) ) {
                    setBR_COFINSSTTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSDefermentPercent") ) {
                final Object value = values.remove("BR_ICMSDefermentPercent");
                if( (value == null) || (!value.equals(getBR_ICMSDefermentPercent())) ) {
                    setBR_ICMSDefermentPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPOnICMSDefermentAmount") ) {
                final Object value = values.remove("BR_FCPOnICMSDefermentAmount");
                if( (value == null) || (!value.equals(getBR_FCPOnICMSDefermentAmount())) ) {
                    setBR_FCPOnICMSDefermentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPOnICMSDeferralTaxRate") ) {
                final Object value = values.remove("BR_FCPOnICMSDeferralTaxRate");
                if( (value == null) || (!value.equals(getBR_FCPOnICMSDeferralTaxRate())) ) {
                    setBR_FCPOnICMSDeferralTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_FCPOnICMSDefermentPercent") ) {
                final Object value = values.remove("BR_FCPOnICMSDefermentPercent");
                if( (value == null) || (!value.equals(getBR_FCPOnICMSDefermentPercent())) ) {
                    setBR_FCPOnICMSDefermentPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ExemptedICMSSTAmount") ) {
                final Object value = values.remove("BR_ExemptedICMSSTAmount");
                if( (value == null) || (!value.equals(getBR_ExemptedICMSSTAmount())) ) {
                    setBR_ExemptedICMSSTAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_ICMSSTExemptionReason") ) {
                final Object value = values.remove("BR_ICMSSTExemptionReason");
                if( (value == null) || (!value.equals(getBR_ICMSSTExemptionReason())) ) {
                    setBR_ICMSSTExemptionReason(((String) value));
                }
            }
            if( values.containsKey("BR_ExclICMSAmtFromPISAndCOFINS") ) {
                final Object value = values.remove("BR_ExclICMSAmtFromPISAndCOFINS");
                if( (value == null) || (!value.equals(getBR_ExclICMSAmtFromPISAndCOFINS())) ) {
                    setBR_ExclICMSAmtFromPISAndCOFINS(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFMonoICMSDeferredAmount") ) {
                final Object value = values.remove("BR_NFMonoICMSDeferredAmount");
                if( (value == null) || (!value.equals(getBR_NFMonoICMSDeferredAmount())) ) {
                    setBR_NFMonoICMSDeferredAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFAdRemICMSRetainedTaxRate") ) {
                final Object value = values.remove("BR_NFAdRemICMSRetainedTaxRate");
                if( (value == null) || (!value.equals(getBR_NFAdRemICMSRetainedTaxRate())) ) {
                    setBR_NFAdRemICMSRetainedTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFMonoICMSRetainedAmount") ) {
                final Object value = values.remove("BR_NFMonoICMSRetainedAmount");
                if( (value == null) || (!value.equals(getBR_NFMonoICMSRetainedAmount())) ) {
                    setBR_NFMonoICMSRetainedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFMonoRetainedTaxedQuantity") ) {
                final Object value = values.remove("BR_NFMonoRetainedTaxedQuantity");
                if( (value == null) || (!value.equals(getBR_NFMonoRetainedTaxedQuantity())) ) {
                    setBR_NFMonoRetainedTaxedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFAdRemICMSReductionReason") ) {
                final Object value = values.remove("BR_NFAdRemICMSReductionReason");
                if( (value == null) || (!value.equals(getBR_NFAdRemICMSReductionReason())) ) {
                    setBR_NFAdRemICMSReductionReason(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdRemICMSReductionRate") ) {
                final Object value = values.remove("BR_NFAdRemICMSReductionRate");
                if( (value == null) || (!value.equals(getBR_NFAdRemICMSReductionRate())) ) {
                    setBR_NFAdRemICMSReductionRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFMonoICMSOperationAmount") ) {
                final Object value = values.remove("BR_NFMonoICMSOperationAmount");
                if( (value == null) || (!value.equals(getBR_NFMonoICMSOperationAmount())) ) {
                    setBR_NFMonoICMSOperationAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFAdRemICMSDeferralPercent") ) {
                final Object value = values.remove("BR_NFAdRemICMSDeferralPercent");
                if( (value == null) || (!value.equals(getBR_NFAdRemICMSDeferralPercent())) ) {
                    setBR_NFAdRemICMSDeferralPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFMessageText") ) {
                final Object value = values.remove("BR_NFMessageText");
                if( (value == null) || (!value.equals(getBR_NFMessageText())) ) {
                    setBR_NFMessageText(((String) value));
                }
            }
            if( values.containsKey("BR_NFAdditionalProductInfoText") ) {
                final Object value = values.remove("BR_NFAdditionalProductInfoText");
                if( (value == null) || (!value.equals(getBR_NFAdditionalProductInfoText())) ) {
                    setBR_NFAdditionalProductInfoText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFAdditionImportDoc") ) {
                final Object value = (values).remove("to_BR_NFAdditionImportDoc");
                if( value instanceof Iterable ) {
                    if( toBR_NFAdditionImportDoc == null ) {
                        toBR_NFAdditionImportDoc = Lists.newArrayList();
                    } else {
                        toBR_NFAdditionImportDoc = Lists.newArrayList(toBR_NFAdditionImportDoc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFAdditionImportDoc entity;
                        if( toBR_NFAdditionImportDoc.size() > i ) {
                            entity = toBR_NFAdditionImportDoc.get(i);
                        } else {
                            entity = new BR_NFAdditionImportDoc();
                            toBR_NFAdditionImportDoc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFePharmaceutical") ) {
                final Object value = (values).remove("to_BR_NFePharmaceutical");
                if( value instanceof Map ) {
                    if( toBR_NFePharmaceutical == null ) {
                        toBR_NFePharmaceutical = new BR_NFePharmaceutical();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFePharmaceutical.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFeProductTraceability") ) {
                final Object value = (values).remove("to_BR_NFeProductTraceability");
                if( value instanceof Iterable ) {
                    if( toBR_NFeProductTraceability == null ) {
                        toBR_NFeProductTraceability = Lists.newArrayList();
                    } else {
                        toBR_NFeProductTraceability = Lists.newArrayList(toBR_NFeProductTraceability);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFeProductTraceability entity;
                        if( toBR_NFeProductTraceability.size() > i ) {
                            entity = toBR_NFeProductTraceability.get(i);
                        } else {
                            entity = new BR_NFeProductTraceability();
                            toBR_NFeProductTraceability.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFExportDocument") ) {
                final Object value = (values).remove("to_BR_NFExportDocument");
                if( value instanceof Iterable ) {
                    if( toBR_NFExportDocument == null ) {
                        toBR_NFExportDocument = Lists.newArrayList();
                    } else {
                        toBR_NFExportDocument = Lists.newArrayList(toBR_NFExportDocument);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFExportDocument entity;
                        if( toBR_NFExportDocument.size() > i ) {
                            entity = toBR_NFExportDocument.get(i);
                        } else {
                            entity = new BR_NFExportDocument();
                            toBR_NFExportDocument.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFFuel") ) {
                final Object value = (values).remove("to_BR_NFFuel");
                if( value instanceof Map ) {
                    if( toBR_NFFuel == null ) {
                        toBR_NFFuel = new BR_NFFuel();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFFuel.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFFuelOriginIndicator") ) {
                final Object value = (values).remove("to_BR_NFFuelOriginIndicator");
                if( value instanceof Iterable ) {
                    if( toBR_NFFuelOriginIndicator == null ) {
                        toBR_NFFuelOriginIndicator = Lists.newArrayList();
                    } else {
                        toBR_NFFuelOriginIndicator = Lists.newArrayList(toBR_NFFuelOriginIndicator);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFFuelOriginIndicator entity;
                        if( toBR_NFFuelOriginIndicator.size() > i ) {
                            entity = toBR_NFFuelOriginIndicator.get(i);
                        } else {
                            entity = new BR_NFFuelOriginIndicator();
                            toBR_NFFuelOriginIndicator.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFItemAdditionalInfo") ) {
                final Object value = (values).remove("to_BR_NFItemAdditionalInfo");
                if( value instanceof Iterable ) {
                    if( toBR_NFItemAdditionalInfo == null ) {
                        toBR_NFItemAdditionalInfo = Lists.newArrayList();
                    } else {
                        toBR_NFItemAdditionalInfo = Lists.newArrayList(toBR_NFItemAdditionalInfo);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFItemAdditionalInfo entity;
                        if( toBR_NFItemAdditionalInfo.size() > i ) {
                            entity = toBR_NFItemAdditionalInfo.get(i);
                        } else {
                            entity = new BR_NFItemAdditionalInfo();
                            toBR_NFItemAdditionalInfo.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFItemNVE") ) {
                final Object value = (values).remove("to_BR_NFItemNVE");
                if( value instanceof Iterable ) {
                    if( toBR_NFItemNVE == null ) {
                        toBR_NFItemNVE = Lists.newArrayList();
                    } else {
                        toBR_NFItemNVE = Lists.newArrayList(toBR_NFItemNVE);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFItemNVE entity;
                        if( toBR_NFItemNVE.size() > i ) {
                            entity = toBR_NFItemNVE.get(i);
                        } else {
                            entity = new BR_NFItemNVE();
                            toBR_NFItemNVE.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFItemText") ) {
                final Object value = (values).remove("to_BR_NFItemText");
                if( value instanceof Iterable ) {
                    if( toBR_NFItemText == null ) {
                        toBR_NFItemText = Lists.newArrayList();
                    } else {
                        toBR_NFItemText = Lists.newArrayList(toBR_NFItemText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFItemText entity;
                        if( toBR_NFItemText.size() > i ) {
                            entity = toBR_NFItemText.get(i);
                        } else {
                            entity = new BR_NFItemText();
                            toBR_NFItemText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFTax") ) {
                final Object value = (values).remove("to_BR_NFTax");
                if( value instanceof Iterable ) {
                    if( toBR_NFTax == null ) {
                        toBR_NFTax = Lists.newArrayList();
                    } else {
                        toBR_NFTax = Lists.newArrayList(toBR_NFTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BR_NFTAX entity;
                        if( toBR_NFTax.size() > i ) {
                            entity = toBR_NFTax.get(i);
                        } else {
                            entity = new BR_NFTAX();
                            toBR_NFTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BR_NFVehicle") ) {
                final Object value = (values).remove("to_BR_NFVehicle");
                if( value instanceof Map ) {
                    if( toBR_NFVehicle == null ) {
                        toBR_NFVehicle = new BR_NFVehicle();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFVehicle.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        if( toBR_NFAdditionImportDoc != null ) {
            (values).put("to_BR_NFAdditionImportDoc", toBR_NFAdditionImportDoc);
        }
        if( toBR_NFePharmaceutical != null ) {
            (values).put("to_BR_NFePharmaceutical", toBR_NFePharmaceutical);
        }
        if( toBR_NFeProductTraceability != null ) {
            (values).put("to_BR_NFeProductTraceability", toBR_NFeProductTraceability);
        }
        if( toBR_NFExportDocument != null ) {
            (values).put("to_BR_NFExportDocument", toBR_NFExportDocument);
        }
        if( toBR_NFFuel != null ) {
            (values).put("to_BR_NFFuel", toBR_NFFuel);
        }
        if( toBR_NFFuelOriginIndicator != null ) {
            (values).put("to_BR_NFFuelOriginIndicator", toBR_NFFuelOriginIndicator);
        }
        if( toBR_NFItemAdditionalInfo != null ) {
            (values).put("to_BR_NFItemAdditionalInfo", toBR_NFItemAdditionalInfo);
        }
        if( toBR_NFItemNVE != null ) {
            (values).put("to_BR_NFItemNVE", toBR_NFItemNVE);
        }
        if( toBR_NFItemText != null ) {
            (values).put("to_BR_NFItemText", toBR_NFItemText);
        }
        if( toBR_NFTax != null ) {
            (values).put("to_BR_NFTax", toBR_NFTax);
        }
        if( toBR_NFVehicle != null ) {
            (values).put("to_BR_NFVehicle", toBR_NFVehicle);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Fetches the <b>BR_NFAdditionImportDoc</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFAdditionImportDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFAdditionImportDoc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFAdditionImportDoc> fetchBR_NFAdditionImportDoc()
    {
        return fetchFieldAsList("to_BR_NFAdditionImportDoc", BR_NFAdditionImportDoc.class);
    }

    /**
     * Retrieval of associated <b>BR_NFAdditionImportDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionImportDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionImportDoc</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFAdditionImportDoc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFAdditionImportDoc> getBR_NFAdditionImportDocOrFetch()
    {
        if( toBR_NFAdditionImportDoc == null ) {
            toBR_NFAdditionImportDoc = fetchBR_NFAdditionImportDoc();
        }
        return toBR_NFAdditionImportDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFAdditionImportDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionImportDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFAdditionImportDoc</b> is already loaded, the result
     *         will contain the <b>BR_NFAdditionImportDoc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFAdditionImportDoc>> getBR_NFAdditionImportDocIfPresent()
    {
        return Option.of(toBR_NFAdditionImportDoc);
    }

    /**
     * Overwrites the list of associated <b>BR_NFAdditionImportDoc</b> entities for the loaded navigation property
     * <b>to_BR_NFAdditionImportDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionImportDoc</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFAdditionImportDoc</b> entities.
     */
    public void setBR_NFAdditionImportDoc( @Nonnull final List<BR_NFAdditionImportDoc> value )
    {
        if( toBR_NFAdditionImportDoc == null ) {
            toBR_NFAdditionImportDoc = Lists.newArrayList();
        }
        toBR_NFAdditionImportDoc.clear();
        toBR_NFAdditionImportDoc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFAdditionImportDoc</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFAdditionImportDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFAdditionImportDoc</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFAdditionImportDoc</b> entities.
     */
    public void addBR_NFAdditionImportDoc( BR_NFAdditionImportDoc... entity )
    {
        if( toBR_NFAdditionImportDoc == null ) {
            toBR_NFAdditionImportDoc = Lists.newArrayList();
        }
        toBR_NFAdditionImportDoc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFePharmaceutical</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_NFePharmaceutical</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFePharmaceutical</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFePharmaceutical fetchBR_NFePharmaceutical()
    {
        return fetchFieldAsSingle("to_BR_NFePharmaceutical", BR_NFePharmaceutical.class);
    }

    /**
     * Retrieval of associated <b>BR_NFePharmaceutical</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFePharmaceutical</b>.
     * <p>
     * If the navigation property <b>to_BR_NFePharmaceutical</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFePharmaceutical</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFePharmaceutical getBR_NFePharmaceuticalOrFetch()
    {
        if( toBR_NFePharmaceutical == null ) {
            toBR_NFePharmaceutical = fetchBR_NFePharmaceutical();
        }
        return toBR_NFePharmaceutical;
    }

    /**
     * Retrieval of associated <b>BR_NFePharmaceutical</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFePharmaceutical</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFePharmaceutical</b> is already loaded, the result
     *         will contain the <b>BR_NFePharmaceutical</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BR_NFePharmaceutical> getBR_NFePharmaceuticalIfPresent()
    {
        return Option.of(toBR_NFePharmaceutical);
    }

    /**
     * Overwrites the associated <b>BR_NFePharmaceutical</b> entity for the loaded navigation property
     * <b>to_BR_NFePharmaceutical</b>.
     *
     * @param value
     *            New <b>BR_NFePharmaceutical</b> entity.
     */
    public void setBR_NFePharmaceutical( final BR_NFePharmaceutical value )
    {
        toBR_NFePharmaceutical = value;
    }

    /**
     * Fetches the <b>BR_NFeProductTraceability</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BR_NFeProductTraceability</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFeProductTraceability</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFeProductTraceability> fetchBR_NFeProductTraceability()
    {
        return fetchFieldAsList("to_BR_NFeProductTraceability", BR_NFeProductTraceability.class);
    }

    /**
     * Retrieval of associated <b>BR_NFeProductTraceability</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFeProductTraceability</b>.
     * <p>
     * If the navigation property <b>to_BR_NFeProductTraceability</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFeProductTraceability</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFeProductTraceability> getBR_NFeProductTraceabilityOrFetch()
    {
        if( toBR_NFeProductTraceability == null ) {
            toBR_NFeProductTraceability = fetchBR_NFeProductTraceability();
        }
        return toBR_NFeProductTraceability;
    }

    /**
     * Retrieval of associated <b>BR_NFeProductTraceability</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFeProductTraceability</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFeProductTraceability</b> is already loaded, the
     *         result will contain the <b>BR_NFeProductTraceability</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFeProductTraceability>> getBR_NFeProductTraceabilityIfPresent()
    {
        return Option.of(toBR_NFeProductTraceability);
    }

    /**
     * Overwrites the list of associated <b>BR_NFeProductTraceability</b> entities for the loaded navigation property
     * <b>to_BR_NFeProductTraceability</b>.
     * <p>
     * If the navigation property <b>to_BR_NFeProductTraceability</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFeProductTraceability</b> entities.
     */
    public void setBR_NFeProductTraceability( @Nonnull final List<BR_NFeProductTraceability> value )
    {
        if( toBR_NFeProductTraceability == null ) {
            toBR_NFeProductTraceability = Lists.newArrayList();
        }
        toBR_NFeProductTraceability.clear();
        toBR_NFeProductTraceability.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFeProductTraceability</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFeProductTraceability</b>.
     * <p>
     * If the navigation property <b>to_BR_NFeProductTraceability</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFeProductTraceability</b> entities.
     */
    public void addBR_NFeProductTraceability( BR_NFeProductTraceability... entity )
    {
        if( toBR_NFeProductTraceability == null ) {
            toBR_NFeProductTraceability = Lists.newArrayList();
        }
        toBR_NFeProductTraceability.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFExportDocument</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BR_NFExportDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFExportDocument</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFExportDocument> fetchBR_NFExportDocument()
    {
        return fetchFieldAsList("to_BR_NFExportDocument", BR_NFExportDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFExportDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFExportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFExportDocument</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFExportDocument</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFExportDocument> getBR_NFExportDocumentOrFetch()
    {
        if( toBR_NFExportDocument == null ) {
            toBR_NFExportDocument = fetchBR_NFExportDocument();
        }
        return toBR_NFExportDocument;
    }

    /**
     * Retrieval of associated <b>BR_NFExportDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFExportDocument</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFExportDocument</b> is already loaded, the result
     *         will contain the <b>BR_NFExportDocument</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFExportDocument>> getBR_NFExportDocumentIfPresent()
    {
        return Option.of(toBR_NFExportDocument);
    }

    /**
     * Overwrites the list of associated <b>BR_NFExportDocument</b> entities for the loaded navigation property
     * <b>to_BR_NFExportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFExportDocument</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFExportDocument</b> entities.
     */
    public void setBR_NFExportDocument( @Nonnull final List<BR_NFExportDocument> value )
    {
        if( toBR_NFExportDocument == null ) {
            toBR_NFExportDocument = Lists.newArrayList();
        }
        toBR_NFExportDocument.clear();
        toBR_NFExportDocument.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFExportDocument</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFExportDocument</b>.
     * <p>
     * If the navigation property <b>to_BR_NFExportDocument</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFExportDocument</b> entities.
     */
    public void addBR_NFExportDocument( BR_NFExportDocument... entity )
    {
        if( toBR_NFExportDocument == null ) {
            toBR_NFExportDocument = Lists.newArrayList();
        }
        toBR_NFExportDocument.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFFuel</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFFuel</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFFuel</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFFuel fetchBR_NFFuel()
    {
        return fetchFieldAsSingle("to_BR_NFFuel", BR_NFFuel.class);
    }

    /**
     * Retrieval of associated <b>BR_NFFuel</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFFuel</b>.
     * <p>
     * If the navigation property <b>to_BR_NFFuel</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFFuel</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFFuel getBR_NFFuelOrFetch()
    {
        if( toBR_NFFuel == null ) {
            toBR_NFFuel = fetchBR_NFFuel();
        }
        return toBR_NFFuel;
    }

    /**
     * Retrieval of associated <b>BR_NFFuel</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFFuel</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFFuel</b> is already loaded, the result will contain
     *         the <b>BR_NFFuel</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFFuel> getBR_NFFuelIfPresent()
    {
        return Option.of(toBR_NFFuel);
    }

    /**
     * Overwrites the associated <b>BR_NFFuel</b> entity for the loaded navigation property <b>to_BR_NFFuel</b>.
     *
     * @param value
     *            New <b>BR_NFFuel</b> entity.
     */
    public void setBR_NFFuel( final BR_NFFuel value )
    {
        toBR_NFFuel = value;
    }

    /**
     * Fetches the <b>BR_NFFuelOriginIndicator</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BR_NFFuelOriginIndicator</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFFuelOriginIndicator</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFFuelOriginIndicator> fetchBR_NFFuelOriginIndicator()
    {
        return fetchFieldAsList("to_BR_NFFuelOriginIndicator", BR_NFFuelOriginIndicator.class);
    }

    /**
     * Retrieval of associated <b>BR_NFFuelOriginIndicator</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFFuelOriginIndicator</b>.
     * <p>
     * If the navigation property <b>to_BR_NFFuelOriginIndicator</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFFuelOriginIndicator</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFFuelOriginIndicator> getBR_NFFuelOriginIndicatorOrFetch()
    {
        if( toBR_NFFuelOriginIndicator == null ) {
            toBR_NFFuelOriginIndicator = fetchBR_NFFuelOriginIndicator();
        }
        return toBR_NFFuelOriginIndicator;
    }

    /**
     * Retrieval of associated <b>BR_NFFuelOriginIndicator</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFFuelOriginIndicator</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFFuelOriginIndicator</b> is already loaded, the
     *         result will contain the <b>BR_NFFuelOriginIndicator</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFFuelOriginIndicator>> getBR_NFFuelOriginIndicatorIfPresent()
    {
        return Option.of(toBR_NFFuelOriginIndicator);
    }

    /**
     * Overwrites the list of associated <b>BR_NFFuelOriginIndicator</b> entities for the loaded navigation property
     * <b>to_BR_NFFuelOriginIndicator</b>.
     * <p>
     * If the navigation property <b>to_BR_NFFuelOriginIndicator</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFFuelOriginIndicator</b> entities.
     */
    public void setBR_NFFuelOriginIndicator( @Nonnull final List<BR_NFFuelOriginIndicator> value )
    {
        if( toBR_NFFuelOriginIndicator == null ) {
            toBR_NFFuelOriginIndicator = Lists.newArrayList();
        }
        toBR_NFFuelOriginIndicator.clear();
        toBR_NFFuelOriginIndicator.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFFuelOriginIndicator</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFFuelOriginIndicator</b>.
     * <p>
     * If the navigation property <b>to_BR_NFFuelOriginIndicator</b> of a queried <b>BR_NFItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFFuelOriginIndicator</b> entities.
     */
    public void addBR_NFFuelOriginIndicator( BR_NFFuelOriginIndicator... entity )
    {
        if( toBR_NFFuelOriginIndicator == null ) {
            toBR_NFFuelOriginIndicator = Lists.newArrayList();
        }
        toBR_NFFuelOriginIndicator.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFItemAdditionalInfo</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BR_NFItemAdditionalInfo</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFItemAdditionalInfo</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemAdditionalInfo> fetchBR_NFItemAdditionalInfo()
    {
        return fetchFieldAsList("to_BR_NFItemAdditionalInfo", BR_NFItemAdditionalInfo.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItemAdditionalInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFItemAdditionalInfo</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemAdditionalInfo</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItemAdditionalInfo</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemAdditionalInfo> getBR_NFItemAdditionalInfoOrFetch()
    {
        if( toBR_NFItemAdditionalInfo == null ) {
            toBR_NFItemAdditionalInfo = fetchBR_NFItemAdditionalInfo();
        }
        return toBR_NFItemAdditionalInfo;
    }

    /**
     * Retrieval of associated <b>BR_NFItemAdditionalInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BR_NFItemAdditionalInfo</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItemAdditionalInfo</b> is already loaded, the
     *         result will contain the <b>BR_NFItemAdditionalInfo</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFItemAdditionalInfo>> getBR_NFItemAdditionalInfoIfPresent()
    {
        return Option.of(toBR_NFItemAdditionalInfo);
    }

    /**
     * Overwrites the list of associated <b>BR_NFItemAdditionalInfo</b> entities for the loaded navigation property
     * <b>to_BR_NFItemAdditionalInfo</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemAdditionalInfo</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFItemAdditionalInfo</b> entities.
     */
    public void setBR_NFItemAdditionalInfo( @Nonnull final List<BR_NFItemAdditionalInfo> value )
    {
        if( toBR_NFItemAdditionalInfo == null ) {
            toBR_NFItemAdditionalInfo = Lists.newArrayList();
        }
        toBR_NFItemAdditionalInfo.clear();
        toBR_NFItemAdditionalInfo.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFItemAdditionalInfo</b> entities. This corresponds to the OData
     * navigation property <b>to_BR_NFItemAdditionalInfo</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemAdditionalInfo</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFItemAdditionalInfo</b> entities.
     */
    public void addBR_NFItemAdditionalInfo( BR_NFItemAdditionalInfo... entity )
    {
        if( toBR_NFItemAdditionalInfo == null ) {
            toBR_NFItemAdditionalInfo = Lists.newArrayList();
        }
        toBR_NFItemAdditionalInfo.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFItemNVE</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItemNVE</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFItemNVE</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemNVE> fetchBR_NFItemNVE()
    {
        return fetchFieldAsList("to_BR_NFItemNVE", BR_NFItemNVE.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItemNVE</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItemNVE</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemNVE</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItemNVE</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemNVE> getBR_NFItemNVEOrFetch()
    {
        if( toBR_NFItemNVE == null ) {
            toBR_NFItemNVE = fetchBR_NFItemNVE();
        }
        return toBR_NFItemNVE;
    }

    /**
     * Retrieval of associated <b>BR_NFItemNVE</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItemNVE</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItemNVE</b> is already loaded, the result will
     *         contain the <b>BR_NFItemNVE</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFItemNVE>> getBR_NFItemNVEIfPresent()
    {
        return Option.of(toBR_NFItemNVE);
    }

    /**
     * Overwrites the list of associated <b>BR_NFItemNVE</b> entities for the loaded navigation property
     * <b>to_BR_NFItemNVE</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemNVE</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFItemNVE</b> entities.
     */
    public void setBR_NFItemNVE( @Nonnull final List<BR_NFItemNVE> value )
    {
        if( toBR_NFItemNVE == null ) {
            toBR_NFItemNVE = Lists.newArrayList();
        }
        toBR_NFItemNVE.clear();
        toBR_NFItemNVE.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFItemNVE</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFItemNVE</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemNVE</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFItemNVE</b> entities.
     */
    public void addBR_NFItemNVE( BR_NFItemNVE... entity )
    {
        if( toBR_NFItemNVE == null ) {
            toBR_NFItemNVE = Lists.newArrayList();
        }
        toBR_NFItemNVE.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFItemText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BR_NFItemText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFItemText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemText> fetchBR_NFItemText()
    {
        return fetchFieldAsList("to_BR_NFItemText", BR_NFItemText.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItemText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItemText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemText</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFItemText> getBR_NFItemTextOrFetch()
    {
        if( toBR_NFItemText == null ) {
            toBR_NFItemText = fetchBR_NFItemText();
        }
        return toBR_NFItemText;
    }

    /**
     * Retrieval of associated <b>BR_NFItemText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BR_NFItemText</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItemText</b> is already loaded, the result will
     *         contain the <b>BR_NFItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BR_NFItemText>> getBR_NFItemTextIfPresent()
    {
        return Option.of(toBR_NFItemText);
    }

    /**
     * Overwrites the list of associated <b>BR_NFItemText</b> entities for the loaded navigation property
     * <b>to_BR_NFItemText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemText</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFItemText</b> entities.
     */
    public void setBR_NFItemText( @Nonnull final List<BR_NFItemText> value )
    {
        if( toBR_NFItemText == null ) {
            toBR_NFItemText = Lists.newArrayList();
        }
        toBR_NFItemText.clear();
        toBR_NFItemText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFItemText</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFItemText</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItemText</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFItemText</b> entities.
     */
    public void addBR_NFItemText( BR_NFItemText... entity )
    {
        if( toBR_NFItemText == null ) {
            toBR_NFItemText = Lists.newArrayList();
        }
        toBR_NFItemText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFTAX</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BR_NFTAX</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTAX> fetchBR_NFTax()
    {
        return fetchFieldAsList("to_BR_NFTax", BR_NFTAX.class);
    }

    /**
     * Retrieval of associated <b>BR_NFTAX</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_BR_NFTax</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTax</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFTAX</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BR_NFTAX> getBR_NFTaxOrFetch()
    {
        if( toBR_NFTax == null ) {
            toBR_NFTax = fetchBR_NFTax();
        }
        return toBR_NFTax;
    }

    /**
     * Retrieval of associated <b>BR_NFTAX</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_BR_NFTax</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFTax</b> is already loaded, the result will contain
     *         the <b>BR_NFTAX</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<BR_NFTAX>> getBR_NFTaxIfPresent()
    {
        return Option.of(toBR_NFTax);
    }

    /**
     * Overwrites the list of associated <b>BR_NFTAX</b> entities for the loaded navigation property <b>to_BR_NFTax</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTax</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BR_NFTAX</b> entities.
     */
    public void setBR_NFTax( @Nonnull final List<BR_NFTAX> value )
    {
        if( toBR_NFTax == null ) {
            toBR_NFTax = Lists.newArrayList();
        }
        toBR_NFTax.clear();
        toBR_NFTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BR_NFTAX</b> entities. This corresponds to the OData navigation
     * property <b>to_BR_NFTax</b>.
     * <p>
     * If the navigation property <b>to_BR_NFTax</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BR_NFTAX</b> entities.
     */
    public void addBR_NFTax( BR_NFTAX... entity )
    {
        if( toBR_NFTax == null ) {
            toBR_NFTax = Lists.newArrayList();
        }
        toBR_NFTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BR_NFVehicle</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFVehicle</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFVehicle</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFVehicle fetchBR_NFVehicle()
    {
        return fetchFieldAsSingle("to_BR_NFVehicle", BR_NFVehicle.class);
    }

    /**
     * Retrieval of associated <b>BR_NFVehicle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFVehicle</b>.
     * <p>
     * If the navigation property <b>to_BR_NFVehicle</b> of a queried <b>BR_NFItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFVehicle</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFVehicle getBR_NFVehicleOrFetch()
    {
        if( toBR_NFVehicle == null ) {
            toBR_NFVehicle = fetchBR_NFVehicle();
        }
        return toBR_NFVehicle;
    }

    /**
     * Retrieval of associated <b>BR_NFVehicle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFVehicle</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFVehicle</b> is already loaded, the result will
     *         contain the <b>BR_NFVehicle</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BR_NFVehicle> getBR_NFVehicleIfPresent()
    {
        return Option.of(toBR_NFVehicle);
    }

    /**
     * Overwrites the associated <b>BR_NFVehicle</b> entity for the loaded navigation property <b>to_BR_NFVehicle</b>.
     *
     * @param value
     *            New <b>BR_NFVehicle</b> entity.
     */
    public void setBR_NFVehicle( final BR_NFVehicle value )
    {
        toBR_NFVehicle = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFItem instances.
     *
     */
    public final static class BR_NFItemBuilder
    {

        private BR_NFDocument toBR_NFDoc;
        private List<BR_NFAdditionImportDoc> toBR_NFAdditionImportDoc = Lists.newArrayList();
        private BR_NFePharmaceutical toBR_NFePharmaceutical;
        private List<BR_NFeProductTraceability> toBR_NFeProductTraceability = Lists.newArrayList();
        private List<BR_NFExportDocument> toBR_NFExportDocument = Lists.newArrayList();
        private BR_NFFuel toBR_NFFuel;
        private List<BR_NFFuelOriginIndicator> toBR_NFFuelOriginIndicator = Lists.newArrayList();
        private List<BR_NFItemAdditionalInfo> toBR_NFItemAdditionalInfo = Lists.newArrayList();
        private List<BR_NFItemNVE> toBR_NFItemNVE = Lists.newArrayList();
        private List<BR_NFItemText> toBR_NFItemText = Lists.newArrayList();
        private List<BR_NFTAX> toBR_NFTax = Lists.newArrayList();
        private BR_NFVehicle toBR_NFVehicle;

        private BR_NFItem.BR_NFItemBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFItem</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFAdditionImportDoc( final List<BR_NFAdditionImportDoc> value )
        {
            toBR_NFAdditionImportDoc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFAdditionImportDoc</b> for <b>BR_NFItem</b> to multiple
         * <b>BR_NFAdditionImportDoc</b>.
         *
         * @param value
         *            The BR_NFAdditionImportDocs to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFAdditionImportDoc( BR_NFAdditionImportDoc... value )
        {
            return toBR_NFAdditionImportDoc(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFePharmaceutical( final BR_NFePharmaceutical value )
        {
            toBR_NFePharmaceutical = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFePharmaceutical</b> for <b>BR_NFItem</b> to single
         * <b>BR_NFePharmaceutical</b>.
         *
         * @param value
         *            The BR_NFePharmaceutical to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFePharmaceutical( final BR_NFePharmaceutical value )
        {
            return toBR_NFePharmaceutical(value);
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFeProductTraceability( final List<BR_NFeProductTraceability> value )
        {
            toBR_NFeProductTraceability.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFeProductTraceability</b> for <b>BR_NFItem</b> to multiple
         * <b>BR_NFeProductTraceability</b>.
         *
         * @param value
         *            The BR_NFeProductTraceabilitys to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFeProductTraceability( BR_NFeProductTraceability... value )
        {
            return toBR_NFeProductTraceability(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFExportDocument( final List<BR_NFExportDocument> value )
        {
            toBR_NFExportDocument.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFExportDocument</b> for <b>BR_NFItem</b> to multiple
         * <b>BR_NFExportDocument</b>.
         *
         * @param value
         *            The BR_NFExportDocuments to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFExportDocument( BR_NFExportDocument... value )
        {
            return toBR_NFExportDocument(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFFuel( final BR_NFFuel value )
        {
            toBR_NFFuel = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFFuel</b> for <b>BR_NFItem</b> to single <b>BR_NFFuel</b>.
         *
         * @param value
         *            The BR_NFFuel to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFFuel( final BR_NFFuel value )
        {
            return toBR_NFFuel(value);
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFFuelOriginIndicator( final List<BR_NFFuelOriginIndicator> value )
        {
            toBR_NFFuelOriginIndicator.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFFuelOriginIndicator</b> for <b>BR_NFItem</b> to multiple
         * <b>BR_NFFuelOriginIndicator</b>.
         *
         * @param value
         *            The BR_NFFuelOriginIndicators to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFFuelOriginIndicator( BR_NFFuelOriginIndicator... value )
        {
            return toBR_NFFuelOriginIndicator(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFItemAdditionalInfo( final List<BR_NFItemAdditionalInfo> value )
        {
            toBR_NFItemAdditionalInfo.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItemAdditionalInfo</b> for <b>BR_NFItem</b> to multiple
         * <b>BR_NFItemAdditionalInfo</b>.
         *
         * @param value
         *            The BR_NFItemAdditionalInfos to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFItemAdditionalInfo( BR_NFItemAdditionalInfo... value )
        {
            return toBR_NFItemAdditionalInfo(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFItemNVE( final List<BR_NFItemNVE> value )
        {
            toBR_NFItemNVE.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItemNVE</b> for <b>BR_NFItem</b> to multiple <b>BR_NFItemNVE</b>.
         *
         * @param value
         *            The BR_NFItemNVEs to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFItemNVE( BR_NFItemNVE... value )
        {
            return toBR_NFItemNVE(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFItemText( final List<BR_NFItemText> value )
        {
            toBR_NFItemText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItemText</b> for <b>BR_NFItem</b> to multiple <b>BR_NFItemText</b>.
         *
         * @param value
         *            The BR_NFItemTexts to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFItemText( BR_NFItemText... value )
        {
            return toBR_NFItemText(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFTax( final List<BR_NFTAX> value )
        {
            toBR_NFTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFTax</b> for <b>BR_NFItem</b> to multiple <b>BR_NFTAX</b>.
         *
         * @param value
         *            The BR_NFTAXs to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFTax( BR_NFTAX... value )
        {
            return toBR_NFTax(Lists.newArrayList(value));
        }

        private BR_NFItem.BR_NFItemBuilder toBR_NFVehicle( final BR_NFVehicle value )
        {
            toBR_NFVehicle = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFVehicle</b> for <b>BR_NFItem</b> to single <b>BR_NFVehicle</b>.
         *
         * @param value
         *            The BR_NFVehicle to build this BR_NFItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFItem.BR_NFItemBuilder bR_NFVehicle( final BR_NFVehicle value )
        {
            return toBR_NFVehicle(value);
        }

    }

}
