/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFItemAdditionalInfoSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
 * BR_NFItemAdditionalInfo} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BR_NFItemAdditionalInfoByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFItemAdditionalInfoByKeyFluentHelper, BR_NFItemAdditionalInfo, BR_NFItemAdditionalInfoSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     * BR_NFItemAdditionalInfo} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFItemAdditionalInfo}
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFItemAdditionalInfo}
     * @param bR_NotaFiscalItem
     *            Document Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param bR_NFInfoFieldUsage
     *            Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BR_NFItemAdditionalInfoByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFInfoFieldUsage )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NotaFiscalItem", bR_NotaFiscalItem);
        this.key.put("BR_NFInfoFieldUsage", bR_NFInfoFieldUsage);
    }

    @Override
    @Nonnull
    protected Class<BR_NFItemAdditionalInfo> getEntityClass()
    {
        return BR_NFItemAdditionalInfo.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
