/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Item text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFItemText extends VdmEntity<BR_NFItemText>
{

    /**
     * Selector for all available fields of BR_NFItemText.
     *
     */
    public final static BR_NFItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BR_NOTA_FISCAL = new BR_NFItemTextField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BR_NOTA_FISCAL_ITEM =
        new BR_NFItemTextField<String>("BR_NotaFiscalItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTextType</b>
     * </p>
     *
     * @return NF text type
     */
    @Key
    @SerializedName( "BR_NFTextType" )
    @JsonProperty( "BR_NFTextType" )
    @Nullable
    @ODataField( odataName = "BR_NFTextType" )
    private String bR_NFTextType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTextType</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BRNF_TEXT_TYPE = new BR_NFItemTextField<String>("BR_NFTextType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTextSequenceNumber</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "BR_NFTextSequenceNumber" )
    @JsonProperty( "BR_NFTextSequenceNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFTextSequenceNumber" )
    private String bR_NFTextSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTextSequenceNumber</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BRNF_TEXT_SEQUENCE_NUMBER =
        new BR_NFItemTextField<String>("BR_NFTextSequenceNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFText</b>
     * </p>
     *
     * @return NF Texts
     */
    @SerializedName( "BR_NFText" )
    @JsonProperty( "BR_NFText" )
    @Nullable
    @ODataField( odataName = "BR_NFText" )
    private String bR_NFText;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFText</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BRNF_TEXT = new BR_NFItemTextField<String>("BR_NFText");
    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTaxPartnerTextID</b>
     * </p>
     *
     * @return Text ID from SAP Tax Partner
     */
    @SerializedName( "BR_NFTaxPartnerTextID" )
    @JsonProperty( "BR_NFTaxPartnerTextID" )
    @Nullable
    @ODataField( odataName = "BR_NFTaxPartnerTextID" )
    private String bR_NFTaxPartnerTextID;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTaxPartnerTextID</b> field to query operations.
     *
     */
    public final static BR_NFItemTextField<String> BRNF_TAX_PARTNER_TEXT_ID =
        new BR_NFItemTextField<String>("BR_NFTaxPartnerTextID");

    @Nonnull
    @Override
    public Class<BR_NFItemText> getType()
    {
        return BR_NFItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTextType</b>
     * </p>
     *
     * @param bR_NFTextType
     *            NF text type
     */
    public void setBR_NFTextType( @Nullable final String bR_NFTextType )
    {
        rememberChangedField("BR_NFTextType", this.bR_NFTextType);
        this.bR_NFTextType = bR_NFTextType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTextSequenceNumber</b>
     * </p>
     *
     * @param bR_NFTextSequenceNumber
     *            Counter
     */
    public void setBR_NFTextSequenceNumber( @Nullable final String bR_NFTextSequenceNumber )
    {
        rememberChangedField("BR_NFTextSequenceNumber", this.bR_NFTextSequenceNumber);
        this.bR_NFTextSequenceNumber = bR_NFTextSequenceNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFText</b>
     * </p>
     *
     * @param bR_NFText
     *            NF Texts
     */
    public void setBR_NFText( @Nullable final String bR_NFText )
    {
        rememberChangedField("BR_NFText", this.bR_NFText);
        this.bR_NFText = bR_NFText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTaxPartnerTextID</b>
     * </p>
     *
     * @param bR_NFTaxPartnerTextID
     *            Text ID from SAP Tax Partner
     */
    public void setBR_NFTaxPartnerTextID( @Nullable final String bR_NFTaxPartnerTextID )
    {
        rememberChangedField("BR_NFTaxPartnerTextID", this.bR_NFTaxPartnerTextID);
        this.bR_NFTaxPartnerTextID = bR_NFTaxPartnerTextID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        result.put("BR_NFTextType", getBR_NFTextType());
        result.put("BR_NFTextSequenceNumber", getBR_NFTextSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("BR_NFTextType", getBR_NFTextType());
        values.put("BR_NFTextSequenceNumber", getBR_NFTextSequenceNumber());
        values.put("BR_NFText", getBR_NFText());
        values.put("BR_NFTaxPartnerTextID", getBR_NFTaxPartnerTextID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("BR_NFTextType") ) {
                final Object value = values.remove("BR_NFTextType");
                if( (value == null) || (!value.equals(getBR_NFTextType())) ) {
                    setBR_NFTextType(((String) value));
                }
            }
            if( values.containsKey("BR_NFTextSequenceNumber") ) {
                final Object value = values.remove("BR_NFTextSequenceNumber");
                if( (value == null) || (!value.equals(getBR_NFTextSequenceNumber())) ) {
                    setBR_NFTextSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFText") ) {
                final Object value = values.remove("BR_NFText");
                if( (value == null) || (!value.equals(getBR_NFText())) ) {
                    setBR_NFText(((String) value));
                }
            }
            if( values.containsKey("BR_NFTaxPartnerTextID") ) {
                final Object value = values.remove("BR_NFTaxPartnerTextID");
                if( (value == null) || (!value.equals(getBR_NFTaxPartnerTextID())) ) {
                    setBR_NFTaxPartnerTextID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

}
