/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFPartner extends VdmEntity<BR_NFPartner>
{

    /**
     * Selector for all available fields of BR_NFPartner.
     *
     */
    public final static BR_NFPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BR_NOTA_FISCAL = new BR_NFPartnerField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "BR_NFPartnerFunction" )
    @JsonProperty( "BR_NFPartnerFunction" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerFunction" )
    private String bR_NFPartnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerFunction</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_FUNCTION =
        new BR_NFPartnerField<String>("BR_NFPartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartner</b>
     * </p>
     *
     * @return Partner ID (Customer, Vendor, Business Place)
     */
    @SerializedName( "BR_NFPartner" )
    @JsonProperty( "BR_NFPartner" )
    @Nullable
    @ODataField( odataName = "BR_NFPartner" )
    private String bR_NFPartner;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartner</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER = new BR_NFPartnerField<String>("BR_NFPartner");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTitle</b>
     * </p>
     *
     * @return Title
     */
    @SerializedName( "BR_NFPartnerTitle" )
    @JsonProperty( "BR_NFPartnerTitle" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerTitle" )
    private String bR_NFPartnerTitle;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerTitle</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_TITLE =
        new BR_NFPartnerField<String>("BR_NFPartnerTitle");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BR_NFPartnerName1" )
    @JsonProperty( "BR_NFPartnerName1" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName1" )
    private String bR_NFPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName1</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_NAME1 =
        new BR_NFPartnerField<String>("BR_NFPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BR_NFPartnerName2" )
    @JsonProperty( "BR_NFPartnerName2" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName2" )
    private String bR_NFPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName2</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_NAME2 =
        new BR_NFPartnerField<String>("BR_NFPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "BR_NFPartnerName3" )
    @JsonProperty( "BR_NFPartnerName3" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName3" )
    private String bR_NFPartnerName3;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName3</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_NAME3 =
        new BR_NFPartnerField<String>("BR_NFPartnerName3");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "BR_NFPartnerName4" )
    @JsonProperty( "BR_NFPartnerName4" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerName4" )
    private String bR_NFPartnerName4;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerName4</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_NAME4 =
        new BR_NFPartnerField<String>("BR_NFPartnerName4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerType</b>
     * </p>
     *
     * @return Type
     */
    @SerializedName( "BR_NFPartnerType" )
    @JsonProperty( "BR_NFPartnerType" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerType" )
    private String bR_NFPartnerType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerType</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_TYPE = new BR_NFPartnerField<String>("BR_NFPartnerType");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStreetName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "BR_NFPartnerStreetName" )
    @JsonProperty( "BR_NFPartnerStreetName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerStreetName" )
    private String bR_NFPartnerStreetName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerStreetName</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_STREET_NAME =
        new BR_NFPartnerField<String>("BR_NFPartnerStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "BR_NFPartnerCityName" )
    @JsonProperty( "BR_NFPartnerCityName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCityName" )
    private String bR_NFPartnerCityName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCityName</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_CITY_NAME =
        new BR_NFPartnerField<String>("BR_NFPartnerCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerRegionCode</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "BR_NFPartnerRegionCode" )
    @JsonProperty( "BR_NFPartnerRegionCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerRegionCode" )
    private String bR_NFPartnerRegionCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerRegionCode</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_REGION_CODE =
        new BR_NFPartnerField<String>("BR_NFPartnerRegionCode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerDistrictName</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "BR_NFPartnerDistrictName" )
    @JsonProperty( "BR_NFPartnerDistrictName" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerDistrictName" )
    private String bR_NFPartnerDistrictName;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerDistrictName</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_DISTRICT_NAME =
        new BR_NFPartnerField<String>("BR_NFPartnerDistrictName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCountryCode</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "BR_NFPartnerCountryCode" )
    @JsonProperty( "BR_NFPartnerCountryCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCountryCode" )
    private String bR_NFPartnerCountryCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCountryCode</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_COUNTRY_CODE =
        new BR_NFPartnerField<String>("BR_NFPartnerCountryCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "BR_NFPartnerPostalCode" )
    @JsonProperty( "BR_NFPartnerPostalCode" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerPostalCode" )
    private String bR_NFPartnerPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerPostalCode</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_POSTAL_CODE =
        new BR_NFPartnerField<String>("BR_NFPartnerPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCFOPCategory</b>
     * </p>
     *
     * @return CFOP Category
     */
    @SerializedName( "BR_NFPartnerCFOPCategory" )
    @JsonProperty( "BR_NFPartnerCFOPCategory" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCFOPCategory" )
    private String bR_NFPartnerCFOPCategory;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCFOPCategory</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_CFOP_CATEGORY =
        new BR_NFPartnerField<String>("BR_NFPartnerCFOPCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerIsNaturalPerson</b>
     * </p>
     *
     * @return Natural Person
     */
    @SerializedName( "BR_NFPartnerIsNaturalPerson" )
    @JsonProperty( "BR_NFPartnerIsNaturalPerson" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerIsNaturalPerson" )
    private String bR_NFPartnerIsNaturalPerson;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerIsNaturalPerson</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_IS_NATURAL_PERSON =
        new BR_NFPartnerField<String>("BR_NFPartnerIsNaturalPerson");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNPJ</b>
     * </p>
     *
     * @return CNPJ
     */
    @SerializedName( "BR_NFPartnerCNPJ" )
    @JsonProperty( "BR_NFPartnerCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCNPJ" )
    private String bR_NFPartnerCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_CNPJ = new BR_NFPartnerField<String>("BR_NFPartnerCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCPF</b>
     * </p>
     *
     * @return CPF
     */
    @SerializedName( "BR_NFPartnerCPF" )
    @JsonProperty( "BR_NFPartnerCPF" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerCPF" )
    private String bR_NFPartnerCPF;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerCPF</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_CPF = new BR_NFPartnerField<String>("BR_NFPartnerCPF");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Addresses: telephone no.
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> PHONE_NUMBER = new BR_NFPartnerField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumber</b>
     * </p>
     *
     * @return State Tax Number
     */
    @SerializedName( "BR_NFPartnerStateTaxNumber" )
    @JsonProperty( "BR_NFPartnerStateTaxNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerStateTaxNumber" )
    private String bR_NFPartnerStateTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerStateTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_STATE_TAX_NUMBER =
        new BR_NFPartnerField<String>("BR_NFPartnerStateTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerMunicipalTaxNumber</b>
     * </p>
     *
     * @return Municipal Tax Number
     */
    @SerializedName( "BR_NFPartnerMunicipalTaxNumber" )
    @JsonProperty( "BR_NFPartnerMunicipalTaxNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerMunicipalTaxNumber" )
    private String bR_NFPartnerMunicipalTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerMunicipalTaxNumber</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_MUNICIPAL_TAX_NUMBER =
        new BR_NFPartnerField<String>("BR_NFPartnerMunicipalTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> TAX_JURISDICTION = new BR_NFPartnerField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeFiscalDocumentPartner</b>
     * </p>
     *
     * @return CT-e Partner in Fiscal Document
     */
    @SerializedName( "BR_CTeFiscalDocumentPartner" )
    @JsonProperty( "BR_CTeFiscalDocumentPartner" )
    @Nullable
    @ODataField( odataName = "BR_CTeFiscalDocumentPartner" )
    private String bR_CTeFiscalDocumentPartner;
    /**
     * Use with available fluent helpers to apply the <b>BR_CTeFiscalDocumentPartner</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRC_TE_FISCAL_DOCUMENT_PARTNER =
        new BR_NFPartnerField<String>("BR_CTeFiscalDocumentPartner");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPlaceType</b>
     * </p>
     *
     * @return Nota Fiscal Partner Place Type
     */
    @SerializedName( "BR_NFPartnerPlaceType" )
    @JsonProperty( "BR_NFPartnerPlaceType" )
    @Nullable
    @ODataField( odataName = "BR_NFPartnerPlaceType" )
    private String bR_NFPartnerPlaceType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPartnerPlaceType</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> BRNF_PARTNER_PLACE_TYPE =
        new BR_NFPartnerField<String>("BR_NFPartnerPlaceType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @return The isBusinessPurposeCompleted contained in this entity.
     */
    @SerializedName( "IsBusinessPurposeCompleted" )
    @JsonProperty( "IsBusinessPurposeCompleted" )
    @Nullable
    @ODataField( odataName = "IsBusinessPurposeCompleted" )
    private String isBusinessPurposeCompleted;
    /**
     * Use with available fluent helpers to apply the <b>IsBusinessPurposeCompleted</b> field to query operations.
     *
     */
    public final static BR_NFPartnerField<String> IS_BUSINESS_PURPOSE_COMPLETED =
        new BR_NFPartnerField<String>("IsBusinessPurposeCompleted");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFPartner</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFPartnerOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFPartnerOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFPartner> getType()
    {
        return BR_NFPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerFunction</b>
     * </p>
     *
     * @param bR_NFPartnerFunction
     *            Partner Function
     */
    public void setBR_NFPartnerFunction( @Nullable final String bR_NFPartnerFunction )
    {
        rememberChangedField("BR_NFPartnerFunction", this.bR_NFPartnerFunction);
        this.bR_NFPartnerFunction = bR_NFPartnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartner</b>
     * </p>
     *
     * @param bR_NFPartner
     *            Partner ID (Customer, Vendor, Business Place)
     */
    public void setBR_NFPartner( @Nullable final String bR_NFPartner )
    {
        rememberChangedField("BR_NFPartner", this.bR_NFPartner);
        this.bR_NFPartner = bR_NFPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerTitle</b>
     * </p>
     *
     * @param bR_NFPartnerTitle
     *            Title
     */
    public void setBR_NFPartnerTitle( @Nullable final String bR_NFPartnerTitle )
    {
        rememberChangedField("BR_NFPartnerTitle", this.bR_NFPartnerTitle);
        this.bR_NFPartnerTitle = bR_NFPartnerTitle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName1</b>
     * </p>
     *
     * @param bR_NFPartnerName1
     *            Name 1
     */
    public void setBR_NFPartnerName1( @Nullable final String bR_NFPartnerName1 )
    {
        rememberChangedField("BR_NFPartnerName1", this.bR_NFPartnerName1);
        this.bR_NFPartnerName1 = bR_NFPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName2</b>
     * </p>
     *
     * @param bR_NFPartnerName2
     *            Name 2
     */
    public void setBR_NFPartnerName2( @Nullable final String bR_NFPartnerName2 )
    {
        rememberChangedField("BR_NFPartnerName2", this.bR_NFPartnerName2);
        this.bR_NFPartnerName2 = bR_NFPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName3</b>
     * </p>
     *
     * @param bR_NFPartnerName3
     *            Name 3
     */
    public void setBR_NFPartnerName3( @Nullable final String bR_NFPartnerName3 )
    {
        rememberChangedField("BR_NFPartnerName3", this.bR_NFPartnerName3);
        this.bR_NFPartnerName3 = bR_NFPartnerName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerName4</b>
     * </p>
     *
     * @param bR_NFPartnerName4
     *            Name 4
     */
    public void setBR_NFPartnerName4( @Nullable final String bR_NFPartnerName4 )
    {
        rememberChangedField("BR_NFPartnerName4", this.bR_NFPartnerName4);
        this.bR_NFPartnerName4 = bR_NFPartnerName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerType</b>
     * </p>
     *
     * @param bR_NFPartnerType
     *            Type
     */
    public void setBR_NFPartnerType( @Nullable final String bR_NFPartnerType )
    {
        rememberChangedField("BR_NFPartnerType", this.bR_NFPartnerType);
        this.bR_NFPartnerType = bR_NFPartnerType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStreetName</b>
     * </p>
     *
     * @param bR_NFPartnerStreetName
     *            Street and House Number
     */
    public void setBR_NFPartnerStreetName( @Nullable final String bR_NFPartnerStreetName )
    {
        rememberChangedField("BR_NFPartnerStreetName", this.bR_NFPartnerStreetName);
        this.bR_NFPartnerStreetName = bR_NFPartnerStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCityName</b>
     * </p>
     *
     * @param bR_NFPartnerCityName
     *            City
     */
    public void setBR_NFPartnerCityName( @Nullable final String bR_NFPartnerCityName )
    {
        rememberChangedField("BR_NFPartnerCityName", this.bR_NFPartnerCityName);
        this.bR_NFPartnerCityName = bR_NFPartnerCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerRegionCode</b>
     * </p>
     *
     * @param bR_NFPartnerRegionCode
     *            Region (State, Province, County)
     */
    public void setBR_NFPartnerRegionCode( @Nullable final String bR_NFPartnerRegionCode )
    {
        rememberChangedField("BR_NFPartnerRegionCode", this.bR_NFPartnerRegionCode);
        this.bR_NFPartnerRegionCode = bR_NFPartnerRegionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerDistrictName</b>
     * </p>
     *
     * @param bR_NFPartnerDistrictName
     *            District
     */
    public void setBR_NFPartnerDistrictName( @Nullable final String bR_NFPartnerDistrictName )
    {
        rememberChangedField("BR_NFPartnerDistrictName", this.bR_NFPartnerDistrictName);
        this.bR_NFPartnerDistrictName = bR_NFPartnerDistrictName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCountryCode</b>
     * </p>
     *
     * @param bR_NFPartnerCountryCode
     *            Country/Region Key
     */
    public void setBR_NFPartnerCountryCode( @Nullable final String bR_NFPartnerCountryCode )
    {
        rememberChangedField("BR_NFPartnerCountryCode", this.bR_NFPartnerCountryCode);
        this.bR_NFPartnerCountryCode = bR_NFPartnerCountryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPostalCode</b>
     * </p>
     *
     * @param bR_NFPartnerPostalCode
     *            Postal Code
     */
    public void setBR_NFPartnerPostalCode( @Nullable final String bR_NFPartnerPostalCode )
    {
        rememberChangedField("BR_NFPartnerPostalCode", this.bR_NFPartnerPostalCode);
        this.bR_NFPartnerPostalCode = bR_NFPartnerPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCFOPCategory</b>
     * </p>
     *
     * @param bR_NFPartnerCFOPCategory
     *            CFOP Category
     */
    public void setBR_NFPartnerCFOPCategory( @Nullable final String bR_NFPartnerCFOPCategory )
    {
        rememberChangedField("BR_NFPartnerCFOPCategory", this.bR_NFPartnerCFOPCategory);
        this.bR_NFPartnerCFOPCategory = bR_NFPartnerCFOPCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerIsNaturalPerson</b>
     * </p>
     *
     * @param bR_NFPartnerIsNaturalPerson
     *            Natural Person
     */
    public void setBR_NFPartnerIsNaturalPerson( @Nullable final String bR_NFPartnerIsNaturalPerson )
    {
        rememberChangedField("BR_NFPartnerIsNaturalPerson", this.bR_NFPartnerIsNaturalPerson);
        this.bR_NFPartnerIsNaturalPerson = bR_NFPartnerIsNaturalPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCNPJ</b>
     * </p>
     *
     * @param bR_NFPartnerCNPJ
     *            CNPJ
     */
    public void setBR_NFPartnerCNPJ( @Nullable final String bR_NFPartnerCNPJ )
    {
        rememberChangedField("BR_NFPartnerCNPJ", this.bR_NFPartnerCNPJ);
        this.bR_NFPartnerCNPJ = bR_NFPartnerCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerCPF</b>
     * </p>
     *
     * @param bR_NFPartnerCPF
     *            CPF
     */
    public void setBR_NFPartnerCPF( @Nullable final String bR_NFPartnerCPF )
    {
        rememberChangedField("BR_NFPartnerCPF", this.bR_NFPartnerCPF);
        this.bR_NFPartnerCPF = bR_NFPartnerCPF;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Addresses: telephone no.
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerStateTaxNumber</b>
     * </p>
     *
     * @param bR_NFPartnerStateTaxNumber
     *            State Tax Number
     */
    public void setBR_NFPartnerStateTaxNumber( @Nullable final String bR_NFPartnerStateTaxNumber )
    {
        rememberChangedField("BR_NFPartnerStateTaxNumber", this.bR_NFPartnerStateTaxNumber);
        this.bR_NFPartnerStateTaxNumber = bR_NFPartnerStateTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerMunicipalTaxNumber</b>
     * </p>
     *
     * @param bR_NFPartnerMunicipalTaxNumber
     *            Municipal Tax Number
     */
    public void setBR_NFPartnerMunicipalTaxNumber( @Nullable final String bR_NFPartnerMunicipalTaxNumber )
    {
        rememberChangedField("BR_NFPartnerMunicipalTaxNumber", this.bR_NFPartnerMunicipalTaxNumber);
        this.bR_NFPartnerMunicipalTaxNumber = bR_NFPartnerMunicipalTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_CTeFiscalDocumentPartner</b>
     * </p>
     *
     * @param bR_CTeFiscalDocumentPartner
     *            CT-e Partner in Fiscal Document
     */
    public void setBR_CTeFiscalDocumentPartner( @Nullable final String bR_CTeFiscalDocumentPartner )
    {
        rememberChangedField("BR_CTeFiscalDocumentPartner", this.bR_CTeFiscalDocumentPartner);
        this.bR_CTeFiscalDocumentPartner = bR_CTeFiscalDocumentPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPartnerPlaceType</b>
     * </p>
     *
     * @param bR_NFPartnerPlaceType
     *            Nota Fiscal Partner Place Type
     */
    public void setBR_NFPartnerPlaceType( @Nullable final String bR_NFPartnerPlaceType )
    {
        rememberChangedField("BR_NFPartnerPlaceType", this.bR_NFPartnerPlaceType);
        this.bR_NFPartnerPlaceType = bR_NFPartnerPlaceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @param isBusinessPurposeCompleted
     *            The isBusinessPurposeCompleted to set.
     */
    public void setIsBusinessPurposeCompleted( @Nullable final String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFPartnerFunction", getBR_NFPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFPartnerFunction", getBR_NFPartnerFunction());
        values.put("BR_NFPartner", getBR_NFPartner());
        values.put("BR_NFPartnerTitle", getBR_NFPartnerTitle());
        values.put("BR_NFPartnerName1", getBR_NFPartnerName1());
        values.put("BR_NFPartnerName2", getBR_NFPartnerName2());
        values.put("BR_NFPartnerName3", getBR_NFPartnerName3());
        values.put("BR_NFPartnerName4", getBR_NFPartnerName4());
        values.put("BR_NFPartnerType", getBR_NFPartnerType());
        values.put("BR_NFPartnerStreetName", getBR_NFPartnerStreetName());
        values.put("BR_NFPartnerCityName", getBR_NFPartnerCityName());
        values.put("BR_NFPartnerRegionCode", getBR_NFPartnerRegionCode());
        values.put("BR_NFPartnerDistrictName", getBR_NFPartnerDistrictName());
        values.put("BR_NFPartnerCountryCode", getBR_NFPartnerCountryCode());
        values.put("BR_NFPartnerPostalCode", getBR_NFPartnerPostalCode());
        values.put("BR_NFPartnerCFOPCategory", getBR_NFPartnerCFOPCategory());
        values.put("BR_NFPartnerIsNaturalPerson", getBR_NFPartnerIsNaturalPerson());
        values.put("BR_NFPartnerCNPJ", getBR_NFPartnerCNPJ());
        values.put("BR_NFPartnerCPF", getBR_NFPartnerCPF());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("BR_NFPartnerStateTaxNumber", getBR_NFPartnerStateTaxNumber());
        values.put("BR_NFPartnerMunicipalTaxNumber", getBR_NFPartnerMunicipalTaxNumber());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("BR_CTeFiscalDocumentPartner", getBR_CTeFiscalDocumentPartner());
        values.put("BR_NFPartnerPlaceType", getBR_NFPartnerPlaceType());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerFunction") ) {
                final Object value = values.remove("BR_NFPartnerFunction");
                if( (value == null) || (!value.equals(getBR_NFPartnerFunction())) ) {
                    setBR_NFPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartner") ) {
                final Object value = values.remove("BR_NFPartner");
                if( (value == null) || (!value.equals(getBR_NFPartner())) ) {
                    setBR_NFPartner(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerTitle") ) {
                final Object value = values.remove("BR_NFPartnerTitle");
                if( (value == null) || (!value.equals(getBR_NFPartnerTitle())) ) {
                    setBR_NFPartnerTitle(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName1") ) {
                final Object value = values.remove("BR_NFPartnerName1");
                if( (value == null) || (!value.equals(getBR_NFPartnerName1())) ) {
                    setBR_NFPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName2") ) {
                final Object value = values.remove("BR_NFPartnerName2");
                if( (value == null) || (!value.equals(getBR_NFPartnerName2())) ) {
                    setBR_NFPartnerName2(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName3") ) {
                final Object value = values.remove("BR_NFPartnerName3");
                if( (value == null) || (!value.equals(getBR_NFPartnerName3())) ) {
                    setBR_NFPartnerName3(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerName4") ) {
                final Object value = values.remove("BR_NFPartnerName4");
                if( (value == null) || (!value.equals(getBR_NFPartnerName4())) ) {
                    setBR_NFPartnerName4(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerType") ) {
                final Object value = values.remove("BR_NFPartnerType");
                if( (value == null) || (!value.equals(getBR_NFPartnerType())) ) {
                    setBR_NFPartnerType(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerStreetName") ) {
                final Object value = values.remove("BR_NFPartnerStreetName");
                if( (value == null) || (!value.equals(getBR_NFPartnerStreetName())) ) {
                    setBR_NFPartnerStreetName(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCityName") ) {
                final Object value = values.remove("BR_NFPartnerCityName");
                if( (value == null) || (!value.equals(getBR_NFPartnerCityName())) ) {
                    setBR_NFPartnerCityName(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerRegionCode") ) {
                final Object value = values.remove("BR_NFPartnerRegionCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerRegionCode())) ) {
                    setBR_NFPartnerRegionCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerDistrictName") ) {
                final Object value = values.remove("BR_NFPartnerDistrictName");
                if( (value == null) || (!value.equals(getBR_NFPartnerDistrictName())) ) {
                    setBR_NFPartnerDistrictName(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCountryCode") ) {
                final Object value = values.remove("BR_NFPartnerCountryCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerCountryCode())) ) {
                    setBR_NFPartnerCountryCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerPostalCode") ) {
                final Object value = values.remove("BR_NFPartnerPostalCode");
                if( (value == null) || (!value.equals(getBR_NFPartnerPostalCode())) ) {
                    setBR_NFPartnerPostalCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCFOPCategory") ) {
                final Object value = values.remove("BR_NFPartnerCFOPCategory");
                if( (value == null) || (!value.equals(getBR_NFPartnerCFOPCategory())) ) {
                    setBR_NFPartnerCFOPCategory(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerIsNaturalPerson") ) {
                final Object value = values.remove("BR_NFPartnerIsNaturalPerson");
                if( (value == null) || (!value.equals(getBR_NFPartnerIsNaturalPerson())) ) {
                    setBR_NFPartnerIsNaturalPerson(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCNPJ") ) {
                final Object value = values.remove("BR_NFPartnerCNPJ");
                if( (value == null) || (!value.equals(getBR_NFPartnerCNPJ())) ) {
                    setBR_NFPartnerCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerCPF") ) {
                final Object value = values.remove("BR_NFPartnerCPF");
                if( (value == null) || (!value.equals(getBR_NFPartnerCPF())) ) {
                    setBR_NFPartnerCPF(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerStateTaxNumber") ) {
                final Object value = values.remove("BR_NFPartnerStateTaxNumber");
                if( (value == null) || (!value.equals(getBR_NFPartnerStateTaxNumber())) ) {
                    setBR_NFPartnerStateTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerMunicipalTaxNumber") ) {
                final Object value = values.remove("BR_NFPartnerMunicipalTaxNumber");
                if( (value == null) || (!value.equals(getBR_NFPartnerMunicipalTaxNumber())) ) {
                    setBR_NFPartnerMunicipalTaxNumber(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("BR_CTeFiscalDocumentPartner") ) {
                final Object value = values.remove("BR_CTeFiscalDocumentPartner");
                if( (value == null) || (!value.equals(getBR_CTeFiscalDocumentPartner())) ) {
                    setBR_CTeFiscalDocumentPartner(((String) value));
                }
            }
            if( values.containsKey("BR_NFPartnerPlaceType") ) {
                final Object value = values.remove("BR_NFPartnerPlaceType");
                if( (value == null) || (!value.equals(getBR_NFPartnerPlaceType())) ) {
                    setBR_NFPartnerPlaceType(((String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFPartner</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFPartner instances.
     *
     */
    public final static class BR_NFPartnerBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFPartner.BR_NFPartnerBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFPartner</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFPartner.BR_NFPartnerBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
