/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFReferencedProcessSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
 * BR_NFReferencedProcess} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BR_NFReferencedProcessByKeyFluentHelper
    extends
    FluentHelperByKey<BR_NFReferencedProcessByKeyFluentHelper, BR_NFReferencedProcess, BR_NFReferencedProcessSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     * BR_NFReferencedProcess} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param bR_NFReferencedProcessSqncNmbr
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BR_NFReferencedProcess}
     * @param bR_NotaFiscal
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BR_NFReferencedProcess}
     */
    public BR_NFReferencedProcessByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String bR_NotaFiscal,
        final String bR_NFReferencedProcessSqncNmbr )
    {
        super(servicePath, entityCollection);
        this.key.put("BR_NotaFiscal", bR_NotaFiscal);
        this.key.put("BR_NFReferencedProcessSqncNmbr", bR_NFReferencedProcessSqncNmbr);
    }

    @Override
    @Nonnull
    protected Class<BR_NFReferencedProcess> getEntityClass()
    {
        return BR_NFReferencedProcess.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
