/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTAXField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTAXOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFTAXSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Tax
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFTAXType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFTAX extends VdmEntity<BR_NFTAX>
{

    /**
     * Selector for all available fields of BR_NFTAX.
     *
     */
    public final static BR_NFTAXSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BR_NOTA_FISCAL = new BR_NFTAXField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BR_NOTA_FISCAL_ITEM = new BR_NFTAXField<String>("BR_NotaFiscalItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxType</b>
     * </p>
     *
     * @return Tax Type
     */
    @Key
    @SerializedName( "BR_TaxType" )
    @JsonProperty( "BR_TaxType" )
    @Nullable
    @ODataField( odataName = "BR_TaxType" )
    private String bR_TaxType;
    /**
     * Use with available fluent helpers to apply the <b>BR_TaxType</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BR_TAX_TYPE = new BR_NFTAXField<String>("BR_TaxType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     *
     * @return Tax Group
     */
    @SerializedName( "TaxGroup" )
    @JsonProperty( "TaxGroup" )
    @Nullable
    @ODataField( odataName = "TaxGroup" )
    private String taxGroup;
    /**
     * Use with available fluent helpers to apply the <b>TaxGroup</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> TAX_GROUP = new BR_NFTAXField<String>("TaxGroup");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemBaseAmount</b>
     * </p>
     *
     * @return Base Amount
     */
    @SerializedName( "BR_NFItemBaseAmount" )
    @JsonProperty( "BR_NFItemBaseAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFItemBaseAmount" )
    private BigDecimal bR_NFItemBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_BASE_AMOUNT =
        new BR_NFTAXField<BigDecimal>("BR_NFItemBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxRate</b>
     * </p>
     *
     * @return Tax Rate
     */
    @SerializedName( "BR_NFItemTaxRate" )
    @JsonProperty( "BR_NFItemTaxRate" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxRate" )
    private BigDecimal bR_NFItemTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxRate</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_TAX_RATE =
        new BR_NFTAXField<BigDecimal>("BR_NFItemTaxRate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxAmount</b>
     * </p>
     *
     * @return Tax value
     */
    @SerializedName( "BR_NFItemTaxAmount" )
    @JsonProperty( "BR_NFItemTaxAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxAmount" )
    private BigDecimal bR_NFItemTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_TAX_AMOUNT =
        new BR_NFTAXField<BigDecimal>("BR_NFItemTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExcludedBaseAmount</b>
     * </p>
     *
     * @return Excluded Base Amount
     */
    @SerializedName( "BR_NFItemExcludedBaseAmount" )
    @JsonProperty( "BR_NFItemExcludedBaseAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFItemExcludedBaseAmount" )
    private BigDecimal bR_NFItemExcludedBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemExcludedBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_EXCLUDED_BASE_AMOUNT =
        new BR_NFTAXField<BigDecimal>("BR_NFItemExcludedBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemOtherBaseAmount</b>
     * </p>
     *
     * @return Other base amount
     */
    @SerializedName( "BR_NFItemOtherBaseAmount" )
    @JsonProperty( "BR_NFItemOtherBaseAmount" )
    @Nullable
    @ODataField( odataName = "BR_NFItemOtherBaseAmount" )
    private BigDecimal bR_NFItemOtherBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemOtherBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_OTHER_BASE_AMOUNT =
        new BR_NFTAXField<BigDecimal>("BR_NFItemOtherBaseAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct1Unit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_NFItemTaxBasePct1Unit" )
    @JsonProperty( "BR_NFItemTaxBasePct1Unit" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxBasePct1Unit" )
    private String bR_NFItemTaxBasePct1Unit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxBasePct1Unit</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITEM_TAX_BASE_PCT1_UNIT =
        new BR_NFTAXField<String>("BR_NFItemTaxBasePct1Unit");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct1</b>
     * </p>
     *
     * @return Tax Base
     */
    @SerializedName( "BR_NFItemTaxBasePct1" )
    @JsonProperty( "BR_NFItemTaxBasePct1" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxBasePct1" )
    private BigDecimal bR_NFItemTaxBasePct1;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxBasePct1</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_TAX_BASE_PCT1 =
        new BR_NFTAXField<BigDecimal>("BR_NFItemTaxBasePct1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct2Unit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_NFItemTaxBasePct2Unit" )
    @JsonProperty( "BR_NFItemTaxBasePct2Unit" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxBasePct2Unit" )
    private String bR_NFItemTaxBasePct2Unit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxBasePct2Unit</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITEM_TAX_BASE_PCT2_UNIT =
        new BR_NFTAXField<String>("BR_NFItemTaxBasePct2Unit");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct2</b>
     * </p>
     *
     * @return Tax base (%)
     */
    @SerializedName( "BR_NFItemTaxBasePct2" )
    @JsonProperty( "BR_NFItemTaxBasePct2" )
    @Nullable
    @ODataField( odataName = "BR_NFItemTaxBasePct2" )
    private BigDecimal bR_NFItemTaxBasePct2;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemTaxBasePct2</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_TAX_BASE_PCT2 =
        new BR_NFTAXField<BigDecimal>("BR_NFItemTaxBasePct2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemIsStatisticalTax</b>
     * </p>
     *
     * @return Statistical Tax Item
     */
    @SerializedName( "BR_NFItemIsStatisticalTax" )
    @JsonProperty( "BR_NFItemIsStatisticalTax" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFItemIsStatisticalTax" )
    private Boolean bR_NFItemIsStatisticalTax;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemIsStatisticalTax</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<Boolean> BRNF_ITEM_IS_STATISTICAL_TAX =
        new BR_NFTAXField<Boolean>("BR_NFItemIsStatisticalTax");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasFixedMktTariff</b>
     * </p>
     *
     * @return Nota Fiscal tax record type
     */
    @SerializedName( "BR_NFItemHasFixedMktTariff" )
    @JsonProperty( "BR_NFItemHasFixedMktTariff" )
    @Nullable
    @ODataField( odataName = "BR_NFItemHasFixedMktTariff" )
    private String bR_NFItemHasFixedMktTariff;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemHasFixedMktTariff</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITEM_HAS_FIXED_MKT_TARIFF =
        new BR_NFTAXField<String>("BR_NFItemHasFixedMktTariff");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffBaseQty</b>
     * </p>
     *
     * @return Pauta Base Four Decimals
     */
    @SerializedName( "BR_NFItemFixedMktTariffBaseQty" )
    @JsonProperty( "BR_NFItemFixedMktTariffBaseQty" )
    @Nullable
    @ODataField( odataName = "BR_NFItemFixedMktTariffBaseQty" )
    private BigDecimal bR_NFItemFixedMktTariffBaseQty;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemFixedMktTariffBaseQty</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_FIXED_MKT_TARIFF_BASE_QTY =
        new BR_NFTAXField<BigDecimal>("BR_NFItemFixedMktTariffBaseQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMarketTariffUnit</b>
     * </p>
     *
     * @return Pauta Unit
     */
    @SerializedName( "BR_NFItemFixedMarketTariffUnit" )
    @JsonProperty( "BR_NFItemFixedMarketTariffUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFItemFixedMarketTariffUnit" )
    private String bR_NFItemFixedMarketTariffUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemFixedMarketTariffUnit</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITEM_FIXED_MARKET_TARIFF_UNIT =
        new BR_NFTAXField<String>("BR_NFItemFixedMarketTariffUnit");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemWhldgCollectionCode</b>
     * </p>
     *
     * @return Official Withholding Tax Collection Code
     */
    @SerializedName( "BR_NFItemWhldgCollectionCode" )
    @JsonProperty( "BR_NFItemWhldgCollectionCode" )
    @Nullable
    @ODataField( odataName = "BR_NFItemWhldgCollectionCode" )
    private String bR_NFItemWhldgCollectionCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemWhldgCollectionCode</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITEM_WHLDG_COLLECTION_CODE =
        new BR_NFTAXField<String>("BR_NFItemWhldgCollectionCode");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffTaxRate</b>
     * </p>
     *
     * @return Tax Rate with 4 Decimal Places
     */
    @SerializedName( "BR_NFItemFixedMktTariffTaxRate" )
    @JsonProperty( "BR_NFItemFixedMktTariffTaxRate" )
    @Nullable
    @ODataField( odataName = "BR_NFItemFixedMktTariffTaxRate" )
    private BigDecimal bR_NFItemFixedMktTariffTaxRate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemFixedMktTariffTaxRate</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_FIXED_MKT_TARIFF_TAX_RATE =
        new BR_NFTAXField<BigDecimal>("BR_NFItemFixedMktTariffTaxRate");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffQty</b>
     * </p>
     *
     * @return Number of Units for Pauta with 4 DP (for Reporting Only)
     */
    @SerializedName( "BR_NFItemFixedMktTariffQty" )
    @JsonProperty( "BR_NFItemFixedMktTariffQty" )
    @Nullable
    @ODataField( odataName = "BR_NFItemFixedMktTariffQty" )
    private BigDecimal bR_NFItemFixedMktTariffQty;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemFixedMktTariffQty</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> BRNF_ITEM_FIXED_MKT_TARIFF_QTY =
        new BR_NFTAXField<BigDecimal>("BR_NFItemFixedMktTariffQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItmFxdMktTariffUnit4Dcmls</b>
     * </p>
     *
     * @return UoM for Pauta with 4 Decimal Places (for Reporting Only)
     */
    @SerializedName( "BR_NFItmFxdMktTariffUnit4Dcmls" )
    @JsonProperty( "BR_NFItmFxdMktTariffUnit4Dcmls" )
    @Nullable
    @ODataField( odataName = "BR_NFItmFxdMktTariffUnit4Dcmls" )
    private String bR_NFItmFxdMktTariffUnit4Dcmls;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItmFxdMktTariffUnit4Dcmls</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNF_ITM_FXD_MKT_TARIFF_UNIT4_DCMLS =
        new BR_NFTAXField<String>("BR_NFItmFxdMktTariffUnit4Dcmls");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxesAreIncludedInNetAmount</b>
     * </p>
     *
     * @return Tax Already Included in Net Value
     */
    @SerializedName( "TaxesAreIncludedInNetAmount" )
    @JsonProperty( "TaxesAreIncludedInNetAmount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TaxesAreIncludedInNetAmount" )
    private Boolean taxesAreIncludedInNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxesAreIncludedInNetAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<Boolean> TAXES_ARE_INCLUDED_IN_NET_AMOUNT =
        new BR_NFTAXField<Boolean>("TaxesAreIncludedInNetAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasWithholdingTax</b>
     * </p>
     *
     * @return Withholding Tax
     */
    @SerializedName( "BR_NFItemHasWithholdingTax" )
    @JsonProperty( "BR_NFItemHasWithholdingTax" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_NFItemHasWithholdingTax" )
    private Boolean bR_NFItemHasWithholdingTax;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemHasWithholdingTax</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<Boolean> BRNF_ITEM_HAS_WITHHOLDING_TAX =
        new BR_NFTAXField<Boolean>("BR_NFItemHasWithholdingTax");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSServiceTypeIncoming</b>
     * </p>
     *
     * @return Service Type (Incoming)
     */
    @SerializedName( "BR_NFSServiceTypeIncoming" )
    @JsonProperty( "BR_NFSServiceTypeIncoming" )
    @Nullable
    @ODataField( odataName = "BR_NFSServiceTypeIncoming" )
    private String bR_NFSServiceTypeIncoming;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSServiceTypeIncoming</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNFS_SERVICE_TYPE_INCOMING =
        new BR_NFTAXField<String>("BR_NFSServiceTypeIncoming");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSServiceTypeOutgoing</b>
     * </p>
     *
     * @return Service Type (Outgoing)
     */
    @SerializedName( "BR_NFSServiceTypeOutgoing" )
    @JsonProperty( "BR_NFSServiceTypeOutgoing" )
    @Nullable
    @ODataField( odataName = "BR_NFSServiceTypeOutgoing" )
    private String bR_NFSServiceTypeOutgoing;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFSServiceTypeOutgoing</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> BRNFS_SERVICE_TYPE_OUTGOING =
        new BR_NFTAXField<String>("BR_NFSServiceTypeOutgoing");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction Code For Brazilian Tax Calculation
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> TAX_JURISDICTION = new BR_NFTAXField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AggregateBaseAmount</b>
     * </p>
     *
     * @return The aggregateBaseAmount contained in this entity.
     */
    @SerializedName( "AggregateBaseAmount" )
    @JsonProperty( "AggregateBaseAmount" )
    @Nullable
    @ODataField( odataName = "AggregateBaseAmount" )
    private BigDecimal aggregateBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>AggregateBaseAmount</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<BigDecimal> AGGREGATE_BASE_AMOUNT =
        new BR_NFTAXField<BigDecimal>("AggregateBaseAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFTAXField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFTAXField<String>("SalesDocumentCurrency");
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFTAX</b> to single <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFItem toBR_NFItem;
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTAX</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFTAXOneToOneLink<BR_NFItem> TO_BRNF_ITEM =
        new BR_NFTAXOneToOneLink<BR_NFItem>("to_BR_NFItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFTAXOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFTAXOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFTAX> getType()
    {
        return BR_NFTAX.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxType</b>
     * </p>
     *
     * @param bR_TaxType
     *            Tax Type
     */
    public void setBR_TaxType( @Nullable final String bR_TaxType )
    {
        rememberChangedField("BR_TaxType", this.bR_TaxType);
        this.bR_TaxType = bR_TaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     *
     * @param taxGroup
     *            Tax Group
     */
    public void setTaxGroup( @Nullable final String taxGroup )
    {
        rememberChangedField("TaxGroup", this.taxGroup);
        this.taxGroup = taxGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemBaseAmount</b>
     * </p>
     *
     * @param bR_NFItemBaseAmount
     *            Base Amount
     */
    public void setBR_NFItemBaseAmount( @Nullable final BigDecimal bR_NFItemBaseAmount )
    {
        rememberChangedField("BR_NFItemBaseAmount", this.bR_NFItemBaseAmount);
        this.bR_NFItemBaseAmount = bR_NFItemBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxRate</b>
     * </p>
     *
     * @param bR_NFItemTaxRate
     *            Tax Rate
     */
    public void setBR_NFItemTaxRate( @Nullable final BigDecimal bR_NFItemTaxRate )
    {
        rememberChangedField("BR_NFItemTaxRate", this.bR_NFItemTaxRate);
        this.bR_NFItemTaxRate = bR_NFItemTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxAmount</b>
     * </p>
     *
     * @param bR_NFItemTaxAmount
     *            Tax value
     */
    public void setBR_NFItemTaxAmount( @Nullable final BigDecimal bR_NFItemTaxAmount )
    {
        rememberChangedField("BR_NFItemTaxAmount", this.bR_NFItemTaxAmount);
        this.bR_NFItemTaxAmount = bR_NFItemTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemExcludedBaseAmount</b>
     * </p>
     *
     * @param bR_NFItemExcludedBaseAmount
     *            Excluded Base Amount
     */
    public void setBR_NFItemExcludedBaseAmount( @Nullable final BigDecimal bR_NFItemExcludedBaseAmount )
    {
        rememberChangedField("BR_NFItemExcludedBaseAmount", this.bR_NFItemExcludedBaseAmount);
        this.bR_NFItemExcludedBaseAmount = bR_NFItemExcludedBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemOtherBaseAmount</b>
     * </p>
     *
     * @param bR_NFItemOtherBaseAmount
     *            Other base amount
     */
    public void setBR_NFItemOtherBaseAmount( @Nullable final BigDecimal bR_NFItemOtherBaseAmount )
    {
        rememberChangedField("BR_NFItemOtherBaseAmount", this.bR_NFItemOtherBaseAmount);
        this.bR_NFItemOtherBaseAmount = bR_NFItemOtherBaseAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct1Unit</b>
     * </p>
     *
     * @param bR_NFItemTaxBasePct1Unit
     *            Unit of Measurement
     */
    public void setBR_NFItemTaxBasePct1Unit( @Nullable final String bR_NFItemTaxBasePct1Unit )
    {
        rememberChangedField("BR_NFItemTaxBasePct1Unit", this.bR_NFItemTaxBasePct1Unit);
        this.bR_NFItemTaxBasePct1Unit = bR_NFItemTaxBasePct1Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct1</b>
     * </p>
     *
     * @param bR_NFItemTaxBasePct1
     *            Tax Base
     */
    public void setBR_NFItemTaxBasePct1( @Nullable final BigDecimal bR_NFItemTaxBasePct1 )
    {
        rememberChangedField("BR_NFItemTaxBasePct1", this.bR_NFItemTaxBasePct1);
        this.bR_NFItemTaxBasePct1 = bR_NFItemTaxBasePct1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct2Unit</b>
     * </p>
     *
     * @param bR_NFItemTaxBasePct2Unit
     *            Unit of Measurement
     */
    public void setBR_NFItemTaxBasePct2Unit( @Nullable final String bR_NFItemTaxBasePct2Unit )
    {
        rememberChangedField("BR_NFItemTaxBasePct2Unit", this.bR_NFItemTaxBasePct2Unit);
        this.bR_NFItemTaxBasePct2Unit = bR_NFItemTaxBasePct2Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemTaxBasePct2</b>
     * </p>
     *
     * @param bR_NFItemTaxBasePct2
     *            Tax base (%)
     */
    public void setBR_NFItemTaxBasePct2( @Nullable final BigDecimal bR_NFItemTaxBasePct2 )
    {
        rememberChangedField("BR_NFItemTaxBasePct2", this.bR_NFItemTaxBasePct2);
        this.bR_NFItemTaxBasePct2 = bR_NFItemTaxBasePct2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemIsStatisticalTax</b>
     * </p>
     *
     * @param bR_NFItemIsStatisticalTax
     *            Statistical Tax Item
     */
    public void setBR_NFItemIsStatisticalTax( @Nullable final Boolean bR_NFItemIsStatisticalTax )
    {
        rememberChangedField("BR_NFItemIsStatisticalTax", this.bR_NFItemIsStatisticalTax);
        this.bR_NFItemIsStatisticalTax = bR_NFItemIsStatisticalTax;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasFixedMktTariff</b>
     * </p>
     *
     * @param bR_NFItemHasFixedMktTariff
     *            Nota Fiscal tax record type
     */
    public void setBR_NFItemHasFixedMktTariff( @Nullable final String bR_NFItemHasFixedMktTariff )
    {
        rememberChangedField("BR_NFItemHasFixedMktTariff", this.bR_NFItemHasFixedMktTariff);
        this.bR_NFItemHasFixedMktTariff = bR_NFItemHasFixedMktTariff;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffBaseQty</b>
     * </p>
     *
     * @param bR_NFItemFixedMktTariffBaseQty
     *            Pauta Base Four Decimals
     */
    public void setBR_NFItemFixedMktTariffBaseQty( @Nullable final BigDecimal bR_NFItemFixedMktTariffBaseQty )
    {
        rememberChangedField("BR_NFItemFixedMktTariffBaseQty", this.bR_NFItemFixedMktTariffBaseQty);
        this.bR_NFItemFixedMktTariffBaseQty = bR_NFItemFixedMktTariffBaseQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMarketTariffUnit</b>
     * </p>
     *
     * @param bR_NFItemFixedMarketTariffUnit
     *            Pauta Unit
     */
    public void setBR_NFItemFixedMarketTariffUnit( @Nullable final String bR_NFItemFixedMarketTariffUnit )
    {
        rememberChangedField("BR_NFItemFixedMarketTariffUnit", this.bR_NFItemFixedMarketTariffUnit);
        this.bR_NFItemFixedMarketTariffUnit = bR_NFItemFixedMarketTariffUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemWhldgCollectionCode</b>
     * </p>
     *
     * @param bR_NFItemWhldgCollectionCode
     *            Official Withholding Tax Collection Code
     */
    public void setBR_NFItemWhldgCollectionCode( @Nullable final String bR_NFItemWhldgCollectionCode )
    {
        rememberChangedField("BR_NFItemWhldgCollectionCode", this.bR_NFItemWhldgCollectionCode);
        this.bR_NFItemWhldgCollectionCode = bR_NFItemWhldgCollectionCode;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffTaxRate</b>
     * </p>
     *
     * @param bR_NFItemFixedMktTariffTaxRate
     *            Tax Rate with 4 Decimal Places
     */
    public void setBR_NFItemFixedMktTariffTaxRate( @Nullable final BigDecimal bR_NFItemFixedMktTariffTaxRate )
    {
        rememberChangedField("BR_NFItemFixedMktTariffTaxRate", this.bR_NFItemFixedMktTariffTaxRate);
        this.bR_NFItemFixedMktTariffTaxRate = bR_NFItemFixedMktTariffTaxRate;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemFixedMktTariffQty</b>
     * </p>
     *
     * @param bR_NFItemFixedMktTariffQty
     *            Number of Units for Pauta with 4 DP (for Reporting Only)
     */
    public void setBR_NFItemFixedMktTariffQty( @Nullable final BigDecimal bR_NFItemFixedMktTariffQty )
    {
        rememberChangedField("BR_NFItemFixedMktTariffQty", this.bR_NFItemFixedMktTariffQty);
        this.bR_NFItemFixedMktTariffQty = bR_NFItemFixedMktTariffQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItmFxdMktTariffUnit4Dcmls</b>
     * </p>
     *
     * @param bR_NFItmFxdMktTariffUnit4Dcmls
     *            UoM for Pauta with 4 Decimal Places (for Reporting Only)
     */
    public void setBR_NFItmFxdMktTariffUnit4Dcmls( @Nullable final String bR_NFItmFxdMktTariffUnit4Dcmls )
    {
        rememberChangedField("BR_NFItmFxdMktTariffUnit4Dcmls", this.bR_NFItmFxdMktTariffUnit4Dcmls);
        this.bR_NFItmFxdMktTariffUnit4Dcmls = bR_NFItmFxdMktTariffUnit4Dcmls;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxesAreIncludedInNetAmount</b>
     * </p>
     *
     * @param taxesAreIncludedInNetAmount
     *            Tax Already Included in Net Value
     */
    public void setTaxesAreIncludedInNetAmount( @Nullable final Boolean taxesAreIncludedInNetAmount )
    {
        rememberChangedField("TaxesAreIncludedInNetAmount", this.taxesAreIncludedInNetAmount);
        this.taxesAreIncludedInNetAmount = taxesAreIncludedInNetAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemHasWithholdingTax</b>
     * </p>
     *
     * @param bR_NFItemHasWithholdingTax
     *            Withholding Tax
     */
    public void setBR_NFItemHasWithholdingTax( @Nullable final Boolean bR_NFItemHasWithholdingTax )
    {
        rememberChangedField("BR_NFItemHasWithholdingTax", this.bR_NFItemHasWithholdingTax);
        this.bR_NFItemHasWithholdingTax = bR_NFItemHasWithholdingTax;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSServiceTypeIncoming</b>
     * </p>
     *
     * @param bR_NFSServiceTypeIncoming
     *            Service Type (Incoming)
     */
    public void setBR_NFSServiceTypeIncoming( @Nullable final String bR_NFSServiceTypeIncoming )
    {
        rememberChangedField("BR_NFSServiceTypeIncoming", this.bR_NFSServiceTypeIncoming);
        this.bR_NFSServiceTypeIncoming = bR_NFSServiceTypeIncoming;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFSServiceTypeOutgoing</b>
     * </p>
     *
     * @param bR_NFSServiceTypeOutgoing
     *            Service Type (Outgoing)
     */
    public void setBR_NFSServiceTypeOutgoing( @Nullable final String bR_NFSServiceTypeOutgoing )
    {
        rememberChangedField("BR_NFSServiceTypeOutgoing", this.bR_NFSServiceTypeOutgoing);
        this.bR_NFSServiceTypeOutgoing = bR_NFSServiceTypeOutgoing;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction Code For Brazilian Tax Calculation
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AggregateBaseAmount</b>
     * </p>
     *
     * @param aggregateBaseAmount
     *            The aggregateBaseAmount to set.
     */
    public void setAggregateBaseAmount( @Nullable final BigDecimal aggregateBaseAmount )
    {
        rememberChangedField("AggregateBaseAmount", this.aggregateBaseAmount);
        this.aggregateBaseAmount = aggregateBaseAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFTAX";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        result.put("BR_TaxType", getBR_TaxType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("BR_TaxType", getBR_TaxType());
        values.put("TaxGroup", getTaxGroup());
        values.put("BR_NFItemBaseAmount", getBR_NFItemBaseAmount());
        values.put("BR_NFItemTaxRate", getBR_NFItemTaxRate());
        values.put("BR_NFItemTaxAmount", getBR_NFItemTaxAmount());
        values.put("BR_NFItemExcludedBaseAmount", getBR_NFItemExcludedBaseAmount());
        values.put("BR_NFItemOtherBaseAmount", getBR_NFItemOtherBaseAmount());
        values.put("BR_NFItemTaxBasePct1Unit", getBR_NFItemTaxBasePct1Unit());
        values.put("BR_NFItemTaxBasePct1", getBR_NFItemTaxBasePct1());
        values.put("BR_NFItemTaxBasePct2Unit", getBR_NFItemTaxBasePct2Unit());
        values.put("BR_NFItemTaxBasePct2", getBR_NFItemTaxBasePct2());
        values.put("BR_NFItemIsStatisticalTax", getBR_NFItemIsStatisticalTax());
        values.put("BR_NFItemHasFixedMktTariff", getBR_NFItemHasFixedMktTariff());
        values.put("BR_NFItemFixedMktTariffBaseQty", getBR_NFItemFixedMktTariffBaseQty());
        values.put("BR_NFItemFixedMarketTariffUnit", getBR_NFItemFixedMarketTariffUnit());
        values.put("BR_NFItemWhldgCollectionCode", getBR_NFItemWhldgCollectionCode());
        values.put("BR_NFItemFixedMktTariffTaxRate", getBR_NFItemFixedMktTariffTaxRate());
        values.put("BR_NFItemFixedMktTariffQty", getBR_NFItemFixedMktTariffQty());
        values.put("BR_NFItmFxdMktTariffUnit4Dcmls", getBR_NFItmFxdMktTariffUnit4Dcmls());
        values.put("TaxesAreIncludedInNetAmount", getTaxesAreIncludedInNetAmount());
        values.put("BR_NFItemHasWithholdingTax", getBR_NFItemHasWithholdingTax());
        values.put("BR_NFSServiceTypeIncoming", getBR_NFSServiceTypeIncoming());
        values.put("BR_NFSServiceTypeOutgoing", getBR_NFSServiceTypeOutgoing());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("AggregateBaseAmount", getAggregateBaseAmount());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("BR_TaxType") ) {
                final Object value = values.remove("BR_TaxType");
                if( (value == null) || (!value.equals(getBR_TaxType())) ) {
                    setBR_TaxType(((String) value));
                }
            }
            if( values.containsKey("TaxGroup") ) {
                final Object value = values.remove("TaxGroup");
                if( (value == null) || (!value.equals(getTaxGroup())) ) {
                    setTaxGroup(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemBaseAmount") ) {
                final Object value = values.remove("BR_NFItemBaseAmount");
                if( (value == null) || (!value.equals(getBR_NFItemBaseAmount())) ) {
                    setBR_NFItemBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxRate") ) {
                final Object value = values.remove("BR_NFItemTaxRate");
                if( (value == null) || (!value.equals(getBR_NFItemTaxRate())) ) {
                    setBR_NFItemTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxAmount") ) {
                final Object value = values.remove("BR_NFItemTaxAmount");
                if( (value == null) || (!value.equals(getBR_NFItemTaxAmount())) ) {
                    setBR_NFItemTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemExcludedBaseAmount") ) {
                final Object value = values.remove("BR_NFItemExcludedBaseAmount");
                if( (value == null) || (!value.equals(getBR_NFItemExcludedBaseAmount())) ) {
                    setBR_NFItemExcludedBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemOtherBaseAmount") ) {
                final Object value = values.remove("BR_NFItemOtherBaseAmount");
                if( (value == null) || (!value.equals(getBR_NFItemOtherBaseAmount())) ) {
                    setBR_NFItemOtherBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxBasePct1Unit") ) {
                final Object value = values.remove("BR_NFItemTaxBasePct1Unit");
                if( (value == null) || (!value.equals(getBR_NFItemTaxBasePct1Unit())) ) {
                    setBR_NFItemTaxBasePct1Unit(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxBasePct1") ) {
                final Object value = values.remove("BR_NFItemTaxBasePct1");
                if( (value == null) || (!value.equals(getBR_NFItemTaxBasePct1())) ) {
                    setBR_NFItemTaxBasePct1(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxBasePct2Unit") ) {
                final Object value = values.remove("BR_NFItemTaxBasePct2Unit");
                if( (value == null) || (!value.equals(getBR_NFItemTaxBasePct2Unit())) ) {
                    setBR_NFItemTaxBasePct2Unit(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemTaxBasePct2") ) {
                final Object value = values.remove("BR_NFItemTaxBasePct2");
                if( (value == null) || (!value.equals(getBR_NFItemTaxBasePct2())) ) {
                    setBR_NFItemTaxBasePct2(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemIsStatisticalTax") ) {
                final Object value = values.remove("BR_NFItemIsStatisticalTax");
                if( (value == null) || (!value.equals(getBR_NFItemIsStatisticalTax())) ) {
                    setBR_NFItemIsStatisticalTax(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFItemHasFixedMktTariff") ) {
                final Object value = values.remove("BR_NFItemHasFixedMktTariff");
                if( (value == null) || (!value.equals(getBR_NFItemHasFixedMktTariff())) ) {
                    setBR_NFItemHasFixedMktTariff(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemFixedMktTariffBaseQty") ) {
                final Object value = values.remove("BR_NFItemFixedMktTariffBaseQty");
                if( (value == null) || (!value.equals(getBR_NFItemFixedMktTariffBaseQty())) ) {
                    setBR_NFItemFixedMktTariffBaseQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemFixedMarketTariffUnit") ) {
                final Object value = values.remove("BR_NFItemFixedMarketTariffUnit");
                if( (value == null) || (!value.equals(getBR_NFItemFixedMarketTariffUnit())) ) {
                    setBR_NFItemFixedMarketTariffUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemWhldgCollectionCode") ) {
                final Object value = values.remove("BR_NFItemWhldgCollectionCode");
                if( (value == null) || (!value.equals(getBR_NFItemWhldgCollectionCode())) ) {
                    setBR_NFItemWhldgCollectionCode(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemFixedMktTariffTaxRate") ) {
                final Object value = values.remove("BR_NFItemFixedMktTariffTaxRate");
                if( (value == null) || (!value.equals(getBR_NFItemFixedMktTariffTaxRate())) ) {
                    setBR_NFItemFixedMktTariffTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItemFixedMktTariffQty") ) {
                final Object value = values.remove("BR_NFItemFixedMktTariffQty");
                if( (value == null) || (!value.equals(getBR_NFItemFixedMktTariffQty())) ) {
                    setBR_NFItemFixedMktTariffQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFItmFxdMktTariffUnit4Dcmls") ) {
                final Object value = values.remove("BR_NFItmFxdMktTariffUnit4Dcmls");
                if( (value == null) || (!value.equals(getBR_NFItmFxdMktTariffUnit4Dcmls())) ) {
                    setBR_NFItmFxdMktTariffUnit4Dcmls(((String) value));
                }
            }
            if( values.containsKey("TaxesAreIncludedInNetAmount") ) {
                final Object value = values.remove("TaxesAreIncludedInNetAmount");
                if( (value == null) || (!value.equals(getTaxesAreIncludedInNetAmount())) ) {
                    setTaxesAreIncludedInNetAmount(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFItemHasWithholdingTax") ) {
                final Object value = values.remove("BR_NFItemHasWithholdingTax");
                if( (value == null) || (!value.equals(getBR_NFItemHasWithholdingTax())) ) {
                    setBR_NFItemHasWithholdingTax(((Boolean) value));
                }
            }
            if( values.containsKey("BR_NFSServiceTypeIncoming") ) {
                final Object value = values.remove("BR_NFSServiceTypeIncoming");
                if( (value == null) || (!value.equals(getBR_NFSServiceTypeIncoming())) ) {
                    setBR_NFSServiceTypeIncoming(((String) value));
                }
            }
            if( values.containsKey("BR_NFSServiceTypeOutgoing") ) {
                final Object value = values.remove("BR_NFSServiceTypeOutgoing");
                if( (value == null) || (!value.equals(getBR_NFSServiceTypeOutgoing())) ) {
                    setBR_NFSServiceTypeOutgoing(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("AggregateBaseAmount") ) {
                final Object value = values.remove("AggregateBaseAmount");
                if( (value == null) || (!value.equals(getAggregateBaseAmount())) ) {
                    setAggregateBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Map ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = new BR_NFItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFTAXField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFTAXField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFTAXField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFTAXField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem fetchBR_NFItem()
    {
        return fetchFieldAsSingle("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFTAX</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFTAX</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFItem> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the associated <b>BR_NFItem</b> entity for the loaded navigation property <b>to_BR_NFItem</b>.
     *
     * @param value
     *            New <b>BR_NFItem</b> entity.
     */
    public void setBR_NFItem( final BR_NFItem value )
    {
        toBR_NFItem = value;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFTAX</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFTAX</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFTAX instances.
     *
     */
    public final static class BR_NFTAXBuilder
    {

        private BR_NFItem toBR_NFItem;
        private BR_NFDocument toBR_NFDoc;

        private BR_NFTAX.BR_NFTAXBuilder toBR_NFItem( final BR_NFItem value )
        {
            toBR_NFItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFTAX</b> to single <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItem to build this BR_NFTAX with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFTAX.BR_NFTAXBuilder bR_NFItem( final BR_NFItem value )
        {
            return toBR_NFItem(value);
        }

        private BR_NFTAX.BR_NFTAXBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTAX</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFTAX with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFTAX.BR_NFTAXBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
