/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTradeNoteField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTradeNoteOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFTradeNoteSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Trade Note
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFTradeNoteType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFTradeNote extends VdmEntity<BR_NFTradeNote>
{

    /**
     * Selector for all available fields of BR_NFTradeNote.
     *
     */
    public final static BR_NFTradeNoteSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFTradeNoteField<String> BR_NOTA_FISCAL = new BR_NFTradeNoteField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteSequenceNumber</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "BR_NFTradeNoteSequenceNumber" )
    @JsonProperty( "BR_NFTradeNoteSequenceNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFTradeNoteSequenceNumber" )
    private String bR_NFTradeNoteSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTradeNoteSequenceNumber</b> field to query operations.
     *
     */
    public final static BR_NFTradeNoteField<String> BRNF_TRADE_NOTE_SEQUENCE_NUMBER =
        new BR_NFTradeNoteField<String>("BR_NFTradeNoteSequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteNumber</b>
     * </p>
     *
     * @return Trade Note Number
     */
    @SerializedName( "BR_NFTradeNoteNumber" )
    @JsonProperty( "BR_NFTradeNoteNumber" )
    @Nullable
    @ODataField( odataName = "BR_NFTradeNoteNumber" )
    private String bR_NFTradeNoteNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTradeNoteNumber</b> field to query operations.
     *
     */
    public final static BR_NFTradeNoteField<String> BRNF_TRADE_NOTE_NUMBER =
        new BR_NFTradeNoteField<String>("BR_NFTradeNoteNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteExpiringDate</b>
     * </p>
     *
     * @return Expiring Date
     */
    @SerializedName( "BR_NFTradeNoteExpiringDate" )
    @JsonProperty( "BR_NFTradeNoteExpiringDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BR_NFTradeNoteExpiringDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bR_NFTradeNoteExpiringDate;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTradeNoteExpiringDate</b> field to query operations.
     *
     */
    public final static BR_NFTradeNoteField<LocalDateTime> BRNF_TRADE_NOTE_EXPIRING_DATE =
        new BR_NFTradeNoteField<LocalDateTime>("BR_NFTradeNoteExpiringDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteValue</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "BR_NFTradeNoteValue" )
    @JsonProperty( "BR_NFTradeNoteValue" )
    @Nullable
    @ODataField( odataName = "BR_NFTradeNoteValue" )
    private BigDecimal bR_NFTradeNoteValue;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTradeNoteValue</b> field to query operations.
     *
     */
    public final static BR_NFTradeNoteField<BigDecimal> BRNF_TRADE_NOTE_VALUE =
        new BR_NFTradeNoteField<BigDecimal>("BR_NFTradeNoteValue");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTradeNote</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFTradeNoteOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFTradeNoteOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFTradeNote> getType()
    {
        return BR_NFTradeNote.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteSequenceNumber</b>
     * </p>
     *
     * @param bR_NFTradeNoteSequenceNumber
     *            Counter
     */
    public void setBR_NFTradeNoteSequenceNumber( @Nullable final String bR_NFTradeNoteSequenceNumber )
    {
        rememberChangedField("BR_NFTradeNoteSequenceNumber", this.bR_NFTradeNoteSequenceNumber);
        this.bR_NFTradeNoteSequenceNumber = bR_NFTradeNoteSequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteNumber</b>
     * </p>
     *
     * @param bR_NFTradeNoteNumber
     *            Trade Note Number
     */
    public void setBR_NFTradeNoteNumber( @Nullable final String bR_NFTradeNoteNumber )
    {
        rememberChangedField("BR_NFTradeNoteNumber", this.bR_NFTradeNoteNumber);
        this.bR_NFTradeNoteNumber = bR_NFTradeNoteNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteExpiringDate</b>
     * </p>
     *
     * @param bR_NFTradeNoteExpiringDate
     *            Expiring Date
     */
    public void setBR_NFTradeNoteExpiringDate( @Nullable final LocalDateTime bR_NFTradeNoteExpiringDate )
    {
        rememberChangedField("BR_NFTradeNoteExpiringDate", this.bR_NFTradeNoteExpiringDate);
        this.bR_NFTradeNoteExpiringDate = bR_NFTradeNoteExpiringDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTradeNoteValue</b>
     * </p>
     *
     * @param bR_NFTradeNoteValue
     *            Amount
     */
    public void setBR_NFTradeNoteValue( @Nullable final BigDecimal bR_NFTradeNoteValue )
    {
        rememberChangedField("BR_NFTradeNoteValue", this.bR_NFTradeNoteValue);
        this.bR_NFTradeNoteValue = bR_NFTradeNoteValue;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFTradeNote";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFTradeNoteSequenceNumber", getBR_NFTradeNoteSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFTradeNoteSequenceNumber", getBR_NFTradeNoteSequenceNumber());
        values.put("BR_NFTradeNoteNumber", getBR_NFTradeNoteNumber());
        values.put("BR_NFTradeNoteExpiringDate", getBR_NFTradeNoteExpiringDate());
        values.put("BR_NFTradeNoteValue", getBR_NFTradeNoteValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFTradeNoteSequenceNumber") ) {
                final Object value = values.remove("BR_NFTradeNoteSequenceNumber");
                if( (value == null) || (!value.equals(getBR_NFTradeNoteSequenceNumber())) ) {
                    setBR_NFTradeNoteSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFTradeNoteNumber") ) {
                final Object value = values.remove("BR_NFTradeNoteNumber");
                if( (value == null) || (!value.equals(getBR_NFTradeNoteNumber())) ) {
                    setBR_NFTradeNoteNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFTradeNoteExpiringDate") ) {
                final Object value = values.remove("BR_NFTradeNoteExpiringDate");
                if( (value == null) || (!value.equals(getBR_NFTradeNoteExpiringDate())) ) {
                    setBR_NFTradeNoteExpiringDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_NFTradeNoteValue") ) {
                final Object value = values.remove("BR_NFTradeNoteValue");
                if( (value == null) || (!value.equals(getBR_NFTradeNoteValue())) ) {
                    setBR_NFTradeNoteValue(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFTradeNoteField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFTradeNoteField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFTradeNoteField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFTradeNoteField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFTradeNote</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFTradeNote</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFTradeNote instances.
     *
     */
    public final static class BR_NFTradeNoteBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFTradeNote.BR_NFTradeNoteBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTradeNote</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFTradeNote with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFTradeNote.BR_NFTradeNoteBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
