/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTransportedVolumeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTransportedVolumeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFTransportedVolumeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Transported Volume
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFTransportedVolumeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFTransportedVolume extends VdmEntity<BR_NFTransportedVolume>
{

    /**
     * Selector for all available fields of BR_NFTransportedVolume.
     *
     */
    public final static BR_NFTransportedVolumeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BR_NOTA_FISCAL =
        new BR_NFTransportedVolumeField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumesSequence</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "BR_NFTransptVolumesSequence" )
    @JsonProperty( "BR_NFTransptVolumesSequence" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolumesSequence" )
    private String bR_NFTransptVolumesSequence;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolumesSequence</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPT_VOLUMES_SEQUENCE =
        new BR_NFTransportedVolumeField<String>("BR_NFTransptVolumesSequence");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeQtyVal</b>
     * </p>
     *
     * @return Volume Quantity
     */
    @SerializedName( "BR_NFTransportedVolumeQtyVal" )
    @JsonProperty( "BR_NFTransportedVolumeQtyVal" )
    @Nullable
    @ODataField( odataName = "BR_NFTransportedVolumeQtyVal" )
    private BigDecimal bR_NFTransportedVolumeQtyVal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransportedVolumeQtyVal</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<BigDecimal> BRNF_TRANSPORTED_VOLUME_QTY_VAL =
        new BR_NFTransportedVolumeField<BigDecimal>("BR_NFTransportedVolumeQtyVal");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeType</b>
     * </p>
     *
     * @return Volume Type
     */
    @SerializedName( "BR_NFTransportedVolumeType" )
    @JsonProperty( "BR_NFTransportedVolumeType" )
    @Nullable
    @ODataField( odataName = "BR_NFTransportedVolumeType" )
    private String bR_NFTransportedVolumeType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransportedVolumeType</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPORTED_VOLUME_TYPE =
        new BR_NFTransportedVolumeField<String>("BR_NFTransportedVolumeType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeTrademark</b>
     * </p>
     *
     * @return Volume Trademark
     */
    @SerializedName( "BR_NFTransptVolumeTrademark" )
    @JsonProperty( "BR_NFTransptVolumeTrademark" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolumeTrademark" )
    private String bR_NFTransptVolumeTrademark;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolumeTrademark</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPT_VOLUME_TRADEMARK =
        new BR_NFTransportedVolumeField<String>("BR_NFTransptVolumeTrademark");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeID</b>
     * </p>
     *
     * @return Volume Number
     */
    @SerializedName( "BR_NFTransportedVolumeID" )
    @JsonProperty( "BR_NFTransportedVolumeID" )
    @Nullable
    @ODataField( odataName = "BR_NFTransportedVolumeID" )
    private String bR_NFTransportedVolumeID;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransportedVolumeID</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPORTED_VOLUME_ID =
        new BR_NFTransportedVolumeField<String>("BR_NFTransportedVolumeID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolNetWeightUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_NFTransptVolNetWeightUnit" )
    @JsonProperty( "BR_NFTransptVolNetWeightUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolNetWeightUnit" )
    private String bR_NFTransptVolNetWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolNetWeightUnit</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPT_VOL_NET_WEIGHT_UNIT =
        new BR_NFTransportedVolumeField<String>("BR_NFTransptVolNetWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "BR_NFTransptVolumeNetWeight" )
    @JsonProperty( "BR_NFTransptVolumeNetWeight" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolumeNetWeight" )
    private BigDecimal bR_NFTransptVolumeNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolumeNetWeight</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<BigDecimal> BRNF_TRANSPT_VOLUME_NET_WEIGHT =
        new BR_NFTransportedVolumeField<BigDecimal>("BR_NFTransptVolumeNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolGrossWgtUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "BR_NFTransptVolGrossWgtUnit" )
    @JsonProperty( "BR_NFTransptVolGrossWgtUnit" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolGrossWgtUnit" )
    private String bR_NFTransptVolGrossWgtUnit;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolGrossWgtUnit</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPT_VOL_GROSS_WGT_UNIT =
        new BR_NFTransportedVolumeField<String>("BR_NFTransptVolGrossWgtUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "BR_NFTransptVolumeGrossWeight" )
    @JsonProperty( "BR_NFTransptVolumeGrossWeight" )
    @Nullable
    @ODataField( odataName = "BR_NFTransptVolumeGrossWeight" )
    private BigDecimal bR_NFTransptVolumeGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransptVolumeGrossWeight</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<BigDecimal> BRNF_TRANSPT_VOLUME_GROSS_WEIGHT =
        new BR_NFTransportedVolumeField<BigDecimal>("BR_NFTransptVolumeGrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeSeal</b>
     * </p>
     *
     * @return Seal Number
     */
    @SerializedName( "BR_NFTransportedVolumeSeal" )
    @JsonProperty( "BR_NFTransportedVolumeSeal" )
    @Nullable
    @ODataField( odataName = "BR_NFTransportedVolumeSeal" )
    private String bR_NFTransportedVolumeSeal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFTransportedVolumeSeal</b> field to query operations.
     *
     */
    public final static BR_NFTransportedVolumeField<String> BRNF_TRANSPORTED_VOLUME_SEAL =
        new BR_NFTransportedVolumeField<String>("BR_NFTransportedVolumeSeal");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTransportedVolume</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFTransportedVolumeOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFTransportedVolumeOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFTransportedVolume> getType()
    {
        return BR_NFTransportedVolume.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumesSequence</b>
     * </p>
     *
     * @param bR_NFTransptVolumesSequence
     *            Counter
     */
    public void setBR_NFTransptVolumesSequence( @Nullable final String bR_NFTransptVolumesSequence )
    {
        rememberChangedField("BR_NFTransptVolumesSequence", this.bR_NFTransptVolumesSequence);
        this.bR_NFTransptVolumesSequence = bR_NFTransptVolumesSequence;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeQtyVal</b>
     * </p>
     *
     * @param bR_NFTransportedVolumeQtyVal
     *            Volume Quantity
     */
    public void setBR_NFTransportedVolumeQtyVal( @Nullable final BigDecimal bR_NFTransportedVolumeQtyVal )
    {
        rememberChangedField("BR_NFTransportedVolumeQtyVal", this.bR_NFTransportedVolumeQtyVal);
        this.bR_NFTransportedVolumeQtyVal = bR_NFTransportedVolumeQtyVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeType</b>
     * </p>
     *
     * @param bR_NFTransportedVolumeType
     *            Volume Type
     */
    public void setBR_NFTransportedVolumeType( @Nullable final String bR_NFTransportedVolumeType )
    {
        rememberChangedField("BR_NFTransportedVolumeType", this.bR_NFTransportedVolumeType);
        this.bR_NFTransportedVolumeType = bR_NFTransportedVolumeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeTrademark</b>
     * </p>
     *
     * @param bR_NFTransptVolumeTrademark
     *            Volume Trademark
     */
    public void setBR_NFTransptVolumeTrademark( @Nullable final String bR_NFTransptVolumeTrademark )
    {
        rememberChangedField("BR_NFTransptVolumeTrademark", this.bR_NFTransptVolumeTrademark);
        this.bR_NFTransptVolumeTrademark = bR_NFTransptVolumeTrademark;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeID</b>
     * </p>
     *
     * @param bR_NFTransportedVolumeID
     *            Volume Number
     */
    public void setBR_NFTransportedVolumeID( @Nullable final String bR_NFTransportedVolumeID )
    {
        rememberChangedField("BR_NFTransportedVolumeID", this.bR_NFTransportedVolumeID);
        this.bR_NFTransportedVolumeID = bR_NFTransportedVolumeID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolNetWeightUnit</b>
     * </p>
     *
     * @param bR_NFTransptVolNetWeightUnit
     *            Unit of Measurement
     */
    public void setBR_NFTransptVolNetWeightUnit( @Nullable final String bR_NFTransptVolNetWeightUnit )
    {
        rememberChangedField("BR_NFTransptVolNetWeightUnit", this.bR_NFTransptVolNetWeightUnit);
        this.bR_NFTransptVolNetWeightUnit = bR_NFTransptVolNetWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeNetWeight</b>
     * </p>
     *
     * @param bR_NFTransptVolumeNetWeight
     *            Net Weight
     */
    public void setBR_NFTransptVolumeNetWeight( @Nullable final BigDecimal bR_NFTransptVolumeNetWeight )
    {
        rememberChangedField("BR_NFTransptVolumeNetWeight", this.bR_NFTransptVolumeNetWeight);
        this.bR_NFTransptVolumeNetWeight = bR_NFTransptVolumeNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolGrossWgtUnit</b>
     * </p>
     *
     * @param bR_NFTransptVolGrossWgtUnit
     *            Unit of Measurement
     */
    public void setBR_NFTransptVolGrossWgtUnit( @Nullable final String bR_NFTransptVolGrossWgtUnit )
    {
        rememberChangedField("BR_NFTransptVolGrossWgtUnit", this.bR_NFTransptVolGrossWgtUnit);
        this.bR_NFTransptVolGrossWgtUnit = bR_NFTransptVolGrossWgtUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransptVolumeGrossWeight</b>
     * </p>
     *
     * @param bR_NFTransptVolumeGrossWeight
     *            Gross Weight
     */
    public void setBR_NFTransptVolumeGrossWeight( @Nullable final BigDecimal bR_NFTransptVolumeGrossWeight )
    {
        rememberChangedField("BR_NFTransptVolumeGrossWeight", this.bR_NFTransptVolumeGrossWeight);
        this.bR_NFTransptVolumeGrossWeight = bR_NFTransptVolumeGrossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFTransportedVolumeSeal</b>
     * </p>
     *
     * @param bR_NFTransportedVolumeSeal
     *            Seal Number
     */
    public void setBR_NFTransportedVolumeSeal( @Nullable final String bR_NFTransportedVolumeSeal )
    {
        rememberChangedField("BR_NFTransportedVolumeSeal", this.bR_NFTransportedVolumeSeal);
        this.bR_NFTransportedVolumeSeal = bR_NFTransportedVolumeSeal;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFTransportedVolume";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NFTransptVolumesSequence", getBR_NFTransptVolumesSequence());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NFTransptVolumesSequence", getBR_NFTransptVolumesSequence());
        values.put("BR_NFTransportedVolumeQtyVal", getBR_NFTransportedVolumeQtyVal());
        values.put("BR_NFTransportedVolumeType", getBR_NFTransportedVolumeType());
        values.put("BR_NFTransptVolumeTrademark", getBR_NFTransptVolumeTrademark());
        values.put("BR_NFTransportedVolumeID", getBR_NFTransportedVolumeID());
        values.put("BR_NFTransptVolNetWeightUnit", getBR_NFTransptVolNetWeightUnit());
        values.put("BR_NFTransptVolumeNetWeight", getBR_NFTransptVolumeNetWeight());
        values.put("BR_NFTransptVolGrossWgtUnit", getBR_NFTransptVolGrossWgtUnit());
        values.put("BR_NFTransptVolumeGrossWeight", getBR_NFTransptVolumeGrossWeight());
        values.put("BR_NFTransportedVolumeSeal", getBR_NFTransportedVolumeSeal());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolumesSequence") ) {
                final Object value = values.remove("BR_NFTransptVolumesSequence");
                if( (value == null) || (!value.equals(getBR_NFTransptVolumesSequence())) ) {
                    setBR_NFTransptVolumesSequence(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransportedVolumeQtyVal") ) {
                final Object value = values.remove("BR_NFTransportedVolumeQtyVal");
                if( (value == null) || (!value.equals(getBR_NFTransportedVolumeQtyVal())) ) {
                    setBR_NFTransportedVolumeQtyVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFTransportedVolumeType") ) {
                final Object value = values.remove("BR_NFTransportedVolumeType");
                if( (value == null) || (!value.equals(getBR_NFTransportedVolumeType())) ) {
                    setBR_NFTransportedVolumeType(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolumeTrademark") ) {
                final Object value = values.remove("BR_NFTransptVolumeTrademark");
                if( (value == null) || (!value.equals(getBR_NFTransptVolumeTrademark())) ) {
                    setBR_NFTransptVolumeTrademark(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransportedVolumeID") ) {
                final Object value = values.remove("BR_NFTransportedVolumeID");
                if( (value == null) || (!value.equals(getBR_NFTransportedVolumeID())) ) {
                    setBR_NFTransportedVolumeID(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolNetWeightUnit") ) {
                final Object value = values.remove("BR_NFTransptVolNetWeightUnit");
                if( (value == null) || (!value.equals(getBR_NFTransptVolNetWeightUnit())) ) {
                    setBR_NFTransptVolNetWeightUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolumeNetWeight") ) {
                final Object value = values.remove("BR_NFTransptVolumeNetWeight");
                if( (value == null) || (!value.equals(getBR_NFTransptVolumeNetWeight())) ) {
                    setBR_NFTransptVolumeNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolGrossWgtUnit") ) {
                final Object value = values.remove("BR_NFTransptVolGrossWgtUnit");
                if( (value == null) || (!value.equals(getBR_NFTransptVolGrossWgtUnit())) ) {
                    setBR_NFTransptVolGrossWgtUnit(((String) value));
                }
            }
            if( values.containsKey("BR_NFTransptVolumeGrossWeight") ) {
                final Object value = values.remove("BR_NFTransptVolumeGrossWeight");
                if( (value == null) || (!value.equals(getBR_NFTransptVolumeGrossWeight())) ) {
                    setBR_NFTransptVolumeGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("BR_NFTransportedVolumeSeal") ) {
                final Object value = values.remove("BR_NFTransportedVolumeSeal");
                if( (value == null) || (!value.equals(getBR_NFTransportedVolumeSeal())) ) {
                    setBR_NFTransportedVolumeSeal(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFTransportedVolumeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFTransportedVolumeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFTransportedVolumeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFTransportedVolumeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFTransportedVolume</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFTransportedVolume</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFTransportedVolume instances.
     *
     */
    public final static class BR_NFTransportedVolumeBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFTransportedVolume.BR_NFTransportedVolumeBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFTransportedVolume</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFTransportedVolume with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFTransportedVolume.BR_NFTransportedVolumeBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
