/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFVehicleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFVehicleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFVehicleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Vehicle
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFVehicleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFVehicle extends VdmEntity<BR_NFVehicle>
{

    /**
     * Selector for all available fields of BR_NFVehicle.
     *
     */
    public final static BR_NFVehicleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> BR_NOTA_FISCAL = new BR_NFVehicleField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> BR_NOTA_FISCAL_ITEM =
        new BR_NFVehicleField<String>("BR_NotaFiscalItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModel</b>
     * </p>
     *
     * @return Brand Model Code
     */
    @SerializedName( "VehicleModel" )
    @JsonProperty( "VehicleModel" )
    @Nullable
    @ODataField( odataName = "VehicleModel" )
    private String vehicleModel;
    /**
     * Use with available fluent helpers to apply the <b>VehicleModel</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_MODEL = new BR_NFVehicleField<String>("VehicleModel");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModelYear</b>
     * </p>
     *
     * @return Vehicle Model Year
     */
    @SerializedName( "VehicleModelYear" )
    @JsonProperty( "VehicleModelYear" )
    @Nullable
    @ODataField( odataName = "VehicleModelYear" )
    private String vehicleModelYear;
    /**
     * Use with available fluent helpers to apply the <b>VehicleModelYear</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_MODEL_YEAR =
        new BR_NFVehicleField<String>("VehicleModelYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleYearOfManufacture</b>
     * </p>
     *
     * @return Manufacturing Year
     */
    @SerializedName( "VehicleYearOfManufacture" )
    @JsonProperty( "VehicleYearOfManufacture" )
    @Nullable
    @ODataField( odataName = "VehicleYearOfManufacture" )
    private String vehicleYearOfManufacture;
    /**
     * Use with available fluent helpers to apply the <b>VehicleYearOfManufacture</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_YEAR_OF_MANUFACTURE =
        new BR_NFVehicleField<String>("VehicleYearOfManufacture");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VehicleType</b>
     * </p>
     *
     * @return Vehicle Type
     */
    @SerializedName( "VehicleType" )
    @JsonProperty( "VehicleType" )
    @Nullable
    @ODataField( odataName = "VehicleType" )
    private String vehicleType;
    /**
     * Use with available fluent helpers to apply the <b>VehicleType</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_TYPE = new BR_NFVehicleField<String>("VehicleType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VehicleFuelType</b>
     * </p>
     *
     * @return Vehicle Fuel Type
     */
    @SerializedName( "VehicleFuelType" )
    @JsonProperty( "VehicleFuelType" )
    @Nullable
    @ODataField( odataName = "VehicleFuelType" )
    private String vehicleFuelType;
    /**
     * Use with available fluent helpers to apply the <b>VehicleFuelType</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_FUEL_TYPE = new BR_NFVehicleField<String>("VehicleFuelType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleEnginePower</b>
     * </p>
     *
     * @return Engine Power
     */
    @SerializedName( "VehicleEnginePower" )
    @JsonProperty( "VehicleEnginePower" )
    @Nullable
    @ODataField( odataName = "VehicleEnginePower" )
    private String vehicleEnginePower;
    /**
     * Use with available fluent helpers to apply the <b>VehicleEnginePower</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_ENGINE_POWER =
        new BR_NFVehicleField<String>("VehicleEnginePower");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCylinderCapacityValue</b>
     * </p>
     *
     * @return Cylinder Capacity
     */
    @SerializedName( "VehicleCylinderCapacityValue" )
    @JsonProperty( "VehicleCylinderCapacityValue" )
    @Nullable
    @ODataField( odataName = "VehicleCylinderCapacityValue" )
    private String vehicleCylinderCapacityValue;
    /**
     * Use with available fluent helpers to apply the <b>VehicleCylinderCapacityValue</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_CYLINDER_CAPACITY_VALUE =
        new BR_NFVehicleField<String>("VehicleCylinderCapacityValue");
    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>VehicleEngineNumber</b>
     * </p>
     *
     * @return Engine Number
     */
    @SerializedName( "VehicleEngineNumber" )
    @JsonProperty( "VehicleEngineNumber" )
    @Nullable
    @ODataField( odataName = "VehicleEngineNumber" )
    private String vehicleEngineNumber;
    /**
     * Use with available fluent helpers to apply the <b>VehicleEngineNumber</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_ENGINE_NUMBER =
        new BR_NFVehicleField<String>("VehicleEngineNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCarMakerColor</b>
     * </p>
     *
     * @return Carmaker Color Code
     */
    @SerializedName( "VehicleCarMakerColor" )
    @JsonProperty( "VehicleCarMakerColor" )
    @Nullable
    @ODataField( odataName = "VehicleCarMakerColor" )
    private String vehicleCarMakerColor;
    /**
     * Use with available fluent helpers to apply the <b>VehicleCarMakerColor</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_CAR_MAKER_COLOR =
        new BR_NFVehicleField<String>("VehicleCarMakerColor");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehiclePaintingType</b>
     * </p>
     *
     * @return Painting Type
     */
    @SerializedName( "VehiclePaintingType" )
    @JsonProperty( "VehiclePaintingType" )
    @Nullable
    @ODataField( odataName = "VehiclePaintingType" )
    private String vehiclePaintingType;
    /**
     * Use with available fluent helpers to apply the <b>VehiclePaintingType</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_PAINTING_TYPE =
        new BR_NFVehicleField<String>("VehiclePaintingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeVehicleDENATRANColor</b>
     * </p>
     *
     * @return Color Code (DENATRAN)
     */
    @SerializedName( "BR_NFeVehicleDENATRANColor" )
    @JsonProperty( "BR_NFeVehicleDENATRANColor" )
    @Nullable
    @ODataField( odataName = "BR_NFeVehicleDENATRANColor" )
    private String bR_NFeVehicleDENATRANColor;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeVehicleDENATRANColor</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> BRN_FE_VEHICLE_DENATRAN_COLOR =
        new BR_NFVehicleField<String>("BR_NFeVehicleDENATRANColor");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>VehicleColorDesc</b>
     * </p>
     *
     * @return Color Description
     */
    @SerializedName( "VehicleColorDesc" )
    @JsonProperty( "VehicleColorDesc" )
    @Nullable
    @ODataField( odataName = "VehicleColorDesc" )
    private String vehicleColorDesc;
    /**
     * Use with available fluent helpers to apply the <b>VehicleColorDesc</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_COLOR_DESC =
        new BR_NFVehicleField<String>("VehicleColorDesc");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>VehicleChassis</b>
     * </p>
     *
     * @return Vehicle Chassis
     */
    @SerializedName( "VehicleChassis" )
    @JsonProperty( "VehicleChassis" )
    @Nullable
    @ODataField( odataName = "VehicleChassis" )
    private String vehicleChassis;
    /**
     * Use with available fluent helpers to apply the <b>VehicleChassis</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_CHASSIS = new BR_NFVehicleField<String>("VehicleChassis");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>VehicleSerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "VehicleSerialNumber" )
    @JsonProperty( "VehicleSerialNumber" )
    @Nullable
    @ODataField( odataName = "VehicleSerialNumber" )
    private String vehicleSerialNumber;
    /**
     * Use with available fluent helpers to apply the <b>VehicleSerialNumber</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_SERIAL_NUMBER =
        new BR_NFVehicleField<String>("VehicleSerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleNetWeightUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "VehicleNetWeightUnit" )
    @JsonProperty( "VehicleNetWeightUnit" )
    @Nullable
    @ODataField( odataName = "VehicleNetWeightUnit" )
    private String vehicleNetWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>VehicleNetWeightUnit</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_NET_WEIGHT_UNIT =
        new BR_NFVehicleField<String>("VehicleNetWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "VehicleNetWeight" )
    @JsonProperty( "VehicleNetWeight" )
    @Nullable
    @ODataField( odataName = "VehicleNetWeight" )
    private BigDecimal vehicleNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>VehicleNetWeight</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<BigDecimal> VEHICLE_NET_WEIGHT =
        new BR_NFVehicleField<BigDecimal>("VehicleNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleGrossWeightUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "VehicleGrossWeightUnit" )
    @JsonProperty( "VehicleGrossWeightUnit" )
    @Nullable
    @ODataField( odataName = "VehicleGrossWeightUnit" )
    private String vehicleGrossWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>VehicleGrossWeightUnit</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_GROSS_WEIGHT_UNIT =
        new BR_NFVehicleField<String>("VehicleGrossWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "VehicleGrossWeight" )
    @JsonProperty( "VehicleGrossWeight" )
    @Nullable
    @ODataField( odataName = "VehicleGrossWeight" )
    private BigDecimal vehicleGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>VehicleGrossWeight</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<BigDecimal> VEHICLE_GROSS_WEIGHT =
        new BR_NFVehicleField<BigDecimal>("VehicleGrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleMaximumCapacityValue</b>
     * </p>
     *
     * @return Maximum Capacity
     */
    @SerializedName( "VehicleMaximumCapacityValue" )
    @JsonProperty( "VehicleMaximumCapacityValue" )
    @Nullable
    @ODataField( odataName = "VehicleMaximumCapacityValue" )
    private String vehicleMaximumCapacityValue;
    /**
     * Use with available fluent helpers to apply the <b>VehicleMaximumCapacityValue</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_MAXIMUM_CAPACITY_VALUE =
        new BR_NFVehicleField<String>("VehicleMaximumCapacityValue");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>VehicleMaxTractionCapacity</b>
     * </p>
     *
     * @return Traction Capacity
     */
    @SerializedName( "VehicleMaxTractionCapacity" )
    @JsonProperty( "VehicleMaxTractionCapacity" )
    @Nullable
    @ODataField( odataName = "VehicleMaxTractionCapacity" )
    private String vehicleMaxTractionCapacity;
    /**
     * Use with available fluent helpers to apply the <b>VehicleMaxTractionCapacity</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_MAX_TRACTION_CAPACITY =
        new BR_NFVehicleField<String>("VehicleMaxTractionCapacity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistanceBetweenAxlesQtyValue</b>
     * </p>
     *
     * @return Distance Between Axles
     */
    @SerializedName( "DistanceBetweenAxlesQtyValue" )
    @JsonProperty( "DistanceBetweenAxlesQtyValue" )
    @Nullable
    @ODataField( odataName = "DistanceBetweenAxlesQtyValue" )
    private String distanceBetweenAxlesQtyValue;
    /**
     * Use with available fluent helpers to apply the <b>DistanceBetweenAxlesQtyValue</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> DISTANCE_BETWEEN_AXLES_QTY_VALUE =
        new BR_NFVehicleField<String>("DistanceBetweenAxlesQtyValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleUsage</b>
     * </p>
     *
     * @return Vehicle Usage
     */
    @SerializedName( "VehicleUsage" )
    @JsonProperty( "VehicleUsage" )
    @Nullable
    @ODataField( odataName = "VehicleUsage" )
    private String vehicleUsage;
    /**
     * Use with available fluent helpers to apply the <b>VehicleUsage</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_USAGE = new BR_NFVehicleField<String>("VehicleUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemVINCondition</b>
     * </p>
     *
     * @return VIN Condition
     */
    @SerializedName( "BR_NFItemVINCondition" )
    @JsonProperty( "BR_NFItemVINCondition" )
    @Nullable
    @ODataField( odataName = "BR_NFItemVINCondition" )
    private String bR_NFItemVINCondition;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFItemVINCondition</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> BRNF_ITEM_VIN_CONDITION =
        new BR_NFVehicleField<String>("BR_NFItemVINCondition");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCondition</b>
     * </p>
     *
     * @return Vehicle Condition
     */
    @SerializedName( "VehicleCondition" )
    @JsonProperty( "VehicleCondition" )
    @Nullable
    @ODataField( odataName = "VehicleCondition" )
    private String vehicleCondition;
    /**
     * Use with available fluent helpers to apply the <b>VehicleCondition</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_CONDITION = new BR_NFVehicleField<String>("VehicleCondition");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleRestriction</b>
     * </p>
     *
     * @return Vehicle Restriction
     */
    @SerializedName( "VehicleRestriction" )
    @JsonProperty( "VehicleRestriction" )
    @Nullable
    @ODataField( odataName = "VehicleRestriction" )
    private String vehicleRestriction;
    /**
     * Use with available fluent helpers to apply the <b>VehicleRestriction</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_RESTRICTION =
        new BR_NFVehicleField<String>("VehicleRestriction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleOperationType</b>
     * </p>
     *
     * @return Vehicle Operation
     */
    @SerializedName( "VehicleOperationType" )
    @JsonProperty( "VehicleOperationType" )
    @Nullable
    @ODataField( odataName = "VehicleOperationType" )
    private String vehicleOperationType;
    /**
     * Use with available fluent helpers to apply the <b>VehicleOperationType</b> field to query operations.
     *
     */
    public final static BR_NFVehicleField<String> VEHICLE_OPERATION_TYPE =
        new BR_NFVehicleField<String>("VehicleOperationType");
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFVehicle</b> to single <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFItem toBR_NFItem;
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFVehicle</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFVehicleOneToOneLink<BR_NFItem> TO_BRNF_ITEM =
        new BR_NFVehicleOneToOneLink<BR_NFItem>("to_BR_NFItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFVehicleOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFVehicleOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFVehicle> getType()
    {
        return BR_NFVehicle.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModel</b>
     * </p>
     *
     * @param vehicleModel
     *            Brand Model Code
     */
    public void setVehicleModel( @Nullable final String vehicleModel )
    {
        rememberChangedField("VehicleModel", this.vehicleModel);
        this.vehicleModel = vehicleModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModelYear</b>
     * </p>
     *
     * @param vehicleModelYear
     *            Vehicle Model Year
     */
    public void setVehicleModelYear( @Nullable final String vehicleModelYear )
    {
        rememberChangedField("VehicleModelYear", this.vehicleModelYear);
        this.vehicleModelYear = vehicleModelYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleYearOfManufacture</b>
     * </p>
     *
     * @param vehicleYearOfManufacture
     *            Manufacturing Year
     */
    public void setVehicleYearOfManufacture( @Nullable final String vehicleYearOfManufacture )
    {
        rememberChangedField("VehicleYearOfManufacture", this.vehicleYearOfManufacture);
        this.vehicleYearOfManufacture = vehicleYearOfManufacture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VehicleType</b>
     * </p>
     *
     * @param vehicleType
     *            Vehicle Type
     */
    public void setVehicleType( @Nullable final String vehicleType )
    {
        rememberChangedField("VehicleType", this.vehicleType);
        this.vehicleType = vehicleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VehicleFuelType</b>
     * </p>
     *
     * @param vehicleFuelType
     *            Vehicle Fuel Type
     */
    public void setVehicleFuelType( @Nullable final String vehicleFuelType )
    {
        rememberChangedField("VehicleFuelType", this.vehicleFuelType);
        this.vehicleFuelType = vehicleFuelType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleEnginePower</b>
     * </p>
     *
     * @param vehicleEnginePower
     *            Engine Power
     */
    public void setVehicleEnginePower( @Nullable final String vehicleEnginePower )
    {
        rememberChangedField("VehicleEnginePower", this.vehicleEnginePower);
        this.vehicleEnginePower = vehicleEnginePower;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCylinderCapacityValue</b>
     * </p>
     *
     * @param vehicleCylinderCapacityValue
     *            Cylinder Capacity
     */
    public void setVehicleCylinderCapacityValue( @Nullable final String vehicleCylinderCapacityValue )
    {
        rememberChangedField("VehicleCylinderCapacityValue", this.vehicleCylinderCapacityValue);
        this.vehicleCylinderCapacityValue = vehicleCylinderCapacityValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>VehicleEngineNumber</b>
     * </p>
     *
     * @param vehicleEngineNumber
     *            Engine Number
     */
    public void setVehicleEngineNumber( @Nullable final String vehicleEngineNumber )
    {
        rememberChangedField("VehicleEngineNumber", this.vehicleEngineNumber);
        this.vehicleEngineNumber = vehicleEngineNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCarMakerColor</b>
     * </p>
     *
     * @param vehicleCarMakerColor
     *            Carmaker Color Code
     */
    public void setVehicleCarMakerColor( @Nullable final String vehicleCarMakerColor )
    {
        rememberChangedField("VehicleCarMakerColor", this.vehicleCarMakerColor);
        this.vehicleCarMakerColor = vehicleCarMakerColor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehiclePaintingType</b>
     * </p>
     *
     * @param vehiclePaintingType
     *            Painting Type
     */
    public void setVehiclePaintingType( @Nullable final String vehiclePaintingType )
    {
        rememberChangedField("VehiclePaintingType", this.vehiclePaintingType);
        this.vehiclePaintingType = vehiclePaintingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeVehicleDENATRANColor</b>
     * </p>
     *
     * @param bR_NFeVehicleDENATRANColor
     *            Color Code (DENATRAN)
     */
    public void setBR_NFeVehicleDENATRANColor( @Nullable final String bR_NFeVehicleDENATRANColor )
    {
        rememberChangedField("BR_NFeVehicleDENATRANColor", this.bR_NFeVehicleDENATRANColor);
        this.bR_NFeVehicleDENATRANColor = bR_NFeVehicleDENATRANColor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>VehicleColorDesc</b>
     * </p>
     *
     * @param vehicleColorDesc
     *            Color Description
     */
    public void setVehicleColorDesc( @Nullable final String vehicleColorDesc )
    {
        rememberChangedField("VehicleColorDesc", this.vehicleColorDesc);
        this.vehicleColorDesc = vehicleColorDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>VehicleChassis</b>
     * </p>
     *
     * @param vehicleChassis
     *            Vehicle Chassis
     */
    public void setVehicleChassis( @Nullable final String vehicleChassis )
    {
        rememberChangedField("VehicleChassis", this.vehicleChassis);
        this.vehicleChassis = vehicleChassis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>VehicleSerialNumber</b>
     * </p>
     *
     * @param vehicleSerialNumber
     *            Serial Number
     */
    public void setVehicleSerialNumber( @Nullable final String vehicleSerialNumber )
    {
        rememberChangedField("VehicleSerialNumber", this.vehicleSerialNumber);
        this.vehicleSerialNumber = vehicleSerialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleNetWeightUnit</b>
     * </p>
     *
     * @param vehicleNetWeightUnit
     *            Unit of Measurement
     */
    public void setVehicleNetWeightUnit( @Nullable final String vehicleNetWeightUnit )
    {
        rememberChangedField("VehicleNetWeightUnit", this.vehicleNetWeightUnit);
        this.vehicleNetWeightUnit = vehicleNetWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleNetWeight</b>
     * </p>
     *
     * @param vehicleNetWeight
     *            Net Weight
     */
    public void setVehicleNetWeight( @Nullable final BigDecimal vehicleNetWeight )
    {
        rememberChangedField("VehicleNetWeight", this.vehicleNetWeight);
        this.vehicleNetWeight = vehicleNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleGrossWeightUnit</b>
     * </p>
     *
     * @param vehicleGrossWeightUnit
     *            Unit of Measurement
     */
    public void setVehicleGrossWeightUnit( @Nullable final String vehicleGrossWeightUnit )
    {
        rememberChangedField("VehicleGrossWeightUnit", this.vehicleGrossWeightUnit);
        this.vehicleGrossWeightUnit = vehicleGrossWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleGrossWeight</b>
     * </p>
     *
     * @param vehicleGrossWeight
     *            Gross Weight
     */
    public void setVehicleGrossWeight( @Nullable final BigDecimal vehicleGrossWeight )
    {
        rememberChangedField("VehicleGrossWeight", this.vehicleGrossWeight);
        this.vehicleGrossWeight = vehicleGrossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VehicleMaximumCapacityValue</b>
     * </p>
     *
     * @param vehicleMaximumCapacityValue
     *            Maximum Capacity
     */
    public void setVehicleMaximumCapacityValue( @Nullable final String vehicleMaximumCapacityValue )
    {
        rememberChangedField("VehicleMaximumCapacityValue", this.vehicleMaximumCapacityValue);
        this.vehicleMaximumCapacityValue = vehicleMaximumCapacityValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>VehicleMaxTractionCapacity</b>
     * </p>
     *
     * @param vehicleMaxTractionCapacity
     *            Traction Capacity
     */
    public void setVehicleMaxTractionCapacity( @Nullable final String vehicleMaxTractionCapacity )
    {
        rememberChangedField("VehicleMaxTractionCapacity", this.vehicleMaxTractionCapacity);
        this.vehicleMaxTractionCapacity = vehicleMaxTractionCapacity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistanceBetweenAxlesQtyValue</b>
     * </p>
     *
     * @param distanceBetweenAxlesQtyValue
     *            Distance Between Axles
     */
    public void setDistanceBetweenAxlesQtyValue( @Nullable final String distanceBetweenAxlesQtyValue )
    {
        rememberChangedField("DistanceBetweenAxlesQtyValue", this.distanceBetweenAxlesQtyValue);
        this.distanceBetweenAxlesQtyValue = distanceBetweenAxlesQtyValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleUsage</b>
     * </p>
     *
     * @param vehicleUsage
     *            Vehicle Usage
     */
    public void setVehicleUsage( @Nullable final String vehicleUsage )
    {
        rememberChangedField("VehicleUsage", this.vehicleUsage);
        this.vehicleUsage = vehicleUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFItemVINCondition</b>
     * </p>
     *
     * @param bR_NFItemVINCondition
     *            VIN Condition
     */
    public void setBR_NFItemVINCondition( @Nullable final String bR_NFItemVINCondition )
    {
        rememberChangedField("BR_NFItemVINCondition", this.bR_NFItemVINCondition);
        this.bR_NFItemVINCondition = bR_NFItemVINCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleCondition</b>
     * </p>
     *
     * @param vehicleCondition
     *            Vehicle Condition
     */
    public void setVehicleCondition( @Nullable final String vehicleCondition )
    {
        rememberChangedField("VehicleCondition", this.vehicleCondition);
        this.vehicleCondition = vehicleCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleRestriction</b>
     * </p>
     *
     * @param vehicleRestriction
     *            Vehicle Restriction
     */
    public void setVehicleRestriction( @Nullable final String vehicleRestriction )
    {
        rememberChangedField("VehicleRestriction", this.vehicleRestriction);
        this.vehicleRestriction = vehicleRestriction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VehicleOperationType</b>
     * </p>
     *
     * @param vehicleOperationType
     *            Vehicle Operation
     */
    public void setVehicleOperationType( @Nullable final String vehicleOperationType )
    {
        rememberChangedField("VehicleOperationType", this.vehicleOperationType);
        this.vehicleOperationType = vehicleOperationType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFVehicle";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("VehicleModel", getVehicleModel());
        values.put("VehicleModelYear", getVehicleModelYear());
        values.put("VehicleYearOfManufacture", getVehicleYearOfManufacture());
        values.put("VehicleType", getVehicleType());
        values.put("VehicleFuelType", getVehicleFuelType());
        values.put("VehicleEnginePower", getVehicleEnginePower());
        values.put("VehicleCylinderCapacityValue", getVehicleCylinderCapacityValue());
        values.put("VehicleEngineNumber", getVehicleEngineNumber());
        values.put("VehicleCarMakerColor", getVehicleCarMakerColor());
        values.put("VehiclePaintingType", getVehiclePaintingType());
        values.put("BR_NFeVehicleDENATRANColor", getBR_NFeVehicleDENATRANColor());
        values.put("VehicleColorDesc", getVehicleColorDesc());
        values.put("VehicleChassis", getVehicleChassis());
        values.put("VehicleSerialNumber", getVehicleSerialNumber());
        values.put("VehicleNetWeightUnit", getVehicleNetWeightUnit());
        values.put("VehicleNetWeight", getVehicleNetWeight());
        values.put("VehicleGrossWeightUnit", getVehicleGrossWeightUnit());
        values.put("VehicleGrossWeight", getVehicleGrossWeight());
        values.put("VehicleMaximumCapacityValue", getVehicleMaximumCapacityValue());
        values.put("VehicleMaxTractionCapacity", getVehicleMaxTractionCapacity());
        values.put("DistanceBetweenAxlesQtyValue", getDistanceBetweenAxlesQtyValue());
        values.put("VehicleUsage", getVehicleUsage());
        values.put("BR_NFItemVINCondition", getBR_NFItemVINCondition());
        values.put("VehicleCondition", getVehicleCondition());
        values.put("VehicleRestriction", getVehicleRestriction());
        values.put("VehicleOperationType", getVehicleOperationType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("VehicleModel") ) {
                final Object value = values.remove("VehicleModel");
                if( (value == null) || (!value.equals(getVehicleModel())) ) {
                    setVehicleModel(((String) value));
                }
            }
            if( values.containsKey("VehicleModelYear") ) {
                final Object value = values.remove("VehicleModelYear");
                if( (value == null) || (!value.equals(getVehicleModelYear())) ) {
                    setVehicleModelYear(((String) value));
                }
            }
            if( values.containsKey("VehicleYearOfManufacture") ) {
                final Object value = values.remove("VehicleYearOfManufacture");
                if( (value == null) || (!value.equals(getVehicleYearOfManufacture())) ) {
                    setVehicleYearOfManufacture(((String) value));
                }
            }
            if( values.containsKey("VehicleType") ) {
                final Object value = values.remove("VehicleType");
                if( (value == null) || (!value.equals(getVehicleType())) ) {
                    setVehicleType(((String) value));
                }
            }
            if( values.containsKey("VehicleFuelType") ) {
                final Object value = values.remove("VehicleFuelType");
                if( (value == null) || (!value.equals(getVehicleFuelType())) ) {
                    setVehicleFuelType(((String) value));
                }
            }
            if( values.containsKey("VehicleEnginePower") ) {
                final Object value = values.remove("VehicleEnginePower");
                if( (value == null) || (!value.equals(getVehicleEnginePower())) ) {
                    setVehicleEnginePower(((String) value));
                }
            }
            if( values.containsKey("VehicleCylinderCapacityValue") ) {
                final Object value = values.remove("VehicleCylinderCapacityValue");
                if( (value == null) || (!value.equals(getVehicleCylinderCapacityValue())) ) {
                    setVehicleCylinderCapacityValue(((String) value));
                }
            }
            if( values.containsKey("VehicleEngineNumber") ) {
                final Object value = values.remove("VehicleEngineNumber");
                if( (value == null) || (!value.equals(getVehicleEngineNumber())) ) {
                    setVehicleEngineNumber(((String) value));
                }
            }
            if( values.containsKey("VehicleCarMakerColor") ) {
                final Object value = values.remove("VehicleCarMakerColor");
                if( (value == null) || (!value.equals(getVehicleCarMakerColor())) ) {
                    setVehicleCarMakerColor(((String) value));
                }
            }
            if( values.containsKey("VehiclePaintingType") ) {
                final Object value = values.remove("VehiclePaintingType");
                if( (value == null) || (!value.equals(getVehiclePaintingType())) ) {
                    setVehiclePaintingType(((String) value));
                }
            }
            if( values.containsKey("BR_NFeVehicleDENATRANColor") ) {
                final Object value = values.remove("BR_NFeVehicleDENATRANColor");
                if( (value == null) || (!value.equals(getBR_NFeVehicleDENATRANColor())) ) {
                    setBR_NFeVehicleDENATRANColor(((String) value));
                }
            }
            if( values.containsKey("VehicleColorDesc") ) {
                final Object value = values.remove("VehicleColorDesc");
                if( (value == null) || (!value.equals(getVehicleColorDesc())) ) {
                    setVehicleColorDesc(((String) value));
                }
            }
            if( values.containsKey("VehicleChassis") ) {
                final Object value = values.remove("VehicleChassis");
                if( (value == null) || (!value.equals(getVehicleChassis())) ) {
                    setVehicleChassis(((String) value));
                }
            }
            if( values.containsKey("VehicleSerialNumber") ) {
                final Object value = values.remove("VehicleSerialNumber");
                if( (value == null) || (!value.equals(getVehicleSerialNumber())) ) {
                    setVehicleSerialNumber(((String) value));
                }
            }
            if( values.containsKey("VehicleNetWeightUnit") ) {
                final Object value = values.remove("VehicleNetWeightUnit");
                if( (value == null) || (!value.equals(getVehicleNetWeightUnit())) ) {
                    setVehicleNetWeightUnit(((String) value));
                }
            }
            if( values.containsKey("VehicleNetWeight") ) {
                final Object value = values.remove("VehicleNetWeight");
                if( (value == null) || (!value.equals(getVehicleNetWeight())) ) {
                    setVehicleNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("VehicleGrossWeightUnit") ) {
                final Object value = values.remove("VehicleGrossWeightUnit");
                if( (value == null) || (!value.equals(getVehicleGrossWeightUnit())) ) {
                    setVehicleGrossWeightUnit(((String) value));
                }
            }
            if( values.containsKey("VehicleGrossWeight") ) {
                final Object value = values.remove("VehicleGrossWeight");
                if( (value == null) || (!value.equals(getVehicleGrossWeight())) ) {
                    setVehicleGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("VehicleMaximumCapacityValue") ) {
                final Object value = values.remove("VehicleMaximumCapacityValue");
                if( (value == null) || (!value.equals(getVehicleMaximumCapacityValue())) ) {
                    setVehicleMaximumCapacityValue(((String) value));
                }
            }
            if( values.containsKey("VehicleMaxTractionCapacity") ) {
                final Object value = values.remove("VehicleMaxTractionCapacity");
                if( (value == null) || (!value.equals(getVehicleMaxTractionCapacity())) ) {
                    setVehicleMaxTractionCapacity(((String) value));
                }
            }
            if( values.containsKey("DistanceBetweenAxlesQtyValue") ) {
                final Object value = values.remove("DistanceBetweenAxlesQtyValue");
                if( (value == null) || (!value.equals(getDistanceBetweenAxlesQtyValue())) ) {
                    setDistanceBetweenAxlesQtyValue(((String) value));
                }
            }
            if( values.containsKey("VehicleUsage") ) {
                final Object value = values.remove("VehicleUsage");
                if( (value == null) || (!value.equals(getVehicleUsage())) ) {
                    setVehicleUsage(((String) value));
                }
            }
            if( values.containsKey("BR_NFItemVINCondition") ) {
                final Object value = values.remove("BR_NFItemVINCondition");
                if( (value == null) || (!value.equals(getBR_NFItemVINCondition())) ) {
                    setBR_NFItemVINCondition(((String) value));
                }
            }
            if( values.containsKey("VehicleCondition") ) {
                final Object value = values.remove("VehicleCondition");
                if( (value == null) || (!value.equals(getVehicleCondition())) ) {
                    setVehicleCondition(((String) value));
                }
            }
            if( values.containsKey("VehicleRestriction") ) {
                final Object value = values.remove("VehicleRestriction");
                if( (value == null) || (!value.equals(getVehicleRestriction())) ) {
                    setVehicleRestriction(((String) value));
                }
            }
            if( values.containsKey("VehicleOperationType") ) {
                final Object value = values.remove("VehicleOperationType");
                if( (value == null) || (!value.equals(getVehicleOperationType())) ) {
                    setVehicleOperationType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Map ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = new BR_NFItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFVehicleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFVehicleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFVehicleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFVehicleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem fetchBR_NFItem()
    {
        return fetchFieldAsSingle("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFVehicle</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFVehicle</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFItem> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the associated <b>BR_NFItem</b> entity for the loaded navigation property <b>to_BR_NFItem</b>.
     *
     * @param value
     *            New <b>BR_NFItem</b> entity.
     */
    public void setBR_NFItem( final BR_NFItem value )
    {
        toBR_NFItem = value;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFVehicle</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFVehicle</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFVehicle instances.
     *
     */
    public final static class BR_NFVehicleBuilder
    {

        private BR_NFItem toBR_NFItem;
        private BR_NFDocument toBR_NFDoc;

        private BR_NFVehicle.BR_NFVehicleBuilder toBR_NFItem( final BR_NFItem value )
        {
            toBR_NFItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFVehicle</b> to single <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItem to build this BR_NFVehicle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFVehicle.BR_NFVehicleBuilder bR_NFItem( final BR_NFItem value )
        {
            return toBR_NFItem(value);
        }

        private BR_NFVehicle.BR_NFVehicleBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFVehicle</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFVehicle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFVehicle.BR_NFVehicleBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
