/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFePaymentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFePaymentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFePaymentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Payment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFePaymentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFePayment extends VdmEntity<BR_NFePayment>
{

    /**
     * Selector for all available fields of BR_NFePayment.
     *
     */
    public final static BR_NFePaymentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> BR_NOTA_FISCAL = new BR_NFePaymentField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> SEQUENCE_NUMBER = new BR_NFePaymentField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> PAYMENT_METHOD = new BR_NFePaymentField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAmount</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "PaymentAmount" )
    @JsonProperty( "PaymentAmount" )
    @Nullable
    @ODataField( odataName = "PaymentAmount" )
    private BigDecimal paymentAmount;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAmount</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<BigDecimal> PAYMENT_AMOUNT =
        new BR_NFePaymentField<BigDecimal>("PaymentAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentSystemIntegrationType</b>
     * </p>
     *
     * @return Payment Integration Type
     */
    @SerializedName( "PaymentSystemIntegrationType" )
    @JsonProperty( "PaymentSystemIntegrationType" )
    @Nullable
    @ODataField( odataName = "PaymentSystemIntegrationType" )
    private String paymentSystemIntegrationType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentSystemIntegrationType</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> PAYMENT_SYSTEM_INTEGRATION_TYPE =
        new BR_NFePaymentField<String>("PaymentSystemIntegrationType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_CreditCardCompanyCNPJ</b>
     * </p>
     *
     * @return Credit Card Issuer CNPJ
     */
    @SerializedName( "BR_CreditCardCompanyCNPJ" )
    @JsonProperty( "BR_CreditCardCompanyCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_CreditCardCompanyCNPJ" )
    private String bR_CreditCardCompanyCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_CreditCardCompanyCNPJ</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> BR_CREDIT_CARD_COMPANY_CNPJ =
        new BR_NFePaymentField<String>("BR_CreditCardCompanyCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditCardBrand</b>
     * </p>
     *
     * @return Credit/Debit Card Company
     */
    @SerializedName( "CreditCardBrand" )
    @JsonProperty( "CreditCardBrand" )
    @Nullable
    @ODataField( odataName = "CreditCardBrand" )
    private String creditCardBrand;
    /**
     * Use with available fluent helpers to apply the <b>CreditCardBrand</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> CREDIT_CARD_BRAND =
        new BR_NFePaymentField<String>("CreditCardBrand");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CreditCardTransactionAuthznID</b>
     * </p>
     *
     * @return Authorization Number
     */
    @SerializedName( "CreditCardTransactionAuthznID" )
    @JsonProperty( "CreditCardTransactionAuthznID" )
    @Nullable
    @ODataField( odataName = "CreditCardTransactionAuthznID" )
    private String creditCardTransactionAuthznID;
    /**
     * Use with available fluent helpers to apply the <b>CreditCardTransactionAuthznID</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> CREDIT_CARD_TRANSACTION_AUTHZN_ID =
        new BR_NFePaymentField<String>("CreditCardTransactionAuthznID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentForm</b>
     * </p>
     *
     * @return Form
     */
    @SerializedName( "PaymentForm" )
    @JsonProperty( "PaymentForm" )
    @Nullable
    @ODataField( odataName = "PaymentForm" )
    private String paymentForm;
    /**
     * Use with available fluent helpers to apply the <b>PaymentForm</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> PAYMENT_FORM = new BR_NFePaymentField<String>("PaymentForm");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPaymentMethodManualDesc</b>
     * </p>
     *
     * @return Method Description
     */
    @SerializedName( "BR_NFPaymentMethodManualDesc" )
    @JsonProperty( "BR_NFPaymentMethodManualDesc" )
    @Nullable
    @ODataField( odataName = "BR_NFPaymentMethodManualDesc" )
    private String bR_NFPaymentMethodManualDesc;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFPaymentMethodManualDesc</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> BRNF_PAYMENT_METHOD_MANUAL_DESC =
        new BR_NFePaymentField<String>("BR_NFPaymentMethodManualDesc");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "SalesDocumentCurrency" )
    @JsonProperty( "SalesDocumentCurrency" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCurrency" )
    private String salesDocumentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCurrency</b> field to query operations.
     *
     */
    public final static BR_NFePaymentField<String> SALES_DOCUMENT_CURRENCY =
        new BR_NFePaymentField<String>("SalesDocumentCurrency");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFePayment</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFePaymentOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFePaymentOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_NFePayment> getType()
    {
        return BR_NFePayment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Counter
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAmount</b>
     * </p>
     *
     * @param paymentAmount
     *            Amount
     */
    public void setPaymentAmount( @Nullable final BigDecimal paymentAmount )
    {
        rememberChangedField("PaymentAmount", this.paymentAmount);
        this.paymentAmount = paymentAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentSystemIntegrationType</b>
     * </p>
     *
     * @param paymentSystemIntegrationType
     *            Payment Integration Type
     */
    public void setPaymentSystemIntegrationType( @Nullable final String paymentSystemIntegrationType )
    {
        rememberChangedField("PaymentSystemIntegrationType", this.paymentSystemIntegrationType);
        this.paymentSystemIntegrationType = paymentSystemIntegrationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_CreditCardCompanyCNPJ</b>
     * </p>
     *
     * @param bR_CreditCardCompanyCNPJ
     *            Credit Card Issuer CNPJ
     */
    public void setBR_CreditCardCompanyCNPJ( @Nullable final String bR_CreditCardCompanyCNPJ )
    {
        rememberChangedField("BR_CreditCardCompanyCNPJ", this.bR_CreditCardCompanyCNPJ);
        this.bR_CreditCardCompanyCNPJ = bR_CreditCardCompanyCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditCardBrand</b>
     * </p>
     *
     * @param creditCardBrand
     *            Credit/Debit Card Company
     */
    public void setCreditCardBrand( @Nullable final String creditCardBrand )
    {
        rememberChangedField("CreditCardBrand", this.creditCardBrand);
        this.creditCardBrand = creditCardBrand;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CreditCardTransactionAuthznID</b>
     * </p>
     *
     * @param creditCardTransactionAuthznID
     *            Authorization Number
     */
    public void setCreditCardTransactionAuthznID( @Nullable final String creditCardTransactionAuthznID )
    {
        rememberChangedField("CreditCardTransactionAuthznID", this.creditCardTransactionAuthznID);
        this.creditCardTransactionAuthznID = creditCardTransactionAuthznID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentForm</b>
     * </p>
     *
     * @param paymentForm
     *            Form
     */
    public void setPaymentForm( @Nullable final String paymentForm )
    {
        rememberChangedField("PaymentForm", this.paymentForm);
        this.paymentForm = paymentForm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFPaymentMethodManualDesc</b>
     * </p>
     *
     * @param bR_NFPaymentMethodManualDesc
     *            Method Description
     */
    public void setBR_NFPaymentMethodManualDesc( @Nullable final String bR_NFPaymentMethodManualDesc )
    {
        rememberChangedField("BR_NFPaymentMethodManualDesc", this.bR_NFPaymentMethodManualDesc);
        this.bR_NFPaymentMethodManualDesc = bR_NFPaymentMethodManualDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCurrency</b>
     * </p>
     *
     * @param salesDocumentCurrency
     *            SD Document Currency
     */
    public void setSalesDocumentCurrency( @Nullable final String salesDocumentCurrency )
    {
        rememberChangedField("SalesDocumentCurrency", this.salesDocumentCurrency);
        this.salesDocumentCurrency = salesDocumentCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFePayment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("SequenceNumber", getSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("PaymentAmount", getPaymentAmount());
        values.put("PaymentSystemIntegrationType", getPaymentSystemIntegrationType());
        values.put("BR_CreditCardCompanyCNPJ", getBR_CreditCardCompanyCNPJ());
        values.put("CreditCardBrand", getCreditCardBrand());
        values.put("CreditCardTransactionAuthznID", getCreditCardTransactionAuthznID());
        values.put("PaymentForm", getPaymentForm());
        values.put("BR_NFPaymentMethodManualDesc", getBR_NFPaymentMethodManualDesc());
        values.put("SalesDocumentCurrency", getSalesDocumentCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("PaymentAmount") ) {
                final Object value = values.remove("PaymentAmount");
                if( (value == null) || (!value.equals(getPaymentAmount())) ) {
                    setPaymentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentSystemIntegrationType") ) {
                final Object value = values.remove("PaymentSystemIntegrationType");
                if( (value == null) || (!value.equals(getPaymentSystemIntegrationType())) ) {
                    setPaymentSystemIntegrationType(((String) value));
                }
            }
            if( values.containsKey("BR_CreditCardCompanyCNPJ") ) {
                final Object value = values.remove("BR_CreditCardCompanyCNPJ");
                if( (value == null) || (!value.equals(getBR_CreditCardCompanyCNPJ())) ) {
                    setBR_CreditCardCompanyCNPJ(((String) value));
                }
            }
            if( values.containsKey("CreditCardBrand") ) {
                final Object value = values.remove("CreditCardBrand");
                if( (value == null) || (!value.equals(getCreditCardBrand())) ) {
                    setCreditCardBrand(((String) value));
                }
            }
            if( values.containsKey("CreditCardTransactionAuthznID") ) {
                final Object value = values.remove("CreditCardTransactionAuthznID");
                if( (value == null) || (!value.equals(getCreditCardTransactionAuthznID())) ) {
                    setCreditCardTransactionAuthznID(((String) value));
                }
            }
            if( values.containsKey("PaymentForm") ) {
                final Object value = values.remove("PaymentForm");
                if( (value == null) || (!value.equals(getPaymentForm())) ) {
                    setPaymentForm(((String) value));
                }
            }
            if( values.containsKey("BR_NFPaymentMethodManualDesc") ) {
                final Object value = values.remove("BR_NFPaymentMethodManualDesc");
                if( (value == null) || (!value.equals(getBR_NFPaymentMethodManualDesc())) ) {
                    setBR_NFPaymentMethodManualDesc(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentCurrency") ) {
                final Object value = values.remove("SalesDocumentCurrency");
                if( (value == null) || (!value.equals(getSalesDocumentCurrency())) ) {
                    setSalesDocumentCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BR_NFePaymentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFePaymentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFePaymentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFePaymentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFePayment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFePayment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFePayment instances.
     *
     */
    public final static class BR_NFePaymentBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_NFePayment.BR_NFePaymentBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFePayment</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFePayment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFePayment.BR_NFePaymentBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
