/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFeProductTraceabilityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFeProductTraceabilityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFeProductTraceabilitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Traceability
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_NFeProductTraceabilityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_NFeProductTraceability extends VdmEntity<BR_NFeProductTraceability>
{

    /**
     * Selector for all available fields of BR_NFeProductTraceability.
     *
     */
    public final static BR_NFeProductTraceabilitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> BR_NOTA_FISCAL =
        new BR_NFeProductTraceabilityField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @return Document Item Number
     */
    @Key
    @SerializedName( "BR_NotaFiscalItem" )
    @JsonProperty( "BR_NotaFiscalItem" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscalItem" )
    private String bR_NotaFiscalItem;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscalItem</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> BR_NOTA_FISCAL_ITEM =
        new BR_NFeProductTraceabilityField<String>("BR_NotaFiscalItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> SEQUENCE_NUMBER =
        new BR_NFeProductTraceabilityField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "ProductBatch" )
    @JsonProperty( "ProductBatch" )
    @Nullable
    @ODataField( odataName = "ProductBatch" )
    private String productBatch;
    /**
     * Use with available fluent helpers to apply the <b>ProductBatch</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> PRODUCT_BATCH =
        new BR_NFeProductTraceabilityField<String>("ProductBatch");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatchQuantity</b>
     * </p>
     *
     * @return Batch Quantity
     */
    @SerializedName( "ProductBatchQuantity" )
    @JsonProperty( "ProductBatchQuantity" )
    @Nullable
    @ODataField( odataName = "ProductBatchQuantity" )
    private BigDecimal productBatchQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProductBatchQuantity</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<BigDecimal> PRODUCT_BATCH_QUANTITY =
        new BR_NFeProductTraceabilityField<BigDecimal>("ProductBatchQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingDate</b>
     * </p>
     *
     * @return Manufacturing Date
     */
    @SerializedName( "ManufacturingDate" )
    @JsonProperty( "ManufacturingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ManufacturingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime manufacturingDate;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingDate</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<LocalDateTime> MANUFACTURING_DATE =
        new BR_NFeProductTraceabilityField<LocalDateTime>("ManufacturingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExpirationDate</b>
     * </p>
     *
     * @return Expiring Date
     */
    @SerializedName( "ExpirationDate" )
    @JsonProperty( "ExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime expirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ExpirationDate</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<LocalDateTime> EXPIRATION_DATE =
        new BR_NFeProductTraceabilityField<LocalDateTime>("ExpirationDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AggregationID</b>
     * </p>
     *
     * @return OBSOLETE: Aggregation Code
     */
    @SerializedName( "AggregationID" )
    @JsonProperty( "AggregationID" )
    @Nullable
    @ODataField( odataName = "AggregationID" )
    private String aggregationID;
    /**
     * Use with available fluent helpers to apply the <b>AggregationID</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> AGGREGATION_ID =
        new BR_NFeProductTraceabilityField<String>("AggregationID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeProdTrcblyAggregationID</b>
     * </p>
     *
     * @return Aggregation Code
     */
    @SerializedName( "BR_NFeProdTrcblyAggregationID" )
    @JsonProperty( "BR_NFeProdTrcblyAggregationID" )
    @Nullable
    @ODataField( odataName = "BR_NFeProdTrcblyAggregationID" )
    private String bR_NFeProdTrcblyAggregationID;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFeProdTrcblyAggregationID</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> BRN_FE_PROD_TRCBLY_AGGREGATION_ID =
        new BR_NFeProductTraceabilityField<String>("BR_NFeProdTrcblyAggregationID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityField<String> BASE_UNIT =
        new BR_NFeProductTraceabilityField<String>("BaseUnit");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFeProductTraceability</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFeProductTraceability</b> to single <b>BR_NFItem</b>.
     *
     */
    @SerializedName( "to_BR_NFItem" )
    @JsonProperty( "to_BR_NFItem" )
    @ODataField( odataName = "to_BR_NFItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFItem toBR_NFItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_NFeProductTraceabilityOneToOneLink<BR_NFDocument>("to_BR_NFDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFItem</b> navigation property to query operations.
     *
     */
    public final static BR_NFeProductTraceabilityOneToOneLink<BR_NFItem> TO_BRNF_ITEM =
        new BR_NFeProductTraceabilityOneToOneLink<BR_NFItem>("to_BR_NFItem");

    @Nonnull
    @Override
    public Class<BR_NFeProductTraceability> getType()
    {
        return BR_NFeProductTraceability.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscalItem</b>
     * </p>
     *
     * @param bR_NotaFiscalItem
     *            Document Item Number
     */
    public void setBR_NotaFiscalItem( @Nullable final String bR_NotaFiscalItem )
    {
        rememberChangedField("BR_NotaFiscalItem", this.bR_NotaFiscalItem);
        this.bR_NotaFiscalItem = bR_NotaFiscalItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Counter
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatch</b>
     * </p>
     *
     * @param productBatch
     *            Batch Number
     */
    public void setProductBatch( @Nullable final String productBatch )
    {
        rememberChangedField("ProductBatch", this.productBatch);
        this.productBatch = productBatch;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductBatchQuantity</b>
     * </p>
     *
     * @param productBatchQuantity
     *            Batch Quantity
     */
    public void setProductBatchQuantity( @Nullable final BigDecimal productBatchQuantity )
    {
        rememberChangedField("ProductBatchQuantity", this.productBatchQuantity);
        this.productBatchQuantity = productBatchQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingDate</b>
     * </p>
     *
     * @param manufacturingDate
     *            Manufacturing Date
     */
    public void setManufacturingDate( @Nullable final LocalDateTime manufacturingDate )
    {
        rememberChangedField("ManufacturingDate", this.manufacturingDate);
        this.manufacturingDate = manufacturingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExpirationDate</b>
     * </p>
     *
     * @param expirationDate
     *            Expiring Date
     */
    public void setExpirationDate( @Nullable final LocalDateTime expirationDate )
    {
        rememberChangedField("ExpirationDate", this.expirationDate);
        this.expirationDate = expirationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AggregationID</b>
     * </p>
     *
     * @param aggregationID
     *            OBSOLETE: Aggregation Code
     */
    public void setAggregationID( @Nullable final String aggregationID )
    {
        rememberChangedField("AggregationID", this.aggregationID);
        this.aggregationID = aggregationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFeProdTrcblyAggregationID</b>
     * </p>
     *
     * @param bR_NFeProdTrcblyAggregationID
     *            Aggregation Code
     */
    public void setBR_NFeProdTrcblyAggregationID( @Nullable final String bR_NFeProdTrcblyAggregationID )
    {
        rememberChangedField("BR_NFeProdTrcblyAggregationID", this.bR_NFeProdTrcblyAggregationID);
        this.bR_NFeProdTrcblyAggregationID = bR_NFeProdTrcblyAggregationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_NFeProductTraceability";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        result.put("SequenceNumber", getSequenceNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_NotaFiscalItem", getBR_NotaFiscalItem());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("ProductBatch", getProductBatch());
        values.put("ProductBatchQuantity", getProductBatchQuantity());
        values.put("ManufacturingDate", getManufacturingDate());
        values.put("ExpirationDate", getExpirationDate());
        values.put("AggregationID", getAggregationID());
        values.put("BR_NFeProdTrcblyAggregationID", getBR_NFeProdTrcblyAggregationID());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_NotaFiscalItem") ) {
                final Object value = values.remove("BR_NotaFiscalItem");
                if( (value == null) || (!value.equals(getBR_NotaFiscalItem())) ) {
                    setBR_NotaFiscalItem(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("ProductBatch") ) {
                final Object value = values.remove("ProductBatch");
                if( (value == null) || (!value.equals(getProductBatch())) ) {
                    setProductBatch(((String) value));
                }
            }
            if( values.containsKey("ProductBatchQuantity") ) {
                final Object value = values.remove("ProductBatchQuantity");
                if( (value == null) || (!value.equals(getProductBatchQuantity())) ) {
                    setProductBatchQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ManufacturingDate") ) {
                final Object value = values.remove("ManufacturingDate");
                if( (value == null) || (!value.equals(getManufacturingDate())) ) {
                    setManufacturingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExpirationDate") ) {
                final Object value = values.remove("ExpirationDate");
                if( (value == null) || (!value.equals(getExpirationDate())) ) {
                    setExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AggregationID") ) {
                final Object value = values.remove("AggregationID");
                if( (value == null) || (!value.equals(getAggregationID())) ) {
                    setAggregationID(((String) value));
                }
            }
            if( values.containsKey("BR_NFeProdTrcblyAggregationID") ) {
                final Object value = values.remove("BR_NFeProdTrcblyAggregationID");
                if( (value == null) || (!value.equals(getBR_NFeProdTrcblyAggregationID())) ) {
                    setBR_NFeProdTrcblyAggregationID(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BR_NFItem") ) {
                final Object value = (values).remove("to_BR_NFItem");
                if( value instanceof Map ) {
                    if( toBR_NFItem == null ) {
                        toBR_NFItem = new BR_NFItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_NFeProductTraceabilityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_NFeProductTraceabilityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_NFeProductTraceabilityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_NFeProductTraceabilityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        if( toBR_NFItem != null ) {
            (values).put("to_BR_NFItem", toBR_NFItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_NFeProductTraceability</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFeProductTraceability</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Fetches the <b>BR_NFItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem fetchBR_NFItem()
    {
        return fetchFieldAsSingle("to_BR_NFItem", BR_NFItem.class);
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property <b>to_BR_NFItem</b> of a queried <b>BR_NFeProductTraceability</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFItem getBR_NFItemOrFetch()
    {
        if( toBR_NFItem == null ) {
            toBR_NFItem = fetchBR_NFItem();
        }
        return toBR_NFItem;
    }

    /**
     * Retrieval of associated <b>BR_NFItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BR_NFItem</b>.
     * <p>
     * If the navigation property for an entity <b>BR_NFeProductTraceability</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFItem</b> is already loaded, the result will contain
     *         the <b>BR_NFItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFItem> getBR_NFItemIfPresent()
    {
        return Option.of(toBR_NFItem);
    }

    /**
     * Overwrites the associated <b>BR_NFItem</b> entity for the loaded navigation property <b>to_BR_NFItem</b>.
     *
     * @param value
     *            New <b>BR_NFItem</b> entity.
     */
    public void setBR_NFItem( final BR_NFItem value )
    {
        toBR_NFItem = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_NFeProductTraceability instances.
     *
     */
    public final static class BR_NFeProductTraceabilityBuilder
    {

        private BR_NFDocument toBR_NFDoc;
        private BR_NFItem toBR_NFItem;

        private BR_NFeProductTraceability.BR_NFeProductTraceabilityBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_NFeProductTraceability</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_NFeProductTraceability with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFeProductTraceability.BR_NFeProductTraceabilityBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

        private BR_NFeProductTraceability.BR_NFeProductTraceabilityBuilder toBR_NFItem( final BR_NFItem value )
        {
            toBR_NFItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFItem</b> for <b>BR_NFeProductTraceability</b> to single <b>BR_NFItem</b>.
         *
         * @param value
         *            The BR_NFItem to build this BR_NFeProductTraceability with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_NFeProductTraceability.BR_NFeProductTraceabilityBuilder bR_NFItem( final BR_NFItem value )
        {
            return toBR_NFItem(value);
        }

    }

}
