/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_OneTimePartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_OneTimePartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_OneTimePartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal One Time Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_OneTimePartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_OneTimePartner extends VdmEntity<BR_OneTimePartner>
{

    /**
     * Selector for all available fields of BR_OneTimePartner.
     *
     */
    public final static BR_OneTimePartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BR_NOTA_FISCAL =
        new BR_OneTimePartnerField<String>("BR_NotaFiscal");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerFunction</b>
     * </p>
     *
     * @return Nota Fiscal Partner Function
     */
    @Key
    @SerializedName( "BR_PartnerFunction" )
    @JsonProperty( "BR_PartnerFunction" )
    @Nullable
    @ODataField( odataName = "BR_PartnerFunction" )
    private String bR_PartnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>BR_PartnerFunction</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BR_PARTNER_FUNCTION =
        new BR_OneTimePartnerField<String>("BR_PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_NAME1 =
        new BR_OneTimePartnerField<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_NAME2 =
        new BR_OneTimePartnerField<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCNPJ</b>
     * </p>
     *
     * @return Tax Number 1
     */
    @SerializedName( "BR_PartnerCNPJ" )
    @JsonProperty( "BR_PartnerCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_PartnerCNPJ" )
    private String bR_PartnerCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_PartnerCNPJ</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BR_PARTNER_CNPJ =
        new BR_OneTimePartnerField<String>("BR_PartnerCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCPF</b>
     * </p>
     *
     * @return Tax Number 2
     */
    @SerializedName( "BR_PartnerCPF" )
    @JsonProperty( "BR_PartnerCPF" )
    @Nullable
    @ODataField( odataName = "BR_PartnerCPF" )
    private String bR_PartnerCPF;
    /**
     * Use with available fluent helpers to apply the <b>BR_PartnerCPF</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BR_PARTNER_CPF =
        new BR_OneTimePartnerField<String>("BR_PartnerCPF");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerStateTaxNumberST</b>
     * </p>
     *
     * @return State Tax Number
     */
    @SerializedName( "BR_PartnerStateTaxNumberST" )
    @JsonProperty( "BR_PartnerStateTaxNumberST" )
    @Nullable
    @ODataField( odataName = "BR_PartnerStateTaxNumberST" )
    private String bR_PartnerStateTaxNumberST;
    /**
     * Use with available fluent helpers to apply the <b>BR_PartnerStateTaxNumberST</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BR_PARTNER_STATE_TAX_NUMBER_ST =
        new BR_OneTimePartnerField<String>("BR_PartnerStateTaxNumberST");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerTaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "BusinessPartnerTaxJurisdiction" )
    @JsonProperty( "BusinessPartnerTaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerTaxJurisdiction" )
    private String businessPartnerTaxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerTaxJurisdiction</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_TAX_JURISDICTION =
        new BR_OneTimePartnerField<String>("BusinessPartnerTaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerStreetNameOnly</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "BusinessPartnerStreetNameOnly" )
    @JsonProperty( "BusinessPartnerStreetNameOnly" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerStreetNameOnly" )
    private String businessPartnerStreetNameOnly;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerStreetNameOnly</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_STREET_NAME_ONLY =
        new BR_OneTimePartnerField<String>("BusinessPartnerStreetNameOnly");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerStreetName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "BusinessPartnerStreetName" )
    @JsonProperty( "BusinessPartnerStreetName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerStreetName" )
    private String businessPartnerStreetName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerStreetName</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_STREET_NAME =
        new BR_OneTimePartnerField<String>("BusinessPartnerStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "BusinessPartnerHouseNumber" )
    @JsonProperty( "BusinessPartnerHouseNumber" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerHouseNumber" )
    private String businessPartnerHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerHouseNumber</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_HOUSE_NUMBER =
        new BR_OneTimePartnerField<String>("BusinessPartnerHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPHsNmbrSuplmntTxt</b>
     * </p>
     *
     * @return House number supplement
     */
    @SerializedName( "BPHsNmbrSuplmntTxt" )
    @JsonProperty( "BPHsNmbrSuplmntTxt" )
    @Nullable
    @ODataField( odataName = "BPHsNmbrSuplmntTxt" )
    private String bPHsNmbrSuplmntTxt;
    /**
     * Use with available fluent helpers to apply the <b>BPHsNmbrSuplmntTxt</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BP_HS_NMBR_SUPLMNT_TXT =
        new BR_OneTimePartnerField<String>("BPHsNmbrSuplmntTxt");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDistrict</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "BusinessPartnerDistrict" )
    @JsonProperty( "BusinessPartnerDistrict" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerDistrict" )
    private String businessPartnerDistrict;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerDistrict</b> field to query operations.
     *
     */
    public final static BR_OneTimePartnerField<String> BUSINESS_PARTNER_DISTRICT =
        new BR_OneTimePartnerField<String>("BusinessPartnerDistrict");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_OneTimePartner</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_OneTimePartnerOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_OneTimePartnerOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_OneTimePartner> getType()
    {
        return BR_OneTimePartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerFunction</b>
     * </p>
     *
     * @param bR_PartnerFunction
     *            Nota Fiscal Partner Function
     */
    public void setBR_PartnerFunction( @Nullable final String bR_PartnerFunction )
    {
        rememberChangedField("BR_PartnerFunction", this.bR_PartnerFunction);
        this.bR_PartnerFunction = bR_PartnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name 1
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCNPJ</b>
     * </p>
     *
     * @param bR_PartnerCNPJ
     *            Tax Number 1
     */
    public void setBR_PartnerCNPJ( @Nullable final String bR_PartnerCNPJ )
    {
        rememberChangedField("BR_PartnerCNPJ", this.bR_PartnerCNPJ);
        this.bR_PartnerCNPJ = bR_PartnerCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerCPF</b>
     * </p>
     *
     * @param bR_PartnerCPF
     *            Tax Number 2
     */
    public void setBR_PartnerCPF( @Nullable final String bR_PartnerCPF )
    {
        rememberChangedField("BR_PartnerCPF", this.bR_PartnerCPF);
        this.bR_PartnerCPF = bR_PartnerCPF;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_PartnerStateTaxNumberST</b>
     * </p>
     *
     * @param bR_PartnerStateTaxNumberST
     *            State Tax Number
     */
    public void setBR_PartnerStateTaxNumberST( @Nullable final String bR_PartnerStateTaxNumberST )
    {
        rememberChangedField("BR_PartnerStateTaxNumberST", this.bR_PartnerStateTaxNumberST);
        this.bR_PartnerStateTaxNumberST = bR_PartnerStateTaxNumberST;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerTaxJurisdiction</b>
     * </p>
     *
     * @param businessPartnerTaxJurisdiction
     *            Tax Jurisdiction
     */
    public void setBusinessPartnerTaxJurisdiction( @Nullable final String businessPartnerTaxJurisdiction )
    {
        rememberChangedField("BusinessPartnerTaxJurisdiction", this.businessPartnerTaxJurisdiction);
        this.businessPartnerTaxJurisdiction = businessPartnerTaxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerStreetNameOnly</b>
     * </p>
     *
     * @param businessPartnerStreetNameOnly
     *            Street
     */
    public void setBusinessPartnerStreetNameOnly( @Nullable final String businessPartnerStreetNameOnly )
    {
        rememberChangedField("BusinessPartnerStreetNameOnly", this.businessPartnerStreetNameOnly);
        this.businessPartnerStreetNameOnly = businessPartnerStreetNameOnly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerStreetName</b>
     * </p>
     *
     * @param businessPartnerStreetName
     *            Street and House Number
     */
    public void setBusinessPartnerStreetName( @Nullable final String businessPartnerStreetName )
    {
        rememberChangedField("BusinessPartnerStreetName", this.businessPartnerStreetName);
        this.businessPartnerStreetName = businessPartnerStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerHouseNumber</b>
     * </p>
     *
     * @param businessPartnerHouseNumber
     *            House Number
     */
    public void setBusinessPartnerHouseNumber( @Nullable final String businessPartnerHouseNumber )
    {
        rememberChangedField("BusinessPartnerHouseNumber", this.businessPartnerHouseNumber);
        this.businessPartnerHouseNumber = businessPartnerHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPHsNmbrSuplmntTxt</b>
     * </p>
     *
     * @param bPHsNmbrSuplmntTxt
     *            House number supplement
     */
    public void setBPHsNmbrSuplmntTxt( @Nullable final String bPHsNmbrSuplmntTxt )
    {
        rememberChangedField("BPHsNmbrSuplmntTxt", this.bPHsNmbrSuplmntTxt);
        this.bPHsNmbrSuplmntTxt = bPHsNmbrSuplmntTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDistrict</b>
     * </p>
     *
     * @param businessPartnerDistrict
     *            District
     */
    public void setBusinessPartnerDistrict( @Nullable final String businessPartnerDistrict )
    {
        rememberChangedField("BusinessPartnerDistrict", this.businessPartnerDistrict);
        this.businessPartnerDistrict = businessPartnerDistrict;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_OneTimePartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        result.put("BR_PartnerFunction", getBR_PartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_PartnerFunction", getBR_PartnerFunction());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("BR_PartnerCNPJ", getBR_PartnerCNPJ());
        values.put("BR_PartnerCPF", getBR_PartnerCPF());
        values.put("BR_PartnerStateTaxNumberST", getBR_PartnerStateTaxNumberST());
        values.put("BusinessPartnerTaxJurisdiction", getBusinessPartnerTaxJurisdiction());
        values.put("BusinessPartnerStreetNameOnly", getBusinessPartnerStreetNameOnly());
        values.put("BusinessPartnerStreetName", getBusinessPartnerStreetName());
        values.put("BusinessPartnerHouseNumber", getBusinessPartnerHouseNumber());
        values.put("BPHsNmbrSuplmntTxt", getBPHsNmbrSuplmntTxt());
        values.put("BusinessPartnerDistrict", getBusinessPartnerDistrict());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_PartnerFunction") ) {
                final Object value = values.remove("BR_PartnerFunction");
                if( (value == null) || (!value.equals(getBR_PartnerFunction())) ) {
                    setBR_PartnerFunction(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("BR_PartnerCNPJ") ) {
                final Object value = values.remove("BR_PartnerCNPJ");
                if( (value == null) || (!value.equals(getBR_PartnerCNPJ())) ) {
                    setBR_PartnerCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_PartnerCPF") ) {
                final Object value = values.remove("BR_PartnerCPF");
                if( (value == null) || (!value.equals(getBR_PartnerCPF())) ) {
                    setBR_PartnerCPF(((String) value));
                }
            }
            if( values.containsKey("BR_PartnerStateTaxNumberST") ) {
                final Object value = values.remove("BR_PartnerStateTaxNumberST");
                if( (value == null) || (!value.equals(getBR_PartnerStateTaxNumberST())) ) {
                    setBR_PartnerStateTaxNumberST(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerTaxJurisdiction") ) {
                final Object value = values.remove("BusinessPartnerTaxJurisdiction");
                if( (value == null) || (!value.equals(getBusinessPartnerTaxJurisdiction())) ) {
                    setBusinessPartnerTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerStreetNameOnly") ) {
                final Object value = values.remove("BusinessPartnerStreetNameOnly");
                if( (value == null) || (!value.equals(getBusinessPartnerStreetNameOnly())) ) {
                    setBusinessPartnerStreetNameOnly(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerStreetName") ) {
                final Object value = values.remove("BusinessPartnerStreetName");
                if( (value == null) || (!value.equals(getBusinessPartnerStreetName())) ) {
                    setBusinessPartnerStreetName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerHouseNumber") ) {
                final Object value = values.remove("BusinessPartnerHouseNumber");
                if( (value == null) || (!value.equals(getBusinessPartnerHouseNumber())) ) {
                    setBusinessPartnerHouseNumber(((String) value));
                }
            }
            if( values.containsKey("BPHsNmbrSuplmntTxt") ) {
                final Object value = values.remove("BPHsNmbrSuplmntTxt");
                if( (value == null) || (!value.equals(getBPHsNmbrSuplmntTxt())) ) {
                    setBPHsNmbrSuplmntTxt(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerDistrict") ) {
                final Object value = values.remove("BusinessPartnerDistrict");
                if( (value == null) || (!value.equals(getBusinessPartnerDistrict())) ) {
                    setBusinessPartnerDistrict(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_OneTimePartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_OneTimePartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_OneTimePartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_OneTimePartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_OneTimePartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_OneTimePartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_OneTimePartner instances.
     *
     */
    public final static class BR_OneTimePartnerBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_OneTimePartner.BR_OneTimePartnerBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_OneTimePartner</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_OneTimePartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_OneTimePartner.BR_OneTimePartnerBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
