/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_TechnicalResponsibleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_TechnicalResponsibleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_TechnicalResponsibleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Brazil Nota Fiscal Technical Responsible
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BR_TechnicalResponsibleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BR_TechnicalResponsible extends VdmEntity<BR_TechnicalResponsible>
{

    /**
     * Selector for all available fields of BR_TechnicalResponsible.
     *
     */
    public final static BR_TechnicalResponsibleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "BR_NotaFiscal" )
    @JsonProperty( "BR_NotaFiscal" )
    @Nullable
    @ODataField( odataName = "BR_NotaFiscal" )
    private String bR_NotaFiscal;
    /**
     * Use with available fluent helpers to apply the <b>BR_NotaFiscal</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_NOTA_FISCAL =
        new BR_TechnicalResponsibleField<String>("BR_NotaFiscal");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalResponsibleCNPJ</b>
     * </p>
     *
     * @return Technical Responsible CNPJ
     */
    @SerializedName( "BR_TechnicalResponsibleCNPJ" )
    @JsonProperty( "BR_TechnicalResponsibleCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_TechnicalResponsibleCNPJ" )
    private String bR_TechnicalResponsibleCNPJ;
    /**
     * Use with available fluent helpers to apply the <b>BR_TechnicalResponsibleCNPJ</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_TECHNICAL_RESPONSIBLE_CNPJ =
        new BR_TechnicalResponsibleField<String>("BR_TechnicalResponsibleCNPJ");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalRespContactName</b>
     * </p>
     *
     * @return Contact Name
     */
    @SerializedName( "BR_TechnicalRespContactName" )
    @JsonProperty( "BR_TechnicalRespContactName" )
    @Nullable
    @ODataField( odataName = "BR_TechnicalRespContactName" )
    private String bR_TechnicalRespContactName;
    /**
     * Use with available fluent helpers to apply the <b>BR_TechnicalRespContactName</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_TECHNICAL_RESP_CONTACT_NAME =
        new BR_TechnicalResponsibleField<String>("BR_TechnicalRespContactName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalResponsibleEmail</b>
     * </p>
     *
     * @return E-mail
     */
    @SerializedName( "BR_TechnicalResponsibleEmail" )
    @JsonProperty( "BR_TechnicalResponsibleEmail" )
    @Nullable
    @ODataField( odataName = "BR_TechnicalResponsibleEmail" )
    private String bR_TechnicalResponsibleEmail;
    /**
     * Use with available fluent helpers to apply the <b>BR_TechnicalResponsibleEmail</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_TECHNICAL_RESPONSIBLE_EMAIL =
        new BR_TechnicalResponsibleField<String>("BR_TechnicalResponsibleEmail");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechResponsiblePhoneNumber</b>
     * </p>
     *
     * @return Phone
     */
    @SerializedName( "BR_TechResponsiblePhoneNumber" )
    @JsonProperty( "BR_TechResponsiblePhoneNumber" )
    @Nullable
    @ODataField( odataName = "BR_TechResponsiblePhoneNumber" )
    private String bR_TechResponsiblePhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>BR_TechResponsiblePhoneNumber</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_TECH_RESPONSIBLE_PHONE_NUMBER =
        new BR_TechnicalResponsibleField<String>("BR_TechResponsiblePhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_SecureCodeTechRespID</b>
     * </p>
     *
     * @return Secure Code Identifier
     */
    @SerializedName( "BR_SecureCodeTechRespID" )
    @JsonProperty( "BR_SecureCodeTechRespID" )
    @Nullable
    @ODataField( odataName = "BR_SecureCodeTechRespID" )
    private String bR_SecureCodeTechRespID;
    /**
     * Use with available fluent helpers to apply the <b>BR_SecureCodeTechRespID</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_SECURE_CODE_TECH_RESP_ID =
        new BR_TechnicalResponsibleField<String>("BR_SecureCodeTechRespID");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>BR_SecureCodeTechnicalRespHash</b>
     * </p>
     *
     * @return Secure Code
     */
    @SerializedName( "BR_SecureCodeTechnicalRespHash" )
    @JsonProperty( "BR_SecureCodeTechnicalRespHash" )
    @Nullable
    @ODataField( odataName = "BR_SecureCodeTechnicalRespHash" )
    private String bR_SecureCodeTechnicalRespHash;
    /**
     * Use with available fluent helpers to apply the <b>BR_SecureCodeTechnicalRespHash</b> field to query operations.
     *
     */
    public final static BR_TechnicalResponsibleField<String> BR_SECURE_CODE_TECHNICAL_RESP_HASH =
        new BR_TechnicalResponsibleField<String>("BR_SecureCodeTechnicalRespHash");
    /**
     * Navigation property <b>to_BR_NFDoc</b> for <b>BR_TechnicalResponsible</b> to single <b>BR_NFDocument</b>.
     *
     */
    @SerializedName( "to_BR_NFDoc" )
    @JsonProperty( "to_BR_NFDoc" )
    @ODataField( odataName = "to_BR_NFDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BR_NFDocument toBR_NFDoc;
    /**
     * Use with available fluent helpers to apply the <b>to_BR_NFDoc</b> navigation property to query operations.
     *
     */
    public final static BR_TechnicalResponsibleOneToOneLink<BR_NFDocument> TO_BRNF_DOC =
        new BR_TechnicalResponsibleOneToOneLink<BR_NFDocument>("to_BR_NFDoc");

    @Nonnull
    @Override
    public Class<BR_TechnicalResponsible> getType()
    {
        return BR_TechnicalResponsible.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BR_NotaFiscal</b>
     * </p>
     *
     * @param bR_NotaFiscal
     *            Document Number
     */
    public void setBR_NotaFiscal( @Nullable final String bR_NotaFiscal )
    {
        rememberChangedField("BR_NotaFiscal", this.bR_NotaFiscal);
        this.bR_NotaFiscal = bR_NotaFiscal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalResponsibleCNPJ</b>
     * </p>
     *
     * @param bR_TechnicalResponsibleCNPJ
     *            Technical Responsible CNPJ
     */
    public void setBR_TechnicalResponsibleCNPJ( @Nullable final String bR_TechnicalResponsibleCNPJ )
    {
        rememberChangedField("BR_TechnicalResponsibleCNPJ", this.bR_TechnicalResponsibleCNPJ);
        this.bR_TechnicalResponsibleCNPJ = bR_TechnicalResponsibleCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalRespContactName</b>
     * </p>
     *
     * @param bR_TechnicalRespContactName
     *            Contact Name
     */
    public void setBR_TechnicalRespContactName( @Nullable final String bR_TechnicalRespContactName )
    {
        rememberChangedField("BR_TechnicalRespContactName", this.bR_TechnicalRespContactName);
        this.bR_TechnicalRespContactName = bR_TechnicalRespContactName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechnicalResponsibleEmail</b>
     * </p>
     *
     * @param bR_TechnicalResponsibleEmail
     *            E-mail
     */
    public void setBR_TechnicalResponsibleEmail( @Nullable final String bR_TechnicalResponsibleEmail )
    {
        rememberChangedField("BR_TechnicalResponsibleEmail", this.bR_TechnicalResponsibleEmail);
        this.bR_TechnicalResponsibleEmail = bR_TechnicalResponsibleEmail;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>BR_TechResponsiblePhoneNumber</b>
     * </p>
     *
     * @param bR_TechResponsiblePhoneNumber
     *            Phone
     */
    public void setBR_TechResponsiblePhoneNumber( @Nullable final String bR_TechResponsiblePhoneNumber )
    {
        rememberChangedField("BR_TechResponsiblePhoneNumber", this.bR_TechResponsiblePhoneNumber);
        this.bR_TechResponsiblePhoneNumber = bR_TechResponsiblePhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_SecureCodeTechRespID</b>
     * </p>
     *
     * @param bR_SecureCodeTechRespID
     *            Secure Code Identifier
     */
    public void setBR_SecureCodeTechRespID( @Nullable final String bR_SecureCodeTechRespID )
    {
        rememberChangedField("BR_SecureCodeTechRespID", this.bR_SecureCodeTechRespID);
        this.bR_SecureCodeTechRespID = bR_SecureCodeTechRespID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>BR_SecureCodeTechnicalRespHash</b>
     * </p>
     *
     * @param bR_SecureCodeTechnicalRespHash
     *            Secure Code
     */
    public void setBR_SecureCodeTechnicalRespHash( @Nullable final String bR_SecureCodeTechnicalRespHash )
    {
        rememberChangedField("BR_SecureCodeTechnicalRespHash", this.bR_SecureCodeTechnicalRespHash);
        this.bR_SecureCodeTechnicalRespHash = bR_SecureCodeTechnicalRespHash;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BR_TechnicalResponsible";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BR_NotaFiscal", getBR_NotaFiscal());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BR_NotaFiscal", getBR_NotaFiscal());
        values.put("BR_TechnicalResponsibleCNPJ", getBR_TechnicalResponsibleCNPJ());
        values.put("BR_TechnicalRespContactName", getBR_TechnicalRespContactName());
        values.put("BR_TechnicalResponsibleEmail", getBR_TechnicalResponsibleEmail());
        values.put("BR_TechResponsiblePhoneNumber", getBR_TechResponsiblePhoneNumber());
        values.put("BR_SecureCodeTechRespID", getBR_SecureCodeTechRespID());
        values.put("BR_SecureCodeTechnicalRespHash", getBR_SecureCodeTechnicalRespHash());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BR_NotaFiscal") ) {
                final Object value = values.remove("BR_NotaFiscal");
                if( (value == null) || (!value.equals(getBR_NotaFiscal())) ) {
                    setBR_NotaFiscal(((String) value));
                }
            }
            if( values.containsKey("BR_TechnicalResponsibleCNPJ") ) {
                final Object value = values.remove("BR_TechnicalResponsibleCNPJ");
                if( (value == null) || (!value.equals(getBR_TechnicalResponsibleCNPJ())) ) {
                    setBR_TechnicalResponsibleCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_TechnicalRespContactName") ) {
                final Object value = values.remove("BR_TechnicalRespContactName");
                if( (value == null) || (!value.equals(getBR_TechnicalRespContactName())) ) {
                    setBR_TechnicalRespContactName(((String) value));
                }
            }
            if( values.containsKey("BR_TechnicalResponsibleEmail") ) {
                final Object value = values.remove("BR_TechnicalResponsibleEmail");
                if( (value == null) || (!value.equals(getBR_TechnicalResponsibleEmail())) ) {
                    setBR_TechnicalResponsibleEmail(((String) value));
                }
            }
            if( values.containsKey("BR_TechResponsiblePhoneNumber") ) {
                final Object value = values.remove("BR_TechResponsiblePhoneNumber");
                if( (value == null) || (!value.equals(getBR_TechResponsiblePhoneNumber())) ) {
                    setBR_TechResponsiblePhoneNumber(((String) value));
                }
            }
            if( values.containsKey("BR_SecureCodeTechRespID") ) {
                final Object value = values.remove("BR_SecureCodeTechRespID");
                if( (value == null) || (!value.equals(getBR_SecureCodeTechRespID())) ) {
                    setBR_SecureCodeTechRespID(((String) value));
                }
            }
            if( values.containsKey("BR_SecureCodeTechnicalRespHash") ) {
                final Object value = values.remove("BR_SecureCodeTechnicalRespHash");
                if( (value == null) || (!value.equals(getBR_SecureCodeTechnicalRespHash())) ) {
                    setBR_SecureCodeTechnicalRespHash(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BR_NFDoc") ) {
                final Object value = (values).remove("to_BR_NFDoc");
                if( value instanceof Map ) {
                    if( toBR_NFDoc == null ) {
                        toBR_NFDoc = new BR_NFDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBR_NFDoc.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BR_TechnicalResponsibleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BR_TechnicalResponsibleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BR_TechnicalResponsibleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BR_TechnicalResponsibleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBR_NFDoc != null ) {
            (values).put("to_BR_NFDoc", toBR_NFDoc);
        }
        return values;
    }

    /**
     * Fetches the <b>BR_NFDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BR_NFDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BR_NFDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument fetchBR_NFDoc()
    {
        return fetchFieldAsSingle("to_BR_NFDoc", BR_NFDocument.class);
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property <b>to_BR_NFDoc</b> of a queried <b>BR_TechnicalResponsible</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BR_NFDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BR_NFDocument getBR_NFDocOrFetch()
    {
        if( toBR_NFDoc == null ) {
            toBR_NFDoc = fetchBR_NFDoc();
        }
        return toBR_NFDoc;
    }

    /**
     * Retrieval of associated <b>BR_NFDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BR_NFDoc</b>.
     * <p>
     * If the navigation property for an entity <b>BR_TechnicalResponsible</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BR_NFDoc</b> is already loaded, the result will contain
     *         the <b>BR_NFDocument</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BR_NFDocument> getBR_NFDocIfPresent()
    {
        return Option.of(toBR_NFDoc);
    }

    /**
     * Overwrites the associated <b>BR_NFDocument</b> entity for the loaded navigation property <b>to_BR_NFDoc</b>.
     *
     * @param value
     *            New <b>BR_NFDocument</b> entity.
     */
    public void setBR_NFDoc( final BR_NFDocument value )
    {
        toBR_NFDoc = value;
    }

    /**
     * Helper class to allow for fluent creation of BR_TechnicalResponsible instances.
     *
     */
    public final static class BR_TechnicalResponsibleBuilder
    {

        private BR_NFDocument toBR_NFDoc;

        private BR_TechnicalResponsible.BR_TechnicalResponsibleBuilder toBR_NFDoc( final BR_NFDocument value )
        {
            toBR_NFDoc = value;
            return this;
        }

        /**
         * Navigation property <b>to_BR_NFDoc</b> for <b>BR_TechnicalResponsible</b> to single <b>BR_NFDocument</b>.
         *
         * @param value
         *            The BR_NFDocument to build this BR_TechnicalResponsible with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BR_TechnicalResponsible.BR_TechnicalResponsibleBuilder bR_NFDoc( final BR_NFDocument value )
        {
            return toBR_NFDoc(value);
        }

    }

}
