/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService BrazilNotaFiscalService}.
 *
 */
public interface BrazilNotaFiscalServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BrazilNotaFiscalServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BrazilNotaFiscalServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     * BR_NFAdditionalInformation} entity and save it to the S/4HANA system.
     *
     * @param bR_NFAdditionalInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation
     *            BR_NFAdditionalInformation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFAdditionalInformation( @Nonnull final BR_NFAdditionalInformation bR_NFAdditionalInformation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     * BR_NFAdditionImportDoc} entity and save it to the S/4HANA system.
     *
     * @param bR_NFAdditionImportDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc
     *            BR_NFAdditionImportDoc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFAdditionImportDoc( @Nonnull final BR_NFAdditionImportDoc bR_NFAdditionImportDoc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     *            BR_NFDocument} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet createBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     * BR_NFDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument
     *            BR_NFDocument} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     * BR_NFDocumentReference} entity and save it to the S/4HANA system.
     *
     * @param bR_NFDocumentReference
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
     *            BR_NFDocumentReference} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFDocumentReference( @Nonnull final BR_NFDocumentReference bR_NFDocumentReference );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     * BR_NFePayment} entity and save it to the S/4HANA system.
     *
     * @param bR_NFePayment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment
     *            BR_NFePayment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFePayment( @Nonnull final BR_NFePayment bR_NFePayment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     * BR_NFePharmaceutical} entity and save it to the S/4HANA system.
     *
     * @param bR_NFePharmaceutical
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical
     *            BR_NFePharmaceutical} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFePharmaceutical( @Nonnull final BR_NFePharmaceutical bR_NFePharmaceutical );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     * BR_NFeProductTraceability} entity and save it to the S/4HANA system.
     *
     * @param bR_NFeProductTraceability
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability
     *            BR_NFeProductTraceability} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFeProductTraceability( @Nonnull final BR_NFeProductTraceability bR_NFeProductTraceability );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     * BR_NFExportDeclaration} entity and save it to the S/4HANA system.
     *
     * @param bR_NFExportDeclaration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration
     *            BR_NFExportDeclaration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFExportDeclaration( @Nonnull final BR_NFExportDeclaration bR_NFExportDeclaration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     * BR_NFExportDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFExportDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument
     *            BR_NFExportDocument} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFExportDocument( @Nonnull final BR_NFExportDocument bR_NFExportDocument );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel
     * BR_NFFuel} entity and save it to the S/4HANA system.
     *
     * @param bR_NFFuel
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFFuel( @Nonnull final BR_NFFuel bR_NFFuel );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     * BR_NFFuelOriginIndicator} entity and save it to the S/4HANA system.
     *
     * @param bR_NFFuelOriginIndicator
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
     *            BR_NFFuelOriginIndicator} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFFuelOriginIndicator( @Nonnull final BR_NFFuelOriginIndicator bR_NFFuelOriginIndicator );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     * BR_NFHeaderText} entity and save it to the S/4HANA system.
     *
     * @param bR_NFHeaderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText
     *            BR_NFHeaderText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFHeaderText( @Nonnull final BR_NFHeaderText bR_NFHeaderText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     * BR_NFImportDocument} entity and save it to the S/4HANA system.
     *
     * @param bR_NFImportDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument
     *            BR_NFImportDocument} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFImportDocument( @Nonnull final BR_NFImportDocument bR_NFImportDocument );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem
     * BR_NFItem} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItem( @Nonnull final BR_NFItem bR_NFItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     * BR_NFItemAdditionalInfo} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemAdditionalInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo
     *            BR_NFItemAdditionalInfo} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFItemAdditionalInfo( @Nonnull final BR_NFItemAdditionalInfo bR_NFItemAdditionalInfo );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE
     * BR_NFItemNVE} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemNVE
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE BR_NFItemNVE}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItemNVE( @Nonnull final BR_NFItemNVE bR_NFItemNVE );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     * BR_NFItemText} entity and save it to the S/4HANA system.
     *
     * @param bR_NFItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText
     *            BR_NFItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItemText( @Nonnull final BR_NFItemText bR_NFItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner
     * BR_NFPartner} entity and save it to the S/4HANA system.
     *
     * @param bR_NFPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner BR_NFPartner}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFPartner( @Nonnull final BR_NFPartner bR_NFPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     * BR_NFReferencedProcess} entity and save it to the S/4HANA system.
     *
     * @param bR_NFReferencedProcess
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess
     *            BR_NFReferencedProcess} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFReferencedProcess( @Nonnull final BR_NFReferencedProcess bR_NFReferencedProcess );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     * BR_NFSugarCaneDeductible} entity and save it to the S/4HANA system.
     *
     * @param bR_NFSugarCaneDeductible
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible
     *            BR_NFSugarCaneDeductible} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFSugarCaneDeductible( @Nonnull final BR_NFSugarCaneDeductible bR_NFSugarCaneDeductible );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     * BR_NFSugarCaneSupply} entity and save it to the S/4HANA system.
     *
     * @param bR_NFSugarCaneSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply
     *            BR_NFSugarCaneSupply} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFSugarCaneSupply( @Nonnull final BR_NFSugarCaneSupply bR_NFSugarCaneSupply );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX}
     * entity and save it to the S/4HANA system.
     *
     * @param bR_NFTAX
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTAX( @Nonnull final BR_NFTAX bR_NFTAX );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     * BR_NFTradeNote} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTradeNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote
     *            BR_NFTradeNote} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTradeNote( @Nonnull final BR_NFTradeNote bR_NFTradeNote );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer
     * BR_NFTrailer} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTrailer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer BR_NFTrailer}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTrailer( @Nonnull final BR_NFTrailer bR_NFTrailer );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     * BR_NFTransportedVolume} entity and save it to the S/4HANA system.
     *
     * @param bR_NFTransportedVolume
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
     *            BR_NFTransportedVolume} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_NFTransportedVolume( @Nonnull final BR_NFTransportedVolume bR_NFTransportedVolume );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle
     * BR_NFVehicle} entity and save it to the S/4HANA system.
     *
     * @param bR_NFVehicle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_NFVehicle( @Nonnull final BR_NFVehicle bR_NFVehicle );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     * BR_OneTimePartner} entity and save it to the S/4HANA system.
     *
     * @param bR_OneTimePartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner
     *            BR_OneTimePartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet updateBR_OneTimePartner( @Nonnull final BR_OneTimePartner bR_OneTimePartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     * BR_TechnicalResponsible} entity and save it to the S/4HANA system.
     *
     * @param bR_TechnicalResponsible
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
     *            BR_TechnicalResponsible} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BrazilNotaFiscalServiceBatchChangeSet
        updateBR_TechnicalResponsible( @Nonnull final BR_TechnicalResponsible bR_TechnicalResponsible );

}
