/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible;

/**
 * Implementation of the {@link BrazilNotaFiscalServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService BrazilNotaFiscalService}.
 *
 */
public class DefaultBrazilNotaFiscalServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BrazilNotaFiscalServiceBatch, BrazilNotaFiscalServiceBatchChangeSet>
    implements
    BrazilNotaFiscalServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService service;

    @SuppressWarnings( "deprecation" )
    DefaultBrazilNotaFiscalServiceBatchChangeSet(
        @Nonnull final DefaultBrazilNotaFiscalServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilNotaFiscalService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBrazilNotaFiscalServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFAdditionalInformation(
        @Nonnull final BR_NFAdditionalInformation bR_NFAdditionalInformation )
    {
        return addRequestUpdate(service::updateBR_NFAdditionalInformation, bR_NFAdditionalInformation);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFAdditionImportDoc(
        @Nonnull final BR_NFAdditionImportDoc bR_NFAdditionImportDoc )
    {
        return addRequestUpdate(service::updateBR_NFAdditionImportDoc, bR_NFAdditionImportDoc);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet createBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument )
    {
        return addRequestCreate(service::createBR_NFDocument, bR_NFDocument);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument )
    {
        return addRequestUpdate(service::updateBR_NFDocument, bR_NFDocument);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFDocumentReference(
        @Nonnull final BR_NFDocumentReference bR_NFDocumentReference )
    {
        return addRequestUpdate(service::updateBR_NFDocumentReference, bR_NFDocumentReference);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFePayment( @Nonnull final BR_NFePayment bR_NFePayment )
    {
        return addRequestUpdate(service::updateBR_NFePayment, bR_NFePayment);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFePharmaceutical(
        @Nonnull final BR_NFePharmaceutical bR_NFePharmaceutical )
    {
        return addRequestUpdate(service::updateBR_NFePharmaceutical, bR_NFePharmaceutical);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFeProductTraceability(
        @Nonnull final BR_NFeProductTraceability bR_NFeProductTraceability )
    {
        return addRequestUpdate(service::updateBR_NFeProductTraceability, bR_NFeProductTraceability);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFExportDeclaration(
        @Nonnull final BR_NFExportDeclaration bR_NFExportDeclaration )
    {
        return addRequestUpdate(service::updateBR_NFExportDeclaration, bR_NFExportDeclaration);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFExportDocument(
        @Nonnull final BR_NFExportDocument bR_NFExportDocument )
    {
        return addRequestUpdate(service::updateBR_NFExportDocument, bR_NFExportDocument);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFFuel( @Nonnull final BR_NFFuel bR_NFFuel )
    {
        return addRequestUpdate(service::updateBR_NFFuel, bR_NFFuel);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFFuelOriginIndicator(
        @Nonnull final BR_NFFuelOriginIndicator bR_NFFuelOriginIndicator )
    {
        return addRequestUpdate(service::updateBR_NFFuelOriginIndicator, bR_NFFuelOriginIndicator);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFHeaderText( @Nonnull final BR_NFHeaderText bR_NFHeaderText )
    {
        return addRequestUpdate(service::updateBR_NFHeaderText, bR_NFHeaderText);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFImportDocument(
        @Nonnull final BR_NFImportDocument bR_NFImportDocument )
    {
        return addRequestUpdate(service::updateBR_NFImportDocument, bR_NFImportDocument);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItem( @Nonnull final BR_NFItem bR_NFItem )
    {
        return addRequestUpdate(service::updateBR_NFItem, bR_NFItem);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItemAdditionalInfo(
        @Nonnull final BR_NFItemAdditionalInfo bR_NFItemAdditionalInfo )
    {
        return addRequestUpdate(service::updateBR_NFItemAdditionalInfo, bR_NFItemAdditionalInfo);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItemNVE( @Nonnull final BR_NFItemNVE bR_NFItemNVE )
    {
        return addRequestUpdate(service::updateBR_NFItemNVE, bR_NFItemNVE);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFItemText( @Nonnull final BR_NFItemText bR_NFItemText )
    {
        return addRequestUpdate(service::updateBR_NFItemText, bR_NFItemText);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFPartner( @Nonnull final BR_NFPartner bR_NFPartner )
    {
        return addRequestUpdate(service::updateBR_NFPartner, bR_NFPartner);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFReferencedProcess(
        @Nonnull final BR_NFReferencedProcess bR_NFReferencedProcess )
    {
        return addRequestUpdate(service::updateBR_NFReferencedProcess, bR_NFReferencedProcess);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFSugarCaneDeductible(
        @Nonnull final BR_NFSugarCaneDeductible bR_NFSugarCaneDeductible )
    {
        return addRequestUpdate(service::updateBR_NFSugarCaneDeductible, bR_NFSugarCaneDeductible);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFSugarCaneSupply(
        @Nonnull final BR_NFSugarCaneSupply bR_NFSugarCaneSupply )
    {
        return addRequestUpdate(service::updateBR_NFSugarCaneSupply, bR_NFSugarCaneSupply);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTAX( @Nonnull final BR_NFTAX bR_NFTAX )
    {
        return addRequestUpdate(service::updateBR_NFTAX, bR_NFTAX);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTradeNote( @Nonnull final BR_NFTradeNote bR_NFTradeNote )
    {
        return addRequestUpdate(service::updateBR_NFTradeNote, bR_NFTradeNote);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTrailer( @Nonnull final BR_NFTrailer bR_NFTrailer )
    {
        return addRequestUpdate(service::updateBR_NFTrailer, bR_NFTrailer);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFTransportedVolume(
        @Nonnull final BR_NFTransportedVolume bR_NFTransportedVolume )
    {
        return addRequestUpdate(service::updateBR_NFTransportedVolume, bR_NFTransportedVolume);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_NFVehicle( @Nonnull final BR_NFVehicle bR_NFVehicle )
    {
        return addRequestUpdate(service::updateBR_NFVehicle, bR_NFVehicle);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_OneTimePartner(
        @Nonnull final BR_OneTimePartner bR_OneTimePartner )
    {
        return addRequestUpdate(service::updateBR_OneTimePartner, bR_OneTimePartner);
    }

    @Nonnull
    @Override
    public BrazilNotaFiscalServiceBatchChangeSet updateBR_TechnicalResponsible(
        @Nonnull final BR_TechnicalResponsible bR_TechnicalResponsible )
    {
        return addRequestUpdate(service::updateBR_TechnicalResponsible, bR_TechnicalResponsible);
    }

}
