/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFDocumentReferenceSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference
 * BR_NFDocumentReference} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BR_NFDocumentReferenceLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BR_NFDocumentReferenceLink<ObjectT>, BR_NFDocumentReference, ObjectT>
    implements
    BR_NFDocumentReferenceSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BR_NFDocumentReferenceLink( final String fieldName )
    {
        super(fieldName);
    }

    private BR_NFDocumentReferenceLink(
        final EntityLink<BR_NFDocumentReferenceLink<ObjectT>, BR_NFDocumentReference, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BR_NFDocumentReferenceLink<ObjectT> translateLinkType(
        final EntityLink<BR_NFDocumentReferenceLink<ObjectT>, BR_NFDocumentReference, ObjectT> link )
    {
        return new BR_NFDocumentReferenceLink<ObjectT>(link);
    }

}
