/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable.BR_NFImportDocumentSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument BR_NFImportDocument}
 * to other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BR_NFImportDocumentLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BR_NFImportDocumentLink<ObjectT>, BR_NFImportDocument, ObjectT>
    implements
    BR_NFImportDocumentSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BR_NFImportDocumentLink( final String fieldName )
    {
        super(fieldName);
    }

    private BR_NFImportDocumentLink(
        final EntityLink<BR_NFImportDocumentLink<ObjectT>, BR_NFImportDocument, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BR_NFImportDocumentLink<ObjectT> translateLinkType(
        final EntityLink<BR_NFImportDocumentLink<ObjectT>, BR_NFImportDocument, ObjectT> link )
    {
        return new BR_NFImportDocumentLink<ObjectT>(link);
    }

}
