/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument BR_NFDocument}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFDocumentField
 * BR_NFDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFDocumentLink
 * BR_NFDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_FUNCTION
 * BRNF_PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER
 * BRNF_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_NAME1
 * BRNF_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_NAME2
 * BRNF_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_NAME3
 * BRNF_PARTNER_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_NAME4
 * BRNF_PARTNER_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#PARTNER_IS_ONE_TIME_ACCOUNT
 * PARTNER_IS_ONE_TIME_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_TYPE
 * BRNF_PARTNER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_STREET_NAME
 * BRNF_PARTNER_STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BUSINESS_PARTNER_HOUSE_NUMBER
 * BUSINESS_PARTNER_HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BP_HS_NMBR_SUPLMNT_TXT
 * BP_HS_NMBR_SUPLMNT_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_CITY_NAME
 * BRNF_PARTNER_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_REGION_CODE
 * BRNF_PARTNER_REGION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_DISTRICT_NAME
 * BRNF_PARTNER_DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_COUNTRY_CODE
 * BRNF_PARTNER_COUNTRY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_POSTAL_CODE
 * BRNF_PARTNER_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_IS_NATURAL_PERSON
 * BRNF_PARTNER_IS_NATURAL_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_CNPJ
 * BRNF_PARTNER_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_CPF
 * BRNF_PARTNER_CPF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_STATE_TAX_NUMBER
 * BRNF_PARTNER_STATE_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_MUNICIPAL_TAX_NUMBER
 * BRNF_PARTNER_MUNICIPAL_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_STATE_TAX_NUMBER_ST
 * BRNF_PARTNER_STATE_TAX_NUMBER_ST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_CNAE
 * BRNF_PARTNER_CNAE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_TAX_REGIMEN_CODE
 * BRNF_PARTNER_TAX_REGIMEN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_PARTNER_CFOP_CATEGORY
 * BR_PARTNER_CFOP_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRSUFRAMA_CODE
 * BRSUFRAMA_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRSPED_TAX_CATEGORY
 * BRSPED_TAX_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#REPORTING_INCG_OR_OUTG_DATE
 * REPORTING_INCG_OR_OUTG_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_TAX_JURISDICTION
 * BRNF_PARTNER_TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_OBSERVATION_TEXT
 * BRNF_OBSERVATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#MEANS_OF_TRANSPORT_TYPE
 * MEANS_OF_TRANSPORT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#MEANS_OF_TRANSPORT
 * MEANS_OF_TRANSPORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SHIPPING_UNIT_BRAND
 * BRNF_SHIPPING_UNIT_BRAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SHIPPING_UNIT_NUMBER
 * BRNF_SHIPPING_UNIT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_NUMBER_OF_PACKAGES
 * BRNF_NUMBER_OF_PACKAGES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SHIPPING_UNIT
 * BRNF_SHIPPING_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ARRIVAL_OR_DEPARTURE_DATE
 * BRNF_ARRIVAL_OR_DEPARTURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#HEADER_WEIGHT_UNIT
 * HEADER_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#HEADER_NET_WEIGHT
 * HEADER_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#HEADER_GROSS_WEIGHT
 * HEADER_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ARRIVAL_OR_DEPARTURE_TIME
 * BRNF_ARRIVAL_OR_DEPARTURE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_WHLDG_ICMS_FOR_TRANSP_CFOP
 * BR_WHLDG_ICMS_FOR_TRANSP_CFOP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_WHLDG_ICMS_FOR_TRANSP_CITY
 * BR_WHLDG_ICMS_FOR_TRANSP_CITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_PRINTED
 * BRNF_IS_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_CREATED_MANUALLY
 * BRNF_IS_CREATED_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_INCOMING_ISSD_BY_CUST
 * BRNF_IS_INCOMING_ISSD_BY_CUST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_CANCELED
 * BRNF_IS_CANCELED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_CHARGING_INVOICE
 * BRNF_IS_CHARGING_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_DIRECTION
 * BRNF_DIRECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_TYPE
 * BRNF_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_DOCUMENT_TYPE
 * BRNF_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_MODEL
 * BRNF_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_NUMBER
 * BRNF_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SERIES
 * BRNF_SERIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SUB_SERIES
 * BRNF_SUB_SERIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_SITUATION_CODE
 * BRNF_SITUATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ISSUED_BY
 * BRNF_ISSUED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_CONTINGENCY
 * BRNF_IS_CONTINGENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_AUTHZN_PROTOCOL_NUMBER
 * BRNF_AUTHZN_PROTOCOL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_AUTHENTICATION_DATE
 * BRNF_AUTHENTICATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_AUTHENTICATION_TIME
 * BRNF_AUTHENTICATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_XML_VERSION
 * BRN_FE_XML_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ORIGINAL_AMOUNT
 * BRNF_ORIGINAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_DISCOUNT_AMOUNT
 * BRNF_DISCOUNT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_NET_AMOUNT
 * BRNF_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_COMMITMENT_NOTE
 * BRNF_COMMITMENT_NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_HARVEST
 * SUGARCANE_HARVEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_REF_MONTH_YEAR
 * SUGARCANE_REF_MONTH_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_CUR_MNTH_QTY_UNIT
 * SUGARCANE_CUR_MNTH_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_CURRENT_MONTH_QTY
 * SUGARCANE_CURRENT_MONTH_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_LAST_MNTH_QTY_UNIT
 * SUGARCANE_LAST_MNTH_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_LAST_MNTH_QUANTITY
 * SUGARCANE_LAST_MNTH_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_SUM_BOTH_MNTHS_QTY_UNIT
 * SUGARCANE_SUM_BOTH_MNTHS_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_SUM_BOTH_MONTHS_QTY
 * SUGARCANE_SUM_BOTH_MONTHS_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_SUPPLIES_AMOUNT
 * SUGARCANE_SUPPLIES_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_TOTAL_DEDUCTION_AMOUNT
 * SUGARCANE_TOTAL_DEDUCTION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SUGARCANE_SUPPLIES_NET_AMT
 * SUGARCANE_SUPPLIES_NET_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_DOCUMENT_STATUS
 * BRN_FE_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_FINAL_CONSUMER
 * BRNF_IS_FINAL_CONSUMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_CUSTOMER_PRESENCE
 * BRN_FE_CUSTOMER_PRESENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_DESTINATION
 * BRN_FE_DESTINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_POSTING_DATE
 * BRNF_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BUSINESS_PLACE
 * BUSINESS_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_BUSINESS_PLACE_CNPJ
 * BR_BUSINESS_PLACE_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BUSINESS_PLACE_STATE_TAX_NUMBER
 * BUSINESS_PLACE_STATE_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_BUS_PLACE_STATE_TAX_NUMBER_ST
 * BR_BUS_PLACE_STATE_TAX_NUMBER_ST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BUS_PLACE_MUNICIPAL_TAX_NUMBER
 * BUS_PLACE_MUNICIPAL_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_BUSINESS_PLACE_CNAE
 * BR_BUSINESS_PLACE_CNAE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BUSINESS_PLACE_TAX_REGIMEN_CODE
 * BUSINESS_PLACE_TAX_REGIMEN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_TOTAL_AMOUNT
 * BRNF_TOTAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_FISCAL_YEAR
 * BRNF_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_WITHHOLDING_AMOUNT
 * BRNF_WITHHOLDING_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_PAYMENT_FORM
 * BR_PAYMENT_FORM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#FREIGHT_PAYER
 * FREIGHT_PAYER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRANTT_CARRIER_REGISTRATION
 * BRANTT_CARRIER_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_NUMBER
 * BRN_FE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#WAGON_ID WAGON_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#FERRY_BOAT_ID
 * FERRY_BOAT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_EXPORT_SHIPMENT_PLACE
 * BRNF_EXPORT_SHIPMENT_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_EXPORT_SHIPMENT_REGION
 * BRNF_EXPORT_SHIPMENT_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_EXPORT_DISPATCH_LOCATION
 * BRNF_EXPORT_DISPATCH_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ISSUE_DATE
 * BRNF_ISSUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_MUNICIPAL
 * BRNF_IS_MUNICIPAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_OPERATION_TYPE_DESC
 * BRNF_OPERATION_TYPE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_IS_N_FE
 * BR_IS_N_FE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_CANCELLATION_DATE
 * BRNF_CANCELLATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_HAS_FOLLOW_ON_DOCUMENT
 * BRNF_HAS_FOLLOW_ON_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_REFERENCE_DOCUMENT
 * BRNF_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#LICENSE_PLATE
 * LICENSE_PLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#VEHICLE_REGION
 * VEHICLE_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BR_UTILS_NF_NUMBER
 * BR_UTILS_NF_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_PLACE_TYPE
 * BRNF_PARTNER_PLACE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_IS_CALCULATED_BY_TAX_SERVICE
 * BRNF_IS_CALCULATED_BY_TAX_SERVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#CHANGE_AMOUNT
 * CHANGE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_FISCAL_COUPON_DOC_MODEL
 * BRNF_FISCAL_COUPON_DOC_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_OPERATION_ORDER_NUMBER
 * BRNF_OPERATION_ORDER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_PARTNER_FOREIGN_IDN
 * BRNF_PARTNER_FOREIGN_IDN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_DOCUMENT_TYPE
 * BRC_TE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_MAIN_PRODUCT_TRANSPORTED
 * BRC_TE_MAIN_PRODUCT_TRANSPORTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_TOTAL_GOODS_AMOUNT
 * BRC_TE_TOTAL_GOODS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_PARTNER_SERVICE_TAKER
 * BRC_TE_PARTNER_SERVICE_TAKER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_FISCAL_DOCUMENT_PARTNER
 * BRC_TE_FISCAL_DOCUMENT_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_SERVICE_TYPE
 * BRC_TE_SERVICE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_TRANSPORTATION_MODE
 * BRC_TE_TRANSPORTATION_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_ESTIMATED_DELIVERY_DATE
 * BRC_TE_ESTIMATED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_IS_TRUCK_FULLY_LOADED
 * BRC_TE_IS_TRUCK_FULLY_LOADED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_JURISDICTION_CODE_ORIGIN
 * BRC_TE_JURISDICTION_CODE_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRC_TE_JURISDICTION_CODE_DEST
 * BRC_TE_JURISDICTION_CODE_DEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNFS_VERIFICATION_CODE
 * BRNFS_VERIFICATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNFS_NUMBER
 * BRNFS_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_HAS_SERVICE_ITEM
 * BRNF_HAS_SERVICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#IS_BUSINESS_PURPOSE_COMPLETED
 * IS_BUSINESS_PURPOSE_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_INTERMEDIATOR_TRANSACTION
 * BRN_FE_INTERMEDIATOR_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_INTERMEDIATOR_REGISTRY
 * BRN_FE_INTERMEDIATOR_REGISTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRN_FE_INTERMEDIATOR_CNPJ
 * BRN_FE_INTERMEDIATOR_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_MESSAGE_TEXT
 * BRNF_MESSAGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ADDITIONAL_FISCAL_INFO_TEXT
 * BRNF_ADDITIONAL_FISCAL_INFO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#BRNF_ADDITIONAL_COMPANY_INFO_TEXT
 * BRNF_ADDITIONAL_COMPANY_INFO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_ADDITIONAL_INFORMATION
 * TO_BRNF_ADDITIONAL_INFORMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_DOCUMENT_REFERENCE
 * TO_BRNF_DOCUMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRN_FE_PAYMENT
 * TO_BRN_FE_PAYMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_EXPORT_DECLARATION
 * TO_BRNF_EXPORT_DECLARATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_HEADER_TEXT
 * TO_BRNF_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_IMPORT_DOCUMENT
 * TO_BRNF_IMPORT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_PARTNER
 * TO_BRNF_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_REFERENCED_PROCESS
 * TO_BRNF_REFERENCED_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_SUGAR_CANE_DEDUCTIBLE
 * TO_BRNF_SUGAR_CANE_DEDUCTIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_SUGAR_CANE_SUPPLY
 * TO_BRNF_SUGAR_CANE_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_TRADE_NOTE
 * TO_BRNF_TRADE_NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_TRAILER
 * TO_BRNF_TRAILER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BRNF_TRANSPORTED_VOLUME
 * TO_BRNF_TRANSPORTED_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BR_ONE_TIME_PARTNER
 * TO_BR_ONE_TIME_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument#TO_BR_TECHNICAL_RESPONSIBLE
 * TO_BR_TECHNICAL_RESPONSIBLE}</li>
 * </ul>
 *
 */
public interface BR_NFDocumentSelectable extends EntitySelectable<BR_NFDocument>
{

}
