/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument BR_NFExportDocument}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFExportDocumentField
 * BR_NFExportDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFExportDocumentLink
 * BR_NFExportDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_ITEM_EXPRT_SQNC_NUMBER
 * BRNF_ITEM_EXPRT_SQNC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_ITEM_EXPRT_REG_NUMBER
 * BRNF_ITEM_EXPRT_REG_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_ITEM_EXPRT_N_FE_ACCESS_KEY
 * BRNF_ITEM_EXPRT_N_FE_ACCESS_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_ITEM_EXPORT_REAL_QTY
 * BRNF_ITEM_EXPORT_REAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_ITM_EXPRT_DRWBK_CONCESSION
 * BRNF_ITM_EXPRT_DRWBK_CONCESSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#BRNF_EXPORT_DRAWBACK_CONCESSION
 * BRNF_EXPORT_DRAWBACK_CONCESSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * </ul>
 *
 */
public interface BR_NFExportDocumentSelectable extends EntitySelectable<BR_NFExportDocument>
{

}
