/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator
 * BR_NFFuelOriginIndicator}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFFuelOriginIndicatorField
 * BR_NFFuelOriginIndicatorField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFFuelOriginIndicatorLink
 * BR_NFFuelOriginIndicatorLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#BRNF_IMPORT_INDICATOR_FUEL_ORIGIN
 * BRNF_IMPORT_INDICATOR_FUEL_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#BRNF_ORIGIN_REGION
 * BRNF_ORIGIN_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#BRNF_REGION_ORIGINATING_PERCENT
 * BRNF_REGION_ORIGINATING_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * </ul>
 *
 */
public interface BR_NFFuelOriginIndicatorSelectable extends EntitySelectable<BR_NFFuelOriginIndicator>
{

}
