/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel BR_NFFuel}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFFuelField
 * BR_NFFuelField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFFuelLink
 * BR_NFFuelLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRANP_CODE BRANP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_REGISTER_CODIF
 * BRNF_REGISTER_CODIF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_ENVRMT_TEMPERATURE_FUEL_QTY
 * BRN_FE_ENVRMT_TEMPERATURE_FUEL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_CONSUMER_REGION
 * BRN_FE_FUEL_CONSUMER_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_PERCENTAGE_NATURAL_GAS_UNIT
 * BRNF_PERCENTAGE_NATURAL_GAS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_NATURAL_GAS_PERCENT
 * BRNF_NATURAL_GAS_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_FUEL_CIDE_TAX_BASE_QUANTITY
 * BRNF_FUEL_CIDE_TAX_BASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_FUEL_CIDE_TAX_RATE
 * BRNF_FUEL_CIDE_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_FUEL_CIDE_TAX_AMOUNT
 * BRNF_FUEL_CIDE_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_NOZZLE
 * BRN_FE_FUEL_NOZZLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_PUMP
 * BRN_FE_FUEL_PUMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_TANK
 * BRN_FE_FUEL_TANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_GAUGE_START_QUANTITY
 * BRN_FE_FUEL_GAUGE_START_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRN_FE_FUEL_GAUGE_END_QUANTITY
 * BRN_FE_FUEL_GAUGE_END_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLP_RATIO_UNIT
 * BRGLP_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLP_RATIO
 * BRGLP_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLGNN_RATIO_UNIT
 * BRGLGNN_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLGNN_RATIO
 * BRGLGNN_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLGNI_RATIO_UNIT
 * BRGLGNI_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLGNI_RATIO
 * BRGLGNI_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRGLP_NET_VALUE_AMOUNT
 * BRGLP_NET_VALUE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BRNF_BIODIESEL_MIXING_INDEX_RATE
 * BRNF_BIODIESEL_MIXING_INDEX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * </ul>
 *
 */
public interface BR_NFFuelSelectable extends EntitySelectable<BR_NFFuel>
{

}
