/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument BR_NFImportDocument}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFImportDocumentField
 * BR_NFImportDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFImportDocumentLink
 * BR_NFImportDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_IMPORT_DOCUMENT
 * BRNF_IMPORT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_IMPORT_DOC_REGISTRATION_DATE
 * BRNF_IMPORT_DOC_REGISTRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_CUSTOMS_CLEARANCE_DESC
 * BRNF_CUSTOMS_CLEARANCE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_CUSTOMS_CLEARANCE_TAX_REGION
 * BRNF_CUSTOMS_CLEARANCE_TAX_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_CUSTOMS_CLEARANCE_DATE
 * BRNF_CUSTOMS_CLEARANCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_EXPORTER
 * BRNF_EXPORTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_IMPORT_DECLARATION_TYPE
 * BRNF_IMPORT_DECLARATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_IMP_DOC_MEANS_OF_TRANSPORT
 * BRNF_IMP_DOC_MEANS_OF_TRANSPORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_MARITIME_FREIGHT_AMOUNT
 * BRNF_MARITIME_FREIGHT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_INTERMEDIATE_MODE
 * BRNF_INTERMEDIATE_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_BUYER_REQUESTER_CNPJ
 * BRNF_BUYER_REQUESTER_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_THIRD_PARTY_REGION
 * BRNF_THIRD_PARTY_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#BRNF_IS_MARITIME_FRT_IN_TOTAL_AMT
 * BRNF_IS_MARITIME_FRT_IN_TOTAL_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFImportDocumentSelectable extends EntitySelectable<BR_NFImportDocument>
{

}
