/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem BR_NFItem}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFItemField
 * BR_NFItemField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFItemLink
 * BR_NFItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_TAX_SITUATION
 * BRICMS_TAX_SITUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIPI_TAX_SITUATION
 * BRIPI_TAX_SITUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRISS_TAX_SITUATION
 * BRISS_TAX_SITUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCOFINS_TAX_SITUATION
 * BRCOFINS_TAX_SITUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRPIS_TAX_SITUATION
 * BRPIS_TAX_SITUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_BASE_DETN
 * BRICMS_BASE_DETN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_BASE_DETERMINATION
 * BRICMSST_BASE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_LEGAL_CLASSFCTN
 * BRICMSST_LEGAL_CLASSFCTN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_SUBSTITUTE_ICMS_AMOUNT
 * BR_SUBSTITUTE_ICMS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_EXEMPTION_REASON
 * BRICMS_EXEMPTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_DEFERMENT_AMOUNT
 * BRICMS_DEFERMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_DEFERRAL_TAX_RATE
 * BRICMS_DEFERRAL_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_WITHHOLDING_ICMSST_BASE_AMOUNT
 * BR_WITHHOLDING_ICMSST_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_WITHHOLDING_ICMSST_AMOUNT
 * BR_WITHHOLDING_ICMSST_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIPI_LEGAL_CLASSIFICATION
 * BRIPI_LEGAL_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_TOBACCO_BEVERAGE_IPI_CLASSFCTN
 * BR_TOBACCO_BEVERAGE_IPI_CLASSFCTN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIPI_CONTROL_SEAL_CODE
 * BRIPI_CONTROL_SEAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIPI_CONTROL_SEAL_QUANTITY_VALUE
 * BRIPI_CONTROL_SEAL_QUANTITY_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#INTERNAL_ORDER
 * INTERNAL_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#SEGMENT SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_NET_FREIGHT_AMOUNT
 * BRNF_NET_FREIGHT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_NET_INSURANCE_AMOUNT
 * BRNF_NET_INSURANCE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_NET_OTHER_EXPENSES_AMOUNT
 * BRNF_NET_OTHER_EXPENSES_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#NET_PRICE_AMOUNT
 * NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#NET_VALUE_AMOUNT
 * NET_VALUE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_ITEM_TYPE
 * BRNF_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_OR_ISS_IS_INCLUDED_IN_PRICE
 * BRICMS_OR_ISS_IS_INCLUDED_IN_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_ITEM_IS_STATISTICAL
 * BRNF_ITEM_IS_STATISTICAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_IS_SERVICE_ITEM
 * BRNF_IS_SERVICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#VALUATION_TYPE
 * VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCFOP_CATEGORY
 * BRCFOP_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#QUANTITY_IN_BASE_UNIT
 * QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_SOURCE_DOCUMENT_TYPE
 * BRNF_SOURCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_SOURCE_DOCUMENT_NUMBER
 * BRNF_SOURCE_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_SOURCE_DOCUMENT_ITEM
 * BRNF_SOURCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_REFERENCE_NF_NUMBER
 * BR_REFERENCE_NF_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_REFERENCE_NF_ITEM
 * BR_REFERENCE_NF_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_PERCENT_RETURNED
 * BRNF_PERCENT_RETURNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_NET_DISCOUNT_AMOUNT
 * BRNF_NET_DISCOUNT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EXEMPTED_ICMS_AMOUNT
 * BR_EXEMPTED_ICMS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_STATISTICAL_EXEMPTION_AMT
 * BRICMS_STATISTICAL_EXEMPTION_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_MARGIN_ADDED_PERCENT
 * BRICMSST_MARGIN_ADDED_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCPRB_IS_RELEVANT
 * BRCPRB_IS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_TOTAL_AMOUNT
 * BRNF_TOTAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCFOP_CODE
 * BRCFOP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_MATERIAL_ORIGIN
 * BR_MATERIAL_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_MATERIAL_USAGE
 * BR_MATERIAL_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#IS_PRODUCED_INHOUSE
 * IS_PRODUCED_INHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#NCM_CODE NCM_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNBS_CODE BRNBS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BREFDREINF_SERVICE_CODE
 * BREFDREINF_SERVICE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#B_R_L_C116_SERVICE_CODE
 * B_R_L_C116_SERVICE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRISS_BENEFIT_CODE
 * BRISS_BENEFIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCSTISS_CODE
 * BRCSTISS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_APPROXIMATE_TOTAL_TAX_AMOUNT
 * BRNF_APPROXIMATE_TOTAL_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCI_NUMBER
 * BRFCI_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_TAX_LAW
 * BRICMS_TAX_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIPI_TAX_LAW
 * BRIPI_TAX_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRISS_TAX_LAW
 * BRISS_TAX_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCOFINS_TAX_LAW
 * BRCOFINS_TAX_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRPIS_TAX_LAW
 * BRPIS_TAX_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#GL_ACCOUNT GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#INTERNATIONAL_ARTICLE_NUMBER
 * INTERNATIONAL_ARTICLE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_EXTERNAL_ITEM_NUMBER
 * BRNF_EXTERNAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRRECOPI_NUMBER
 * BRRECOPI_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRISS_SUSPENSION_PROCESS
 * BRISS_SUSPENSION_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_TRIBUTARY_QUANTITY
 * BRNF_TRIBUTARY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_TRIBUTARY_UNIT
 * BRNF_TRIBUTARY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_IS_PHYSICAL_MVT_OF_MATERIAL
 * BRNF_IS_PHYSICAL_MVT_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_ITEM_HAS_TAX_INCENTIVE
 * BRNF_ITEM_HAS_TAX_INCENTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_PRICE_AMOUNT_WITH_TAXES
 * BRNF_PRICE_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_VALUE_AMOUNT_WITH_TAXES
 * BRNF_VALUE_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_DISCOUNT_AMOUNT_WITH_TAXES
 * BRNF_DISCOUNT_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_FREIGHT_AMOUNT_WITH_TAXES
 * BRNF_FREIGHT_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_INSURANCE_AMOUNT_WITH_TAXES
 * BRNF_INSURANCE_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_EXPENSES_AMOUNT_WITH_TAXES
 * BRNF_EXPENSES_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_EXEMPTED_ICMS_WITH_TAXES
 * BRNF_EXEMPTED_ICMS_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_TOTAL_AMOUNT_WITH_TAXES
 * BRNF_TOTAL_AMOUNT_WITH_TAXES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_TAX_CODE
 * BR_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#ACTIVITY_NUMBER
 * ACTIVITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#CREDIT_CALCULATION_BASE_CODE
 * CREDIT_CALCULATION_BASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_REDUCN_PCT_EFFCTV_CALC_BASIS
 * BR_REDUCN_PCT_EFFCTV_CALC_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EFFCTV_CALC_BASIS_AMOUNT
 * BR_EFFCTV_CALC_BASIS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EFFECTIVE_ICMS_RATE
 * BR_EFFECTIVE_ICMS_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EFFECTIVE_ICMS_AMOUNT
 * BR_EFFECTIVE_ICMS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#PRODUCTION_IS_IN_RELEVANT_SCALE
 * PRODUCTION_IS_IN_RELEVANT_SCALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_MANUFACTURER_CNPJ
 * BR_MANUFACTURER_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TAX_INCENTIVE_CODE
 * TAX_INCENTIVE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_DEST_TAX_BASE_AMOUNT
 * BRICMSST_DEST_TAX_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_DEST_TAX_AMOUNT
 * BRICMSST_DEST_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCP_ON_ICMSST_WITHHELD_BASE_AMT
 * BRFCP_ON_ICMSST_WITHHELD_BASE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFC_PON_ICMSST_WITHHELD_RATE
 * BRFC_PON_ICMSST_WITHHELD_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#CUSTOMS_CHARGES_AMOUNT
 * CUSTOMS_CHARGES_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCP_ON_ICMSST_WITHHELD_AMOUNT
 * BRFCP_ON_ICMSST_WITHHELD_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRIOF_TAX_AMOUNT
 * BRIOF_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_RATE_INCLUDING_FCP
 * BRICMSST_RATE_INCLUDING_FCP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRN_FE_STATISTICAL_AMOUNT
 * BRN_FE_STATISTICAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_PARTNER_CNAE
 * BRNF_PARTNER_CNAE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_BUSINESS_PLACE_CNAE
 * BR_BUSINESS_PLACE_CNAE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_FREIGHT_NATURE
 * BRNF_FREIGHT_NATURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_INTERNAL_BARCODE
 * BR_INTERNAL_BARCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_INTERNAL_TRIBUTARY_BARCODE
 * BR_INTERNAL_TRIBUTARY_BARCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_IS_PISST_IN_TOTAL_AMOUNT
 * BRNF_IS_PISST_IN_TOTAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRPISST_IN_NF_TOTAL
 * BRPISST_IN_NF_TOTAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRPISST_TAX_AMOUNT
 * BRPISST_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_IS_COFINSST_IN_TOTAL_AMOUNT
 * BRNF_IS_COFINSST_IN_TOTAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCOFINSST_IN_NF_TOTAL
 * BRCOFINSST_IN_NF_TOTAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRCOFINSST_TAX_AMOUNT
 * BRCOFINSST_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMS_DEFERMENT_PERCENT
 * BRICMS_DEFERMENT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCP_ON_ICMS_DEFERMENT_AMOUNT
 * BRFCP_ON_ICMS_DEFERMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCP_ON_ICMS_DEFERRAL_TAX_RATE
 * BRFCP_ON_ICMS_DEFERRAL_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRFCP_ON_ICMS_DEFERMENT_PERCENT
 * BRFCP_ON_ICMS_DEFERMENT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EXEMPTED_ICMSST_AMOUNT
 * BR_EXEMPTED_ICMSST_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRICMSST_EXEMPTION_REASON
 * BRICMSST_EXEMPTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BR_EXCL_ICMS_AMT_FROM_PIS_AND_COFINS
 * BR_EXCL_ICMS_AMT_FROM_PIS_AND_COFINS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_MONO_ICMS_DEFERRED_AMOUNT
 * BRNF_MONO_ICMS_DEFERRED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_AD_REM_ICMS_RETAINED_TAX_RATE
 * BRNF_AD_REM_ICMS_RETAINED_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_MONO_ICMS_RETAINED_AMOUNT
 * BRNF_MONO_ICMS_RETAINED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_MONO_RETAINED_TAXED_QUANTITY
 * BRNF_MONO_RETAINED_TAXED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_AD_REM_ICMS_REDUCTION_REASON
 * BRNF_AD_REM_ICMS_REDUCTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_AD_REM_ICMS_REDUCTION_RATE
 * BRNF_AD_REM_ICMS_REDUCTION_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_MONO_ICMS_OPERATION_AMOUNT
 * BRNF_MONO_ICMS_OPERATION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_AD_REM_ICMS_DEFERRAL_PERCENT
 * BRNF_AD_REM_ICMS_DEFERRAL_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_MESSAGE_TEXT
 * BRNF_MESSAGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#BRNF_ADDITIONAL_PRODUCT_INFO_TEXT
 * BRNF_ADDITIONAL_PRODUCT_INFO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_ADDITION_IMPORT_DOC
 * TO_BRNF_ADDITION_IMPORT_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRN_FE_PHARMACEUTICAL
 * TO_BRN_FE_PHARMACEUTICAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRN_FE_PRODUCT_TRACEABILITY
 * TO_BRN_FE_PRODUCT_TRACEABILITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_EXPORT_DOCUMENT
 * TO_BRNF_EXPORT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_FUEL
 * TO_BRNF_FUEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_FUEL_ORIGIN_INDICATOR
 * TO_BRNF_FUEL_ORIGIN_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_ITEM_ADDITIONAL_INFO
 * TO_BRNF_ITEM_ADDITIONAL_INFO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_ITEM_NVE
 * TO_BRNF_ITEM_NVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_ITEM_TEXT
 * TO_BRNF_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_TAX
 * TO_BRNF_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem#TO_BRNF_VEHICLE
 * TO_BRNF_VEHICLE}</li>
 * </ul>
 *
 */
public interface BR_NFItemSelectable extends EntitySelectable<BR_NFItem>
{

}
