/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX BR_NFTAX}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTAXField
 * BR_NFTAXField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTAXLink
 * BR_NFTAXLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BR_TAX_TYPE
 * BR_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#TAX_GROUP TAX_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_BASE_AMOUNT
 * BRNF_ITEM_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_RATE
 * BRNF_ITEM_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_AMOUNT
 * BRNF_ITEM_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_EXCLUDED_BASE_AMOUNT
 * BRNF_ITEM_EXCLUDED_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_OTHER_BASE_AMOUNT
 * BRNF_ITEM_OTHER_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_BASE_PCT1_UNIT
 * BRNF_ITEM_TAX_BASE_PCT1_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_BASE_PCT1
 * BRNF_ITEM_TAX_BASE_PCT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_BASE_PCT2_UNIT
 * BRNF_ITEM_TAX_BASE_PCT2_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_TAX_BASE_PCT2
 * BRNF_ITEM_TAX_BASE_PCT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_IS_STATISTICAL_TAX
 * BRNF_ITEM_IS_STATISTICAL_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_HAS_FIXED_MKT_TARIFF
 * BRNF_ITEM_HAS_FIXED_MKT_TARIFF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_FIXED_MKT_TARIFF_BASE_QTY
 * BRNF_ITEM_FIXED_MKT_TARIFF_BASE_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_FIXED_MARKET_TARIFF_UNIT
 * BRNF_ITEM_FIXED_MARKET_TARIFF_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_WHLDG_COLLECTION_CODE
 * BRNF_ITEM_WHLDG_COLLECTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_FIXED_MKT_TARIFF_TAX_RATE
 * BRNF_ITEM_FIXED_MKT_TARIFF_TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_FIXED_MKT_TARIFF_QTY
 * BRNF_ITEM_FIXED_MKT_TARIFF_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITM_FXD_MKT_TARIFF_UNIT4_DCMLS
 * BRNF_ITM_FXD_MKT_TARIFF_UNIT4_DCMLS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#TAXES_ARE_INCLUDED_IN_NET_AMOUNT
 * TAXES_ARE_INCLUDED_IN_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNF_ITEM_HAS_WITHHOLDING_TAX
 * BRNF_ITEM_HAS_WITHHOLDING_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNFS_SERVICE_TYPE_INCOMING
 * BRNFS_SERVICE_TYPE_INCOMING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#BRNFS_SERVICE_TYPE_OUTGOING
 * BRNFS_SERVICE_TYPE_OUTGOING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#AGGREGATE_BASE_AMOUNT
 * AGGREGATE_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFTAXSelectable extends EntitySelectable<BR_NFTAX>
{

}
