/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote BR_NFTradeNote}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTradeNoteField
 * BR_NFTradeNoteField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTradeNoteLink
 * BR_NFTradeNoteLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#BRNF_TRADE_NOTE_SEQUENCE_NUMBER
 * BRNF_TRADE_NOTE_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#BRNF_TRADE_NOTE_NUMBER
 * BRNF_TRADE_NOTE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#BRNF_TRADE_NOTE_EXPIRING_DATE
 * BRNF_TRADE_NOTE_EXPIRING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#BRNF_TRADE_NOTE_VALUE
 * BRNF_TRADE_NOTE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFTradeNoteSelectable extends EntitySelectable<BR_NFTradeNote>
{

}
