/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume
 * BR_NFTransportedVolume}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFTransportedVolumeField
 * BR_NFTransportedVolumeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFTransportedVolumeLink
 * BR_NFTransportedVolumeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOLUMES_SEQUENCE
 * BRNF_TRANSPT_VOLUMES_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPORTED_VOLUME_QTY_VAL
 * BRNF_TRANSPORTED_VOLUME_QTY_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPORTED_VOLUME_TYPE
 * BRNF_TRANSPORTED_VOLUME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOLUME_TRADEMARK
 * BRNF_TRANSPT_VOLUME_TRADEMARK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPORTED_VOLUME_ID
 * BRNF_TRANSPORTED_VOLUME_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOL_NET_WEIGHT_UNIT
 * BRNF_TRANSPT_VOL_NET_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOLUME_NET_WEIGHT
 * BRNF_TRANSPT_VOLUME_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOL_GROSS_WGT_UNIT
 * BRNF_TRANSPT_VOL_GROSS_WGT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPT_VOLUME_GROSS_WEIGHT
 * BRNF_TRANSPT_VOLUME_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#BRNF_TRANSPORTED_VOLUME_SEAL
 * BRNF_TRANSPORTED_VOLUME_SEAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFTransportedVolumeSelectable extends EntitySelectable<BR_NFTransportedVolume>
{

}
