/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle BR_NFVehicle}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFVehicleField
 * BR_NFVehicleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFVehicleLink BR_NFVehicleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#BR_NOTA_FISCAL_ITEM
 * BR_NOTA_FISCAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_MODEL
 * VEHICLE_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_MODEL_YEAR
 * VEHICLE_MODEL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_YEAR_OF_MANUFACTURE
 * VEHICLE_YEAR_OF_MANUFACTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_TYPE
 * VEHICLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_FUEL_TYPE
 * VEHICLE_FUEL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_ENGINE_POWER
 * VEHICLE_ENGINE_POWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_CYLINDER_CAPACITY_VALUE
 * VEHICLE_CYLINDER_CAPACITY_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_ENGINE_NUMBER
 * VEHICLE_ENGINE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_CAR_MAKER_COLOR
 * VEHICLE_CAR_MAKER_COLOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_PAINTING_TYPE
 * VEHICLE_PAINTING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#BRN_FE_VEHICLE_DENATRAN_COLOR
 * BRN_FE_VEHICLE_DENATRAN_COLOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_COLOR_DESC
 * VEHICLE_COLOR_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_CHASSIS
 * VEHICLE_CHASSIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_SERIAL_NUMBER
 * VEHICLE_SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_NET_WEIGHT_UNIT
 * VEHICLE_NET_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_NET_WEIGHT
 * VEHICLE_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_GROSS_WEIGHT_UNIT
 * VEHICLE_GROSS_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_GROSS_WEIGHT
 * VEHICLE_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_MAXIMUM_CAPACITY_VALUE
 * VEHICLE_MAXIMUM_CAPACITY_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_MAX_TRACTION_CAPACITY
 * VEHICLE_MAX_TRACTION_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#DISTANCE_BETWEEN_AXLES_QTY_VALUE
 * DISTANCE_BETWEEN_AXLES_QTY_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_USAGE
 * VEHICLE_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#BRNF_ITEM_VIN_CONDITION
 * BRNF_ITEM_VIN_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_CONDITION
 * VEHICLE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_RESTRICTION
 * VEHICLE_RESTRICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#VEHICLE_OPERATION_TYPE
 * VEHICLE_OPERATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#TO_BRNF_ITEM
 * TO_BRNF_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFVehicleSelectable extends EntitySelectable<BR_NFVehicle>
{

}
