/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment BR_NFePayment}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_NFePaymentField
 * BR_NFePaymentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_NFePaymentLink
 * BR_NFePaymentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#SEQUENCE_NUMBER
 * SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#PAYMENT_AMOUNT
 * PAYMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#PAYMENT_SYSTEM_INTEGRATION_TYPE
 * PAYMENT_SYSTEM_INTEGRATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#BR_CREDIT_CARD_COMPANY_CNPJ
 * BR_CREDIT_CARD_COMPANY_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#CREDIT_CARD_BRAND
 * CREDIT_CARD_BRAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#CREDIT_CARD_TRANSACTION_AUTHZN_ID
 * CREDIT_CARD_TRANSACTION_AUTHZN_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#PAYMENT_FORM
 * PAYMENT_FORM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#BRNF_PAYMENT_METHOD_MANUAL_DESC
 * BRNF_PAYMENT_METHOD_MANUAL_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#SALES_DOCUMENT_CURRENCY
 * SALES_DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_NFePaymentSelectable extends EntitySelectable<BR_NFePayment>
{

}
