/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible
 * BR_TechnicalResponsible}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.field.BR_TechnicalResponsibleField
 * BR_TechnicalResponsibleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.link.BR_TechnicalResponsibleLink
 * BR_TechnicalResponsibleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_NOTA_FISCAL
 * BR_NOTA_FISCAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_TECHNICAL_RESPONSIBLE_CNPJ
 * BR_TECHNICAL_RESPONSIBLE_CNPJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_TECHNICAL_RESP_CONTACT_NAME
 * BR_TECHNICAL_RESP_CONTACT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_TECHNICAL_RESPONSIBLE_EMAIL
 * BR_TECHNICAL_RESPONSIBLE_EMAIL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_TECH_RESPONSIBLE_PHONE_NUMBER
 * BR_TECH_RESPONSIBLE_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_SECURE_CODE_TECH_RESP_ID
 * BR_SECURE_CODE_TECH_RESP_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#BR_SECURE_CODE_TECHNICAL_RESP_HASH
 * BR_SECURE_CODE_TECHNICAL_RESP_HASH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible#TO_BRNF_DOC
 * TO_BRNF_DOC}</li>
 * </ul>
 *
 */
public interface BR_TechnicalResponsibleSelectable extends EntitySelectable<BR_TechnicalResponsible>
{

}
