/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.field.BudgetAccountCoreField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.link.BudgetAccountCoreLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.selectable.BudgetAccountCoreSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Account
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetAccountCore_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetAccountCore extends VdmEntity<BudgetAccountCore>
{

    /**
     * Selector for all available fields of BudgetAccountCore.
     *
     */
    public final static BudgetAccountCoreSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @return Budget Account
     */
    @Key
    @SerializedName( "PubSecBudgetAccount" )
    @JsonProperty( "PubSecBudgetAccount" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccount" )
    private String pubSecBudgetAccount;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccount</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> PUB_SEC_BUDGET_ACCOUNT =
        new BudgetAccountCoreField<String>("PubSecBudgetAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @return Budget Account Company Code
     */
    @Key
    @SerializedName( "PubSecBudgetAccountCoCode" )
    @JsonProperty( "PubSecBudgetAccountCoCode" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccountCoCode" )
    private String pubSecBudgetAccountCoCode;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccountCoCode</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> PUB_SEC_BUDGET_ACCOUNT_CO_CODE =
        new BudgetAccountCoreField<String>("PubSecBudgetAccountCoCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> CHART_OF_ACCOUNTS =
        new BudgetAccountCoreField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnType</b>
     * </p>
     *
     * @return Budget Consumption Type
     */
    @SerializedName( "PubSecBudgetCnsmpnType" )
    @JsonProperty( "PubSecBudgetCnsmpnType" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetCnsmpnType" )
    private String pubSecBudgetCnsmpnType;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnType</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> PUB_SEC_BUDGET_CNSMPN_TYPE =
        new BudgetAccountCoreField<String>("PubSecBudgetCnsmpnType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctRevnExpnCode</b>
     * </p>
     *
     * @return Expense or Revenue on Budget Account
     */
    @SerializedName( "PubSecBdgtAcctRevnExpnCode" )
    @JsonProperty( "PubSecBdgtAcctRevnExpnCode" )
    @Nullable
    @ODataField( odataName = "PubSecBdgtAcctRevnExpnCode" )
    private String pubSecBdgtAcctRevnExpnCode;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctRevnExpnCode</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE =
        new BudgetAccountCoreField<String>("PubSecBdgtAcctRevnExpnCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetIsRelevant</b>
     * </p>
     *
     * @return Budget-Relevant Indicator
     */
    @SerializedName( "PubSecBudgetIsRelevant" )
    @JsonProperty( "PubSecBudgetIsRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PubSecBudgetIsRelevant" )
    private Boolean pubSecBudgetIsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetIsRelevant</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<Boolean> PUB_SEC_BUDGET_IS_RELEVANT =
        new BudgetAccountCoreField<Boolean>("PubSecBudgetIsRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsPostgAllowed</b>
     * </p>
     *
     * @return Posting to Budget Account Allowed
     */
    @SerializedName( "PubSecBdgtAcctIsPostgAllowed" )
    @JsonProperty( "PubSecBdgtAcctIsPostgAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PubSecBdgtAcctIsPostgAllowed" )
    private Boolean pubSecBdgtAcctIsPostgAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctIsPostgAllowed</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<Boolean> PUB_SEC_BDGT_ACCT_IS_POSTG_ALLOWED =
        new BudgetAccountCoreField<Boolean>("PubSecBdgtAcctIsPostgAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsBdgtAllowed</b>
     * </p>
     *
     * @return Budgeting Allowed for Budget Account
     */
    @SerializedName( "PubSecBdgtAcctIsBdgtAllowed" )
    @JsonProperty( "PubSecBdgtAcctIsBdgtAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PubSecBdgtAcctIsBdgtAllowed" )
    private Boolean pubSecBdgtAcctIsBdgtAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctIsBdgtAllowed</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<Boolean> PUB_SEC_BDGT_ACCT_IS_BDGT_ALLOWED =
        new BudgetAccountCoreField<Boolean>("PubSecBdgtAcctIsBdgtAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsCarryFwd</b>
     * </p>
     *
     * @return Use Budget Account as Carryforward Account
     */
    @SerializedName( "PubSecBdgtAcctIsCarryFwd" )
    @JsonProperty( "PubSecBdgtAcctIsCarryFwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PubSecBdgtAcctIsCarryFwd" )
    private Boolean pubSecBdgtAcctIsCarryFwd;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctIsCarryFwd</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<Boolean> PUB_SEC_BDGT_ACCT_IS_CARRY_FWD =
        new BudgetAccountCoreField<Boolean>("PubSecBdgtAcctIsCarryFwd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctCarryFwdTo</b>
     * </p>
     *
     * @return Carry Forward Budget Account To Account
     */
    @SerializedName( "PubSecBdgtAcctCarryFwdTo" )
    @JsonProperty( "PubSecBdgtAcctCarryFwdTo" )
    @Nullable
    @ODataField( odataName = "PubSecBdgtAcctCarryFwdTo" )
    private String pubSecBdgtAcctCarryFwdTo;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctCarryFwdTo</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> PUB_SEC_BDGT_ACCT_CARRY_FWD_TO =
        new BudgetAccountCoreField<String>("PubSecBdgtAcctCarryFwdTo");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerAccount</b>
     * </p>
     *
     * @return Cash Origin Account
     */
    @SerializedName( "CashLedgerAccount" )
    @JsonProperty( "CashLedgerAccount" )
    @Nullable
    @ODataField( odataName = "CashLedgerAccount" )
    private String cashLedgerAccount;
    /**
     * Use with available fluent helpers to apply the <b>CashLedgerAccount</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreField<String> CASH_LEDGER_ACCOUNT =
        new BudgetAccountCoreField<String>("CashLedgerAccount");
    /**
     * Navigation property <b>to_Text</b> for <b>BudgetAccountCore</b> to multiple <b>BudgetAccountCoreText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetAccountCoreText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BudgetAccountCoreLink<BudgetAccountCoreText> TO_TEXT =
        new BudgetAccountCoreLink<BudgetAccountCoreText>("to_Text");

    @Nonnull
    @Override
    public Class<BudgetAccountCore> getType()
    {
        return BudgetAccountCore.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @param pubSecBudgetAccount
     *            Budget Account
     */
    public void setPubSecBudgetAccount( @Nullable final String pubSecBudgetAccount )
    {
        rememberChangedField("PubSecBudgetAccount", this.pubSecBudgetAccount);
        this.pubSecBudgetAccount = pubSecBudgetAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     */
    public void setPubSecBudgetAccountCoCode( @Nullable final String pubSecBudgetAccountCoCode )
    {
        rememberChangedField("PubSecBudgetAccountCoCode", this.pubSecBudgetAccountCoCode);
        this.pubSecBudgetAccountCoCode = pubSecBudgetAccountCoCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnType</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnType
     *            Budget Consumption Type
     */
    public void setPubSecBudgetCnsmpnType( @Nullable final String pubSecBudgetCnsmpnType )
    {
        rememberChangedField("PubSecBudgetCnsmpnType", this.pubSecBudgetCnsmpnType);
        this.pubSecBudgetCnsmpnType = pubSecBudgetCnsmpnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctRevnExpnCode</b>
     * </p>
     *
     * @param pubSecBdgtAcctRevnExpnCode
     *            Expense or Revenue on Budget Account
     */
    public void setPubSecBdgtAcctRevnExpnCode( @Nullable final String pubSecBdgtAcctRevnExpnCode )
    {
        rememberChangedField("PubSecBdgtAcctRevnExpnCode", this.pubSecBdgtAcctRevnExpnCode);
        this.pubSecBdgtAcctRevnExpnCode = pubSecBdgtAcctRevnExpnCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetIsRelevant</b>
     * </p>
     *
     * @param pubSecBudgetIsRelevant
     *            Budget-Relevant Indicator
     */
    public void setPubSecBudgetIsRelevant( @Nullable final Boolean pubSecBudgetIsRelevant )
    {
        rememberChangedField("PubSecBudgetIsRelevant", this.pubSecBudgetIsRelevant);
        this.pubSecBudgetIsRelevant = pubSecBudgetIsRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsPostgAllowed</b>
     * </p>
     *
     * @param pubSecBdgtAcctIsPostgAllowed
     *            Posting to Budget Account Allowed
     */
    public void setPubSecBdgtAcctIsPostgAllowed( @Nullable final Boolean pubSecBdgtAcctIsPostgAllowed )
    {
        rememberChangedField("PubSecBdgtAcctIsPostgAllowed", this.pubSecBdgtAcctIsPostgAllowed);
        this.pubSecBdgtAcctIsPostgAllowed = pubSecBdgtAcctIsPostgAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsBdgtAllowed</b>
     * </p>
     *
     * @param pubSecBdgtAcctIsBdgtAllowed
     *            Budgeting Allowed for Budget Account
     */
    public void setPubSecBdgtAcctIsBdgtAllowed( @Nullable final Boolean pubSecBdgtAcctIsBdgtAllowed )
    {
        rememberChangedField("PubSecBdgtAcctIsBdgtAllowed", this.pubSecBdgtAcctIsBdgtAllowed);
        this.pubSecBdgtAcctIsBdgtAllowed = pubSecBdgtAcctIsBdgtAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctIsCarryFwd</b>
     * </p>
     *
     * @param pubSecBdgtAcctIsCarryFwd
     *            Use Budget Account as Carryforward Account
     */
    public void setPubSecBdgtAcctIsCarryFwd( @Nullable final Boolean pubSecBdgtAcctIsCarryFwd )
    {
        rememberChangedField("PubSecBdgtAcctIsCarryFwd", this.pubSecBdgtAcctIsCarryFwd);
        this.pubSecBdgtAcctIsCarryFwd = pubSecBdgtAcctIsCarryFwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctCarryFwdTo</b>
     * </p>
     *
     * @param pubSecBdgtAcctCarryFwdTo
     *            Carry Forward Budget Account To Account
     */
    public void setPubSecBdgtAcctCarryFwdTo( @Nullable final String pubSecBdgtAcctCarryFwdTo )
    {
        rememberChangedField("PubSecBdgtAcctCarryFwdTo", this.pubSecBdgtAcctCarryFwdTo);
        this.pubSecBdgtAcctCarryFwdTo = pubSecBdgtAcctCarryFwdTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerAccount</b>
     * </p>
     *
     * @param cashLedgerAccount
     *            Cash Origin Account
     */
    public void setCashLedgerAccount( @Nullable final String cashLedgerAccount )
    {
        rememberChangedField("CashLedgerAccount", this.cashLedgerAccount);
        this.cashLedgerAccount = cashLedgerAccount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PubSecBudgetAccount", getPubSecBudgetAccount());
        result.put("PubSecBudgetAccountCoCode", getPubSecBudgetAccountCoCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PubSecBudgetAccount", getPubSecBudgetAccount());
        values.put("PubSecBudgetAccountCoCode", getPubSecBudgetAccountCoCode());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("PubSecBudgetCnsmpnType", getPubSecBudgetCnsmpnType());
        values.put("PubSecBdgtAcctRevnExpnCode", getPubSecBdgtAcctRevnExpnCode());
        values.put("PubSecBudgetIsRelevant", getPubSecBudgetIsRelevant());
        values.put("PubSecBdgtAcctIsPostgAllowed", getPubSecBdgtAcctIsPostgAllowed());
        values.put("PubSecBdgtAcctIsBdgtAllowed", getPubSecBdgtAcctIsBdgtAllowed());
        values.put("PubSecBdgtAcctIsCarryFwd", getPubSecBdgtAcctIsCarryFwd());
        values.put("PubSecBdgtAcctCarryFwdTo", getPubSecBdgtAcctCarryFwdTo());
        values.put("CashLedgerAccount", getCashLedgerAccount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PubSecBudgetAccount") ) {
                final Object value = values.remove("PubSecBudgetAccount");
                if( (value == null) || (!value.equals(getPubSecBudgetAccount())) ) {
                    setPubSecBudgetAccount(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetAccountCoCode") ) {
                final Object value = values.remove("PubSecBudgetAccountCoCode");
                if( (value == null) || (!value.equals(getPubSecBudgetAccountCoCode())) ) {
                    setPubSecBudgetAccountCoCode(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnType") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnType");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnType())) ) {
                    setPubSecBudgetCnsmpnType(((String) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctRevnExpnCode") ) {
                final Object value = values.remove("PubSecBdgtAcctRevnExpnCode");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctRevnExpnCode())) ) {
                    setPubSecBdgtAcctRevnExpnCode(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetIsRelevant") ) {
                final Object value = values.remove("PubSecBudgetIsRelevant");
                if( (value == null) || (!value.equals(getPubSecBudgetIsRelevant())) ) {
                    setPubSecBudgetIsRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctIsPostgAllowed") ) {
                final Object value = values.remove("PubSecBdgtAcctIsPostgAllowed");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctIsPostgAllowed())) ) {
                    setPubSecBdgtAcctIsPostgAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctIsBdgtAllowed") ) {
                final Object value = values.remove("PubSecBdgtAcctIsBdgtAllowed");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctIsBdgtAllowed())) ) {
                    setPubSecBdgtAcctIsBdgtAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctIsCarryFwd") ) {
                final Object value = values.remove("PubSecBdgtAcctIsCarryFwd");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctIsCarryFwd())) ) {
                    setPubSecBdgtAcctIsCarryFwd(((Boolean) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctCarryFwdTo") ) {
                final Object value = values.remove("PubSecBdgtAcctCarryFwdTo");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctCarryFwdTo())) ) {
                    setPubSecBdgtAcctCarryFwdTo(((String) value));
                }
            }
            if( values.containsKey("CashLedgerAccount") ) {
                final Object value = values.remove("CashLedgerAccount");
                if( (value == null) || (!value.equals(getCashLedgerAccount())) ) {
                    setCashLedgerAccount(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetAccountCoreText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BudgetAccountCoreText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BudgetAccountCoreField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetAccountCoreField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetAccountCoreField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetAccountCoreField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetAccountCoreText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetAccountCoreText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreText> fetchText()
    {
        return fetchFieldAsList("to_Text", BudgetAccountCoreText.class);
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetAccountCoreText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetAccountCore</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BudgetAccountCoreText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BudgetAccountCoreText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BudgetAccountCoreText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetAccountCoreText</b> entities.
     */
    public void setText( @Nonnull final List<BudgetAccountCoreText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetAccountCoreText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetAccountCoreText</b> entities.
     */
    public void addText( BudgetAccountCoreText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BudgetAccountCore instances.
     *
     */
    public final static class BudgetAccountCoreBuilder
    {

        private List<BudgetAccountCoreText> toText = Lists.newArrayList();

        private BudgetAccountCore.BudgetAccountCoreBuilder toText( final List<BudgetAccountCoreText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BudgetAccountCore</b> to multiple <b>BudgetAccountCoreText</b>.
         *
         * @param value
         *            The BudgetAccountCoreTexts to build this BudgetAccountCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetAccountCore.BudgetAccountCoreBuilder text( BudgetAccountCoreText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
