/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.selectable.BudgetAccountCoreSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore BudgetAccountCore} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class BudgetAccountCoreByKeyFluentHelper
    extends
    FluentHelperByKey<BudgetAccountCoreByKeyFluentHelper, BudgetAccountCore, BudgetAccountCoreSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore BudgetAccountCore}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BudgetAccountCore}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BudgetAccountCore}
     * @param pubSecBudgetAccount
     *            Budget Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public BudgetAccountCoreByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String pubSecBudgetAccount,
        final String pubSecBudgetAccountCoCode )
    {
        super(servicePath, entityCollection);
        this.key.put("PubSecBudgetAccount", pubSecBudgetAccount);
        this.key.put("PubSecBudgetAccountCoCode", pubSecBudgetAccountCoCode);
    }

    @Override
    @Nonnull
    protected Class<BudgetAccountCore> getEntityClass()
    {
        return BudgetAccountCore.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
