/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.field.BudgetAccountCoreTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.link.BudgetAccountCoreTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.selectable.BudgetAccountCoreTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Account Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetAccountCoreText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetAccountCoreText extends VdmEntity<BudgetAccountCoreText>
{

    /**
     * Selector for all available fields of BudgetAccountCoreText.
     *
     */
    public final static BudgetAccountCoreTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @return Budget Account
     */
    @Key
    @SerializedName( "PubSecBudgetAccount" )
    @JsonProperty( "PubSecBudgetAccount" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccount" )
    private String pubSecBudgetAccount;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccount</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> PUB_SEC_BUDGET_ACCOUNT =
        new BudgetAccountCoreTextField<String>("PubSecBudgetAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @return Budget Account Company Code
     */
    @Key
    @SerializedName( "PubSecBudgetAccountCoCode" )
    @JsonProperty( "PubSecBudgetAccountCoCode" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccountCoCode" )
    private String pubSecBudgetAccountCoCode;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccountCoCode</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> PUB_SEC_BUDGET_ACCOUNT_CO_CODE =
        new BudgetAccountCoreTextField<String>("PubSecBudgetAccountCoCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> LANGUAGE =
        new BudgetAccountCoreTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> CHART_OF_ACCOUNTS =
        new BudgetAccountCoreTextField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountName</b>
     * </p>
     *
     * @return Budget Account Name
     */
    @SerializedName( "BudgetAccountName" )
    @JsonProperty( "BudgetAccountName" )
    @Nullable
    @ODataField( odataName = "BudgetAccountName" )
    private String budgetAccountName;
    /**
     * Use with available fluent helpers to apply the <b>BudgetAccountName</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> BUDGET_ACCOUNT_NAME =
        new BudgetAccountCoreTextField<String>("BudgetAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountDescription</b>
     * </p>
     *
     * @return Budget Account Description
     */
    @SerializedName( "BudgetAccountDescription" )
    @JsonProperty( "BudgetAccountDescription" )
    @Nullable
    @ODataField( odataName = "BudgetAccountDescription" )
    private String budgetAccountDescription;
    /**
     * Use with available fluent helpers to apply the <b>BudgetAccountDescription</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreTextField<String> BUDGET_ACCOUNT_DESCRIPTION =
        new BudgetAccountCoreTextField<String>("BudgetAccountDescription");
    /**
     * Navigation property <b>to_BudgetAccount</b> for <b>BudgetAccountCoreText</b> to single <b>BudgetAccountCore</b>.
     *
     */
    @SerializedName( "to_BudgetAccount" )
    @JsonProperty( "to_BudgetAccount" )
    @ODataField( odataName = "to_BudgetAccount" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BudgetAccountCore toBudgetAccount;
    /**
     * Use with available fluent helpers to apply the <b>to_BudgetAccount</b> navigation property to query operations.
     *
     */
    public final static BudgetAccountCoreTextOneToOneLink<BudgetAccountCore> TO_BUDGET_ACCOUNT =
        new BudgetAccountCoreTextOneToOneLink<BudgetAccountCore>("to_BudgetAccount");

    @Nonnull
    @Override
    public Class<BudgetAccountCoreText> getType()
    {
        return BudgetAccountCoreText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @param pubSecBudgetAccount
     *            Budget Account
     */
    public void setPubSecBudgetAccount( @Nullable final String pubSecBudgetAccount )
    {
        rememberChangedField("PubSecBudgetAccount", this.pubSecBudgetAccount);
        this.pubSecBudgetAccount = pubSecBudgetAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     */
    public void setPubSecBudgetAccountCoCode( @Nullable final String pubSecBudgetAccountCoCode )
    {
        rememberChangedField("PubSecBudgetAccountCoCode", this.pubSecBudgetAccountCoCode);
        this.pubSecBudgetAccountCoCode = pubSecBudgetAccountCoCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountName</b>
     * </p>
     *
     * @param budgetAccountName
     *            Budget Account Name
     */
    public void setBudgetAccountName( @Nullable final String budgetAccountName )
    {
        rememberChangedField("BudgetAccountName", this.budgetAccountName);
        this.budgetAccountName = budgetAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountDescription</b>
     * </p>
     *
     * @param budgetAccountDescription
     *            Budget Account Description
     */
    public void setBudgetAccountDescription( @Nullable final String budgetAccountDescription )
    {
        rememberChangedField("BudgetAccountDescription", this.budgetAccountDescription);
        this.budgetAccountDescription = budgetAccountDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetAccountText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PubSecBudgetAccount", getPubSecBudgetAccount());
        result.put("PubSecBudgetAccountCoCode", getPubSecBudgetAccountCoCode());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PubSecBudgetAccount", getPubSecBudgetAccount());
        values.put("PubSecBudgetAccountCoCode", getPubSecBudgetAccountCoCode());
        values.put("Language", getLanguage());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("BudgetAccountName", getBudgetAccountName());
        values.put("BudgetAccountDescription", getBudgetAccountDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PubSecBudgetAccount") ) {
                final Object value = values.remove("PubSecBudgetAccount");
                if( (value == null) || (!value.equals(getPubSecBudgetAccount())) ) {
                    setPubSecBudgetAccount(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetAccountCoCode") ) {
                final Object value = values.remove("PubSecBudgetAccountCoCode");
                if( (value == null) || (!value.equals(getPubSecBudgetAccountCoCode())) ) {
                    setPubSecBudgetAccountCoCode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("BudgetAccountName") ) {
                final Object value = values.remove("BudgetAccountName");
                if( (value == null) || (!value.equals(getBudgetAccountName())) ) {
                    setBudgetAccountName(((String) value));
                }
            }
            if( values.containsKey("BudgetAccountDescription") ) {
                final Object value = values.remove("BudgetAccountDescription");
                if( (value == null) || (!value.equals(getBudgetAccountDescription())) ) {
                    setBudgetAccountDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BudgetAccount") ) {
                final Object value = (values).remove("to_BudgetAccount");
                if( value instanceof Map ) {
                    if( toBudgetAccount == null ) {
                        toBudgetAccount = new BudgetAccountCore();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBudgetAccount.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BudgetAccountCoreTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetAccountCoreTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetAccountCoreTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetAccountCoreTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBudgetAccount != null ) {
            (values).put("to_BudgetAccount", toBudgetAccount);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetAccountCore</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BudgetAccount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BudgetAccountCore</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetAccountCore fetchBudgetAccount()
    {
        return fetchFieldAsSingle("to_BudgetAccount", BudgetAccountCore.class);
    }

    /**
     * Retrieval of associated <b>BudgetAccountCore</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BudgetAccount</b>.
     * <p>
     * If the navigation property <b>to_BudgetAccount</b> of a queried <b>BudgetAccountCoreText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetAccountCore</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetAccountCore getBudgetAccountOrFetch()
    {
        if( toBudgetAccount == null ) {
            toBudgetAccount = fetchBudgetAccount();
        }
        return toBudgetAccount;
    }

    /**
     * Retrieval of associated <b>BudgetAccountCore</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BudgetAccount</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetAccountCoreText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BudgetAccount</b> is already loaded, the result will
     *         contain the <b>BudgetAccountCore</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BudgetAccountCore> getBudgetAccountIfPresent()
    {
        return Option.of(toBudgetAccount);
    }

    /**
     * Overwrites the associated <b>BudgetAccountCore</b> entity for the loaded navigation property
     * <b>to_BudgetAccount</b>.
     *
     * @param value
     *            New <b>BudgetAccountCore</b> entity.
     */
    public void setBudgetAccount( final BudgetAccountCore value )
    {
        toBudgetAccount = value;
    }

    /**
     * Helper class to allow for fluent creation of BudgetAccountCoreText instances.
     *
     */
    public final static class BudgetAccountCoreTextBuilder
    {

        private BudgetAccountCore toBudgetAccount;

        private BudgetAccountCoreText.BudgetAccountCoreTextBuilder toBudgetAccount( final BudgetAccountCore value )
        {
            toBudgetAccount = value;
            return this;
        }

        /**
         * Navigation property <b>to_BudgetAccount</b> for <b>BudgetAccountCoreText</b> to single
         * <b>BudgetAccountCore</b>.
         *
         * @param value
         *            The BudgetAccountCore to build this BudgetAccountCoreText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetAccountCoreText.BudgetAccountCoreTextBuilder budgetAccount( final BudgetAccountCore value )
        {
            return toBudgetAccount(value);
        }

    }

}
