/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BudgetAccountServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService BudgetAccountService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBudgetAccountServiceBatch
    extends
    BatchFluentHelperBasic<BudgetAccountServiceBatch, BudgetAccountServiceBatchChangeSet>
    implements
    BudgetAccountServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBudgetAccountServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetAccountServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBudgetAccountServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetAccountServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBudgetAccountServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BudgetAccountServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBudgetAccountServiceBatchChangeSet(this, service);
    }

}
