/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BudgetAccountServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService BudgetAccountService}.
 *
 */
public class DefaultBudgetAccountServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BudgetAccountServiceBatch, BudgetAccountServiceBatchChangeSet>
    implements
    BudgetAccountServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService service;

    @SuppressWarnings( "deprecation" )
    DefaultBudgetAccountServiceBatchChangeSet(
        @Nonnull final DefaultBudgetAccountServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBudgetAccountServiceBatchChangeSet getThis()
    {
        return this;
    }

}
