/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore BudgetAccountCore}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.field.BudgetAccountCoreField
 * BudgetAccountCoreField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.link.BudgetAccountCoreLink
 * BudgetAccountCoreLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BUDGET_ACCOUNT
 * PUB_SEC_BUDGET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BUDGET_ACCOUNT_CO_CODE
 * PUB_SEC_BUDGET_ACCOUNT_CO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BUDGET_CNSMPN_TYPE
 * PUB_SEC_BUDGET_CNSMPN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE
 * PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BUDGET_IS_RELEVANT
 * PUB_SEC_BUDGET_IS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BDGT_ACCT_IS_POSTG_ALLOWED
 * PUB_SEC_BDGT_ACCT_IS_POSTG_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BDGT_ACCT_IS_BDGT_ALLOWED
 * PUB_SEC_BDGT_ACCT_IS_BDGT_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BDGT_ACCT_IS_CARRY_FWD
 * PUB_SEC_BDGT_ACCT_IS_CARRY_FWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#PUB_SEC_BDGT_ACCT_CARRY_FWD_TO
 * PUB_SEC_BDGT_ACCT_CARRY_FWD_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#CASH_LEDGER_ACCOUNT
 * CASH_LEDGER_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCore#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface BudgetAccountCoreSelectable extends EntitySelectable<BudgetAccountCore>
{

}
