/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText
 * BudgetAccountCoreText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.field.BudgetAccountCoreTextField
 * BudgetAccountCoreTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.link.BudgetAccountCoreTextLink
 * BudgetAccountCoreTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#PUB_SEC_BUDGET_ACCOUNT
 * PUB_SEC_BUDGET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#PUB_SEC_BUDGET_ACCOUNT_CO_CODE
 * PUB_SEC_BUDGET_ACCOUNT_CO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#BUDGET_ACCOUNT_NAME
 * BUDGET_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#BUDGET_ACCOUNT_DESCRIPTION
 * BUDGET_ACCOUNT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreText#TO_BUDGET_ACCOUNT
 * TO_BUDGET_ACCOUNT}</li>
 * </ul>
 *
 */
public interface BudgetAccountCoreTextSelectable extends EntitySelectable<BudgetAccountCoreText>
{

}
